# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedVirtualPrivateCloudNatGateway(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'external_ip': 'str',
        'external_ips': 'list[NestedVpcGatewaysCommonExternalIpsType]',
        'id': 'str',
        'name': 'str'
    }

    attribute_map = {
        'external_ip': 'external_ip',
        'external_ips': 'external_ips',
        'id': 'id',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedVirtualPrivateCloudNatGateway - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._external_ip = None
        self._external_ips = None
        self._id = None
        self._name = None
        self.discriminator = None

        self.external_ip = kwargs.get("external_ip", None)
        self.external_ips = kwargs.get("external_ips", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def external_ip(self):
        """Gets the external_ip of this NestedVirtualPrivateCloudNatGateway.  # noqa: E501


        :return: The external_ip of this NestedVirtualPrivateCloudNatGateway.  # noqa: E501
        :rtype: str
        """
        return self._external_ip

    @external_ip.setter
    def external_ip(self, external_ip):
        """Sets the external_ip of this NestedVirtualPrivateCloudNatGateway.


        :param external_ip: The external_ip of this NestedVirtualPrivateCloudNatGateway.  # noqa: E501
        :type external_ip: str
        """

        self._external_ip = external_ip

    @property
    def external_ips(self):
        """Gets the external_ips of this NestedVirtualPrivateCloudNatGateway.  # noqa: E501


        :return: The external_ips of this NestedVirtualPrivateCloudNatGateway.  # noqa: E501
        :rtype: list[NestedVpcGatewaysCommonExternalIpsType]
        """
        return self._external_ips

    @external_ips.setter
    def external_ips(self, external_ips):
        """Sets the external_ips of this NestedVirtualPrivateCloudNatGateway.


        :param external_ips: The external_ips of this NestedVirtualPrivateCloudNatGateway.  # noqa: E501
        :type external_ips: list[NestedVpcGatewaysCommonExternalIpsType]
        """

        self._external_ips = external_ips

    @property
    def id(self):
        """Gets the id of this NestedVirtualPrivateCloudNatGateway.  # noqa: E501


        :return: The id of this NestedVirtualPrivateCloudNatGateway.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this NestedVirtualPrivateCloudNatGateway.


        :param id: The id of this NestedVirtualPrivateCloudNatGateway.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this NestedVirtualPrivateCloudNatGateway.  # noqa: E501


        :return: The name of this NestedVirtualPrivateCloudNatGateway.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NestedVirtualPrivateCloudNatGateway.


        :param name: The name of this NestedVirtualPrivateCloudNatGateway.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedVirtualPrivateCloudNatGateway):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedVirtualPrivateCloudNatGateway):
            return True

        return self.to_dict() != other.to_dict()
