# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedVirtualPrivateCloudNetworkPolicyRule(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'except_ip_block': 'list[str]',
        'ip_block': 'str',
        'ports': 'list[NestedVirtualPrivateCloudNetworkPolicyRulePort]',
        'security_group': 'NestedVirtualPrivateCloudSecurityGroup',
        'security_group_id': 'str',
        'selector': 'list[NestedLabel]',
        'selector_ids': 'list[str]',
        'type': 'VirtualPrivateCloudNetworkPolicyRuleType'
    }

    attribute_map = {
        'except_ip_block': 'except_ip_block',
        'ip_block': 'ip_block',
        'ports': 'ports',
        'security_group': 'security_group',
        'security_group_id': 'security_group_id',
        'selector': 'selector',
        'selector_ids': 'selector_ids',
        'type': 'type'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedVirtualPrivateCloudNetworkPolicyRule - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._except_ip_block = None
        self._ip_block = None
        self._ports = None
        self._security_group = None
        self._security_group_id = None
        self._selector = None
        self._selector_ids = None
        self._type = None
        self.discriminator = None

        self.except_ip_block = kwargs.get("except_ip_block", None)
        self.ip_block = kwargs.get("ip_block", None)
        self.ports = kwargs.get("ports", None)
        self.security_group = kwargs.get("security_group", None)
        self.security_group_id = kwargs.get("security_group_id", None)
        self.selector = kwargs.get("selector", None)
        self.selector_ids = kwargs.get("selector_ids", None)
        if "type" in kwargs:
            self.type = kwargs["type"]

    @property
    def except_ip_block(self):
        """Gets the except_ip_block of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501


        :return: The except_ip_block of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :rtype: list[str]
        """
        return self._except_ip_block

    @except_ip_block.setter
    def except_ip_block(self, except_ip_block):
        """Sets the except_ip_block of this NestedVirtualPrivateCloudNetworkPolicyRule.


        :param except_ip_block: The except_ip_block of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :type except_ip_block: list[str]
        """

        self._except_ip_block = except_ip_block

    @property
    def ip_block(self):
        """Gets the ip_block of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501


        :return: The ip_block of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :rtype: str
        """
        return self._ip_block

    @ip_block.setter
    def ip_block(self, ip_block):
        """Sets the ip_block of this NestedVirtualPrivateCloudNetworkPolicyRule.


        :param ip_block: The ip_block of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :type ip_block: str
        """

        self._ip_block = ip_block

    @property
    def ports(self):
        """Gets the ports of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501


        :return: The ports of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :rtype: list[NestedVirtualPrivateCloudNetworkPolicyRulePort]
        """
        return self._ports

    @ports.setter
    def ports(self, ports):
        """Sets the ports of this NestedVirtualPrivateCloudNetworkPolicyRule.


        :param ports: The ports of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :type ports: list[NestedVirtualPrivateCloudNetworkPolicyRulePort]
        """

        self._ports = ports

    @property
    def security_group(self):
        """Gets the security_group of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501


        :return: The security_group of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :rtype: NestedVirtualPrivateCloudSecurityGroup
        """
        return self._security_group

    @security_group.setter
    def security_group(self, security_group):
        """Sets the security_group of this NestedVirtualPrivateCloudNetworkPolicyRule.


        :param security_group: The security_group of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :type security_group: NestedVirtualPrivateCloudSecurityGroup
        """

        self._security_group = security_group

    @property
    def security_group_id(self):
        """Gets the security_group_id of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501


        :return: The security_group_id of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :rtype: str
        """
        return self._security_group_id

    @security_group_id.setter
    def security_group_id(self, security_group_id):
        """Sets the security_group_id of this NestedVirtualPrivateCloudNetworkPolicyRule.


        :param security_group_id: The security_group_id of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :type security_group_id: str
        """

        self._security_group_id = security_group_id

    @property
    def selector(self):
        """Gets the selector of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501


        :return: The selector of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :rtype: list[NestedLabel]
        """
        return self._selector

    @selector.setter
    def selector(self, selector):
        """Sets the selector of this NestedVirtualPrivateCloudNetworkPolicyRule.


        :param selector: The selector of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :type selector: list[NestedLabel]
        """

        self._selector = selector

    @property
    def selector_ids(self):
        """Gets the selector_ids of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501


        :return: The selector_ids of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :rtype: list[str]
        """
        return self._selector_ids

    @selector_ids.setter
    def selector_ids(self, selector_ids):
        """Sets the selector_ids of this NestedVirtualPrivateCloudNetworkPolicyRule.


        :param selector_ids: The selector_ids of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :type selector_ids: list[str]
        """

        self._selector_ids = selector_ids

    @property
    def type(self):
        """Gets the type of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501


        :return: The type of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :rtype: VirtualPrivateCloudNetworkPolicyRuleType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this NestedVirtualPrivateCloudNetworkPolicyRule.


        :param type: The type of this NestedVirtualPrivateCloudNetworkPolicyRule.  # noqa: E501
        :type type: VirtualPrivateCloudNetworkPolicyRuleType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedVirtualPrivateCloudNetworkPolicyRule):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedVirtualPrivateCloudNetworkPolicyRule):
            return True

        return self.to_dict() != other.to_dict()
