# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedVirtualPrivateCloudNic(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'floating_ip': 'NestedVirtualPrivateCloudFloatingIp',
        'id': 'str',
        'ip_addresses': 'list[str]',
        'local_id': 'str',
        'vpc': 'NestedVirtualPrivateCloud',
        'vpc_subnet': 'NestedVirtualPrivateCloudSubnet'
    }

    attribute_map = {
        'floating_ip': 'floating_ip',
        'id': 'id',
        'ip_addresses': 'ip_addresses',
        'local_id': 'local_id',
        'vpc': 'vpc',
        'vpc_subnet': 'vpc_subnet'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedVirtualPrivateCloudNic - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._floating_ip = None
        self._id = None
        self._ip_addresses = None
        self._local_id = None
        self._vpc = None
        self._vpc_subnet = None
        self.discriminator = None

        self.floating_ip = kwargs.get("floating_ip", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "ip_addresses" in kwargs:
            self.ip_addresses = kwargs["ip_addresses"]
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "vpc" in kwargs:
            self.vpc = kwargs["vpc"]
        if "vpc_subnet" in kwargs:
            self.vpc_subnet = kwargs["vpc_subnet"]

    @property
    def floating_ip(self):
        """Gets the floating_ip of this NestedVirtualPrivateCloudNic.  # noqa: E501


        :return: The floating_ip of this NestedVirtualPrivateCloudNic.  # noqa: E501
        :rtype: NestedVirtualPrivateCloudFloatingIp
        """
        return self._floating_ip

    @floating_ip.setter
    def floating_ip(self, floating_ip):
        """Sets the floating_ip of this NestedVirtualPrivateCloudNic.


        :param floating_ip: The floating_ip of this NestedVirtualPrivateCloudNic.  # noqa: E501
        :type floating_ip: NestedVirtualPrivateCloudFloatingIp
        """

        self._floating_ip = floating_ip

    @property
    def id(self):
        """Gets the id of this NestedVirtualPrivateCloudNic.  # noqa: E501


        :return: The id of this NestedVirtualPrivateCloudNic.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this NestedVirtualPrivateCloudNic.


        :param id: The id of this NestedVirtualPrivateCloudNic.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def ip_addresses(self):
        """Gets the ip_addresses of this NestedVirtualPrivateCloudNic.  # noqa: E501


        :return: The ip_addresses of this NestedVirtualPrivateCloudNic.  # noqa: E501
        :rtype: list[str]
        """
        return self._ip_addresses

    @ip_addresses.setter
    def ip_addresses(self, ip_addresses):
        """Sets the ip_addresses of this NestedVirtualPrivateCloudNic.


        :param ip_addresses: The ip_addresses of this NestedVirtualPrivateCloudNic.  # noqa: E501
        :type ip_addresses: list[str]
        """
        if self.local_vars_configuration.client_side_validation and ip_addresses is None:  # noqa: E501
            raise ValueError("Invalid value for `ip_addresses`, must not be `None`")  # noqa: E501

        self._ip_addresses = ip_addresses

    @property
    def local_id(self):
        """Gets the local_id of this NestedVirtualPrivateCloudNic.  # noqa: E501


        :return: The local_id of this NestedVirtualPrivateCloudNic.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this NestedVirtualPrivateCloudNic.


        :param local_id: The local_id of this NestedVirtualPrivateCloudNic.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def vpc(self):
        """Gets the vpc of this NestedVirtualPrivateCloudNic.  # noqa: E501


        :return: The vpc of this NestedVirtualPrivateCloudNic.  # noqa: E501
        :rtype: NestedVirtualPrivateCloud
        """
        return self._vpc

    @vpc.setter
    def vpc(self, vpc):
        """Sets the vpc of this NestedVirtualPrivateCloudNic.


        :param vpc: The vpc of this NestedVirtualPrivateCloudNic.  # noqa: E501
        :type vpc: NestedVirtualPrivateCloud
        """
        if self.local_vars_configuration.client_side_validation and vpc is None:  # noqa: E501
            raise ValueError("Invalid value for `vpc`, must not be `None`")  # noqa: E501

        self._vpc = vpc

    @property
    def vpc_subnet(self):
        """Gets the vpc_subnet of this NestedVirtualPrivateCloudNic.  # noqa: E501


        :return: The vpc_subnet of this NestedVirtualPrivateCloudNic.  # noqa: E501
        :rtype: NestedVirtualPrivateCloudSubnet
        """
        return self._vpc_subnet

    @vpc_subnet.setter
    def vpc_subnet(self, vpc_subnet):
        """Sets the vpc_subnet of this NestedVirtualPrivateCloudNic.


        :param vpc_subnet: The vpc_subnet of this NestedVirtualPrivateCloudNic.  # noqa: E501
        :type vpc_subnet: NestedVirtualPrivateCloudSubnet
        """
        if self.local_vars_configuration.client_side_validation and vpc_subnet is None:  # noqa: E501
            raise ValueError("Invalid value for `vpc_subnet`, must not be `None`")  # noqa: E501

        self._vpc_subnet = vpc_subnet

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedVirtualPrivateCloudNic):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedVirtualPrivateCloudNic):
            return True

        return self.to_dict() != other.to_dict()
