# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedVirtualPrivateCloudService(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'internal_cidr': 'str',
        'tep_ip_pools': 'list[NestedVirtualPrivateCloudServiceTepIpPool]'
    }

    attribute_map = {
        'id': 'id',
        'internal_cidr': 'internal_cidr',
        'tep_ip_pools': 'tep_ip_pools'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedVirtualPrivateCloudService - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._id = None
        self._internal_cidr = None
        self._tep_ip_pools = None
        self.discriminator = None

        if "id" in kwargs:
            self.id = kwargs["id"]
        if "internal_cidr" in kwargs:
            self.internal_cidr = kwargs["internal_cidr"]
        if "tep_ip_pools" in kwargs:
            self.tep_ip_pools = kwargs["tep_ip_pools"]

    @property
    def id(self):
        """Gets the id of this NestedVirtualPrivateCloudService.  # noqa: E501


        :return: The id of this NestedVirtualPrivateCloudService.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this NestedVirtualPrivateCloudService.


        :param id: The id of this NestedVirtualPrivateCloudService.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def internal_cidr(self):
        """Gets the internal_cidr of this NestedVirtualPrivateCloudService.  # noqa: E501


        :return: The internal_cidr of this NestedVirtualPrivateCloudService.  # noqa: E501
        :rtype: str
        """
        return self._internal_cidr

    @internal_cidr.setter
    def internal_cidr(self, internal_cidr):
        """Sets the internal_cidr of this NestedVirtualPrivateCloudService.


        :param internal_cidr: The internal_cidr of this NestedVirtualPrivateCloudService.  # noqa: E501
        :type internal_cidr: str
        """
        if self.local_vars_configuration.client_side_validation and internal_cidr is None:  # noqa: E501
            raise ValueError("Invalid value for `internal_cidr`, must not be `None`")  # noqa: E501

        self._internal_cidr = internal_cidr

    @property
    def tep_ip_pools(self):
        """Gets the tep_ip_pools of this NestedVirtualPrivateCloudService.  # noqa: E501


        :return: The tep_ip_pools of this NestedVirtualPrivateCloudService.  # noqa: E501
        :rtype: list[NestedVirtualPrivateCloudServiceTepIpPool]
        """
        return self._tep_ip_pools

    @tep_ip_pools.setter
    def tep_ip_pools(self, tep_ip_pools):
        """Sets the tep_ip_pools of this NestedVirtualPrivateCloudService.


        :param tep_ip_pools: The tep_ip_pools of this NestedVirtualPrivateCloudService.  # noqa: E501
        :type tep_ip_pools: list[NestedVirtualPrivateCloudServiceTepIpPool]
        """
        if self.local_vars_configuration.client_side_validation and tep_ip_pools is None:  # noqa: E501
            raise ValueError("Invalid value for `tep_ip_pools`, must not be `None`")  # noqa: E501

        self._tep_ip_pools = tep_ip_pools

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedVirtualPrivateCloudService):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedVirtualPrivateCloudService):
            return True

        return self.to_dict() != other.to_dict()
