# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NestedVpcRouterGatewayRuleNextHopsItemType(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'edge_gateway_id': 'str',
        'nexthop': 'str'
    }

    attribute_map = {
        'edge_gateway_id': 'edge_gateway_id',
        'nexthop': 'nexthop'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NestedVpcRouterGatewayRuleNextHopsItemType - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._edge_gateway_id = None
        self._nexthop = None
        self.discriminator = None

        if "edge_gateway_id" in kwargs:
            self.edge_gateway_id = kwargs["edge_gateway_id"]
        self.nexthop = kwargs.get("nexthop", None)

    @property
    def edge_gateway_id(self):
        """Gets the edge_gateway_id of this NestedVpcRouterGatewayRuleNextHopsItemType.  # noqa: E501


        :return: The edge_gateway_id of this NestedVpcRouterGatewayRuleNextHopsItemType.  # noqa: E501
        :rtype: str
        """
        return self._edge_gateway_id

    @edge_gateway_id.setter
    def edge_gateway_id(self, edge_gateway_id):
        """Sets the edge_gateway_id of this NestedVpcRouterGatewayRuleNextHopsItemType.


        :param edge_gateway_id: The edge_gateway_id of this NestedVpcRouterGatewayRuleNextHopsItemType.  # noqa: E501
        :type edge_gateway_id: str
        """
        if self.local_vars_configuration.client_side_validation and edge_gateway_id is None:  # noqa: E501
            raise ValueError("Invalid value for `edge_gateway_id`, must not be `None`")  # noqa: E501

        self._edge_gateway_id = edge_gateway_id

    @property
    def nexthop(self):
        """Gets the nexthop of this NestedVpcRouterGatewayRuleNextHopsItemType.  # noqa: E501


        :return: The nexthop of this NestedVpcRouterGatewayRuleNextHopsItemType.  # noqa: E501
        :rtype: str
        """
        return self._nexthop

    @nexthop.setter
    def nexthop(self, nexthop):
        """Sets the nexthop of this NestedVpcRouterGatewayRuleNextHopsItemType.


        :param nexthop: The nexthop of this NestedVpcRouterGatewayRuleNextHopsItemType.  # noqa: E501
        :type nexthop: str
        """

        self._nexthop = nexthop

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedVpcRouterGatewayRuleNextHopsItemType):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedVpcRouterGatewayRuleNextHopsItemType):
            return True

        return self.to_dict() != other.to_dict()
