# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NfsExportUpdationParamsData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'ec_m': 'float',
        'ec_k': 'float',
        'resiliency_type': 'ResiliencyType',
        'replica_num': 'float',
        'ip_whitelist': 'str',
        'name': 'str'
    }

    attribute_map = {
        'ec_m': 'ec_m',
        'ec_k': 'ec_k',
        'resiliency_type': 'resiliency_type',
        'replica_num': 'replica_num',
        'ip_whitelist': 'ip_whitelist',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NfsExportUpdationParamsData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._ec_m = None
        self._ec_k = None
        self._resiliency_type = None
        self._replica_num = None
        self._ip_whitelist = None
        self._name = None
        self.discriminator = None

        if "ec_m" in kwargs:
            self.ec_m = kwargs["ec_m"]
        if "ec_k" in kwargs:
            self.ec_k = kwargs["ec_k"]
        if "resiliency_type" in kwargs:
            self.resiliency_type = kwargs["resiliency_type"]
        if "replica_num" in kwargs:
            self.replica_num = kwargs["replica_num"]
        if "ip_whitelist" in kwargs:
            self.ip_whitelist = kwargs["ip_whitelist"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def ec_m(self):
        """Gets the ec_m of this NfsExportUpdationParamsData.  # noqa: E501


        :return: The ec_m of this NfsExportUpdationParamsData.  # noqa: E501
        :rtype: float
        """
        return self._ec_m

    @ec_m.setter
    def ec_m(self, ec_m):
        """Sets the ec_m of this NfsExportUpdationParamsData.


        :param ec_m: The ec_m of this NfsExportUpdationParamsData.  # noqa: E501
        :type ec_m: float
        """

        self._ec_m = ec_m

    @property
    def ec_k(self):
        """Gets the ec_k of this NfsExportUpdationParamsData.  # noqa: E501


        :return: The ec_k of this NfsExportUpdationParamsData.  # noqa: E501
        :rtype: float
        """
        return self._ec_k

    @ec_k.setter
    def ec_k(self, ec_k):
        """Sets the ec_k of this NfsExportUpdationParamsData.


        :param ec_k: The ec_k of this NfsExportUpdationParamsData.  # noqa: E501
        :type ec_k: float
        """

        self._ec_k = ec_k

    @property
    def resiliency_type(self):
        """Gets the resiliency_type of this NfsExportUpdationParamsData.  # noqa: E501


        :return: The resiliency_type of this NfsExportUpdationParamsData.  # noqa: E501
        :rtype: ResiliencyType
        """
        return self._resiliency_type

    @resiliency_type.setter
    def resiliency_type(self, resiliency_type):
        """Sets the resiliency_type of this NfsExportUpdationParamsData.


        :param resiliency_type: The resiliency_type of this NfsExportUpdationParamsData.  # noqa: E501
        :type resiliency_type: ResiliencyType
        """

        self._resiliency_type = resiliency_type

    @property
    def replica_num(self):
        """Gets the replica_num of this NfsExportUpdationParamsData.  # noqa: E501


        :return: The replica_num of this NfsExportUpdationParamsData.  # noqa: E501
        :rtype: float
        """
        return self._replica_num

    @replica_num.setter
    def replica_num(self, replica_num):
        """Sets the replica_num of this NfsExportUpdationParamsData.


        :param replica_num: The replica_num of this NfsExportUpdationParamsData.  # noqa: E501
        :type replica_num: float
        """

        self._replica_num = replica_num

    @property
    def ip_whitelist(self):
        """Gets the ip_whitelist of this NfsExportUpdationParamsData.  # noqa: E501


        :return: The ip_whitelist of this NfsExportUpdationParamsData.  # noqa: E501
        :rtype: str
        """
        return self._ip_whitelist

    @ip_whitelist.setter
    def ip_whitelist(self, ip_whitelist):
        """Sets the ip_whitelist of this NfsExportUpdationParamsData.


        :param ip_whitelist: The ip_whitelist of this NfsExportUpdationParamsData.  # noqa: E501
        :type ip_whitelist: str
        """

        self._ip_whitelist = ip_whitelist

    @property
    def name(self):
        """Gets the name of this NfsExportUpdationParamsData.  # noqa: E501


        :return: The name of this NfsExportUpdationParamsData.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NfsExportUpdationParamsData.


        :param name: The name of this NfsExportUpdationParamsData.  # noqa: E501
        :type name: str
        """

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NfsExportUpdationParamsData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NfsExportUpdationParamsData):
            return True

        return self.to_dict() != other.to_dict()
