# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class OperateHostPowerData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'reason': 'str',
        'force': 'bool',
        'action': 'OperateActionEnum'
    }

    attribute_map = {
        'reason': 'reason',
        'force': 'force',
        'action': 'action'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """OperateHostPowerData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._reason = None
        self._force = None
        self._action = None
        self.discriminator = None

        if "reason" in kwargs:
            self.reason = kwargs["reason"]
        if "force" in kwargs:
            self.force = kwargs["force"]
        if "action" in kwargs:
            self.action = kwargs["action"]

    @property
    def reason(self):
        """Gets the reason of this OperateHostPowerData.  # noqa: E501


        :return: The reason of this OperateHostPowerData.  # noqa: E501
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this OperateHostPowerData.


        :param reason: The reason of this OperateHostPowerData.  # noqa: E501
        :type reason: str
        """

        self._reason = reason

    @property
    def force(self):
        """Gets the force of this OperateHostPowerData.  # noqa: E501


        :return: The force of this OperateHostPowerData.  # noqa: E501
        :rtype: bool
        """
        return self._force

    @force.setter
    def force(self, force):
        """Sets the force of this OperateHostPowerData.


        :param force: The force of this OperateHostPowerData.  # noqa: E501
        :type force: bool
        """
        if self.local_vars_configuration.client_side_validation and force is None:  # noqa: E501
            raise ValueError("Invalid value for `force`, must not be `None`")  # noqa: E501

        self._force = force

    @property
    def action(self):
        """Gets the action of this OperateHostPowerData.  # noqa: E501


        :return: The action of this OperateHostPowerData.  # noqa: E501
        :rtype: OperateActionEnum
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this OperateHostPowerData.


        :param action: The action of this OperateHostPowerData.  # noqa: E501
        :type action: OperateActionEnum
        """
        if self.local_vars_configuration.client_side_validation and action is None:  # noqa: E501
            raise ValueError("Invalid value for `action`, must not be `None`")  # noqa: E501

        self._action = action

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OperateHostPowerData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OperateHostPowerData):
            return True

        return self.to_dict() != other.to_dict()
