# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class OvfDisk(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'size': 'int',
        'type': 'VmDiskType',
        'bus': 'Bus',
        'name': 'str'
    }

    attribute_map = {
        'size': 'size',
        'type': 'type',
        'bus': 'bus',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """OvfDisk - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._size = None
        self._type = None
        self._bus = None
        self._name = None
        self.discriminator = None

        if "size" in kwargs:
            self.size = kwargs["size"]
        if "type" in kwargs:
            self.type = kwargs["type"]
        if "bus" in kwargs:
            self.bus = kwargs["bus"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def size(self):
        """Gets the size of this OvfDisk.  # noqa: E501


        :return: The size of this OvfDisk.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this OvfDisk.


        :param size: The size of this OvfDisk.  # noqa: E501
        :type size: int
        """
        if self.local_vars_configuration.client_side_validation and size is None:  # noqa: E501
            raise ValueError("Invalid value for `size`, must not be `None`")  # noqa: E501

        self._size = size

    @property
    def type(self):
        """Gets the type of this OvfDisk.  # noqa: E501


        :return: The type of this OvfDisk.  # noqa: E501
        :rtype: VmDiskType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this OvfDisk.


        :param type: The type of this OvfDisk.  # noqa: E501
        :type type: VmDiskType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def bus(self):
        """Gets the bus of this OvfDisk.  # noqa: E501


        :return: The bus of this OvfDisk.  # noqa: E501
        :rtype: Bus
        """
        return self._bus

    @bus.setter
    def bus(self, bus):
        """Sets the bus of this OvfDisk.


        :param bus: The bus of this OvfDisk.  # noqa: E501
        :type bus: Bus
        """
        if self.local_vars_configuration.client_side_validation and bus is None:  # noqa: E501
            raise ValueError("Invalid value for `bus`, must not be `None`")  # noqa: E501

        self._bus = bus

    @property
    def name(self):
        """Gets the name of this OvfDisk.  # noqa: E501


        :return: The name of this OvfDisk.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this OvfDisk.


        :param name: The name of this OvfDisk.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OvfDisk):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OvfDisk):
            return True

        return self.to_dict() != other.to_dict()
