# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class PciDevice(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'bus': 'str',
        'bus_location': 'str',
        'class_code': 'str',
        'device_type': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'function_num': 'str',
        'host': 'NestedHost',
        'id': 'str',
        'iommu_status': 'IommuStatus',
        'local_id': 'str',
        'mdev_state': 'PciDeviceMdevState',
        'mdev_type_id': 'str',
        'name': 'str',
        'partitioning_state': 'PciDevicePartitionState',
        'product_id': 'str',
        'slot': 'str',
        'sriov_state': 'PciDeviceSriovState',
        'subsystem_product_id': 'str',
        'subsystem_vendor_id': 'str',
        'total_mdev_num': 'int',
        'total_partitioning_num': 'int',
        'total_vf_num': 'int',
        'usage_type': 'PciDeviceType',
        'used_mdev_num': 'int',
        'used_partitioning_num': 'int',
        'used_vf_num': 'int',
        'user_usage': 'PciDeviceUsage',
        'vendor_id': 'str',
        'verdor_name': 'str'
    }

    attribute_map = {
        'bus': 'bus',
        'bus_location': 'bus_location',
        'class_code': 'class_code',
        'device_type': 'device_type',
        'entity_async_status': 'entityAsyncStatus',
        'function_num': 'function_num',
        'host': 'host',
        'id': 'id',
        'iommu_status': 'iommu_status',
        'local_id': 'local_id',
        'mdev_state': 'mdev_state',
        'mdev_type_id': 'mdev_type_id',
        'name': 'name',
        'partitioning_state': 'partitioning_state',
        'product_id': 'product_id',
        'slot': 'slot',
        'sriov_state': 'sriov_state',
        'subsystem_product_id': 'subsystem_product_id',
        'subsystem_vendor_id': 'subsystem_vendor_id',
        'total_mdev_num': 'total_mdev_num',
        'total_partitioning_num': 'total_partitioning_num',
        'total_vf_num': 'total_vf_num',
        'usage_type': 'usage_type',
        'used_mdev_num': 'used_mdev_num',
        'used_partitioning_num': 'used_partitioning_num',
        'used_vf_num': 'used_vf_num',
        'user_usage': 'user_usage',
        'vendor_id': 'vendor_id',
        'verdor_name': 'verdor_name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """PciDevice - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._bus = None
        self._bus_location = None
        self._class_code = None
        self._device_type = None
        self._entity_async_status = None
        self._function_num = None
        self._host = None
        self._id = None
        self._iommu_status = None
        self._local_id = None
        self._mdev_state = None
        self._mdev_type_id = None
        self._name = None
        self._partitioning_state = None
        self._product_id = None
        self._slot = None
        self._sriov_state = None
        self._subsystem_product_id = None
        self._subsystem_vendor_id = None
        self._total_mdev_num = None
        self._total_partitioning_num = None
        self._total_vf_num = None
        self._usage_type = None
        self._used_mdev_num = None
        self._used_partitioning_num = None
        self._used_vf_num = None
        self._user_usage = None
        self._vendor_id = None
        self._verdor_name = None
        self.discriminator = None

        if "bus" in kwargs:
            self.bus = kwargs["bus"]
        if "bus_location" in kwargs:
            self.bus_location = kwargs["bus_location"]
        if "class_code" in kwargs:
            self.class_code = kwargs["class_code"]
        self.device_type = kwargs.get("device_type", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "function_num" in kwargs:
            self.function_num = kwargs["function_num"]
        if "host" in kwargs:
            self.host = kwargs["host"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.iommu_status = kwargs.get("iommu_status", None)
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        self.mdev_state = kwargs.get("mdev_state", None)
        self.mdev_type_id = kwargs.get("mdev_type_id", None)
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.partitioning_state = kwargs.get("partitioning_state", None)
        if "product_id" in kwargs:
            self.product_id = kwargs["product_id"]
        if "slot" in kwargs:
            self.slot = kwargs["slot"]
        self.sriov_state = kwargs.get("sriov_state", None)
        if "subsystem_product_id" in kwargs:
            self.subsystem_product_id = kwargs["subsystem_product_id"]
        if "subsystem_vendor_id" in kwargs:
            self.subsystem_vendor_id = kwargs["subsystem_vendor_id"]
        self.total_mdev_num = kwargs.get("total_mdev_num", None)
        self.total_partitioning_num = kwargs.get("total_partitioning_num", None)
        self.total_vf_num = kwargs.get("total_vf_num", None)
        self.usage_type = kwargs.get("usage_type", None)
        self.used_mdev_num = kwargs.get("used_mdev_num", None)
        self.used_partitioning_num = kwargs.get("used_partitioning_num", None)
        self.used_vf_num = kwargs.get("used_vf_num", None)
        self.user_usage = kwargs.get("user_usage", None)
        if "vendor_id" in kwargs:
            self.vendor_id = kwargs["vendor_id"]
        if "verdor_name" in kwargs:
            self.verdor_name = kwargs["verdor_name"]

    @property
    def bus(self):
        """Gets the bus of this PciDevice.  # noqa: E501


        :return: The bus of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._bus

    @bus.setter
    def bus(self, bus):
        """Sets the bus of this PciDevice.


        :param bus: The bus of this PciDevice.  # noqa: E501
        :type bus: str
        """
        if self.local_vars_configuration.client_side_validation and bus is None:  # noqa: E501
            raise ValueError("Invalid value for `bus`, must not be `None`")  # noqa: E501

        self._bus = bus

    @property
    def bus_location(self):
        """Gets the bus_location of this PciDevice.  # noqa: E501


        :return: The bus_location of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._bus_location

    @bus_location.setter
    def bus_location(self, bus_location):
        """Sets the bus_location of this PciDevice.


        :param bus_location: The bus_location of this PciDevice.  # noqa: E501
        :type bus_location: str
        """
        if self.local_vars_configuration.client_side_validation and bus_location is None:  # noqa: E501
            raise ValueError("Invalid value for `bus_location`, must not be `None`")  # noqa: E501

        self._bus_location = bus_location

    @property
    def class_code(self):
        """Gets the class_code of this PciDevice.  # noqa: E501


        :return: The class_code of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._class_code

    @class_code.setter
    def class_code(self, class_code):
        """Sets the class_code of this PciDevice.


        :param class_code: The class_code of this PciDevice.  # noqa: E501
        :type class_code: str
        """
        if self.local_vars_configuration.client_side_validation and class_code is None:  # noqa: E501
            raise ValueError("Invalid value for `class_code`, must not be `None`")  # noqa: E501

        self._class_code = class_code

    @property
    def device_type(self):
        """Gets the device_type of this PciDevice.  # noqa: E501


        :return: The device_type of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._device_type

    @device_type.setter
    def device_type(self, device_type):
        """Sets the device_type of this PciDevice.


        :param device_type: The device_type of this PciDevice.  # noqa: E501
        :type device_type: str
        """

        self._device_type = device_type

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this PciDevice.  # noqa: E501


        :return: The entity_async_status of this PciDevice.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this PciDevice.


        :param entity_async_status: The entity_async_status of this PciDevice.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def function_num(self):
        """Gets the function_num of this PciDevice.  # noqa: E501


        :return: The function_num of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._function_num

    @function_num.setter
    def function_num(self, function_num):
        """Sets the function_num of this PciDevice.


        :param function_num: The function_num of this PciDevice.  # noqa: E501
        :type function_num: str
        """
        if self.local_vars_configuration.client_side_validation and function_num is None:  # noqa: E501
            raise ValueError("Invalid value for `function_num`, must not be `None`")  # noqa: E501

        self._function_num = function_num

    @property
    def host(self):
        """Gets the host of this PciDevice.  # noqa: E501


        :return: The host of this PciDevice.  # noqa: E501
        :rtype: NestedHost
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this PciDevice.


        :param host: The host of this PciDevice.  # noqa: E501
        :type host: NestedHost
        """
        if self.local_vars_configuration.client_side_validation and host is None:  # noqa: E501
            raise ValueError("Invalid value for `host`, must not be `None`")  # noqa: E501

        self._host = host

    @property
    def id(self):
        """Gets the id of this PciDevice.  # noqa: E501


        :return: The id of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this PciDevice.


        :param id: The id of this PciDevice.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def iommu_status(self):
        """Gets the iommu_status of this PciDevice.  # noqa: E501


        :return: The iommu_status of this PciDevice.  # noqa: E501
        :rtype: IommuStatus
        """
        return self._iommu_status

    @iommu_status.setter
    def iommu_status(self, iommu_status):
        """Sets the iommu_status of this PciDevice.


        :param iommu_status: The iommu_status of this PciDevice.  # noqa: E501
        :type iommu_status: IommuStatus
        """

        self._iommu_status = iommu_status

    @property
    def local_id(self):
        """Gets the local_id of this PciDevice.  # noqa: E501


        :return: The local_id of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this PciDevice.


        :param local_id: The local_id of this PciDevice.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def mdev_state(self):
        """Gets the mdev_state of this PciDevice.  # noqa: E501


        :return: The mdev_state of this PciDevice.  # noqa: E501
        :rtype: PciDeviceMdevState
        """
        return self._mdev_state

    @mdev_state.setter
    def mdev_state(self, mdev_state):
        """Sets the mdev_state of this PciDevice.


        :param mdev_state: The mdev_state of this PciDevice.  # noqa: E501
        :type mdev_state: PciDeviceMdevState
        """

        self._mdev_state = mdev_state

    @property
    def mdev_type_id(self):
        """Gets the mdev_type_id of this PciDevice.  # noqa: E501


        :return: The mdev_type_id of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._mdev_type_id

    @mdev_type_id.setter
    def mdev_type_id(self, mdev_type_id):
        """Sets the mdev_type_id of this PciDevice.


        :param mdev_type_id: The mdev_type_id of this PciDevice.  # noqa: E501
        :type mdev_type_id: str
        """

        self._mdev_type_id = mdev_type_id

    @property
    def name(self):
        """Gets the name of this PciDevice.  # noqa: E501


        :return: The name of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PciDevice.


        :param name: The name of this PciDevice.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def partitioning_state(self):
        """Gets the partitioning_state of this PciDevice.  # noqa: E501


        :return: The partitioning_state of this PciDevice.  # noqa: E501
        :rtype: PciDevicePartitionState
        """
        return self._partitioning_state

    @partitioning_state.setter
    def partitioning_state(self, partitioning_state):
        """Sets the partitioning_state of this PciDevice.


        :param partitioning_state: The partitioning_state of this PciDevice.  # noqa: E501
        :type partitioning_state: PciDevicePartitionState
        """

        self._partitioning_state = partitioning_state

    @property
    def product_id(self):
        """Gets the product_id of this PciDevice.  # noqa: E501


        :return: The product_id of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._product_id

    @product_id.setter
    def product_id(self, product_id):
        """Sets the product_id of this PciDevice.


        :param product_id: The product_id of this PciDevice.  # noqa: E501
        :type product_id: str
        """
        if self.local_vars_configuration.client_side_validation and product_id is None:  # noqa: E501
            raise ValueError("Invalid value for `product_id`, must not be `None`")  # noqa: E501

        self._product_id = product_id

    @property
    def slot(self):
        """Gets the slot of this PciDevice.  # noqa: E501


        :return: The slot of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._slot

    @slot.setter
    def slot(self, slot):
        """Sets the slot of this PciDevice.


        :param slot: The slot of this PciDevice.  # noqa: E501
        :type slot: str
        """
        if self.local_vars_configuration.client_side_validation and slot is None:  # noqa: E501
            raise ValueError("Invalid value for `slot`, must not be `None`")  # noqa: E501

        self._slot = slot

    @property
    def sriov_state(self):
        """Gets the sriov_state of this PciDevice.  # noqa: E501


        :return: The sriov_state of this PciDevice.  # noqa: E501
        :rtype: PciDeviceSriovState
        """
        return self._sriov_state

    @sriov_state.setter
    def sriov_state(self, sriov_state):
        """Sets the sriov_state of this PciDevice.


        :param sriov_state: The sriov_state of this PciDevice.  # noqa: E501
        :type sriov_state: PciDeviceSriovState
        """

        self._sriov_state = sriov_state

    @property
    def subsystem_product_id(self):
        """Gets the subsystem_product_id of this PciDevice.  # noqa: E501


        :return: The subsystem_product_id of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._subsystem_product_id

    @subsystem_product_id.setter
    def subsystem_product_id(self, subsystem_product_id):
        """Sets the subsystem_product_id of this PciDevice.


        :param subsystem_product_id: The subsystem_product_id of this PciDevice.  # noqa: E501
        :type subsystem_product_id: str
        """
        if self.local_vars_configuration.client_side_validation and subsystem_product_id is None:  # noqa: E501
            raise ValueError("Invalid value for `subsystem_product_id`, must not be `None`")  # noqa: E501

        self._subsystem_product_id = subsystem_product_id

    @property
    def subsystem_vendor_id(self):
        """Gets the subsystem_vendor_id of this PciDevice.  # noqa: E501


        :return: The subsystem_vendor_id of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._subsystem_vendor_id

    @subsystem_vendor_id.setter
    def subsystem_vendor_id(self, subsystem_vendor_id):
        """Sets the subsystem_vendor_id of this PciDevice.


        :param subsystem_vendor_id: The subsystem_vendor_id of this PciDevice.  # noqa: E501
        :type subsystem_vendor_id: str
        """
        if self.local_vars_configuration.client_side_validation and subsystem_vendor_id is None:  # noqa: E501
            raise ValueError("Invalid value for `subsystem_vendor_id`, must not be `None`")  # noqa: E501

        self._subsystem_vendor_id = subsystem_vendor_id

    @property
    def total_mdev_num(self):
        """Gets the total_mdev_num of this PciDevice.  # noqa: E501


        :return: The total_mdev_num of this PciDevice.  # noqa: E501
        :rtype: int
        """
        return self._total_mdev_num

    @total_mdev_num.setter
    def total_mdev_num(self, total_mdev_num):
        """Sets the total_mdev_num of this PciDevice.


        :param total_mdev_num: The total_mdev_num of this PciDevice.  # noqa: E501
        :type total_mdev_num: int
        """

        self._total_mdev_num = total_mdev_num

    @property
    def total_partitioning_num(self):
        """Gets the total_partitioning_num of this PciDevice.  # noqa: E501


        :return: The total_partitioning_num of this PciDevice.  # noqa: E501
        :rtype: int
        """
        return self._total_partitioning_num

    @total_partitioning_num.setter
    def total_partitioning_num(self, total_partitioning_num):
        """Sets the total_partitioning_num of this PciDevice.


        :param total_partitioning_num: The total_partitioning_num of this PciDevice.  # noqa: E501
        :type total_partitioning_num: int
        """

        self._total_partitioning_num = total_partitioning_num

    @property
    def total_vf_num(self):
        """Gets the total_vf_num of this PciDevice.  # noqa: E501


        :return: The total_vf_num of this PciDevice.  # noqa: E501
        :rtype: int
        """
        return self._total_vf_num

    @total_vf_num.setter
    def total_vf_num(self, total_vf_num):
        """Sets the total_vf_num of this PciDevice.


        :param total_vf_num: The total_vf_num of this PciDevice.  # noqa: E501
        :type total_vf_num: int
        """

        self._total_vf_num = total_vf_num

    @property
    def usage_type(self):
        """Gets the usage_type of this PciDevice.  # noqa: E501


        :return: The usage_type of this PciDevice.  # noqa: E501
        :rtype: PciDeviceType
        """
        return self._usage_type

    @usage_type.setter
    def usage_type(self, usage_type):
        """Sets the usage_type of this PciDevice.


        :param usage_type: The usage_type of this PciDevice.  # noqa: E501
        :type usage_type: PciDeviceType
        """

        self._usage_type = usage_type

    @property
    def used_mdev_num(self):
        """Gets the used_mdev_num of this PciDevice.  # noqa: E501


        :return: The used_mdev_num of this PciDevice.  # noqa: E501
        :rtype: int
        """
        return self._used_mdev_num

    @used_mdev_num.setter
    def used_mdev_num(self, used_mdev_num):
        """Sets the used_mdev_num of this PciDevice.


        :param used_mdev_num: The used_mdev_num of this PciDevice.  # noqa: E501
        :type used_mdev_num: int
        """

        self._used_mdev_num = used_mdev_num

    @property
    def used_partitioning_num(self):
        """Gets the used_partitioning_num of this PciDevice.  # noqa: E501


        :return: The used_partitioning_num of this PciDevice.  # noqa: E501
        :rtype: int
        """
        return self._used_partitioning_num

    @used_partitioning_num.setter
    def used_partitioning_num(self, used_partitioning_num):
        """Sets the used_partitioning_num of this PciDevice.


        :param used_partitioning_num: The used_partitioning_num of this PciDevice.  # noqa: E501
        :type used_partitioning_num: int
        """

        self._used_partitioning_num = used_partitioning_num

    @property
    def used_vf_num(self):
        """Gets the used_vf_num of this PciDevice.  # noqa: E501


        :return: The used_vf_num of this PciDevice.  # noqa: E501
        :rtype: int
        """
        return self._used_vf_num

    @used_vf_num.setter
    def used_vf_num(self, used_vf_num):
        """Sets the used_vf_num of this PciDevice.


        :param used_vf_num: The used_vf_num of this PciDevice.  # noqa: E501
        :type used_vf_num: int
        """

        self._used_vf_num = used_vf_num

    @property
    def user_usage(self):
        """Gets the user_usage of this PciDevice.  # noqa: E501


        :return: The user_usage of this PciDevice.  # noqa: E501
        :rtype: PciDeviceUsage
        """
        return self._user_usage

    @user_usage.setter
    def user_usage(self, user_usage):
        """Sets the user_usage of this PciDevice.


        :param user_usage: The user_usage of this PciDevice.  # noqa: E501
        :type user_usage: PciDeviceUsage
        """

        self._user_usage = user_usage

    @property
    def vendor_id(self):
        """Gets the vendor_id of this PciDevice.  # noqa: E501


        :return: The vendor_id of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._vendor_id

    @vendor_id.setter
    def vendor_id(self, vendor_id):
        """Sets the vendor_id of this PciDevice.


        :param vendor_id: The vendor_id of this PciDevice.  # noqa: E501
        :type vendor_id: str
        """
        if self.local_vars_configuration.client_side_validation and vendor_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vendor_id`, must not be `None`")  # noqa: E501

        self._vendor_id = vendor_id

    @property
    def verdor_name(self):
        """Gets the verdor_name of this PciDevice.  # noqa: E501


        :return: The verdor_name of this PciDevice.  # noqa: E501
        :rtype: str
        """
        return self._verdor_name

    @verdor_name.setter
    def verdor_name(self, verdor_name):
        """Sets the verdor_name of this PciDevice.


        :param verdor_name: The verdor_name of this PciDevice.  # noqa: E501
        :type verdor_name: str
        """
        if self.local_vars_configuration.client_side_validation and verdor_name is None:  # noqa: E501
            raise ValueError("Invalid value for `verdor_name`, must not be `None`")  # noqa: E501

        self._verdor_name = verdor_name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PciDevice):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PciDevice):
            return True

        return self.to_dict() != other.to_dict()
