# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class PciDeviceOrderByInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    allowed enum values
    """
    BUS_ASC = "bus_ASC"
    BUS_DESC = "bus_DESC"
    BUS_LOCATION_ASC = "bus_location_ASC"
    BUS_LOCATION_DESC = "bus_location_DESC"
    CLASS_CODE_ASC = "class_code_ASC"
    CLASS_CODE_DESC = "class_code_DESC"
    DEVICE_TYPE_ASC = "device_type_ASC"
    DEVICE_TYPE_DESC = "device_type_DESC"
    ENTITYASYNCSTATUS_ASC = "entityAsyncStatus_ASC"
    ENTITYASYNCSTATUS_DESC = "entityAsyncStatus_DESC"
    FUNCTION_NUM_ASC = "function_num_ASC"
    FUNCTION_NUM_DESC = "function_num_DESC"
    ID_ASC = "id_ASC"
    ID_DESC = "id_DESC"
    IOMMU_STATUS_ASC = "iommu_status_ASC"
    IOMMU_STATUS_DESC = "iommu_status_DESC"
    LOCAL_ID_ASC = "local_id_ASC"
    LOCAL_ID_DESC = "local_id_DESC"
    MDEV_STATE_ASC = "mdev_state_ASC"
    MDEV_STATE_DESC = "mdev_state_DESC"
    MDEV_TYPE_ID_ASC = "mdev_type_id_ASC"
    MDEV_TYPE_ID_DESC = "mdev_type_id_DESC"
    NAME_ASC = "name_ASC"
    NAME_DESC = "name_DESC"
    PARTITIONING_STATE_ASC = "partitioning_state_ASC"
    PARTITIONING_STATE_DESC = "partitioning_state_DESC"
    PRODUCT_ID_ASC = "product_id_ASC"
    PRODUCT_ID_DESC = "product_id_DESC"
    SLOT_ASC = "slot_ASC"
    SLOT_DESC = "slot_DESC"
    SRIOV_STATE_ASC = "sriov_state_ASC"
    SRIOV_STATE_DESC = "sriov_state_DESC"
    SUBSYSTEM_PRODUCT_ID_ASC = "subsystem_product_id_ASC"
    SUBSYSTEM_PRODUCT_ID_DESC = "subsystem_product_id_DESC"
    SUBSYSTEM_VENDOR_ID_ASC = "subsystem_vendor_id_ASC"
    SUBSYSTEM_VENDOR_ID_DESC = "subsystem_vendor_id_DESC"
    TOTAL_MDEV_NUM_ASC = "total_mdev_num_ASC"
    TOTAL_MDEV_NUM_DESC = "total_mdev_num_DESC"
    TOTAL_PARTITIONING_NUM_ASC = "total_partitioning_num_ASC"
    TOTAL_PARTITIONING_NUM_DESC = "total_partitioning_num_DESC"
    TOTAL_VF_NUM_ASC = "total_vf_num_ASC"
    TOTAL_VF_NUM_DESC = "total_vf_num_DESC"
    USAGE_TYPE_ASC = "usage_type_ASC"
    USAGE_TYPE_DESC = "usage_type_DESC"
    USED_MDEV_NUM_ASC = "used_mdev_num_ASC"
    USED_MDEV_NUM_DESC = "used_mdev_num_DESC"
    USED_PARTITIONING_NUM_ASC = "used_partitioning_num_ASC"
    USED_PARTITIONING_NUM_DESC = "used_partitioning_num_DESC"
    USED_VF_NUM_ASC = "used_vf_num_ASC"
    USED_VF_NUM_DESC = "used_vf_num_DESC"
    USER_USAGE_ASC = "user_usage_ASC"
    USER_USAGE_DESC = "user_usage_DESC"
    VENDOR_ID_ASC = "vendor_id_ASC"
    VENDOR_ID_DESC = "vendor_id_DESC"
    VERDOR_NAME_ASC = "verdor_name_ASC"
    VERDOR_NAME_DESC = "verdor_name_DESC"

    allowable_values = [BUS_ASC, BUS_DESC, BUS_LOCATION_ASC, BUS_LOCATION_DESC, CLASS_CODE_ASC, CLASS_CODE_DESC, DEVICE_TYPE_ASC, DEVICE_TYPE_DESC, ENTITYASYNCSTATUS_ASC, ENTITYASYNCSTATUS_DESC, FUNCTION_NUM_ASC, FUNCTION_NUM_DESC, ID_ASC, ID_DESC, IOMMU_STATUS_ASC, IOMMU_STATUS_DESC, LOCAL_ID_ASC, LOCAL_ID_DESC, MDEV_STATE_ASC, MDEV_STATE_DESC, MDEV_TYPE_ID_ASC, MDEV_TYPE_ID_DESC, NAME_ASC, NAME_DESC, PARTITIONING_STATE_ASC, PARTITIONING_STATE_DESC, PRODUCT_ID_ASC, PRODUCT_ID_DESC, SLOT_ASC, SLOT_DESC, SRIOV_STATE_ASC, SRIOV_STATE_DESC, SUBSYSTEM_PRODUCT_ID_ASC, SUBSYSTEM_PRODUCT_ID_DESC, SUBSYSTEM_VENDOR_ID_ASC, SUBSYSTEM_VENDOR_ID_DESC, TOTAL_MDEV_NUM_ASC, TOTAL_MDEV_NUM_DESC, TOTAL_PARTITIONING_NUM_ASC, TOTAL_PARTITIONING_NUM_DESC, TOTAL_VF_NUM_ASC, TOTAL_VF_NUM_DESC, USAGE_TYPE_ASC, USAGE_TYPE_DESC, USED_MDEV_NUM_ASC, USED_MDEV_NUM_DESC, USED_PARTITIONING_NUM_ASC, USED_PARTITIONING_NUM_DESC, USED_VF_NUM_ASC, USED_VF_NUM_DESC, USER_USAGE_ASC, USER_USAGE_DESC, VENDOR_ID_ASC, VENDOR_ID_DESC, VERDOR_NAME_ASC, VERDOR_NAME_DESC]  # noqa: E501

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
    }

    attribute_map = {
    }

    def __init__(self, **kwargs):  # noqa: E501
        """PciDeviceOrderByInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())
        self.discriminator = None

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PciDeviceOrderByInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PciDeviceOrderByInput):
            return True

        return self.to_dict() != other.to_dict()
