# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class PmemDimmWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[PmemDimmWhereInput]',
        '_not': 'list[PmemDimmWhereInput]',
        '_or': 'list[PmemDimmWhereInput]',
        'capacity': 'int',
        'capacity_gt': 'int',
        'capacity_gte': 'int',
        'capacity_in': 'list[int]',
        'capacity_lt': 'int',
        'capacity_lte': 'int',
        'capacity_not': 'int',
        'capacity_not_in': 'list[int]',
        'device_locator': 'str',
        'device_locator_contains': 'str',
        'device_locator_ends_with': 'str',
        'device_locator_gt': 'str',
        'device_locator_gte': 'str',
        'device_locator_in': 'list[str]',
        'device_locator_lt': 'str',
        'device_locator_lte': 'str',
        'device_locator_not': 'str',
        'device_locator_not_contains': 'str',
        'device_locator_not_ends_with': 'str',
        'device_locator_not_in': 'list[str]',
        'device_locator_not_starts_with': 'str',
        'device_locator_starts_with': 'str',
        'disk': 'DiskWhereInput',
        'health_status': 'DiskHealthStatus',
        'health_status_in': 'list[DiskHealthStatus]',
        'health_status_not': 'DiskHealthStatus',
        'health_status_not_in': 'list[DiskHealthStatus]',
        'host': 'HostWhereInput',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'numa_node': 'int',
        'numa_node_gt': 'int',
        'numa_node_gte': 'int',
        'numa_node_in': 'list[int]',
        'numa_node_lt': 'int',
        'numa_node_lte': 'int',
        'numa_node_not': 'int',
        'numa_node_not_in': 'list[int]',
        'part_number': 'str',
        'part_number_contains': 'str',
        'part_number_ends_with': 'str',
        'part_number_gt': 'str',
        'part_number_gte': 'str',
        'part_number_in': 'list[str]',
        'part_number_lt': 'str',
        'part_number_lte': 'str',
        'part_number_not': 'str',
        'part_number_not_contains': 'str',
        'part_number_not_ends_with': 'str',
        'part_number_not_in': 'list[str]',
        'part_number_not_starts_with': 'str',
        'part_number_starts_with': 'str',
        'remaining_life_percent': 'int',
        'remaining_life_percent_gt': 'int',
        'remaining_life_percent_gte': 'int',
        'remaining_life_percent_in': 'list[int]',
        'remaining_life_percent_lt': 'int',
        'remaining_life_percent_lte': 'int',
        'remaining_life_percent_not': 'int',
        'remaining_life_percent_not_in': 'list[int]',
        'version': 'str',
        'version_contains': 'str',
        'version_ends_with': 'str',
        'version_gt': 'str',
        'version_gte': 'str',
        'version_in': 'list[str]',
        'version_lt': 'str',
        'version_lte': 'str',
        'version_not': 'str',
        'version_not_contains': 'str',
        'version_not_ends_with': 'str',
        'version_not_in': 'list[str]',
        'version_not_starts_with': 'str',
        'version_starts_with': 'str'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'capacity': 'capacity',
        'capacity_gt': 'capacity_gt',
        'capacity_gte': 'capacity_gte',
        'capacity_in': 'capacity_in',
        'capacity_lt': 'capacity_lt',
        'capacity_lte': 'capacity_lte',
        'capacity_not': 'capacity_not',
        'capacity_not_in': 'capacity_not_in',
        'device_locator': 'device_locator',
        'device_locator_contains': 'device_locator_contains',
        'device_locator_ends_with': 'device_locator_ends_with',
        'device_locator_gt': 'device_locator_gt',
        'device_locator_gte': 'device_locator_gte',
        'device_locator_in': 'device_locator_in',
        'device_locator_lt': 'device_locator_lt',
        'device_locator_lte': 'device_locator_lte',
        'device_locator_not': 'device_locator_not',
        'device_locator_not_contains': 'device_locator_not_contains',
        'device_locator_not_ends_with': 'device_locator_not_ends_with',
        'device_locator_not_in': 'device_locator_not_in',
        'device_locator_not_starts_with': 'device_locator_not_starts_with',
        'device_locator_starts_with': 'device_locator_starts_with',
        'disk': 'disk',
        'health_status': 'health_status',
        'health_status_in': 'health_status_in',
        'health_status_not': 'health_status_not',
        'health_status_not_in': 'health_status_not_in',
        'host': 'host',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'numa_node': 'numa_node',
        'numa_node_gt': 'numa_node_gt',
        'numa_node_gte': 'numa_node_gte',
        'numa_node_in': 'numa_node_in',
        'numa_node_lt': 'numa_node_lt',
        'numa_node_lte': 'numa_node_lte',
        'numa_node_not': 'numa_node_not',
        'numa_node_not_in': 'numa_node_not_in',
        'part_number': 'part_number',
        'part_number_contains': 'part_number_contains',
        'part_number_ends_with': 'part_number_ends_with',
        'part_number_gt': 'part_number_gt',
        'part_number_gte': 'part_number_gte',
        'part_number_in': 'part_number_in',
        'part_number_lt': 'part_number_lt',
        'part_number_lte': 'part_number_lte',
        'part_number_not': 'part_number_not',
        'part_number_not_contains': 'part_number_not_contains',
        'part_number_not_ends_with': 'part_number_not_ends_with',
        'part_number_not_in': 'part_number_not_in',
        'part_number_not_starts_with': 'part_number_not_starts_with',
        'part_number_starts_with': 'part_number_starts_with',
        'remaining_life_percent': 'remaining_life_percent',
        'remaining_life_percent_gt': 'remaining_life_percent_gt',
        'remaining_life_percent_gte': 'remaining_life_percent_gte',
        'remaining_life_percent_in': 'remaining_life_percent_in',
        'remaining_life_percent_lt': 'remaining_life_percent_lt',
        'remaining_life_percent_lte': 'remaining_life_percent_lte',
        'remaining_life_percent_not': 'remaining_life_percent_not',
        'remaining_life_percent_not_in': 'remaining_life_percent_not_in',
        'version': 'version',
        'version_contains': 'version_contains',
        'version_ends_with': 'version_ends_with',
        'version_gt': 'version_gt',
        'version_gte': 'version_gte',
        'version_in': 'version_in',
        'version_lt': 'version_lt',
        'version_lte': 'version_lte',
        'version_not': 'version_not',
        'version_not_contains': 'version_not_contains',
        'version_not_ends_with': 'version_not_ends_with',
        'version_not_in': 'version_not_in',
        'version_not_starts_with': 'version_not_starts_with',
        'version_starts_with': 'version_starts_with'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """PmemDimmWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._capacity = None
        self._capacity_gt = None
        self._capacity_gte = None
        self._capacity_in = None
        self._capacity_lt = None
        self._capacity_lte = None
        self._capacity_not = None
        self._capacity_not_in = None
        self._device_locator = None
        self._device_locator_contains = None
        self._device_locator_ends_with = None
        self._device_locator_gt = None
        self._device_locator_gte = None
        self._device_locator_in = None
        self._device_locator_lt = None
        self._device_locator_lte = None
        self._device_locator_not = None
        self._device_locator_not_contains = None
        self._device_locator_not_ends_with = None
        self._device_locator_not_in = None
        self._device_locator_not_starts_with = None
        self._device_locator_starts_with = None
        self._disk = None
        self._health_status = None
        self._health_status_in = None
        self._health_status_not = None
        self._health_status_not_in = None
        self._host = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._numa_node = None
        self._numa_node_gt = None
        self._numa_node_gte = None
        self._numa_node_in = None
        self._numa_node_lt = None
        self._numa_node_lte = None
        self._numa_node_not = None
        self._numa_node_not_in = None
        self._part_number = None
        self._part_number_contains = None
        self._part_number_ends_with = None
        self._part_number_gt = None
        self._part_number_gte = None
        self._part_number_in = None
        self._part_number_lt = None
        self._part_number_lte = None
        self._part_number_not = None
        self._part_number_not_contains = None
        self._part_number_not_ends_with = None
        self._part_number_not_in = None
        self._part_number_not_starts_with = None
        self._part_number_starts_with = None
        self._remaining_life_percent = None
        self._remaining_life_percent_gt = None
        self._remaining_life_percent_gte = None
        self._remaining_life_percent_in = None
        self._remaining_life_percent_lt = None
        self._remaining_life_percent_lte = None
        self._remaining_life_percent_not = None
        self._remaining_life_percent_not_in = None
        self._version = None
        self._version_contains = None
        self._version_ends_with = None
        self._version_gt = None
        self._version_gte = None
        self._version_in = None
        self._version_lt = None
        self._version_lte = None
        self._version_not = None
        self._version_not_contains = None
        self._version_not_ends_with = None
        self._version_not_in = None
        self._version_not_starts_with = None
        self._version_starts_with = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.capacity = kwargs.get("capacity", None)
        self.capacity_gt = kwargs.get("capacity_gt", None)
        self.capacity_gte = kwargs.get("capacity_gte", None)
        self.capacity_in = kwargs.get("capacity_in", None)
        self.capacity_lt = kwargs.get("capacity_lt", None)
        self.capacity_lte = kwargs.get("capacity_lte", None)
        self.capacity_not = kwargs.get("capacity_not", None)
        self.capacity_not_in = kwargs.get("capacity_not_in", None)
        self.device_locator = kwargs.get("device_locator", None)
        self.device_locator_contains = kwargs.get("device_locator_contains", None)
        self.device_locator_ends_with = kwargs.get("device_locator_ends_with", None)
        self.device_locator_gt = kwargs.get("device_locator_gt", None)
        self.device_locator_gte = kwargs.get("device_locator_gte", None)
        self.device_locator_in = kwargs.get("device_locator_in", None)
        self.device_locator_lt = kwargs.get("device_locator_lt", None)
        self.device_locator_lte = kwargs.get("device_locator_lte", None)
        self.device_locator_not = kwargs.get("device_locator_not", None)
        self.device_locator_not_contains = kwargs.get("device_locator_not_contains", None)
        self.device_locator_not_ends_with = kwargs.get("device_locator_not_ends_with", None)
        self.device_locator_not_in = kwargs.get("device_locator_not_in", None)
        self.device_locator_not_starts_with = kwargs.get("device_locator_not_starts_with", None)
        self.device_locator_starts_with = kwargs.get("device_locator_starts_with", None)
        self.disk = kwargs.get("disk", None)
        self.health_status = kwargs.get("health_status", None)
        self.health_status_in = kwargs.get("health_status_in", None)
        self.health_status_not = kwargs.get("health_status_not", None)
        self.health_status_not_in = kwargs.get("health_status_not_in", None)
        self.host = kwargs.get("host", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.numa_node = kwargs.get("numa_node", None)
        self.numa_node_gt = kwargs.get("numa_node_gt", None)
        self.numa_node_gte = kwargs.get("numa_node_gte", None)
        self.numa_node_in = kwargs.get("numa_node_in", None)
        self.numa_node_lt = kwargs.get("numa_node_lt", None)
        self.numa_node_lte = kwargs.get("numa_node_lte", None)
        self.numa_node_not = kwargs.get("numa_node_not", None)
        self.numa_node_not_in = kwargs.get("numa_node_not_in", None)
        self.part_number = kwargs.get("part_number", None)
        self.part_number_contains = kwargs.get("part_number_contains", None)
        self.part_number_ends_with = kwargs.get("part_number_ends_with", None)
        self.part_number_gt = kwargs.get("part_number_gt", None)
        self.part_number_gte = kwargs.get("part_number_gte", None)
        self.part_number_in = kwargs.get("part_number_in", None)
        self.part_number_lt = kwargs.get("part_number_lt", None)
        self.part_number_lte = kwargs.get("part_number_lte", None)
        self.part_number_not = kwargs.get("part_number_not", None)
        self.part_number_not_contains = kwargs.get("part_number_not_contains", None)
        self.part_number_not_ends_with = kwargs.get("part_number_not_ends_with", None)
        self.part_number_not_in = kwargs.get("part_number_not_in", None)
        self.part_number_not_starts_with = kwargs.get("part_number_not_starts_with", None)
        self.part_number_starts_with = kwargs.get("part_number_starts_with", None)
        self.remaining_life_percent = kwargs.get("remaining_life_percent", None)
        self.remaining_life_percent_gt = kwargs.get("remaining_life_percent_gt", None)
        self.remaining_life_percent_gte = kwargs.get("remaining_life_percent_gte", None)
        self.remaining_life_percent_in = kwargs.get("remaining_life_percent_in", None)
        self.remaining_life_percent_lt = kwargs.get("remaining_life_percent_lt", None)
        self.remaining_life_percent_lte = kwargs.get("remaining_life_percent_lte", None)
        self.remaining_life_percent_not = kwargs.get("remaining_life_percent_not", None)
        self.remaining_life_percent_not_in = kwargs.get("remaining_life_percent_not_in", None)
        self.version = kwargs.get("version", None)
        self.version_contains = kwargs.get("version_contains", None)
        self.version_ends_with = kwargs.get("version_ends_with", None)
        self.version_gt = kwargs.get("version_gt", None)
        self.version_gte = kwargs.get("version_gte", None)
        self.version_in = kwargs.get("version_in", None)
        self.version_lt = kwargs.get("version_lt", None)
        self.version_lte = kwargs.get("version_lte", None)
        self.version_not = kwargs.get("version_not", None)
        self.version_not_contains = kwargs.get("version_not_contains", None)
        self.version_not_ends_with = kwargs.get("version_not_ends_with", None)
        self.version_not_in = kwargs.get("version_not_in", None)
        self.version_not_starts_with = kwargs.get("version_not_starts_with", None)
        self.version_starts_with = kwargs.get("version_starts_with", None)

    @property
    def _and(self):
        """Gets the _and of this PmemDimmWhereInput.  # noqa: E501


        :return: The _and of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[PmemDimmWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this PmemDimmWhereInput.


        :param _and: The _and of this PmemDimmWhereInput.  # noqa: E501
        :type _and: list[PmemDimmWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this PmemDimmWhereInput.  # noqa: E501


        :return: The _not of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[PmemDimmWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this PmemDimmWhereInput.


        :param _not: The _not of this PmemDimmWhereInput.  # noqa: E501
        :type _not: list[PmemDimmWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this PmemDimmWhereInput.  # noqa: E501


        :return: The _or of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[PmemDimmWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this PmemDimmWhereInput.


        :param _or: The _or of this PmemDimmWhereInput.  # noqa: E501
        :type _or: list[PmemDimmWhereInput]
        """

        self.__or = _or

    @property
    def capacity(self):
        """Gets the capacity of this PmemDimmWhereInput.  # noqa: E501


        :return: The capacity of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._capacity

    @capacity.setter
    def capacity(self, capacity):
        """Sets the capacity of this PmemDimmWhereInput.


        :param capacity: The capacity of this PmemDimmWhereInput.  # noqa: E501
        :type capacity: int
        """

        self._capacity = capacity

    @property
    def capacity_gt(self):
        """Gets the capacity_gt of this PmemDimmWhereInput.  # noqa: E501


        :return: The capacity_gt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._capacity_gt

    @capacity_gt.setter
    def capacity_gt(self, capacity_gt):
        """Sets the capacity_gt of this PmemDimmWhereInput.


        :param capacity_gt: The capacity_gt of this PmemDimmWhereInput.  # noqa: E501
        :type capacity_gt: int
        """

        self._capacity_gt = capacity_gt

    @property
    def capacity_gte(self):
        """Gets the capacity_gte of this PmemDimmWhereInput.  # noqa: E501


        :return: The capacity_gte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._capacity_gte

    @capacity_gte.setter
    def capacity_gte(self, capacity_gte):
        """Sets the capacity_gte of this PmemDimmWhereInput.


        :param capacity_gte: The capacity_gte of this PmemDimmWhereInput.  # noqa: E501
        :type capacity_gte: int
        """

        self._capacity_gte = capacity_gte

    @property
    def capacity_in(self):
        """Gets the capacity_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The capacity_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._capacity_in

    @capacity_in.setter
    def capacity_in(self, capacity_in):
        """Sets the capacity_in of this PmemDimmWhereInput.


        :param capacity_in: The capacity_in of this PmemDimmWhereInput.  # noqa: E501
        :type capacity_in: list[int]
        """

        self._capacity_in = capacity_in

    @property
    def capacity_lt(self):
        """Gets the capacity_lt of this PmemDimmWhereInput.  # noqa: E501


        :return: The capacity_lt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._capacity_lt

    @capacity_lt.setter
    def capacity_lt(self, capacity_lt):
        """Sets the capacity_lt of this PmemDimmWhereInput.


        :param capacity_lt: The capacity_lt of this PmemDimmWhereInput.  # noqa: E501
        :type capacity_lt: int
        """

        self._capacity_lt = capacity_lt

    @property
    def capacity_lte(self):
        """Gets the capacity_lte of this PmemDimmWhereInput.  # noqa: E501


        :return: The capacity_lte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._capacity_lte

    @capacity_lte.setter
    def capacity_lte(self, capacity_lte):
        """Sets the capacity_lte of this PmemDimmWhereInput.


        :param capacity_lte: The capacity_lte of this PmemDimmWhereInput.  # noqa: E501
        :type capacity_lte: int
        """

        self._capacity_lte = capacity_lte

    @property
    def capacity_not(self):
        """Gets the capacity_not of this PmemDimmWhereInput.  # noqa: E501


        :return: The capacity_not of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._capacity_not

    @capacity_not.setter
    def capacity_not(self, capacity_not):
        """Sets the capacity_not of this PmemDimmWhereInput.


        :param capacity_not: The capacity_not of this PmemDimmWhereInput.  # noqa: E501
        :type capacity_not: int
        """

        self._capacity_not = capacity_not

    @property
    def capacity_not_in(self):
        """Gets the capacity_not_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The capacity_not_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._capacity_not_in

    @capacity_not_in.setter
    def capacity_not_in(self, capacity_not_in):
        """Sets the capacity_not_in of this PmemDimmWhereInput.


        :param capacity_not_in: The capacity_not_in of this PmemDimmWhereInput.  # noqa: E501
        :type capacity_not_in: list[int]
        """

        self._capacity_not_in = capacity_not_in

    @property
    def device_locator(self):
        """Gets the device_locator of this PmemDimmWhereInput.  # noqa: E501


        :return: The device_locator of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._device_locator

    @device_locator.setter
    def device_locator(self, device_locator):
        """Sets the device_locator of this PmemDimmWhereInput.


        :param device_locator: The device_locator of this PmemDimmWhereInput.  # noqa: E501
        :type device_locator: str
        """

        self._device_locator = device_locator

    @property
    def device_locator_contains(self):
        """Gets the device_locator_contains of this PmemDimmWhereInput.  # noqa: E501


        :return: The device_locator_contains of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._device_locator_contains

    @device_locator_contains.setter
    def device_locator_contains(self, device_locator_contains):
        """Sets the device_locator_contains of this PmemDimmWhereInput.


        :param device_locator_contains: The device_locator_contains of this PmemDimmWhereInput.  # noqa: E501
        :type device_locator_contains: str
        """

        self._device_locator_contains = device_locator_contains

    @property
    def device_locator_ends_with(self):
        """Gets the device_locator_ends_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The device_locator_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._device_locator_ends_with

    @device_locator_ends_with.setter
    def device_locator_ends_with(self, device_locator_ends_with):
        """Sets the device_locator_ends_with of this PmemDimmWhereInput.


        :param device_locator_ends_with: The device_locator_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :type device_locator_ends_with: str
        """

        self._device_locator_ends_with = device_locator_ends_with

    @property
    def device_locator_gt(self):
        """Gets the device_locator_gt of this PmemDimmWhereInput.  # noqa: E501


        :return: The device_locator_gt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._device_locator_gt

    @device_locator_gt.setter
    def device_locator_gt(self, device_locator_gt):
        """Sets the device_locator_gt of this PmemDimmWhereInput.


        :param device_locator_gt: The device_locator_gt of this PmemDimmWhereInput.  # noqa: E501
        :type device_locator_gt: str
        """

        self._device_locator_gt = device_locator_gt

    @property
    def device_locator_gte(self):
        """Gets the device_locator_gte of this PmemDimmWhereInput.  # noqa: E501


        :return: The device_locator_gte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._device_locator_gte

    @device_locator_gte.setter
    def device_locator_gte(self, device_locator_gte):
        """Sets the device_locator_gte of this PmemDimmWhereInput.


        :param device_locator_gte: The device_locator_gte of this PmemDimmWhereInput.  # noqa: E501
        :type device_locator_gte: str
        """

        self._device_locator_gte = device_locator_gte

    @property
    def device_locator_in(self):
        """Gets the device_locator_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The device_locator_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._device_locator_in

    @device_locator_in.setter
    def device_locator_in(self, device_locator_in):
        """Sets the device_locator_in of this PmemDimmWhereInput.


        :param device_locator_in: The device_locator_in of this PmemDimmWhereInput.  # noqa: E501
        :type device_locator_in: list[str]
        """

        self._device_locator_in = device_locator_in

    @property
    def device_locator_lt(self):
        """Gets the device_locator_lt of this PmemDimmWhereInput.  # noqa: E501


        :return: The device_locator_lt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._device_locator_lt

    @device_locator_lt.setter
    def device_locator_lt(self, device_locator_lt):
        """Sets the device_locator_lt of this PmemDimmWhereInput.


        :param device_locator_lt: The device_locator_lt of this PmemDimmWhereInput.  # noqa: E501
        :type device_locator_lt: str
        """

        self._device_locator_lt = device_locator_lt

    @property
    def device_locator_lte(self):
        """Gets the device_locator_lte of this PmemDimmWhereInput.  # noqa: E501


        :return: The device_locator_lte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._device_locator_lte

    @device_locator_lte.setter
    def device_locator_lte(self, device_locator_lte):
        """Sets the device_locator_lte of this PmemDimmWhereInput.


        :param device_locator_lte: The device_locator_lte of this PmemDimmWhereInput.  # noqa: E501
        :type device_locator_lte: str
        """

        self._device_locator_lte = device_locator_lte

    @property
    def device_locator_not(self):
        """Gets the device_locator_not of this PmemDimmWhereInput.  # noqa: E501


        :return: The device_locator_not of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._device_locator_not

    @device_locator_not.setter
    def device_locator_not(self, device_locator_not):
        """Sets the device_locator_not of this PmemDimmWhereInput.


        :param device_locator_not: The device_locator_not of this PmemDimmWhereInput.  # noqa: E501
        :type device_locator_not: str
        """

        self._device_locator_not = device_locator_not

    @property
    def device_locator_not_contains(self):
        """Gets the device_locator_not_contains of this PmemDimmWhereInput.  # noqa: E501


        :return: The device_locator_not_contains of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._device_locator_not_contains

    @device_locator_not_contains.setter
    def device_locator_not_contains(self, device_locator_not_contains):
        """Sets the device_locator_not_contains of this PmemDimmWhereInput.


        :param device_locator_not_contains: The device_locator_not_contains of this PmemDimmWhereInput.  # noqa: E501
        :type device_locator_not_contains: str
        """

        self._device_locator_not_contains = device_locator_not_contains

    @property
    def device_locator_not_ends_with(self):
        """Gets the device_locator_not_ends_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The device_locator_not_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._device_locator_not_ends_with

    @device_locator_not_ends_with.setter
    def device_locator_not_ends_with(self, device_locator_not_ends_with):
        """Sets the device_locator_not_ends_with of this PmemDimmWhereInput.


        :param device_locator_not_ends_with: The device_locator_not_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :type device_locator_not_ends_with: str
        """

        self._device_locator_not_ends_with = device_locator_not_ends_with

    @property
    def device_locator_not_in(self):
        """Gets the device_locator_not_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The device_locator_not_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._device_locator_not_in

    @device_locator_not_in.setter
    def device_locator_not_in(self, device_locator_not_in):
        """Sets the device_locator_not_in of this PmemDimmWhereInput.


        :param device_locator_not_in: The device_locator_not_in of this PmemDimmWhereInput.  # noqa: E501
        :type device_locator_not_in: list[str]
        """

        self._device_locator_not_in = device_locator_not_in

    @property
    def device_locator_not_starts_with(self):
        """Gets the device_locator_not_starts_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The device_locator_not_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._device_locator_not_starts_with

    @device_locator_not_starts_with.setter
    def device_locator_not_starts_with(self, device_locator_not_starts_with):
        """Sets the device_locator_not_starts_with of this PmemDimmWhereInput.


        :param device_locator_not_starts_with: The device_locator_not_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :type device_locator_not_starts_with: str
        """

        self._device_locator_not_starts_with = device_locator_not_starts_with

    @property
    def device_locator_starts_with(self):
        """Gets the device_locator_starts_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The device_locator_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._device_locator_starts_with

    @device_locator_starts_with.setter
    def device_locator_starts_with(self, device_locator_starts_with):
        """Sets the device_locator_starts_with of this PmemDimmWhereInput.


        :param device_locator_starts_with: The device_locator_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :type device_locator_starts_with: str
        """

        self._device_locator_starts_with = device_locator_starts_with

    @property
    def disk(self):
        """Gets the disk of this PmemDimmWhereInput.  # noqa: E501


        :return: The disk of this PmemDimmWhereInput.  # noqa: E501
        :rtype: DiskWhereInput
        """
        return self._disk

    @disk.setter
    def disk(self, disk):
        """Sets the disk of this PmemDimmWhereInput.


        :param disk: The disk of this PmemDimmWhereInput.  # noqa: E501
        :type disk: DiskWhereInput
        """

        self._disk = disk

    @property
    def health_status(self):
        """Gets the health_status of this PmemDimmWhereInput.  # noqa: E501


        :return: The health_status of this PmemDimmWhereInput.  # noqa: E501
        :rtype: DiskHealthStatus
        """
        return self._health_status

    @health_status.setter
    def health_status(self, health_status):
        """Sets the health_status of this PmemDimmWhereInput.


        :param health_status: The health_status of this PmemDimmWhereInput.  # noqa: E501
        :type health_status: DiskHealthStatus
        """

        self._health_status = health_status

    @property
    def health_status_in(self):
        """Gets the health_status_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The health_status_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[DiskHealthStatus]
        """
        return self._health_status_in

    @health_status_in.setter
    def health_status_in(self, health_status_in):
        """Sets the health_status_in of this PmemDimmWhereInput.


        :param health_status_in: The health_status_in of this PmemDimmWhereInput.  # noqa: E501
        :type health_status_in: list[DiskHealthStatus]
        """

        self._health_status_in = health_status_in

    @property
    def health_status_not(self):
        """Gets the health_status_not of this PmemDimmWhereInput.  # noqa: E501


        :return: The health_status_not of this PmemDimmWhereInput.  # noqa: E501
        :rtype: DiskHealthStatus
        """
        return self._health_status_not

    @health_status_not.setter
    def health_status_not(self, health_status_not):
        """Sets the health_status_not of this PmemDimmWhereInput.


        :param health_status_not: The health_status_not of this PmemDimmWhereInput.  # noqa: E501
        :type health_status_not: DiskHealthStatus
        """

        self._health_status_not = health_status_not

    @property
    def health_status_not_in(self):
        """Gets the health_status_not_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The health_status_not_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[DiskHealthStatus]
        """
        return self._health_status_not_in

    @health_status_not_in.setter
    def health_status_not_in(self, health_status_not_in):
        """Sets the health_status_not_in of this PmemDimmWhereInput.


        :param health_status_not_in: The health_status_not_in of this PmemDimmWhereInput.  # noqa: E501
        :type health_status_not_in: list[DiskHealthStatus]
        """

        self._health_status_not_in = health_status_not_in

    @property
    def host(self):
        """Gets the host of this PmemDimmWhereInput.  # noqa: E501


        :return: The host of this PmemDimmWhereInput.  # noqa: E501
        :rtype: HostWhereInput
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this PmemDimmWhereInput.


        :param host: The host of this PmemDimmWhereInput.  # noqa: E501
        :type host: HostWhereInput
        """

        self._host = host

    @property
    def id(self):
        """Gets the id of this PmemDimmWhereInput.  # noqa: E501


        :return: The id of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this PmemDimmWhereInput.


        :param id: The id of this PmemDimmWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this PmemDimmWhereInput.  # noqa: E501


        :return: The id_contains of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this PmemDimmWhereInput.


        :param id_contains: The id_contains of this PmemDimmWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The id_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this PmemDimmWhereInput.


        :param id_ends_with: The id_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this PmemDimmWhereInput.  # noqa: E501


        :return: The id_gt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this PmemDimmWhereInput.


        :param id_gt: The id_gt of this PmemDimmWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this PmemDimmWhereInput.  # noqa: E501


        :return: The id_gte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this PmemDimmWhereInput.


        :param id_gte: The id_gte of this PmemDimmWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The id_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this PmemDimmWhereInput.


        :param id_in: The id_in of this PmemDimmWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this PmemDimmWhereInput.  # noqa: E501


        :return: The id_lt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this PmemDimmWhereInput.


        :param id_lt: The id_lt of this PmemDimmWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this PmemDimmWhereInput.  # noqa: E501


        :return: The id_lte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this PmemDimmWhereInput.


        :param id_lte: The id_lte of this PmemDimmWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this PmemDimmWhereInput.  # noqa: E501


        :return: The id_not of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this PmemDimmWhereInput.


        :param id_not: The id_not of this PmemDimmWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this PmemDimmWhereInput.  # noqa: E501


        :return: The id_not_contains of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this PmemDimmWhereInput.


        :param id_not_contains: The id_not_contains of this PmemDimmWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this PmemDimmWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The id_not_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this PmemDimmWhereInput.


        :param id_not_in: The id_not_in of this PmemDimmWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this PmemDimmWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The id_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this PmemDimmWhereInput.


        :param id_starts_with: The id_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def local_id(self):
        """Gets the local_id of this PmemDimmWhereInput.  # noqa: E501


        :return: The local_id of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this PmemDimmWhereInput.


        :param local_id: The local_id of this PmemDimmWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this PmemDimmWhereInput.  # noqa: E501


        :return: The local_id_contains of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this PmemDimmWhereInput.


        :param local_id_contains: The local_id_contains of this PmemDimmWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this PmemDimmWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this PmemDimmWhereInput.  # noqa: E501


        :return: The local_id_gt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this PmemDimmWhereInput.


        :param local_id_gt: The local_id_gt of this PmemDimmWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this PmemDimmWhereInput.  # noqa: E501


        :return: The local_id_gte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this PmemDimmWhereInput.


        :param local_id_gte: The local_id_gte of this PmemDimmWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The local_id_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this PmemDimmWhereInput.


        :param local_id_in: The local_id_in of this PmemDimmWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this PmemDimmWhereInput.  # noqa: E501


        :return: The local_id_lt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this PmemDimmWhereInput.


        :param local_id_lt: The local_id_lt of this PmemDimmWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this PmemDimmWhereInput.  # noqa: E501


        :return: The local_id_lte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this PmemDimmWhereInput.


        :param local_id_lte: The local_id_lte of this PmemDimmWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this PmemDimmWhereInput.  # noqa: E501


        :return: The local_id_not of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this PmemDimmWhereInput.


        :param local_id_not: The local_id_not of this PmemDimmWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this PmemDimmWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this PmemDimmWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this PmemDimmWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this PmemDimmWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The local_id_not_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this PmemDimmWhereInput.


        :param local_id_not_in: The local_id_not_in of this PmemDimmWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this PmemDimmWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this PmemDimmWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def name(self):
        """Gets the name of this PmemDimmWhereInput.  # noqa: E501


        :return: The name of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PmemDimmWhereInput.


        :param name: The name of this PmemDimmWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this PmemDimmWhereInput.  # noqa: E501


        :return: The name_contains of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this PmemDimmWhereInput.


        :param name_contains: The name_contains of this PmemDimmWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The name_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this PmemDimmWhereInput.


        :param name_ends_with: The name_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this PmemDimmWhereInput.  # noqa: E501


        :return: The name_gt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this PmemDimmWhereInput.


        :param name_gt: The name_gt of this PmemDimmWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this PmemDimmWhereInput.  # noqa: E501


        :return: The name_gte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this PmemDimmWhereInput.


        :param name_gte: The name_gte of this PmemDimmWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The name_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this PmemDimmWhereInput.


        :param name_in: The name_in of this PmemDimmWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this PmemDimmWhereInput.  # noqa: E501


        :return: The name_lt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this PmemDimmWhereInput.


        :param name_lt: The name_lt of this PmemDimmWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this PmemDimmWhereInput.  # noqa: E501


        :return: The name_lte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this PmemDimmWhereInput.


        :param name_lte: The name_lte of this PmemDimmWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this PmemDimmWhereInput.  # noqa: E501


        :return: The name_not of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this PmemDimmWhereInput.


        :param name_not: The name_not of this PmemDimmWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this PmemDimmWhereInput.  # noqa: E501


        :return: The name_not_contains of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this PmemDimmWhereInput.


        :param name_not_contains: The name_not_contains of this PmemDimmWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this PmemDimmWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The name_not_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this PmemDimmWhereInput.


        :param name_not_in: The name_not_in of this PmemDimmWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this PmemDimmWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The name_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this PmemDimmWhereInput.


        :param name_starts_with: The name_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def numa_node(self):
        """Gets the numa_node of this PmemDimmWhereInput.  # noqa: E501


        :return: The numa_node of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._numa_node

    @numa_node.setter
    def numa_node(self, numa_node):
        """Sets the numa_node of this PmemDimmWhereInput.


        :param numa_node: The numa_node of this PmemDimmWhereInput.  # noqa: E501
        :type numa_node: int
        """

        self._numa_node = numa_node

    @property
    def numa_node_gt(self):
        """Gets the numa_node_gt of this PmemDimmWhereInput.  # noqa: E501


        :return: The numa_node_gt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._numa_node_gt

    @numa_node_gt.setter
    def numa_node_gt(self, numa_node_gt):
        """Sets the numa_node_gt of this PmemDimmWhereInput.


        :param numa_node_gt: The numa_node_gt of this PmemDimmWhereInput.  # noqa: E501
        :type numa_node_gt: int
        """

        self._numa_node_gt = numa_node_gt

    @property
    def numa_node_gte(self):
        """Gets the numa_node_gte of this PmemDimmWhereInput.  # noqa: E501


        :return: The numa_node_gte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._numa_node_gte

    @numa_node_gte.setter
    def numa_node_gte(self, numa_node_gte):
        """Sets the numa_node_gte of this PmemDimmWhereInput.


        :param numa_node_gte: The numa_node_gte of this PmemDimmWhereInput.  # noqa: E501
        :type numa_node_gte: int
        """

        self._numa_node_gte = numa_node_gte

    @property
    def numa_node_in(self):
        """Gets the numa_node_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The numa_node_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._numa_node_in

    @numa_node_in.setter
    def numa_node_in(self, numa_node_in):
        """Sets the numa_node_in of this PmemDimmWhereInput.


        :param numa_node_in: The numa_node_in of this PmemDimmWhereInput.  # noqa: E501
        :type numa_node_in: list[int]
        """

        self._numa_node_in = numa_node_in

    @property
    def numa_node_lt(self):
        """Gets the numa_node_lt of this PmemDimmWhereInput.  # noqa: E501


        :return: The numa_node_lt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._numa_node_lt

    @numa_node_lt.setter
    def numa_node_lt(self, numa_node_lt):
        """Sets the numa_node_lt of this PmemDimmWhereInput.


        :param numa_node_lt: The numa_node_lt of this PmemDimmWhereInput.  # noqa: E501
        :type numa_node_lt: int
        """

        self._numa_node_lt = numa_node_lt

    @property
    def numa_node_lte(self):
        """Gets the numa_node_lte of this PmemDimmWhereInput.  # noqa: E501


        :return: The numa_node_lte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._numa_node_lte

    @numa_node_lte.setter
    def numa_node_lte(self, numa_node_lte):
        """Sets the numa_node_lte of this PmemDimmWhereInput.


        :param numa_node_lte: The numa_node_lte of this PmemDimmWhereInput.  # noqa: E501
        :type numa_node_lte: int
        """

        self._numa_node_lte = numa_node_lte

    @property
    def numa_node_not(self):
        """Gets the numa_node_not of this PmemDimmWhereInput.  # noqa: E501


        :return: The numa_node_not of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._numa_node_not

    @numa_node_not.setter
    def numa_node_not(self, numa_node_not):
        """Sets the numa_node_not of this PmemDimmWhereInput.


        :param numa_node_not: The numa_node_not of this PmemDimmWhereInput.  # noqa: E501
        :type numa_node_not: int
        """

        self._numa_node_not = numa_node_not

    @property
    def numa_node_not_in(self):
        """Gets the numa_node_not_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The numa_node_not_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._numa_node_not_in

    @numa_node_not_in.setter
    def numa_node_not_in(self, numa_node_not_in):
        """Sets the numa_node_not_in of this PmemDimmWhereInput.


        :param numa_node_not_in: The numa_node_not_in of this PmemDimmWhereInput.  # noqa: E501
        :type numa_node_not_in: list[int]
        """

        self._numa_node_not_in = numa_node_not_in

    @property
    def part_number(self):
        """Gets the part_number of this PmemDimmWhereInput.  # noqa: E501


        :return: The part_number of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._part_number

    @part_number.setter
    def part_number(self, part_number):
        """Sets the part_number of this PmemDimmWhereInput.


        :param part_number: The part_number of this PmemDimmWhereInput.  # noqa: E501
        :type part_number: str
        """

        self._part_number = part_number

    @property
    def part_number_contains(self):
        """Gets the part_number_contains of this PmemDimmWhereInput.  # noqa: E501


        :return: The part_number_contains of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._part_number_contains

    @part_number_contains.setter
    def part_number_contains(self, part_number_contains):
        """Sets the part_number_contains of this PmemDimmWhereInput.


        :param part_number_contains: The part_number_contains of this PmemDimmWhereInput.  # noqa: E501
        :type part_number_contains: str
        """

        self._part_number_contains = part_number_contains

    @property
    def part_number_ends_with(self):
        """Gets the part_number_ends_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The part_number_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._part_number_ends_with

    @part_number_ends_with.setter
    def part_number_ends_with(self, part_number_ends_with):
        """Sets the part_number_ends_with of this PmemDimmWhereInput.


        :param part_number_ends_with: The part_number_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :type part_number_ends_with: str
        """

        self._part_number_ends_with = part_number_ends_with

    @property
    def part_number_gt(self):
        """Gets the part_number_gt of this PmemDimmWhereInput.  # noqa: E501


        :return: The part_number_gt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._part_number_gt

    @part_number_gt.setter
    def part_number_gt(self, part_number_gt):
        """Sets the part_number_gt of this PmemDimmWhereInput.


        :param part_number_gt: The part_number_gt of this PmemDimmWhereInput.  # noqa: E501
        :type part_number_gt: str
        """

        self._part_number_gt = part_number_gt

    @property
    def part_number_gte(self):
        """Gets the part_number_gte of this PmemDimmWhereInput.  # noqa: E501


        :return: The part_number_gte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._part_number_gte

    @part_number_gte.setter
    def part_number_gte(self, part_number_gte):
        """Sets the part_number_gte of this PmemDimmWhereInput.


        :param part_number_gte: The part_number_gte of this PmemDimmWhereInput.  # noqa: E501
        :type part_number_gte: str
        """

        self._part_number_gte = part_number_gte

    @property
    def part_number_in(self):
        """Gets the part_number_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The part_number_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._part_number_in

    @part_number_in.setter
    def part_number_in(self, part_number_in):
        """Sets the part_number_in of this PmemDimmWhereInput.


        :param part_number_in: The part_number_in of this PmemDimmWhereInput.  # noqa: E501
        :type part_number_in: list[str]
        """

        self._part_number_in = part_number_in

    @property
    def part_number_lt(self):
        """Gets the part_number_lt of this PmemDimmWhereInput.  # noqa: E501


        :return: The part_number_lt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._part_number_lt

    @part_number_lt.setter
    def part_number_lt(self, part_number_lt):
        """Sets the part_number_lt of this PmemDimmWhereInput.


        :param part_number_lt: The part_number_lt of this PmemDimmWhereInput.  # noqa: E501
        :type part_number_lt: str
        """

        self._part_number_lt = part_number_lt

    @property
    def part_number_lte(self):
        """Gets the part_number_lte of this PmemDimmWhereInput.  # noqa: E501


        :return: The part_number_lte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._part_number_lte

    @part_number_lte.setter
    def part_number_lte(self, part_number_lte):
        """Sets the part_number_lte of this PmemDimmWhereInput.


        :param part_number_lte: The part_number_lte of this PmemDimmWhereInput.  # noqa: E501
        :type part_number_lte: str
        """

        self._part_number_lte = part_number_lte

    @property
    def part_number_not(self):
        """Gets the part_number_not of this PmemDimmWhereInput.  # noqa: E501


        :return: The part_number_not of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._part_number_not

    @part_number_not.setter
    def part_number_not(self, part_number_not):
        """Sets the part_number_not of this PmemDimmWhereInput.


        :param part_number_not: The part_number_not of this PmemDimmWhereInput.  # noqa: E501
        :type part_number_not: str
        """

        self._part_number_not = part_number_not

    @property
    def part_number_not_contains(self):
        """Gets the part_number_not_contains of this PmemDimmWhereInput.  # noqa: E501


        :return: The part_number_not_contains of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._part_number_not_contains

    @part_number_not_contains.setter
    def part_number_not_contains(self, part_number_not_contains):
        """Sets the part_number_not_contains of this PmemDimmWhereInput.


        :param part_number_not_contains: The part_number_not_contains of this PmemDimmWhereInput.  # noqa: E501
        :type part_number_not_contains: str
        """

        self._part_number_not_contains = part_number_not_contains

    @property
    def part_number_not_ends_with(self):
        """Gets the part_number_not_ends_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The part_number_not_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._part_number_not_ends_with

    @part_number_not_ends_with.setter
    def part_number_not_ends_with(self, part_number_not_ends_with):
        """Sets the part_number_not_ends_with of this PmemDimmWhereInput.


        :param part_number_not_ends_with: The part_number_not_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :type part_number_not_ends_with: str
        """

        self._part_number_not_ends_with = part_number_not_ends_with

    @property
    def part_number_not_in(self):
        """Gets the part_number_not_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The part_number_not_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._part_number_not_in

    @part_number_not_in.setter
    def part_number_not_in(self, part_number_not_in):
        """Sets the part_number_not_in of this PmemDimmWhereInput.


        :param part_number_not_in: The part_number_not_in of this PmemDimmWhereInput.  # noqa: E501
        :type part_number_not_in: list[str]
        """

        self._part_number_not_in = part_number_not_in

    @property
    def part_number_not_starts_with(self):
        """Gets the part_number_not_starts_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The part_number_not_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._part_number_not_starts_with

    @part_number_not_starts_with.setter
    def part_number_not_starts_with(self, part_number_not_starts_with):
        """Sets the part_number_not_starts_with of this PmemDimmWhereInput.


        :param part_number_not_starts_with: The part_number_not_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :type part_number_not_starts_with: str
        """

        self._part_number_not_starts_with = part_number_not_starts_with

    @property
    def part_number_starts_with(self):
        """Gets the part_number_starts_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The part_number_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._part_number_starts_with

    @part_number_starts_with.setter
    def part_number_starts_with(self, part_number_starts_with):
        """Sets the part_number_starts_with of this PmemDimmWhereInput.


        :param part_number_starts_with: The part_number_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :type part_number_starts_with: str
        """

        self._part_number_starts_with = part_number_starts_with

    @property
    def remaining_life_percent(self):
        """Gets the remaining_life_percent of this PmemDimmWhereInput.  # noqa: E501


        :return: The remaining_life_percent of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._remaining_life_percent

    @remaining_life_percent.setter
    def remaining_life_percent(self, remaining_life_percent):
        """Sets the remaining_life_percent of this PmemDimmWhereInput.


        :param remaining_life_percent: The remaining_life_percent of this PmemDimmWhereInput.  # noqa: E501
        :type remaining_life_percent: int
        """

        self._remaining_life_percent = remaining_life_percent

    @property
    def remaining_life_percent_gt(self):
        """Gets the remaining_life_percent_gt of this PmemDimmWhereInput.  # noqa: E501


        :return: The remaining_life_percent_gt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._remaining_life_percent_gt

    @remaining_life_percent_gt.setter
    def remaining_life_percent_gt(self, remaining_life_percent_gt):
        """Sets the remaining_life_percent_gt of this PmemDimmWhereInput.


        :param remaining_life_percent_gt: The remaining_life_percent_gt of this PmemDimmWhereInput.  # noqa: E501
        :type remaining_life_percent_gt: int
        """

        self._remaining_life_percent_gt = remaining_life_percent_gt

    @property
    def remaining_life_percent_gte(self):
        """Gets the remaining_life_percent_gte of this PmemDimmWhereInput.  # noqa: E501


        :return: The remaining_life_percent_gte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._remaining_life_percent_gte

    @remaining_life_percent_gte.setter
    def remaining_life_percent_gte(self, remaining_life_percent_gte):
        """Sets the remaining_life_percent_gte of this PmemDimmWhereInput.


        :param remaining_life_percent_gte: The remaining_life_percent_gte of this PmemDimmWhereInput.  # noqa: E501
        :type remaining_life_percent_gte: int
        """

        self._remaining_life_percent_gte = remaining_life_percent_gte

    @property
    def remaining_life_percent_in(self):
        """Gets the remaining_life_percent_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The remaining_life_percent_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._remaining_life_percent_in

    @remaining_life_percent_in.setter
    def remaining_life_percent_in(self, remaining_life_percent_in):
        """Sets the remaining_life_percent_in of this PmemDimmWhereInput.


        :param remaining_life_percent_in: The remaining_life_percent_in of this PmemDimmWhereInput.  # noqa: E501
        :type remaining_life_percent_in: list[int]
        """

        self._remaining_life_percent_in = remaining_life_percent_in

    @property
    def remaining_life_percent_lt(self):
        """Gets the remaining_life_percent_lt of this PmemDimmWhereInput.  # noqa: E501


        :return: The remaining_life_percent_lt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._remaining_life_percent_lt

    @remaining_life_percent_lt.setter
    def remaining_life_percent_lt(self, remaining_life_percent_lt):
        """Sets the remaining_life_percent_lt of this PmemDimmWhereInput.


        :param remaining_life_percent_lt: The remaining_life_percent_lt of this PmemDimmWhereInput.  # noqa: E501
        :type remaining_life_percent_lt: int
        """

        self._remaining_life_percent_lt = remaining_life_percent_lt

    @property
    def remaining_life_percent_lte(self):
        """Gets the remaining_life_percent_lte of this PmemDimmWhereInput.  # noqa: E501


        :return: The remaining_life_percent_lte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._remaining_life_percent_lte

    @remaining_life_percent_lte.setter
    def remaining_life_percent_lte(self, remaining_life_percent_lte):
        """Sets the remaining_life_percent_lte of this PmemDimmWhereInput.


        :param remaining_life_percent_lte: The remaining_life_percent_lte of this PmemDimmWhereInput.  # noqa: E501
        :type remaining_life_percent_lte: int
        """

        self._remaining_life_percent_lte = remaining_life_percent_lte

    @property
    def remaining_life_percent_not(self):
        """Gets the remaining_life_percent_not of this PmemDimmWhereInput.  # noqa: E501


        :return: The remaining_life_percent_not of this PmemDimmWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._remaining_life_percent_not

    @remaining_life_percent_not.setter
    def remaining_life_percent_not(self, remaining_life_percent_not):
        """Sets the remaining_life_percent_not of this PmemDimmWhereInput.


        :param remaining_life_percent_not: The remaining_life_percent_not of this PmemDimmWhereInput.  # noqa: E501
        :type remaining_life_percent_not: int
        """

        self._remaining_life_percent_not = remaining_life_percent_not

    @property
    def remaining_life_percent_not_in(self):
        """Gets the remaining_life_percent_not_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The remaining_life_percent_not_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._remaining_life_percent_not_in

    @remaining_life_percent_not_in.setter
    def remaining_life_percent_not_in(self, remaining_life_percent_not_in):
        """Sets the remaining_life_percent_not_in of this PmemDimmWhereInput.


        :param remaining_life_percent_not_in: The remaining_life_percent_not_in of this PmemDimmWhereInput.  # noqa: E501
        :type remaining_life_percent_not_in: list[int]
        """

        self._remaining_life_percent_not_in = remaining_life_percent_not_in

    @property
    def version(self):
        """Gets the version of this PmemDimmWhereInput.  # noqa: E501


        :return: The version of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this PmemDimmWhereInput.


        :param version: The version of this PmemDimmWhereInput.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def version_contains(self):
        """Gets the version_contains of this PmemDimmWhereInput.  # noqa: E501


        :return: The version_contains of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_contains

    @version_contains.setter
    def version_contains(self, version_contains):
        """Sets the version_contains of this PmemDimmWhereInput.


        :param version_contains: The version_contains of this PmemDimmWhereInput.  # noqa: E501
        :type version_contains: str
        """

        self._version_contains = version_contains

    @property
    def version_ends_with(self):
        """Gets the version_ends_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The version_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_ends_with

    @version_ends_with.setter
    def version_ends_with(self, version_ends_with):
        """Sets the version_ends_with of this PmemDimmWhereInput.


        :param version_ends_with: The version_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :type version_ends_with: str
        """

        self._version_ends_with = version_ends_with

    @property
    def version_gt(self):
        """Gets the version_gt of this PmemDimmWhereInput.  # noqa: E501


        :return: The version_gt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_gt

    @version_gt.setter
    def version_gt(self, version_gt):
        """Sets the version_gt of this PmemDimmWhereInput.


        :param version_gt: The version_gt of this PmemDimmWhereInput.  # noqa: E501
        :type version_gt: str
        """

        self._version_gt = version_gt

    @property
    def version_gte(self):
        """Gets the version_gte of this PmemDimmWhereInput.  # noqa: E501


        :return: The version_gte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_gte

    @version_gte.setter
    def version_gte(self, version_gte):
        """Sets the version_gte of this PmemDimmWhereInput.


        :param version_gte: The version_gte of this PmemDimmWhereInput.  # noqa: E501
        :type version_gte: str
        """

        self._version_gte = version_gte

    @property
    def version_in(self):
        """Gets the version_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The version_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._version_in

    @version_in.setter
    def version_in(self, version_in):
        """Sets the version_in of this PmemDimmWhereInput.


        :param version_in: The version_in of this PmemDimmWhereInput.  # noqa: E501
        :type version_in: list[str]
        """

        self._version_in = version_in

    @property
    def version_lt(self):
        """Gets the version_lt of this PmemDimmWhereInput.  # noqa: E501


        :return: The version_lt of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_lt

    @version_lt.setter
    def version_lt(self, version_lt):
        """Sets the version_lt of this PmemDimmWhereInput.


        :param version_lt: The version_lt of this PmemDimmWhereInput.  # noqa: E501
        :type version_lt: str
        """

        self._version_lt = version_lt

    @property
    def version_lte(self):
        """Gets the version_lte of this PmemDimmWhereInput.  # noqa: E501


        :return: The version_lte of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_lte

    @version_lte.setter
    def version_lte(self, version_lte):
        """Sets the version_lte of this PmemDimmWhereInput.


        :param version_lte: The version_lte of this PmemDimmWhereInput.  # noqa: E501
        :type version_lte: str
        """

        self._version_lte = version_lte

    @property
    def version_not(self):
        """Gets the version_not of this PmemDimmWhereInput.  # noqa: E501


        :return: The version_not of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_not

    @version_not.setter
    def version_not(self, version_not):
        """Sets the version_not of this PmemDimmWhereInput.


        :param version_not: The version_not of this PmemDimmWhereInput.  # noqa: E501
        :type version_not: str
        """

        self._version_not = version_not

    @property
    def version_not_contains(self):
        """Gets the version_not_contains of this PmemDimmWhereInput.  # noqa: E501


        :return: The version_not_contains of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_not_contains

    @version_not_contains.setter
    def version_not_contains(self, version_not_contains):
        """Sets the version_not_contains of this PmemDimmWhereInput.


        :param version_not_contains: The version_not_contains of this PmemDimmWhereInput.  # noqa: E501
        :type version_not_contains: str
        """

        self._version_not_contains = version_not_contains

    @property
    def version_not_ends_with(self):
        """Gets the version_not_ends_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The version_not_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_not_ends_with

    @version_not_ends_with.setter
    def version_not_ends_with(self, version_not_ends_with):
        """Sets the version_not_ends_with of this PmemDimmWhereInput.


        :param version_not_ends_with: The version_not_ends_with of this PmemDimmWhereInput.  # noqa: E501
        :type version_not_ends_with: str
        """

        self._version_not_ends_with = version_not_ends_with

    @property
    def version_not_in(self):
        """Gets the version_not_in of this PmemDimmWhereInput.  # noqa: E501


        :return: The version_not_in of this PmemDimmWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._version_not_in

    @version_not_in.setter
    def version_not_in(self, version_not_in):
        """Sets the version_not_in of this PmemDimmWhereInput.


        :param version_not_in: The version_not_in of this PmemDimmWhereInput.  # noqa: E501
        :type version_not_in: list[str]
        """

        self._version_not_in = version_not_in

    @property
    def version_not_starts_with(self):
        """Gets the version_not_starts_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The version_not_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_not_starts_with

    @version_not_starts_with.setter
    def version_not_starts_with(self, version_not_starts_with):
        """Sets the version_not_starts_with of this PmemDimmWhereInput.


        :param version_not_starts_with: The version_not_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :type version_not_starts_with: str
        """

        self._version_not_starts_with = version_not_starts_with

    @property
    def version_starts_with(self):
        """Gets the version_starts_with of this PmemDimmWhereInput.  # noqa: E501


        :return: The version_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_starts_with

    @version_starts_with.setter
    def version_starts_with(self, version_starts_with):
        """Sets the version_starts_with of this PmemDimmWhereInput.


        :param version_starts_with: The version_starts_with of this PmemDimmWhereInput.  # noqa: E501
        :type version_starts_with: str
        """

        self._version_starts_with = version_starts_with

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PmemDimmWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PmemDimmWhereInput):
            return True

        return self.to_dict() != other.to_dict()
