# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class RackTopoCreationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'brick_topoes': 'BrickTopoWhereInput',
        'cluster_id': 'str',
        'zone_topo_id': 'str',
        'height': 'int',
        'name': 'str'
    }

    attribute_map = {
        'brick_topoes': 'brick_topoes',
        'cluster_id': 'cluster_id',
        'zone_topo_id': 'zone_topo_id',
        'height': 'height',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """RackTopoCreationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._brick_topoes = None
        self._cluster_id = None
        self._zone_topo_id = None
        self._height = None
        self._name = None
        self.discriminator = None

        if "brick_topoes" in kwargs:
            self.brick_topoes = kwargs["brick_topoes"]
        if "cluster_id" in kwargs:
            self.cluster_id = kwargs["cluster_id"]
        if "zone_topo_id" in kwargs:
            self.zone_topo_id = kwargs["zone_topo_id"]
        if "height" in kwargs:
            self.height = kwargs["height"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def brick_topoes(self):
        """Gets the brick_topoes of this RackTopoCreationParams.  # noqa: E501


        :return: The brick_topoes of this RackTopoCreationParams.  # noqa: E501
        :rtype: BrickTopoWhereInput
        """
        return self._brick_topoes

    @brick_topoes.setter
    def brick_topoes(self, brick_topoes):
        """Sets the brick_topoes of this RackTopoCreationParams.


        :param brick_topoes: The brick_topoes of this RackTopoCreationParams.  # noqa: E501
        :type brick_topoes: BrickTopoWhereInput
        """

        self._brick_topoes = brick_topoes

    @property
    def cluster_id(self):
        """Gets the cluster_id of this RackTopoCreationParams.  # noqa: E501


        :return: The cluster_id of this RackTopoCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """Sets the cluster_id of this RackTopoCreationParams.


        :param cluster_id: The cluster_id of this RackTopoCreationParams.  # noqa: E501
        :type cluster_id: str
        """
        if self.local_vars_configuration.client_side_validation and cluster_id is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster_id`, must not be `None`")  # noqa: E501

        self._cluster_id = cluster_id

    @property
    def zone_topo_id(self):
        """Gets the zone_topo_id of this RackTopoCreationParams.  # noqa: E501


        :return: The zone_topo_id of this RackTopoCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._zone_topo_id

    @zone_topo_id.setter
    def zone_topo_id(self, zone_topo_id):
        """Sets the zone_topo_id of this RackTopoCreationParams.


        :param zone_topo_id: The zone_topo_id of this RackTopoCreationParams.  # noqa: E501
        :type zone_topo_id: str
        """
        if self.local_vars_configuration.client_side_validation and zone_topo_id is None:  # noqa: E501
            raise ValueError("Invalid value for `zone_topo_id`, must not be `None`")  # noqa: E501

        self._zone_topo_id = zone_topo_id

    @property
    def height(self):
        """Gets the height of this RackTopoCreationParams.  # noqa: E501


        :return: The height of this RackTopoCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this RackTopoCreationParams.


        :param height: The height of this RackTopoCreationParams.  # noqa: E501
        :type height: int
        """
        if self.local_vars_configuration.client_side_validation and height is None:  # noqa: E501
            raise ValueError("Invalid value for `height`, must not be `None`")  # noqa: E501

        self._height = height

    @property
    def name(self):
        """Gets the name of this RackTopoCreationParams.  # noqa: E501


        :return: The name of this RackTopoCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RackTopoCreationParams.


        :param name: The name of this RackTopoCreationParams.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RackTopoCreationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RackTopoCreationParams):
            return True

        return self.to_dict() != other.to_dict()
