# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ReplicaVm(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'created_at': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'external_cloudtower': 'NestedExternalCloudTower',
        'failover_test_object_descriptor': 'NestedReplicationObjectDescriptor',
        'failover_test_replica_group': 'str',
        'failover_test_vm': 'NestedVm',
        'id': 'str',
        'inbound': 'bool',
        'iscsi_lun': 'NestedIscsiLun',
        'object_descriptor': 'NestedReplicationObjectDescriptor',
        'origin_iscsi_lun': 'NestedIscsiLun',
        'origin_object_descriptor': 'NestedReplicationObjectDescriptor',
        'origin_vm': 'NestedVm',
        'origin_vm_cluster_local_id': 'str',
        'origin_vm_cluster_name': 'str',
        'origin_vm_local_id': 'str',
        'origin_vm_name': 'str',
        'replica_group': 'str',
        'replication_group': 'str',
        'replication_plan': 'NestedReplicationPlan',
        'replication_service': 'NestedReplicationService',
        'replication_target_executions': 'list[NestedReplicationTargetExecution]',
        'restore_points': 'list[NestedReplicationRestorePoint]',
        'state': 'ReplicaVmState',
        'targets_deletable': 'bool',
        'type': 'ReplicationObjectType',
        'updated_at': 'str',
        'vm': 'NestedVm'
    }

    attribute_map = {
        'created_at': 'createdAt',
        'entity_async_status': 'entityAsyncStatus',
        'external_cloudtower': 'external_cloudtower',
        'failover_test_object_descriptor': 'failover_test_object_descriptor',
        'failover_test_replica_group': 'failover_test_replica_group',
        'failover_test_vm': 'failover_test_vm',
        'id': 'id',
        'inbound': 'inbound',
        'iscsi_lun': 'iscsi_lun',
        'object_descriptor': 'object_descriptor',
        'origin_iscsi_lun': 'origin_iscsi_lun',
        'origin_object_descriptor': 'origin_object_descriptor',
        'origin_vm': 'origin_vm',
        'origin_vm_cluster_local_id': 'origin_vm_cluster_local_id',
        'origin_vm_cluster_name': 'origin_vm_cluster_name',
        'origin_vm_local_id': 'origin_vm_local_id',
        'origin_vm_name': 'origin_vm_name',
        'replica_group': 'replica_group',
        'replication_group': 'replication_group',
        'replication_plan': 'replication_plan',
        'replication_service': 'replication_service',
        'replication_target_executions': 'replication_target_executions',
        'restore_points': 'restore_points',
        'state': 'state',
        'targets_deletable': 'targets_deletable',
        'type': 'type',
        'updated_at': 'updatedAt',
        'vm': 'vm'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ReplicaVm - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._created_at = None
        self._entity_async_status = None
        self._external_cloudtower = None
        self._failover_test_object_descriptor = None
        self._failover_test_replica_group = None
        self._failover_test_vm = None
        self._id = None
        self._inbound = None
        self._iscsi_lun = None
        self._object_descriptor = None
        self._origin_iscsi_lun = None
        self._origin_object_descriptor = None
        self._origin_vm = None
        self._origin_vm_cluster_local_id = None
        self._origin_vm_cluster_name = None
        self._origin_vm_local_id = None
        self._origin_vm_name = None
        self._replica_group = None
        self._replication_group = None
        self._replication_plan = None
        self._replication_service = None
        self._replication_target_executions = None
        self._restore_points = None
        self._state = None
        self._targets_deletable = None
        self._type = None
        self._updated_at = None
        self._vm = None
        self.discriminator = None

        if "created_at" in kwargs:
            self.created_at = kwargs["created_at"]
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.external_cloudtower = kwargs.get("external_cloudtower", None)
        self.failover_test_object_descriptor = kwargs.get("failover_test_object_descriptor", None)
        self.failover_test_replica_group = kwargs.get("failover_test_replica_group", None)
        self.failover_test_vm = kwargs.get("failover_test_vm", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.inbound = kwargs.get("inbound", None)
        self.iscsi_lun = kwargs.get("iscsi_lun", None)
        self.object_descriptor = kwargs.get("object_descriptor", None)
        self.origin_iscsi_lun = kwargs.get("origin_iscsi_lun", None)
        if "origin_object_descriptor" in kwargs:
            self.origin_object_descriptor = kwargs["origin_object_descriptor"]
        self.origin_vm = kwargs.get("origin_vm", None)
        self.origin_vm_cluster_local_id = kwargs.get("origin_vm_cluster_local_id", None)
        self.origin_vm_cluster_name = kwargs.get("origin_vm_cluster_name", None)
        self.origin_vm_local_id = kwargs.get("origin_vm_local_id", None)
        self.origin_vm_name = kwargs.get("origin_vm_name", None)
        self.replica_group = kwargs.get("replica_group", None)
        self.replication_group = kwargs.get("replication_group", None)
        self.replication_plan = kwargs.get("replication_plan", None)
        if "replication_service" in kwargs:
            self.replication_service = kwargs["replication_service"]
        self.replication_target_executions = kwargs.get("replication_target_executions", None)
        self.restore_points = kwargs.get("restore_points", None)
        if "state" in kwargs:
            self.state = kwargs["state"]
        self.targets_deletable = kwargs.get("targets_deletable", None)
        if "type" in kwargs:
            self.type = kwargs["type"]
        if "updated_at" in kwargs:
            self.updated_at = kwargs["updated_at"]
        self.vm = kwargs.get("vm", None)

    @property
    def created_at(self):
        """Gets the created_at of this ReplicaVm.  # noqa: E501


        :return: The created_at of this ReplicaVm.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ReplicaVm.


        :param created_at: The created_at of this ReplicaVm.  # noqa: E501
        :type created_at: str
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this ReplicaVm.  # noqa: E501


        :return: The entity_async_status of this ReplicaVm.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this ReplicaVm.


        :param entity_async_status: The entity_async_status of this ReplicaVm.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def external_cloudtower(self):
        """Gets the external_cloudtower of this ReplicaVm.  # noqa: E501


        :return: The external_cloudtower of this ReplicaVm.  # noqa: E501
        :rtype: NestedExternalCloudTower
        """
        return self._external_cloudtower

    @external_cloudtower.setter
    def external_cloudtower(self, external_cloudtower):
        """Sets the external_cloudtower of this ReplicaVm.


        :param external_cloudtower: The external_cloudtower of this ReplicaVm.  # noqa: E501
        :type external_cloudtower: NestedExternalCloudTower
        """

        self._external_cloudtower = external_cloudtower

    @property
    def failover_test_object_descriptor(self):
        """Gets the failover_test_object_descriptor of this ReplicaVm.  # noqa: E501


        :return: The failover_test_object_descriptor of this ReplicaVm.  # noqa: E501
        :rtype: NestedReplicationObjectDescriptor
        """
        return self._failover_test_object_descriptor

    @failover_test_object_descriptor.setter
    def failover_test_object_descriptor(self, failover_test_object_descriptor):
        """Sets the failover_test_object_descriptor of this ReplicaVm.


        :param failover_test_object_descriptor: The failover_test_object_descriptor of this ReplicaVm.  # noqa: E501
        :type failover_test_object_descriptor: NestedReplicationObjectDescriptor
        """

        self._failover_test_object_descriptor = failover_test_object_descriptor

    @property
    def failover_test_replica_group(self):
        """Gets the failover_test_replica_group of this ReplicaVm.  # noqa: E501


        :return: The failover_test_replica_group of this ReplicaVm.  # noqa: E501
        :rtype: str
        """
        return self._failover_test_replica_group

    @failover_test_replica_group.setter
    def failover_test_replica_group(self, failover_test_replica_group):
        """Sets the failover_test_replica_group of this ReplicaVm.


        :param failover_test_replica_group: The failover_test_replica_group of this ReplicaVm.  # noqa: E501
        :type failover_test_replica_group: str
        """

        self._failover_test_replica_group = failover_test_replica_group

    @property
    def failover_test_vm(self):
        """Gets the failover_test_vm of this ReplicaVm.  # noqa: E501


        :return: The failover_test_vm of this ReplicaVm.  # noqa: E501
        :rtype: NestedVm
        """
        return self._failover_test_vm

    @failover_test_vm.setter
    def failover_test_vm(self, failover_test_vm):
        """Sets the failover_test_vm of this ReplicaVm.


        :param failover_test_vm: The failover_test_vm of this ReplicaVm.  # noqa: E501
        :type failover_test_vm: NestedVm
        """

        self._failover_test_vm = failover_test_vm

    @property
    def id(self):
        """Gets the id of this ReplicaVm.  # noqa: E501


        :return: The id of this ReplicaVm.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ReplicaVm.


        :param id: The id of this ReplicaVm.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def inbound(self):
        """Gets the inbound of this ReplicaVm.  # noqa: E501


        :return: The inbound of this ReplicaVm.  # noqa: E501
        :rtype: bool
        """
        return self._inbound

    @inbound.setter
    def inbound(self, inbound):
        """Sets the inbound of this ReplicaVm.


        :param inbound: The inbound of this ReplicaVm.  # noqa: E501
        :type inbound: bool
        """

        self._inbound = inbound

    @property
    def iscsi_lun(self):
        """Gets the iscsi_lun of this ReplicaVm.  # noqa: E501


        :return: The iscsi_lun of this ReplicaVm.  # noqa: E501
        :rtype: NestedIscsiLun
        """
        return self._iscsi_lun

    @iscsi_lun.setter
    def iscsi_lun(self, iscsi_lun):
        """Sets the iscsi_lun of this ReplicaVm.


        :param iscsi_lun: The iscsi_lun of this ReplicaVm.  # noqa: E501
        :type iscsi_lun: NestedIscsiLun
        """

        self._iscsi_lun = iscsi_lun

    @property
    def object_descriptor(self):
        """Gets the object_descriptor of this ReplicaVm.  # noqa: E501


        :return: The object_descriptor of this ReplicaVm.  # noqa: E501
        :rtype: NestedReplicationObjectDescriptor
        """
        return self._object_descriptor

    @object_descriptor.setter
    def object_descriptor(self, object_descriptor):
        """Sets the object_descriptor of this ReplicaVm.


        :param object_descriptor: The object_descriptor of this ReplicaVm.  # noqa: E501
        :type object_descriptor: NestedReplicationObjectDescriptor
        """

        self._object_descriptor = object_descriptor

    @property
    def origin_iscsi_lun(self):
        """Gets the origin_iscsi_lun of this ReplicaVm.  # noqa: E501


        :return: The origin_iscsi_lun of this ReplicaVm.  # noqa: E501
        :rtype: NestedIscsiLun
        """
        return self._origin_iscsi_lun

    @origin_iscsi_lun.setter
    def origin_iscsi_lun(self, origin_iscsi_lun):
        """Sets the origin_iscsi_lun of this ReplicaVm.


        :param origin_iscsi_lun: The origin_iscsi_lun of this ReplicaVm.  # noqa: E501
        :type origin_iscsi_lun: NestedIscsiLun
        """

        self._origin_iscsi_lun = origin_iscsi_lun

    @property
    def origin_object_descriptor(self):
        """Gets the origin_object_descriptor of this ReplicaVm.  # noqa: E501


        :return: The origin_object_descriptor of this ReplicaVm.  # noqa: E501
        :rtype: NestedReplicationObjectDescriptor
        """
        return self._origin_object_descriptor

    @origin_object_descriptor.setter
    def origin_object_descriptor(self, origin_object_descriptor):
        """Sets the origin_object_descriptor of this ReplicaVm.


        :param origin_object_descriptor: The origin_object_descriptor of this ReplicaVm.  # noqa: E501
        :type origin_object_descriptor: NestedReplicationObjectDescriptor
        """
        if self.local_vars_configuration.client_side_validation and origin_object_descriptor is None:  # noqa: E501
            raise ValueError("Invalid value for `origin_object_descriptor`, must not be `None`")  # noqa: E501

        self._origin_object_descriptor = origin_object_descriptor

    @property
    def origin_vm(self):
        """Gets the origin_vm of this ReplicaVm.  # noqa: E501


        :return: The origin_vm of this ReplicaVm.  # noqa: E501
        :rtype: NestedVm
        """
        return self._origin_vm

    @origin_vm.setter
    def origin_vm(self, origin_vm):
        """Sets the origin_vm of this ReplicaVm.


        :param origin_vm: The origin_vm of this ReplicaVm.  # noqa: E501
        :type origin_vm: NestedVm
        """

        self._origin_vm = origin_vm

    @property
    def origin_vm_cluster_local_id(self):
        """Gets the origin_vm_cluster_local_id of this ReplicaVm.  # noqa: E501


        :return: The origin_vm_cluster_local_id of this ReplicaVm.  # noqa: E501
        :rtype: str
        """
        return self._origin_vm_cluster_local_id

    @origin_vm_cluster_local_id.setter
    def origin_vm_cluster_local_id(self, origin_vm_cluster_local_id):
        """Sets the origin_vm_cluster_local_id of this ReplicaVm.


        :param origin_vm_cluster_local_id: The origin_vm_cluster_local_id of this ReplicaVm.  # noqa: E501
        :type origin_vm_cluster_local_id: str
        """

        self._origin_vm_cluster_local_id = origin_vm_cluster_local_id

    @property
    def origin_vm_cluster_name(self):
        """Gets the origin_vm_cluster_name of this ReplicaVm.  # noqa: E501


        :return: The origin_vm_cluster_name of this ReplicaVm.  # noqa: E501
        :rtype: str
        """
        return self._origin_vm_cluster_name

    @origin_vm_cluster_name.setter
    def origin_vm_cluster_name(self, origin_vm_cluster_name):
        """Sets the origin_vm_cluster_name of this ReplicaVm.


        :param origin_vm_cluster_name: The origin_vm_cluster_name of this ReplicaVm.  # noqa: E501
        :type origin_vm_cluster_name: str
        """

        self._origin_vm_cluster_name = origin_vm_cluster_name

    @property
    def origin_vm_local_id(self):
        """Gets the origin_vm_local_id of this ReplicaVm.  # noqa: E501


        :return: The origin_vm_local_id of this ReplicaVm.  # noqa: E501
        :rtype: str
        """
        return self._origin_vm_local_id

    @origin_vm_local_id.setter
    def origin_vm_local_id(self, origin_vm_local_id):
        """Sets the origin_vm_local_id of this ReplicaVm.


        :param origin_vm_local_id: The origin_vm_local_id of this ReplicaVm.  # noqa: E501
        :type origin_vm_local_id: str
        """

        self._origin_vm_local_id = origin_vm_local_id

    @property
    def origin_vm_name(self):
        """Gets the origin_vm_name of this ReplicaVm.  # noqa: E501


        :return: The origin_vm_name of this ReplicaVm.  # noqa: E501
        :rtype: str
        """
        return self._origin_vm_name

    @origin_vm_name.setter
    def origin_vm_name(self, origin_vm_name):
        """Sets the origin_vm_name of this ReplicaVm.


        :param origin_vm_name: The origin_vm_name of this ReplicaVm.  # noqa: E501
        :type origin_vm_name: str
        """

        self._origin_vm_name = origin_vm_name

    @property
    def replica_group(self):
        """Gets the replica_group of this ReplicaVm.  # noqa: E501


        :return: The replica_group of this ReplicaVm.  # noqa: E501
        :rtype: str
        """
        return self._replica_group

    @replica_group.setter
    def replica_group(self, replica_group):
        """Sets the replica_group of this ReplicaVm.


        :param replica_group: The replica_group of this ReplicaVm.  # noqa: E501
        :type replica_group: str
        """

        self._replica_group = replica_group

    @property
    def replication_group(self):
        """Gets the replication_group of this ReplicaVm.  # noqa: E501


        :return: The replication_group of this ReplicaVm.  # noqa: E501
        :rtype: str
        """
        return self._replication_group

    @replication_group.setter
    def replication_group(self, replication_group):
        """Sets the replication_group of this ReplicaVm.


        :param replication_group: The replication_group of this ReplicaVm.  # noqa: E501
        :type replication_group: str
        """

        self._replication_group = replication_group

    @property
    def replication_plan(self):
        """Gets the replication_plan of this ReplicaVm.  # noqa: E501


        :return: The replication_plan of this ReplicaVm.  # noqa: E501
        :rtype: NestedReplicationPlan
        """
        return self._replication_plan

    @replication_plan.setter
    def replication_plan(self, replication_plan):
        """Sets the replication_plan of this ReplicaVm.


        :param replication_plan: The replication_plan of this ReplicaVm.  # noqa: E501
        :type replication_plan: NestedReplicationPlan
        """

        self._replication_plan = replication_plan

    @property
    def replication_service(self):
        """Gets the replication_service of this ReplicaVm.  # noqa: E501


        :return: The replication_service of this ReplicaVm.  # noqa: E501
        :rtype: NestedReplicationService
        """
        return self._replication_service

    @replication_service.setter
    def replication_service(self, replication_service):
        """Sets the replication_service of this ReplicaVm.


        :param replication_service: The replication_service of this ReplicaVm.  # noqa: E501
        :type replication_service: NestedReplicationService
        """
        if self.local_vars_configuration.client_side_validation and replication_service is None:  # noqa: E501
            raise ValueError("Invalid value for `replication_service`, must not be `None`")  # noqa: E501

        self._replication_service = replication_service

    @property
    def replication_target_executions(self):
        """Gets the replication_target_executions of this ReplicaVm.  # noqa: E501


        :return: The replication_target_executions of this ReplicaVm.  # noqa: E501
        :rtype: list[NestedReplicationTargetExecution]
        """
        return self._replication_target_executions

    @replication_target_executions.setter
    def replication_target_executions(self, replication_target_executions):
        """Sets the replication_target_executions of this ReplicaVm.


        :param replication_target_executions: The replication_target_executions of this ReplicaVm.  # noqa: E501
        :type replication_target_executions: list[NestedReplicationTargetExecution]
        """

        self._replication_target_executions = replication_target_executions

    @property
    def restore_points(self):
        """Gets the restore_points of this ReplicaVm.  # noqa: E501


        :return: The restore_points of this ReplicaVm.  # noqa: E501
        :rtype: list[NestedReplicationRestorePoint]
        """
        return self._restore_points

    @restore_points.setter
    def restore_points(self, restore_points):
        """Sets the restore_points of this ReplicaVm.


        :param restore_points: The restore_points of this ReplicaVm.  # noqa: E501
        :type restore_points: list[NestedReplicationRestorePoint]
        """

        self._restore_points = restore_points

    @property
    def state(self):
        """Gets the state of this ReplicaVm.  # noqa: E501


        :return: The state of this ReplicaVm.  # noqa: E501
        :rtype: ReplicaVmState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this ReplicaVm.


        :param state: The state of this ReplicaVm.  # noqa: E501
        :type state: ReplicaVmState
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def targets_deletable(self):
        """Gets the targets_deletable of this ReplicaVm.  # noqa: E501


        :return: The targets_deletable of this ReplicaVm.  # noqa: E501
        :rtype: bool
        """
        return self._targets_deletable

    @targets_deletable.setter
    def targets_deletable(self, targets_deletable):
        """Sets the targets_deletable of this ReplicaVm.


        :param targets_deletable: The targets_deletable of this ReplicaVm.  # noqa: E501
        :type targets_deletable: bool
        """

        self._targets_deletable = targets_deletable

    @property
    def type(self):
        """Gets the type of this ReplicaVm.  # noqa: E501


        :return: The type of this ReplicaVm.  # noqa: E501
        :rtype: ReplicationObjectType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ReplicaVm.


        :param type: The type of this ReplicaVm.  # noqa: E501
        :type type: ReplicationObjectType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def updated_at(self):
        """Gets the updated_at of this ReplicaVm.  # noqa: E501


        :return: The updated_at of this ReplicaVm.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this ReplicaVm.


        :param updated_at: The updated_at of this ReplicaVm.  # noqa: E501
        :type updated_at: str
        """
        if self.local_vars_configuration.client_side_validation and updated_at is None:  # noqa: E501
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501

        self._updated_at = updated_at

    @property
    def vm(self):
        """Gets the vm of this ReplicaVm.  # noqa: E501


        :return: The vm of this ReplicaVm.  # noqa: E501
        :rtype: NestedVm
        """
        return self._vm

    @vm.setter
    def vm(self, vm):
        """Sets the vm of this ReplicaVm.


        :param vm: The vm of this ReplicaVm.  # noqa: E501
        :type vm: NestedVm
        """

        self._vm = vm

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReplicaVm):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ReplicaVm):
            return True

        return self.to_dict() != other.to_dict()
