# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ReplicationPlan(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'abort_window_unfinished': 'bool',
        'activation_timestamp': 'str',
        'compression': 'bool',
        'created_at': 'str',
        'delete_strategy': 'BackupPlanDeleteStrategy',
        'description': 'str',
        'ec_k': 'int',
        'ec_m': 'int',
        'enable_window': 'bool',
        'entity_async_status': 'EntityAsyncStatus',
        'external_cloudtower': 'NestedExternalCloudTower',
        'id': 'str',
        'inbound': 'bool',
        'interval': 'int',
        'ip_mapping': 'list[NestedReplicationIPAddressMapping]',
        'iscsi_luns': 'list[NestedIscsiLun]',
        'keep_mac_address': 'bool',
        'keep_policy': 'BackupPlanKeepPolicy',
        'keep_policy_value': 'int',
        'last_execute_status': 'BackupPlanExecutionStatus',
        'last_execute_status_message': 'str',
        'last_execute_success_job_count': 'int',
        'last_execute_total_job_count': 'int',
        'last_executed_at': 'str',
        'last_manual_execute_status': 'BackupPlanExecutionStatus',
        'last_manual_execute_status_message': 'str',
        'last_manual_execute_success_job_count': 'int',
        'last_manual_execute_total_job_count': 'int',
        'last_manual_executed_at': 'str',
        'name': 'str',
        'network_mapping': 'list[NestedReplicationPlanNetworkMapping]',
        'next_execution_time': 'str',
        'objects_descriptor': 'list[NestedReplicationObjectDescriptor]',
        'period': 'ReplicationPlanPeriod',
        'phase': 'BackupPlanPhase',
        'replica_name_rule': 'ReplicaNameRule',
        'replica_name_setting': 'str',
        'replica_num': 'int',
        'replica_vms': 'list[NestedReplicaVm]',
        'replication_plan_executions': 'list[NestedReplicationPlanExecution]',
        'replication_restore_points': 'list[NestedReplicationRestorePoint]',
        'replication_target_executions': 'list[NestedReplicationTargetExecution]',
        'resiliency_type': 'ResiliencyType',
        'snapshot_consistent_type': 'ConsistentType',
        'status': 'BackupPlanStatus',
        'storage_policy': 'VmVolumeElfStoragePolicyType',
        'target_cluster': 'NestedCluster',
        'target_cluster_descriptor': 'NestedReplicationClusterDescriptor',
        'target_replication_service': 'NestedReplicationService',
        'thin_provision': 'bool',
        'time_points': 'list[NestedBackupPlanTimePoint]',
        'type': 'ReplicationPlanType',
        'updated_at': 'str',
        'vms': 'list[NestedVm]',
        'weekdays': 'list[WeekdayTypeEnum]',
        'window_end': 'str',
        'window_start': 'str'
    }

    attribute_map = {
        'abort_window_unfinished': 'abort_window_unfinished',
        'activation_timestamp': 'activation_timestamp',
        'compression': 'compression',
        'created_at': 'createdAt',
        'delete_strategy': 'delete_strategy',
        'description': 'description',
        'ec_k': 'ec_k',
        'ec_m': 'ec_m',
        'enable_window': 'enable_window',
        'entity_async_status': 'entityAsyncStatus',
        'external_cloudtower': 'external_cloudtower',
        'id': 'id',
        'inbound': 'inbound',
        'interval': 'interval',
        'ip_mapping': 'ip_mapping',
        'iscsi_luns': 'iscsi_luns',
        'keep_mac_address': 'keep_mac_address',
        'keep_policy': 'keep_policy',
        'keep_policy_value': 'keep_policy_value',
        'last_execute_status': 'last_execute_status',
        'last_execute_status_message': 'last_execute_status_message',
        'last_execute_success_job_count': 'last_execute_success_job_count',
        'last_execute_total_job_count': 'last_execute_total_job_count',
        'last_executed_at': 'last_executed_at',
        'last_manual_execute_status': 'last_manual_execute_status',
        'last_manual_execute_status_message': 'last_manual_execute_status_message',
        'last_manual_execute_success_job_count': 'last_manual_execute_success_job_count',
        'last_manual_execute_total_job_count': 'last_manual_execute_total_job_count',
        'last_manual_executed_at': 'last_manual_executed_at',
        'name': 'name',
        'network_mapping': 'network_mapping',
        'next_execution_time': 'next_execution_time',
        'objects_descriptor': 'objects_descriptor',
        'period': 'period',
        'phase': 'phase',
        'replica_name_rule': 'replica_name_rule',
        'replica_name_setting': 'replica_name_setting',
        'replica_num': 'replica_num',
        'replica_vms': 'replica_vms',
        'replication_plan_executions': 'replication_plan_executions',
        'replication_restore_points': 'replication_restore_points',
        'replication_target_executions': 'replication_target_executions',
        'resiliency_type': 'resiliency_type',
        'snapshot_consistent_type': 'snapshot_consistent_type',
        'status': 'status',
        'storage_policy': 'storage_policy',
        'target_cluster': 'target_cluster',
        'target_cluster_descriptor': 'target_cluster_descriptor',
        'target_replication_service': 'target_replication_service',
        'thin_provision': 'thin_provision',
        'time_points': 'time_points',
        'type': 'type',
        'updated_at': 'updatedAt',
        'vms': 'vms',
        'weekdays': 'weekdays',
        'window_end': 'window_end',
        'window_start': 'window_start'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ReplicationPlan - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._abort_window_unfinished = None
        self._activation_timestamp = None
        self._compression = None
        self._created_at = None
        self._delete_strategy = None
        self._description = None
        self._ec_k = None
        self._ec_m = None
        self._enable_window = None
        self._entity_async_status = None
        self._external_cloudtower = None
        self._id = None
        self._inbound = None
        self._interval = None
        self._ip_mapping = None
        self._iscsi_luns = None
        self._keep_mac_address = None
        self._keep_policy = None
        self._keep_policy_value = None
        self._last_execute_status = None
        self._last_execute_status_message = None
        self._last_execute_success_job_count = None
        self._last_execute_total_job_count = None
        self._last_executed_at = None
        self._last_manual_execute_status = None
        self._last_manual_execute_status_message = None
        self._last_manual_execute_success_job_count = None
        self._last_manual_execute_total_job_count = None
        self._last_manual_executed_at = None
        self._name = None
        self._network_mapping = None
        self._next_execution_time = None
        self._objects_descriptor = None
        self._period = None
        self._phase = None
        self._replica_name_rule = None
        self._replica_name_setting = None
        self._replica_num = None
        self._replica_vms = None
        self._replication_plan_executions = None
        self._replication_restore_points = None
        self._replication_target_executions = None
        self._resiliency_type = None
        self._snapshot_consistent_type = None
        self._status = None
        self._storage_policy = None
        self._target_cluster = None
        self._target_cluster_descriptor = None
        self._target_replication_service = None
        self._thin_provision = None
        self._time_points = None
        self._type = None
        self._updated_at = None
        self._vms = None
        self._weekdays = None
        self._window_end = None
        self._window_start = None
        self.discriminator = None

        self.abort_window_unfinished = kwargs.get("abort_window_unfinished", None)
        self.activation_timestamp = kwargs.get("activation_timestamp", None)
        if "compression" in kwargs:
            self.compression = kwargs["compression"]
        if "created_at" in kwargs:
            self.created_at = kwargs["created_at"]
        self.delete_strategy = kwargs.get("delete_strategy", None)
        self.description = kwargs.get("description", None)
        self.ec_k = kwargs.get("ec_k", None)
        self.ec_m = kwargs.get("ec_m", None)
        if "enable_window" in kwargs:
            self.enable_window = kwargs["enable_window"]
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.external_cloudtower = kwargs.get("external_cloudtower", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.inbound = kwargs.get("inbound", None)
        if "interval" in kwargs:
            self.interval = kwargs["interval"]
        if "ip_mapping" in kwargs:
            self.ip_mapping = kwargs["ip_mapping"]
        self.iscsi_luns = kwargs.get("iscsi_luns", None)
        self.keep_mac_address = kwargs.get("keep_mac_address", None)
        self.keep_policy = kwargs.get("keep_policy", None)
        self.keep_policy_value = kwargs.get("keep_policy_value", None)
        if "last_execute_status" in kwargs:
            self.last_execute_status = kwargs["last_execute_status"]
        self.last_execute_status_message = kwargs.get("last_execute_status_message", None)
        self.last_execute_success_job_count = kwargs.get("last_execute_success_job_count", None)
        self.last_execute_total_job_count = kwargs.get("last_execute_total_job_count", None)
        self.last_executed_at = kwargs.get("last_executed_at", None)
        if "last_manual_execute_status" in kwargs:
            self.last_manual_execute_status = kwargs["last_manual_execute_status"]
        self.last_manual_execute_status_message = kwargs.get("last_manual_execute_status_message", None)
        self.last_manual_execute_success_job_count = kwargs.get("last_manual_execute_success_job_count", None)
        self.last_manual_execute_total_job_count = kwargs.get("last_manual_execute_total_job_count", None)
        self.last_manual_executed_at = kwargs.get("last_manual_executed_at", None)
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "network_mapping" in kwargs:
            self.network_mapping = kwargs["network_mapping"]
        self.next_execution_time = kwargs.get("next_execution_time", None)
        if "objects_descriptor" in kwargs:
            self.objects_descriptor = kwargs["objects_descriptor"]
        if "period" in kwargs:
            self.period = kwargs["period"]
        self.phase = kwargs.get("phase", None)
        if "replica_name_rule" in kwargs:
            self.replica_name_rule = kwargs["replica_name_rule"]
        self.replica_name_setting = kwargs.get("replica_name_setting", None)
        self.replica_num = kwargs.get("replica_num", None)
        self.replica_vms = kwargs.get("replica_vms", None)
        self.replication_plan_executions = kwargs.get("replication_plan_executions", None)
        self.replication_restore_points = kwargs.get("replication_restore_points", None)
        self.replication_target_executions = kwargs.get("replication_target_executions", None)
        self.resiliency_type = kwargs.get("resiliency_type", None)
        self.snapshot_consistent_type = kwargs.get("snapshot_consistent_type", None)
        if "status" in kwargs:
            self.status = kwargs["status"]
        if "storage_policy" in kwargs:
            self.storage_policy = kwargs["storage_policy"]
        self.target_cluster = kwargs.get("target_cluster", None)
        if "target_cluster_descriptor" in kwargs:
            self.target_cluster_descriptor = kwargs["target_cluster_descriptor"]
        if "target_replication_service" in kwargs:
            self.target_replication_service = kwargs["target_replication_service"]
        self.thin_provision = kwargs.get("thin_provision", None)
        if "time_points" in kwargs:
            self.time_points = kwargs["time_points"]
        if "type" in kwargs:
            self.type = kwargs["type"]
        if "updated_at" in kwargs:
            self.updated_at = kwargs["updated_at"]
        self.vms = kwargs.get("vms", None)
        self.weekdays = kwargs.get("weekdays", None)
        self.window_end = kwargs.get("window_end", None)
        self.window_start = kwargs.get("window_start", None)

    @property
    def abort_window_unfinished(self):
        """Gets the abort_window_unfinished of this ReplicationPlan.  # noqa: E501


        :return: The abort_window_unfinished of this ReplicationPlan.  # noqa: E501
        :rtype: bool
        """
        return self._abort_window_unfinished

    @abort_window_unfinished.setter
    def abort_window_unfinished(self, abort_window_unfinished):
        """Sets the abort_window_unfinished of this ReplicationPlan.


        :param abort_window_unfinished: The abort_window_unfinished of this ReplicationPlan.  # noqa: E501
        :type abort_window_unfinished: bool
        """

        self._abort_window_unfinished = abort_window_unfinished

    @property
    def activation_timestamp(self):
        """Gets the activation_timestamp of this ReplicationPlan.  # noqa: E501


        :return: The activation_timestamp of this ReplicationPlan.  # noqa: E501
        :rtype: str
        """
        return self._activation_timestamp

    @activation_timestamp.setter
    def activation_timestamp(self, activation_timestamp):
        """Sets the activation_timestamp of this ReplicationPlan.


        :param activation_timestamp: The activation_timestamp of this ReplicationPlan.  # noqa: E501
        :type activation_timestamp: str
        """

        self._activation_timestamp = activation_timestamp

    @property
    def compression(self):
        """Gets the compression of this ReplicationPlan.  # noqa: E501


        :return: The compression of this ReplicationPlan.  # noqa: E501
        :rtype: bool
        """
        return self._compression

    @compression.setter
    def compression(self, compression):
        """Sets the compression of this ReplicationPlan.


        :param compression: The compression of this ReplicationPlan.  # noqa: E501
        :type compression: bool
        """
        if self.local_vars_configuration.client_side_validation and compression is None:  # noqa: E501
            raise ValueError("Invalid value for `compression`, must not be `None`")  # noqa: E501

        self._compression = compression

    @property
    def created_at(self):
        """Gets the created_at of this ReplicationPlan.  # noqa: E501


        :return: The created_at of this ReplicationPlan.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ReplicationPlan.


        :param created_at: The created_at of this ReplicationPlan.  # noqa: E501
        :type created_at: str
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def delete_strategy(self):
        """Gets the delete_strategy of this ReplicationPlan.  # noqa: E501


        :return: The delete_strategy of this ReplicationPlan.  # noqa: E501
        :rtype: BackupPlanDeleteStrategy
        """
        return self._delete_strategy

    @delete_strategy.setter
    def delete_strategy(self, delete_strategy):
        """Sets the delete_strategy of this ReplicationPlan.


        :param delete_strategy: The delete_strategy of this ReplicationPlan.  # noqa: E501
        :type delete_strategy: BackupPlanDeleteStrategy
        """

        self._delete_strategy = delete_strategy

    @property
    def description(self):
        """Gets the description of this ReplicationPlan.  # noqa: E501


        :return: The description of this ReplicationPlan.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ReplicationPlan.


        :param description: The description of this ReplicationPlan.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def ec_k(self):
        """Gets the ec_k of this ReplicationPlan.  # noqa: E501


        :return: The ec_k of this ReplicationPlan.  # noqa: E501
        :rtype: int
        """
        return self._ec_k

    @ec_k.setter
    def ec_k(self, ec_k):
        """Sets the ec_k of this ReplicationPlan.


        :param ec_k: The ec_k of this ReplicationPlan.  # noqa: E501
        :type ec_k: int
        """

        self._ec_k = ec_k

    @property
    def ec_m(self):
        """Gets the ec_m of this ReplicationPlan.  # noqa: E501


        :return: The ec_m of this ReplicationPlan.  # noqa: E501
        :rtype: int
        """
        return self._ec_m

    @ec_m.setter
    def ec_m(self, ec_m):
        """Sets the ec_m of this ReplicationPlan.


        :param ec_m: The ec_m of this ReplicationPlan.  # noqa: E501
        :type ec_m: int
        """

        self._ec_m = ec_m

    @property
    def enable_window(self):
        """Gets the enable_window of this ReplicationPlan.  # noqa: E501


        :return: The enable_window of this ReplicationPlan.  # noqa: E501
        :rtype: bool
        """
        return self._enable_window

    @enable_window.setter
    def enable_window(self, enable_window):
        """Sets the enable_window of this ReplicationPlan.


        :param enable_window: The enable_window of this ReplicationPlan.  # noqa: E501
        :type enable_window: bool
        """
        if self.local_vars_configuration.client_side_validation and enable_window is None:  # noqa: E501
            raise ValueError("Invalid value for `enable_window`, must not be `None`")  # noqa: E501

        self._enable_window = enable_window

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this ReplicationPlan.  # noqa: E501


        :return: The entity_async_status of this ReplicationPlan.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this ReplicationPlan.


        :param entity_async_status: The entity_async_status of this ReplicationPlan.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def external_cloudtower(self):
        """Gets the external_cloudtower of this ReplicationPlan.  # noqa: E501


        :return: The external_cloudtower of this ReplicationPlan.  # noqa: E501
        :rtype: NestedExternalCloudTower
        """
        return self._external_cloudtower

    @external_cloudtower.setter
    def external_cloudtower(self, external_cloudtower):
        """Sets the external_cloudtower of this ReplicationPlan.


        :param external_cloudtower: The external_cloudtower of this ReplicationPlan.  # noqa: E501
        :type external_cloudtower: NestedExternalCloudTower
        """

        self._external_cloudtower = external_cloudtower

    @property
    def id(self):
        """Gets the id of this ReplicationPlan.  # noqa: E501


        :return: The id of this ReplicationPlan.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ReplicationPlan.


        :param id: The id of this ReplicationPlan.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def inbound(self):
        """Gets the inbound of this ReplicationPlan.  # noqa: E501


        :return: The inbound of this ReplicationPlan.  # noqa: E501
        :rtype: bool
        """
        return self._inbound

    @inbound.setter
    def inbound(self, inbound):
        """Sets the inbound of this ReplicationPlan.


        :param inbound: The inbound of this ReplicationPlan.  # noqa: E501
        :type inbound: bool
        """

        self._inbound = inbound

    @property
    def interval(self):
        """Gets the interval of this ReplicationPlan.  # noqa: E501


        :return: The interval of this ReplicationPlan.  # noqa: E501
        :rtype: int
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this ReplicationPlan.


        :param interval: The interval of this ReplicationPlan.  # noqa: E501
        :type interval: int
        """
        if self.local_vars_configuration.client_side_validation and interval is None:  # noqa: E501
            raise ValueError("Invalid value for `interval`, must not be `None`")  # noqa: E501

        self._interval = interval

    @property
    def ip_mapping(self):
        """Gets the ip_mapping of this ReplicationPlan.  # noqa: E501


        :return: The ip_mapping of this ReplicationPlan.  # noqa: E501
        :rtype: list[NestedReplicationIPAddressMapping]
        """
        return self._ip_mapping

    @ip_mapping.setter
    def ip_mapping(self, ip_mapping):
        """Sets the ip_mapping of this ReplicationPlan.


        :param ip_mapping: The ip_mapping of this ReplicationPlan.  # noqa: E501
        :type ip_mapping: list[NestedReplicationIPAddressMapping]
        """
        if self.local_vars_configuration.client_side_validation and ip_mapping is None:  # noqa: E501
            raise ValueError("Invalid value for `ip_mapping`, must not be `None`")  # noqa: E501

        self._ip_mapping = ip_mapping

    @property
    def iscsi_luns(self):
        """Gets the iscsi_luns of this ReplicationPlan.  # noqa: E501


        :return: The iscsi_luns of this ReplicationPlan.  # noqa: E501
        :rtype: list[NestedIscsiLun]
        """
        return self._iscsi_luns

    @iscsi_luns.setter
    def iscsi_luns(self, iscsi_luns):
        """Sets the iscsi_luns of this ReplicationPlan.


        :param iscsi_luns: The iscsi_luns of this ReplicationPlan.  # noqa: E501
        :type iscsi_luns: list[NestedIscsiLun]
        """

        self._iscsi_luns = iscsi_luns

    @property
    def keep_mac_address(self):
        """Gets the keep_mac_address of this ReplicationPlan.  # noqa: E501


        :return: The keep_mac_address of this ReplicationPlan.  # noqa: E501
        :rtype: bool
        """
        return self._keep_mac_address

    @keep_mac_address.setter
    def keep_mac_address(self, keep_mac_address):
        """Sets the keep_mac_address of this ReplicationPlan.


        :param keep_mac_address: The keep_mac_address of this ReplicationPlan.  # noqa: E501
        :type keep_mac_address: bool
        """

        self._keep_mac_address = keep_mac_address

    @property
    def keep_policy(self):
        """Gets the keep_policy of this ReplicationPlan.  # noqa: E501


        :return: The keep_policy of this ReplicationPlan.  # noqa: E501
        :rtype: BackupPlanKeepPolicy
        """
        return self._keep_policy

    @keep_policy.setter
    def keep_policy(self, keep_policy):
        """Sets the keep_policy of this ReplicationPlan.


        :param keep_policy: The keep_policy of this ReplicationPlan.  # noqa: E501
        :type keep_policy: BackupPlanKeepPolicy
        """

        self._keep_policy = keep_policy

    @property
    def keep_policy_value(self):
        """Gets the keep_policy_value of this ReplicationPlan.  # noqa: E501


        :return: The keep_policy_value of this ReplicationPlan.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value

    @keep_policy_value.setter
    def keep_policy_value(self, keep_policy_value):
        """Sets the keep_policy_value of this ReplicationPlan.


        :param keep_policy_value: The keep_policy_value of this ReplicationPlan.  # noqa: E501
        :type keep_policy_value: int
        """

        self._keep_policy_value = keep_policy_value

    @property
    def last_execute_status(self):
        """Gets the last_execute_status of this ReplicationPlan.  # noqa: E501


        :return: The last_execute_status of this ReplicationPlan.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._last_execute_status

    @last_execute_status.setter
    def last_execute_status(self, last_execute_status):
        """Sets the last_execute_status of this ReplicationPlan.


        :param last_execute_status: The last_execute_status of this ReplicationPlan.  # noqa: E501
        :type last_execute_status: BackupPlanExecutionStatus
        """
        if self.local_vars_configuration.client_side_validation and last_execute_status is None:  # noqa: E501
            raise ValueError("Invalid value for `last_execute_status`, must not be `None`")  # noqa: E501

        self._last_execute_status = last_execute_status

    @property
    def last_execute_status_message(self):
        """Gets the last_execute_status_message of this ReplicationPlan.  # noqa: E501


        :return: The last_execute_status_message of this ReplicationPlan.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message

    @last_execute_status_message.setter
    def last_execute_status_message(self, last_execute_status_message):
        """Sets the last_execute_status_message of this ReplicationPlan.


        :param last_execute_status_message: The last_execute_status_message of this ReplicationPlan.  # noqa: E501
        :type last_execute_status_message: str
        """

        self._last_execute_status_message = last_execute_status_message

    @property
    def last_execute_success_job_count(self):
        """Gets the last_execute_success_job_count of this ReplicationPlan.  # noqa: E501


        :return: The last_execute_success_job_count of this ReplicationPlan.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_success_job_count

    @last_execute_success_job_count.setter
    def last_execute_success_job_count(self, last_execute_success_job_count):
        """Sets the last_execute_success_job_count of this ReplicationPlan.


        :param last_execute_success_job_count: The last_execute_success_job_count of this ReplicationPlan.  # noqa: E501
        :type last_execute_success_job_count: int
        """

        self._last_execute_success_job_count = last_execute_success_job_count

    @property
    def last_execute_total_job_count(self):
        """Gets the last_execute_total_job_count of this ReplicationPlan.  # noqa: E501


        :return: The last_execute_total_job_count of this ReplicationPlan.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_total_job_count

    @last_execute_total_job_count.setter
    def last_execute_total_job_count(self, last_execute_total_job_count):
        """Sets the last_execute_total_job_count of this ReplicationPlan.


        :param last_execute_total_job_count: The last_execute_total_job_count of this ReplicationPlan.  # noqa: E501
        :type last_execute_total_job_count: int
        """

        self._last_execute_total_job_count = last_execute_total_job_count

    @property
    def last_executed_at(self):
        """Gets the last_executed_at of this ReplicationPlan.  # noqa: E501


        :return: The last_executed_at of this ReplicationPlan.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at

    @last_executed_at.setter
    def last_executed_at(self, last_executed_at):
        """Sets the last_executed_at of this ReplicationPlan.


        :param last_executed_at: The last_executed_at of this ReplicationPlan.  # noqa: E501
        :type last_executed_at: str
        """

        self._last_executed_at = last_executed_at

    @property
    def last_manual_execute_status(self):
        """Gets the last_manual_execute_status of this ReplicationPlan.  # noqa: E501


        :return: The last_manual_execute_status of this ReplicationPlan.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._last_manual_execute_status

    @last_manual_execute_status.setter
    def last_manual_execute_status(self, last_manual_execute_status):
        """Sets the last_manual_execute_status of this ReplicationPlan.


        :param last_manual_execute_status: The last_manual_execute_status of this ReplicationPlan.  # noqa: E501
        :type last_manual_execute_status: BackupPlanExecutionStatus
        """
        if self.local_vars_configuration.client_side_validation and last_manual_execute_status is None:  # noqa: E501
            raise ValueError("Invalid value for `last_manual_execute_status`, must not be `None`")  # noqa: E501

        self._last_manual_execute_status = last_manual_execute_status

    @property
    def last_manual_execute_status_message(self):
        """Gets the last_manual_execute_status_message of this ReplicationPlan.  # noqa: E501


        :return: The last_manual_execute_status_message of this ReplicationPlan.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message

    @last_manual_execute_status_message.setter
    def last_manual_execute_status_message(self, last_manual_execute_status_message):
        """Sets the last_manual_execute_status_message of this ReplicationPlan.


        :param last_manual_execute_status_message: The last_manual_execute_status_message of this ReplicationPlan.  # noqa: E501
        :type last_manual_execute_status_message: str
        """

        self._last_manual_execute_status_message = last_manual_execute_status_message

    @property
    def last_manual_execute_success_job_count(self):
        """Gets the last_manual_execute_success_job_count of this ReplicationPlan.  # noqa: E501


        :return: The last_manual_execute_success_job_count of this ReplicationPlan.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_success_job_count

    @last_manual_execute_success_job_count.setter
    def last_manual_execute_success_job_count(self, last_manual_execute_success_job_count):
        """Sets the last_manual_execute_success_job_count of this ReplicationPlan.


        :param last_manual_execute_success_job_count: The last_manual_execute_success_job_count of this ReplicationPlan.  # noqa: E501
        :type last_manual_execute_success_job_count: int
        """

        self._last_manual_execute_success_job_count = last_manual_execute_success_job_count

    @property
    def last_manual_execute_total_job_count(self):
        """Gets the last_manual_execute_total_job_count of this ReplicationPlan.  # noqa: E501


        :return: The last_manual_execute_total_job_count of this ReplicationPlan.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_total_job_count

    @last_manual_execute_total_job_count.setter
    def last_manual_execute_total_job_count(self, last_manual_execute_total_job_count):
        """Sets the last_manual_execute_total_job_count of this ReplicationPlan.


        :param last_manual_execute_total_job_count: The last_manual_execute_total_job_count of this ReplicationPlan.  # noqa: E501
        :type last_manual_execute_total_job_count: int
        """

        self._last_manual_execute_total_job_count = last_manual_execute_total_job_count

    @property
    def last_manual_executed_at(self):
        """Gets the last_manual_executed_at of this ReplicationPlan.  # noqa: E501


        :return: The last_manual_executed_at of this ReplicationPlan.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_executed_at

    @last_manual_executed_at.setter
    def last_manual_executed_at(self, last_manual_executed_at):
        """Sets the last_manual_executed_at of this ReplicationPlan.


        :param last_manual_executed_at: The last_manual_executed_at of this ReplicationPlan.  # noqa: E501
        :type last_manual_executed_at: str
        """

        self._last_manual_executed_at = last_manual_executed_at

    @property
    def name(self):
        """Gets the name of this ReplicationPlan.  # noqa: E501


        :return: The name of this ReplicationPlan.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ReplicationPlan.


        :param name: The name of this ReplicationPlan.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def network_mapping(self):
        """Gets the network_mapping of this ReplicationPlan.  # noqa: E501


        :return: The network_mapping of this ReplicationPlan.  # noqa: E501
        :rtype: list[NestedReplicationPlanNetworkMapping]
        """
        return self._network_mapping

    @network_mapping.setter
    def network_mapping(self, network_mapping):
        """Sets the network_mapping of this ReplicationPlan.


        :param network_mapping: The network_mapping of this ReplicationPlan.  # noqa: E501
        :type network_mapping: list[NestedReplicationPlanNetworkMapping]
        """
        if self.local_vars_configuration.client_side_validation and network_mapping is None:  # noqa: E501
            raise ValueError("Invalid value for `network_mapping`, must not be `None`")  # noqa: E501

        self._network_mapping = network_mapping

    @property
    def next_execution_time(self):
        """Gets the next_execution_time of this ReplicationPlan.  # noqa: E501


        :return: The next_execution_time of this ReplicationPlan.  # noqa: E501
        :rtype: str
        """
        return self._next_execution_time

    @next_execution_time.setter
    def next_execution_time(self, next_execution_time):
        """Sets the next_execution_time of this ReplicationPlan.


        :param next_execution_time: The next_execution_time of this ReplicationPlan.  # noqa: E501
        :type next_execution_time: str
        """

        self._next_execution_time = next_execution_time

    @property
    def objects_descriptor(self):
        """Gets the objects_descriptor of this ReplicationPlan.  # noqa: E501


        :return: The objects_descriptor of this ReplicationPlan.  # noqa: E501
        :rtype: list[NestedReplicationObjectDescriptor]
        """
        return self._objects_descriptor

    @objects_descriptor.setter
    def objects_descriptor(self, objects_descriptor):
        """Sets the objects_descriptor of this ReplicationPlan.


        :param objects_descriptor: The objects_descriptor of this ReplicationPlan.  # noqa: E501
        :type objects_descriptor: list[NestedReplicationObjectDescriptor]
        """
        if self.local_vars_configuration.client_side_validation and objects_descriptor is None:  # noqa: E501
            raise ValueError("Invalid value for `objects_descriptor`, must not be `None`")  # noqa: E501

        self._objects_descriptor = objects_descriptor

    @property
    def period(self):
        """Gets the period of this ReplicationPlan.  # noqa: E501


        :return: The period of this ReplicationPlan.  # noqa: E501
        :rtype: ReplicationPlanPeriod
        """
        return self._period

    @period.setter
    def period(self, period):
        """Sets the period of this ReplicationPlan.


        :param period: The period of this ReplicationPlan.  # noqa: E501
        :type period: ReplicationPlanPeriod
        """
        if self.local_vars_configuration.client_side_validation and period is None:  # noqa: E501
            raise ValueError("Invalid value for `period`, must not be `None`")  # noqa: E501

        self._period = period

    @property
    def phase(self):
        """Gets the phase of this ReplicationPlan.  # noqa: E501


        :return: The phase of this ReplicationPlan.  # noqa: E501
        :rtype: BackupPlanPhase
        """
        return self._phase

    @phase.setter
    def phase(self, phase):
        """Sets the phase of this ReplicationPlan.


        :param phase: The phase of this ReplicationPlan.  # noqa: E501
        :type phase: BackupPlanPhase
        """

        self._phase = phase

    @property
    def replica_name_rule(self):
        """Gets the replica_name_rule of this ReplicationPlan.  # noqa: E501


        :return: The replica_name_rule of this ReplicationPlan.  # noqa: E501
        :rtype: ReplicaNameRule
        """
        return self._replica_name_rule

    @replica_name_rule.setter
    def replica_name_rule(self, replica_name_rule):
        """Sets the replica_name_rule of this ReplicationPlan.


        :param replica_name_rule: The replica_name_rule of this ReplicationPlan.  # noqa: E501
        :type replica_name_rule: ReplicaNameRule
        """
        if self.local_vars_configuration.client_side_validation and replica_name_rule is None:  # noqa: E501
            raise ValueError("Invalid value for `replica_name_rule`, must not be `None`")  # noqa: E501

        self._replica_name_rule = replica_name_rule

    @property
    def replica_name_setting(self):
        """Gets the replica_name_setting of this ReplicationPlan.  # noqa: E501


        :return: The replica_name_setting of this ReplicationPlan.  # noqa: E501
        :rtype: str
        """
        return self._replica_name_setting

    @replica_name_setting.setter
    def replica_name_setting(self, replica_name_setting):
        """Sets the replica_name_setting of this ReplicationPlan.


        :param replica_name_setting: The replica_name_setting of this ReplicationPlan.  # noqa: E501
        :type replica_name_setting: str
        """

        self._replica_name_setting = replica_name_setting

    @property
    def replica_num(self):
        """Gets the replica_num of this ReplicationPlan.  # noqa: E501


        :return: The replica_num of this ReplicationPlan.  # noqa: E501
        :rtype: int
        """
        return self._replica_num

    @replica_num.setter
    def replica_num(self, replica_num):
        """Sets the replica_num of this ReplicationPlan.


        :param replica_num: The replica_num of this ReplicationPlan.  # noqa: E501
        :type replica_num: int
        """

        self._replica_num = replica_num

    @property
    def replica_vms(self):
        """Gets the replica_vms of this ReplicationPlan.  # noqa: E501


        :return: The replica_vms of this ReplicationPlan.  # noqa: E501
        :rtype: list[NestedReplicaVm]
        """
        return self._replica_vms

    @replica_vms.setter
    def replica_vms(self, replica_vms):
        """Sets the replica_vms of this ReplicationPlan.


        :param replica_vms: The replica_vms of this ReplicationPlan.  # noqa: E501
        :type replica_vms: list[NestedReplicaVm]
        """

        self._replica_vms = replica_vms

    @property
    def replication_plan_executions(self):
        """Gets the replication_plan_executions of this ReplicationPlan.  # noqa: E501


        :return: The replication_plan_executions of this ReplicationPlan.  # noqa: E501
        :rtype: list[NestedReplicationPlanExecution]
        """
        return self._replication_plan_executions

    @replication_plan_executions.setter
    def replication_plan_executions(self, replication_plan_executions):
        """Sets the replication_plan_executions of this ReplicationPlan.


        :param replication_plan_executions: The replication_plan_executions of this ReplicationPlan.  # noqa: E501
        :type replication_plan_executions: list[NestedReplicationPlanExecution]
        """

        self._replication_plan_executions = replication_plan_executions

    @property
    def replication_restore_points(self):
        """Gets the replication_restore_points of this ReplicationPlan.  # noqa: E501


        :return: The replication_restore_points of this ReplicationPlan.  # noqa: E501
        :rtype: list[NestedReplicationRestorePoint]
        """
        return self._replication_restore_points

    @replication_restore_points.setter
    def replication_restore_points(self, replication_restore_points):
        """Sets the replication_restore_points of this ReplicationPlan.


        :param replication_restore_points: The replication_restore_points of this ReplicationPlan.  # noqa: E501
        :type replication_restore_points: list[NestedReplicationRestorePoint]
        """

        self._replication_restore_points = replication_restore_points

    @property
    def replication_target_executions(self):
        """Gets the replication_target_executions of this ReplicationPlan.  # noqa: E501


        :return: The replication_target_executions of this ReplicationPlan.  # noqa: E501
        :rtype: list[NestedReplicationTargetExecution]
        """
        return self._replication_target_executions

    @replication_target_executions.setter
    def replication_target_executions(self, replication_target_executions):
        """Sets the replication_target_executions of this ReplicationPlan.


        :param replication_target_executions: The replication_target_executions of this ReplicationPlan.  # noqa: E501
        :type replication_target_executions: list[NestedReplicationTargetExecution]
        """

        self._replication_target_executions = replication_target_executions

    @property
    def resiliency_type(self):
        """Gets the resiliency_type of this ReplicationPlan.  # noqa: E501


        :return: The resiliency_type of this ReplicationPlan.  # noqa: E501
        :rtype: ResiliencyType
        """
        return self._resiliency_type

    @resiliency_type.setter
    def resiliency_type(self, resiliency_type):
        """Sets the resiliency_type of this ReplicationPlan.


        :param resiliency_type: The resiliency_type of this ReplicationPlan.  # noqa: E501
        :type resiliency_type: ResiliencyType
        """

        self._resiliency_type = resiliency_type

    @property
    def snapshot_consistent_type(self):
        """Gets the snapshot_consistent_type of this ReplicationPlan.  # noqa: E501


        :return: The snapshot_consistent_type of this ReplicationPlan.  # noqa: E501
        :rtype: ConsistentType
        """
        return self._snapshot_consistent_type

    @snapshot_consistent_type.setter
    def snapshot_consistent_type(self, snapshot_consistent_type):
        """Sets the snapshot_consistent_type of this ReplicationPlan.


        :param snapshot_consistent_type: The snapshot_consistent_type of this ReplicationPlan.  # noqa: E501
        :type snapshot_consistent_type: ConsistentType
        """

        self._snapshot_consistent_type = snapshot_consistent_type

    @property
    def status(self):
        """Gets the status of this ReplicationPlan.  # noqa: E501


        :return: The status of this ReplicationPlan.  # noqa: E501
        :rtype: BackupPlanStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ReplicationPlan.


        :param status: The status of this ReplicationPlan.  # noqa: E501
        :type status: BackupPlanStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def storage_policy(self):
        """Gets the storage_policy of this ReplicationPlan.  # noqa: E501


        :return: The storage_policy of this ReplicationPlan.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._storage_policy

    @storage_policy.setter
    def storage_policy(self, storage_policy):
        """Sets the storage_policy of this ReplicationPlan.


        :param storage_policy: The storage_policy of this ReplicationPlan.  # noqa: E501
        :type storage_policy: VmVolumeElfStoragePolicyType
        """
        if self.local_vars_configuration.client_side_validation and storage_policy is None:  # noqa: E501
            raise ValueError("Invalid value for `storage_policy`, must not be `None`")  # noqa: E501

        self._storage_policy = storage_policy

    @property
    def target_cluster(self):
        """Gets the target_cluster of this ReplicationPlan.  # noqa: E501


        :return: The target_cluster of this ReplicationPlan.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._target_cluster

    @target_cluster.setter
    def target_cluster(self, target_cluster):
        """Sets the target_cluster of this ReplicationPlan.


        :param target_cluster: The target_cluster of this ReplicationPlan.  # noqa: E501
        :type target_cluster: NestedCluster
        """

        self._target_cluster = target_cluster

    @property
    def target_cluster_descriptor(self):
        """Gets the target_cluster_descriptor of this ReplicationPlan.  # noqa: E501


        :return: The target_cluster_descriptor of this ReplicationPlan.  # noqa: E501
        :rtype: NestedReplicationClusterDescriptor
        """
        return self._target_cluster_descriptor

    @target_cluster_descriptor.setter
    def target_cluster_descriptor(self, target_cluster_descriptor):
        """Sets the target_cluster_descriptor of this ReplicationPlan.


        :param target_cluster_descriptor: The target_cluster_descriptor of this ReplicationPlan.  # noqa: E501
        :type target_cluster_descriptor: NestedReplicationClusterDescriptor
        """
        if self.local_vars_configuration.client_side_validation and target_cluster_descriptor is None:  # noqa: E501
            raise ValueError("Invalid value for `target_cluster_descriptor`, must not be `None`")  # noqa: E501

        self._target_cluster_descriptor = target_cluster_descriptor

    @property
    def target_replication_service(self):
        """Gets the target_replication_service of this ReplicationPlan.  # noqa: E501


        :return: The target_replication_service of this ReplicationPlan.  # noqa: E501
        :rtype: NestedReplicationService
        """
        return self._target_replication_service

    @target_replication_service.setter
    def target_replication_service(self, target_replication_service):
        """Sets the target_replication_service of this ReplicationPlan.


        :param target_replication_service: The target_replication_service of this ReplicationPlan.  # noqa: E501
        :type target_replication_service: NestedReplicationService
        """
        if self.local_vars_configuration.client_side_validation and target_replication_service is None:  # noqa: E501
            raise ValueError("Invalid value for `target_replication_service`, must not be `None`")  # noqa: E501

        self._target_replication_service = target_replication_service

    @property
    def thin_provision(self):
        """Gets the thin_provision of this ReplicationPlan.  # noqa: E501


        :return: The thin_provision of this ReplicationPlan.  # noqa: E501
        :rtype: bool
        """
        return self._thin_provision

    @thin_provision.setter
    def thin_provision(self, thin_provision):
        """Sets the thin_provision of this ReplicationPlan.


        :param thin_provision: The thin_provision of this ReplicationPlan.  # noqa: E501
        :type thin_provision: bool
        """

        self._thin_provision = thin_provision

    @property
    def time_points(self):
        """Gets the time_points of this ReplicationPlan.  # noqa: E501


        :return: The time_points of this ReplicationPlan.  # noqa: E501
        :rtype: list[NestedBackupPlanTimePoint]
        """
        return self._time_points

    @time_points.setter
    def time_points(self, time_points):
        """Sets the time_points of this ReplicationPlan.


        :param time_points: The time_points of this ReplicationPlan.  # noqa: E501
        :type time_points: list[NestedBackupPlanTimePoint]
        """
        if self.local_vars_configuration.client_side_validation and time_points is None:  # noqa: E501
            raise ValueError("Invalid value for `time_points`, must not be `None`")  # noqa: E501

        self._time_points = time_points

    @property
    def type(self):
        """Gets the type of this ReplicationPlan.  # noqa: E501


        :return: The type of this ReplicationPlan.  # noqa: E501
        :rtype: ReplicationPlanType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ReplicationPlan.


        :param type: The type of this ReplicationPlan.  # noqa: E501
        :type type: ReplicationPlanType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def updated_at(self):
        """Gets the updated_at of this ReplicationPlan.  # noqa: E501


        :return: The updated_at of this ReplicationPlan.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this ReplicationPlan.


        :param updated_at: The updated_at of this ReplicationPlan.  # noqa: E501
        :type updated_at: str
        """
        if self.local_vars_configuration.client_side_validation and updated_at is None:  # noqa: E501
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501

        self._updated_at = updated_at

    @property
    def vms(self):
        """Gets the vms of this ReplicationPlan.  # noqa: E501


        :return: The vms of this ReplicationPlan.  # noqa: E501
        :rtype: list[NestedVm]
        """
        return self._vms

    @vms.setter
    def vms(self, vms):
        """Sets the vms of this ReplicationPlan.


        :param vms: The vms of this ReplicationPlan.  # noqa: E501
        :type vms: list[NestedVm]
        """

        self._vms = vms

    @property
    def weekdays(self):
        """Gets the weekdays of this ReplicationPlan.  # noqa: E501


        :return: The weekdays of this ReplicationPlan.  # noqa: E501
        :rtype: list[WeekdayTypeEnum]
        """
        return self._weekdays

    @weekdays.setter
    def weekdays(self, weekdays):
        """Sets the weekdays of this ReplicationPlan.


        :param weekdays: The weekdays of this ReplicationPlan.  # noqa: E501
        :type weekdays: list[WeekdayTypeEnum]
        """

        self._weekdays = weekdays

    @property
    def window_end(self):
        """Gets the window_end of this ReplicationPlan.  # noqa: E501


        :return: The window_end of this ReplicationPlan.  # noqa: E501
        :rtype: str
        """
        return self._window_end

    @window_end.setter
    def window_end(self, window_end):
        """Sets the window_end of this ReplicationPlan.


        :param window_end: The window_end of this ReplicationPlan.  # noqa: E501
        :type window_end: str
        """

        self._window_end = window_end

    @property
    def window_start(self):
        """Gets the window_start of this ReplicationPlan.  # noqa: E501


        :return: The window_start of this ReplicationPlan.  # noqa: E501
        :rtype: str
        """
        return self._window_start

    @window_start.setter
    def window_start(self, window_start):
        """Sets the window_start of this ReplicationPlan.


        :param window_start: The window_start of this ReplicationPlan.  # noqa: E501
        :type window_start: str
        """

        self._window_start = window_start

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReplicationPlan):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ReplicationPlan):
            return True

        return self.to_dict() != other.to_dict()
