# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ReplicationPlanWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[ReplicationPlanWhereInput]',
        '_not': 'list[ReplicationPlanWhereInput]',
        '_or': 'list[ReplicationPlanWhereInput]',
        'abort_window_unfinished': 'bool',
        'abort_window_unfinished_not': 'bool',
        'activation_timestamp': 'str',
        'activation_timestamp_gt': 'str',
        'activation_timestamp_gte': 'str',
        'activation_timestamp_in': 'list[str]',
        'activation_timestamp_lt': 'str',
        'activation_timestamp_lte': 'str',
        'activation_timestamp_not': 'str',
        'activation_timestamp_not_in': 'list[str]',
        'compression': 'bool',
        'compression_not': 'bool',
        'created_at': 'str',
        'created_at_gt': 'str',
        'created_at_gte': 'str',
        'created_at_in': 'list[str]',
        'created_at_lt': 'str',
        'created_at_lte': 'str',
        'created_at_not': 'str',
        'created_at_not_in': 'list[str]',
        'delete_strategy': 'BackupPlanDeleteStrategy',
        'delete_strategy_in': 'list[BackupPlanDeleteStrategy]',
        'delete_strategy_not': 'BackupPlanDeleteStrategy',
        'delete_strategy_not_in': 'list[BackupPlanDeleteStrategy]',
        'description': 'str',
        'description_contains': 'str',
        'description_ends_with': 'str',
        'description_gt': 'str',
        'description_gte': 'str',
        'description_in': 'list[str]',
        'description_lt': 'str',
        'description_lte': 'str',
        'description_not': 'str',
        'description_not_contains': 'str',
        'description_not_ends_with': 'str',
        'description_not_in': 'list[str]',
        'description_not_starts_with': 'str',
        'description_starts_with': 'str',
        'ec_k': 'int',
        'ec_k_gt': 'int',
        'ec_k_gte': 'int',
        'ec_k_in': 'list[int]',
        'ec_k_lt': 'int',
        'ec_k_lte': 'int',
        'ec_k_not': 'int',
        'ec_k_not_in': 'list[int]',
        'ec_m': 'int',
        'ec_m_gt': 'int',
        'ec_m_gte': 'int',
        'ec_m_in': 'list[int]',
        'ec_m_lt': 'int',
        'ec_m_lte': 'int',
        'ec_m_not': 'int',
        'ec_m_not_in': 'list[int]',
        'enable_window': 'bool',
        'enable_window_not': 'bool',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'external_cloudtower': 'ExternalCloudTowerWhereInput',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'inbound': 'bool',
        'inbound_not': 'bool',
        'interval': 'int',
        'interval_gt': 'int',
        'interval_gte': 'int',
        'interval_in': 'list[int]',
        'interval_lt': 'int',
        'interval_lte': 'int',
        'interval_not': 'int',
        'interval_not_in': 'list[int]',
        'iscsi_luns_every': 'IscsiLunWhereInput',
        'iscsi_luns_none': 'IscsiLunWhereInput',
        'iscsi_luns_some': 'IscsiLunWhereInput',
        'keep_mac_address': 'bool',
        'keep_mac_address_not': 'bool',
        'keep_policy': 'BackupPlanKeepPolicy',
        'keep_policy_in': 'list[BackupPlanKeepPolicy]',
        'keep_policy_not': 'BackupPlanKeepPolicy',
        'keep_policy_not_in': 'list[BackupPlanKeepPolicy]',
        'keep_policy_value': 'int',
        'keep_policy_value_gt': 'int',
        'keep_policy_value_gte': 'int',
        'keep_policy_value_in': 'list[int]',
        'keep_policy_value_lt': 'int',
        'keep_policy_value_lte': 'int',
        'keep_policy_value_not': 'int',
        'keep_policy_value_not_in': 'list[int]',
        'last_execute_status': 'BackupPlanExecutionStatus',
        'last_execute_status_in': 'list[BackupPlanExecutionStatus]',
        'last_execute_status_message': 'str',
        'last_execute_status_message_contains': 'str',
        'last_execute_status_message_ends_with': 'str',
        'last_execute_status_message_gt': 'str',
        'last_execute_status_message_gte': 'str',
        'last_execute_status_message_in': 'list[str]',
        'last_execute_status_message_lt': 'str',
        'last_execute_status_message_lte': 'str',
        'last_execute_status_message_not': 'str',
        'last_execute_status_message_not_contains': 'str',
        'last_execute_status_message_not_ends_with': 'str',
        'last_execute_status_message_not_in': 'list[str]',
        'last_execute_status_message_not_starts_with': 'str',
        'last_execute_status_message_starts_with': 'str',
        'last_execute_status_not': 'BackupPlanExecutionStatus',
        'last_execute_status_not_in': 'list[BackupPlanExecutionStatus]',
        'last_execute_success_job_count': 'int',
        'last_execute_success_job_count_gt': 'int',
        'last_execute_success_job_count_gte': 'int',
        'last_execute_success_job_count_in': 'list[int]',
        'last_execute_success_job_count_lt': 'int',
        'last_execute_success_job_count_lte': 'int',
        'last_execute_success_job_count_not': 'int',
        'last_execute_success_job_count_not_in': 'list[int]',
        'last_execute_total_job_count': 'int',
        'last_execute_total_job_count_gt': 'int',
        'last_execute_total_job_count_gte': 'int',
        'last_execute_total_job_count_in': 'list[int]',
        'last_execute_total_job_count_lt': 'int',
        'last_execute_total_job_count_lte': 'int',
        'last_execute_total_job_count_not': 'int',
        'last_execute_total_job_count_not_in': 'list[int]',
        'last_executed_at': 'str',
        'last_executed_at_gt': 'str',
        'last_executed_at_gte': 'str',
        'last_executed_at_in': 'list[str]',
        'last_executed_at_lt': 'str',
        'last_executed_at_lte': 'str',
        'last_executed_at_not': 'str',
        'last_executed_at_not_in': 'list[str]',
        'last_manual_execute_status': 'BackupPlanExecutionStatus',
        'last_manual_execute_status_in': 'list[BackupPlanExecutionStatus]',
        'last_manual_execute_status_message': 'str',
        'last_manual_execute_status_message_contains': 'str',
        'last_manual_execute_status_message_ends_with': 'str',
        'last_manual_execute_status_message_gt': 'str',
        'last_manual_execute_status_message_gte': 'str',
        'last_manual_execute_status_message_in': 'list[str]',
        'last_manual_execute_status_message_lt': 'str',
        'last_manual_execute_status_message_lte': 'str',
        'last_manual_execute_status_message_not': 'str',
        'last_manual_execute_status_message_not_contains': 'str',
        'last_manual_execute_status_message_not_ends_with': 'str',
        'last_manual_execute_status_message_not_in': 'list[str]',
        'last_manual_execute_status_message_not_starts_with': 'str',
        'last_manual_execute_status_message_starts_with': 'str',
        'last_manual_execute_status_not': 'BackupPlanExecutionStatus',
        'last_manual_execute_status_not_in': 'list[BackupPlanExecutionStatus]',
        'last_manual_execute_success_job_count': 'int',
        'last_manual_execute_success_job_count_gt': 'int',
        'last_manual_execute_success_job_count_gte': 'int',
        'last_manual_execute_success_job_count_in': 'list[int]',
        'last_manual_execute_success_job_count_lt': 'int',
        'last_manual_execute_success_job_count_lte': 'int',
        'last_manual_execute_success_job_count_not': 'int',
        'last_manual_execute_success_job_count_not_in': 'list[int]',
        'last_manual_execute_total_job_count': 'int',
        'last_manual_execute_total_job_count_gt': 'int',
        'last_manual_execute_total_job_count_gte': 'int',
        'last_manual_execute_total_job_count_in': 'list[int]',
        'last_manual_execute_total_job_count_lt': 'int',
        'last_manual_execute_total_job_count_lte': 'int',
        'last_manual_execute_total_job_count_not': 'int',
        'last_manual_execute_total_job_count_not_in': 'list[int]',
        'last_manual_executed_at': 'str',
        'last_manual_executed_at_gt': 'str',
        'last_manual_executed_at_gte': 'str',
        'last_manual_executed_at_in': 'list[str]',
        'last_manual_executed_at_lt': 'str',
        'last_manual_executed_at_lte': 'str',
        'last_manual_executed_at_not': 'str',
        'last_manual_executed_at_not_in': 'list[str]',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'next_execution_time': 'str',
        'next_execution_time_gt': 'str',
        'next_execution_time_gte': 'str',
        'next_execution_time_in': 'list[str]',
        'next_execution_time_lt': 'str',
        'next_execution_time_lte': 'str',
        'next_execution_time_not': 'str',
        'next_execution_time_not_in': 'list[str]',
        'period': 'ReplicationPlanPeriod',
        'period_in': 'list[ReplicationPlanPeriod]',
        'period_not': 'ReplicationPlanPeriod',
        'period_not_in': 'list[ReplicationPlanPeriod]',
        'phase': 'BackupPlanPhase',
        'phase_in': 'list[BackupPlanPhase]',
        'phase_not': 'BackupPlanPhase',
        'phase_not_in': 'list[BackupPlanPhase]',
        'replica_name_rule': 'ReplicaNameRule',
        'replica_name_rule_in': 'list[ReplicaNameRule]',
        'replica_name_rule_not': 'ReplicaNameRule',
        'replica_name_rule_not_in': 'list[ReplicaNameRule]',
        'replica_name_setting': 'str',
        'replica_name_setting_contains': 'str',
        'replica_name_setting_ends_with': 'str',
        'replica_name_setting_gt': 'str',
        'replica_name_setting_gte': 'str',
        'replica_name_setting_in': 'list[str]',
        'replica_name_setting_lt': 'str',
        'replica_name_setting_lte': 'str',
        'replica_name_setting_not': 'str',
        'replica_name_setting_not_contains': 'str',
        'replica_name_setting_not_ends_with': 'str',
        'replica_name_setting_not_in': 'list[str]',
        'replica_name_setting_not_starts_with': 'str',
        'replica_name_setting_starts_with': 'str',
        'replica_num': 'int',
        'replica_num_gt': 'int',
        'replica_num_gte': 'int',
        'replica_num_in': 'list[int]',
        'replica_num_lt': 'int',
        'replica_num_lte': 'int',
        'replica_num_not': 'int',
        'replica_num_not_in': 'list[int]',
        'replica_vms_every': 'ReplicaVmWhereInput',
        'replica_vms_none': 'ReplicaVmWhereInput',
        'replica_vms_some': 'ReplicaVmWhereInput',
        'replication_plan_executions_every': 'ReplicationPlanExecutionWhereInput',
        'replication_plan_executions_none': 'ReplicationPlanExecutionWhereInput',
        'replication_plan_executions_some': 'ReplicationPlanExecutionWhereInput',
        'replication_restore_points_every': 'ReplicationRestorePointWhereInput',
        'replication_restore_points_none': 'ReplicationRestorePointWhereInput',
        'replication_restore_points_some': 'ReplicationRestorePointWhereInput',
        'replication_target_executions_every': 'ReplicationTargetExecutionWhereInput',
        'replication_target_executions_none': 'ReplicationTargetExecutionWhereInput',
        'replication_target_executions_some': 'ReplicationTargetExecutionWhereInput',
        'resiliency_type': 'ResiliencyType',
        'resiliency_type_in': 'list[ResiliencyType]',
        'resiliency_type_not': 'ResiliencyType',
        'resiliency_type_not_in': 'list[ResiliencyType]',
        'snapshot_consistent_type': 'ConsistentType',
        'snapshot_consistent_type_in': 'list[ConsistentType]',
        'snapshot_consistent_type_not': 'ConsistentType',
        'snapshot_consistent_type_not_in': 'list[ConsistentType]',
        'status': 'BackupPlanStatus',
        'status_in': 'list[BackupPlanStatus]',
        'status_not': 'BackupPlanStatus',
        'status_not_in': 'list[BackupPlanStatus]',
        'storage_policy': 'VmVolumeElfStoragePolicyType',
        'storage_policy_in': 'list[VmVolumeElfStoragePolicyType]',
        'storage_policy_not': 'VmVolumeElfStoragePolicyType',
        'storage_policy_not_in': 'list[VmVolumeElfStoragePolicyType]',
        'target_cluster': 'ClusterWhereInput',
        'target_replication_service': 'ReplicationServiceWhereInput',
        'thin_provision': 'bool',
        'thin_provision_not': 'bool',
        'type': 'ReplicationPlanType',
        'type_in': 'list[ReplicationPlanType]',
        'type_not': 'ReplicationPlanType',
        'type_not_in': 'list[ReplicationPlanType]',
        'updated_at': 'str',
        'updated_at_gt': 'str',
        'updated_at_gte': 'str',
        'updated_at_in': 'list[str]',
        'updated_at_lt': 'str',
        'updated_at_lte': 'str',
        'updated_at_not': 'str',
        'updated_at_not_in': 'list[str]',
        'vms_every': 'VmWhereInput',
        'vms_none': 'VmWhereInput',
        'vms_some': 'VmWhereInput',
        'window_end': 'str',
        'window_end_contains': 'str',
        'window_end_ends_with': 'str',
        'window_end_gt': 'str',
        'window_end_gte': 'str',
        'window_end_in': 'list[str]',
        'window_end_lt': 'str',
        'window_end_lte': 'str',
        'window_end_not': 'str',
        'window_end_not_contains': 'str',
        'window_end_not_ends_with': 'str',
        'window_end_not_in': 'list[str]',
        'window_end_not_starts_with': 'str',
        'window_end_starts_with': 'str',
        'window_start': 'str',
        'window_start_contains': 'str',
        'window_start_ends_with': 'str',
        'window_start_gt': 'str',
        'window_start_gte': 'str',
        'window_start_in': 'list[str]',
        'window_start_lt': 'str',
        'window_start_lte': 'str',
        'window_start_not': 'str',
        'window_start_not_contains': 'str',
        'window_start_not_ends_with': 'str',
        'window_start_not_in': 'list[str]',
        'window_start_not_starts_with': 'str',
        'window_start_starts_with': 'str'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'abort_window_unfinished': 'abort_window_unfinished',
        'abort_window_unfinished_not': 'abort_window_unfinished_not',
        'activation_timestamp': 'activation_timestamp',
        'activation_timestamp_gt': 'activation_timestamp_gt',
        'activation_timestamp_gte': 'activation_timestamp_gte',
        'activation_timestamp_in': 'activation_timestamp_in',
        'activation_timestamp_lt': 'activation_timestamp_lt',
        'activation_timestamp_lte': 'activation_timestamp_lte',
        'activation_timestamp_not': 'activation_timestamp_not',
        'activation_timestamp_not_in': 'activation_timestamp_not_in',
        'compression': 'compression',
        'compression_not': 'compression_not',
        'created_at': 'createdAt',
        'created_at_gt': 'createdAt_gt',
        'created_at_gte': 'createdAt_gte',
        'created_at_in': 'createdAt_in',
        'created_at_lt': 'createdAt_lt',
        'created_at_lte': 'createdAt_lte',
        'created_at_not': 'createdAt_not',
        'created_at_not_in': 'createdAt_not_in',
        'delete_strategy': 'delete_strategy',
        'delete_strategy_in': 'delete_strategy_in',
        'delete_strategy_not': 'delete_strategy_not',
        'delete_strategy_not_in': 'delete_strategy_not_in',
        'description': 'description',
        'description_contains': 'description_contains',
        'description_ends_with': 'description_ends_with',
        'description_gt': 'description_gt',
        'description_gte': 'description_gte',
        'description_in': 'description_in',
        'description_lt': 'description_lt',
        'description_lte': 'description_lte',
        'description_not': 'description_not',
        'description_not_contains': 'description_not_contains',
        'description_not_ends_with': 'description_not_ends_with',
        'description_not_in': 'description_not_in',
        'description_not_starts_with': 'description_not_starts_with',
        'description_starts_with': 'description_starts_with',
        'ec_k': 'ec_k',
        'ec_k_gt': 'ec_k_gt',
        'ec_k_gte': 'ec_k_gte',
        'ec_k_in': 'ec_k_in',
        'ec_k_lt': 'ec_k_lt',
        'ec_k_lte': 'ec_k_lte',
        'ec_k_not': 'ec_k_not',
        'ec_k_not_in': 'ec_k_not_in',
        'ec_m': 'ec_m',
        'ec_m_gt': 'ec_m_gt',
        'ec_m_gte': 'ec_m_gte',
        'ec_m_in': 'ec_m_in',
        'ec_m_lt': 'ec_m_lt',
        'ec_m_lte': 'ec_m_lte',
        'ec_m_not': 'ec_m_not',
        'ec_m_not_in': 'ec_m_not_in',
        'enable_window': 'enable_window',
        'enable_window_not': 'enable_window_not',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'external_cloudtower': 'external_cloudtower',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'inbound': 'inbound',
        'inbound_not': 'inbound_not',
        'interval': 'interval',
        'interval_gt': 'interval_gt',
        'interval_gte': 'interval_gte',
        'interval_in': 'interval_in',
        'interval_lt': 'interval_lt',
        'interval_lte': 'interval_lte',
        'interval_not': 'interval_not',
        'interval_not_in': 'interval_not_in',
        'iscsi_luns_every': 'iscsi_luns_every',
        'iscsi_luns_none': 'iscsi_luns_none',
        'iscsi_luns_some': 'iscsi_luns_some',
        'keep_mac_address': 'keep_mac_address',
        'keep_mac_address_not': 'keep_mac_address_not',
        'keep_policy': 'keep_policy',
        'keep_policy_in': 'keep_policy_in',
        'keep_policy_not': 'keep_policy_not',
        'keep_policy_not_in': 'keep_policy_not_in',
        'keep_policy_value': 'keep_policy_value',
        'keep_policy_value_gt': 'keep_policy_value_gt',
        'keep_policy_value_gte': 'keep_policy_value_gte',
        'keep_policy_value_in': 'keep_policy_value_in',
        'keep_policy_value_lt': 'keep_policy_value_lt',
        'keep_policy_value_lte': 'keep_policy_value_lte',
        'keep_policy_value_not': 'keep_policy_value_not',
        'keep_policy_value_not_in': 'keep_policy_value_not_in',
        'last_execute_status': 'last_execute_status',
        'last_execute_status_in': 'last_execute_status_in',
        'last_execute_status_message': 'last_execute_status_message',
        'last_execute_status_message_contains': 'last_execute_status_message_contains',
        'last_execute_status_message_ends_with': 'last_execute_status_message_ends_with',
        'last_execute_status_message_gt': 'last_execute_status_message_gt',
        'last_execute_status_message_gte': 'last_execute_status_message_gte',
        'last_execute_status_message_in': 'last_execute_status_message_in',
        'last_execute_status_message_lt': 'last_execute_status_message_lt',
        'last_execute_status_message_lte': 'last_execute_status_message_lte',
        'last_execute_status_message_not': 'last_execute_status_message_not',
        'last_execute_status_message_not_contains': 'last_execute_status_message_not_contains',
        'last_execute_status_message_not_ends_with': 'last_execute_status_message_not_ends_with',
        'last_execute_status_message_not_in': 'last_execute_status_message_not_in',
        'last_execute_status_message_not_starts_with': 'last_execute_status_message_not_starts_with',
        'last_execute_status_message_starts_with': 'last_execute_status_message_starts_with',
        'last_execute_status_not': 'last_execute_status_not',
        'last_execute_status_not_in': 'last_execute_status_not_in',
        'last_execute_success_job_count': 'last_execute_success_job_count',
        'last_execute_success_job_count_gt': 'last_execute_success_job_count_gt',
        'last_execute_success_job_count_gte': 'last_execute_success_job_count_gte',
        'last_execute_success_job_count_in': 'last_execute_success_job_count_in',
        'last_execute_success_job_count_lt': 'last_execute_success_job_count_lt',
        'last_execute_success_job_count_lte': 'last_execute_success_job_count_lte',
        'last_execute_success_job_count_not': 'last_execute_success_job_count_not',
        'last_execute_success_job_count_not_in': 'last_execute_success_job_count_not_in',
        'last_execute_total_job_count': 'last_execute_total_job_count',
        'last_execute_total_job_count_gt': 'last_execute_total_job_count_gt',
        'last_execute_total_job_count_gte': 'last_execute_total_job_count_gte',
        'last_execute_total_job_count_in': 'last_execute_total_job_count_in',
        'last_execute_total_job_count_lt': 'last_execute_total_job_count_lt',
        'last_execute_total_job_count_lte': 'last_execute_total_job_count_lte',
        'last_execute_total_job_count_not': 'last_execute_total_job_count_not',
        'last_execute_total_job_count_not_in': 'last_execute_total_job_count_not_in',
        'last_executed_at': 'last_executed_at',
        'last_executed_at_gt': 'last_executed_at_gt',
        'last_executed_at_gte': 'last_executed_at_gte',
        'last_executed_at_in': 'last_executed_at_in',
        'last_executed_at_lt': 'last_executed_at_lt',
        'last_executed_at_lte': 'last_executed_at_lte',
        'last_executed_at_not': 'last_executed_at_not',
        'last_executed_at_not_in': 'last_executed_at_not_in',
        'last_manual_execute_status': 'last_manual_execute_status',
        'last_manual_execute_status_in': 'last_manual_execute_status_in',
        'last_manual_execute_status_message': 'last_manual_execute_status_message',
        'last_manual_execute_status_message_contains': 'last_manual_execute_status_message_contains',
        'last_manual_execute_status_message_ends_with': 'last_manual_execute_status_message_ends_with',
        'last_manual_execute_status_message_gt': 'last_manual_execute_status_message_gt',
        'last_manual_execute_status_message_gte': 'last_manual_execute_status_message_gte',
        'last_manual_execute_status_message_in': 'last_manual_execute_status_message_in',
        'last_manual_execute_status_message_lt': 'last_manual_execute_status_message_lt',
        'last_manual_execute_status_message_lte': 'last_manual_execute_status_message_lte',
        'last_manual_execute_status_message_not': 'last_manual_execute_status_message_not',
        'last_manual_execute_status_message_not_contains': 'last_manual_execute_status_message_not_contains',
        'last_manual_execute_status_message_not_ends_with': 'last_manual_execute_status_message_not_ends_with',
        'last_manual_execute_status_message_not_in': 'last_manual_execute_status_message_not_in',
        'last_manual_execute_status_message_not_starts_with': 'last_manual_execute_status_message_not_starts_with',
        'last_manual_execute_status_message_starts_with': 'last_manual_execute_status_message_starts_with',
        'last_manual_execute_status_not': 'last_manual_execute_status_not',
        'last_manual_execute_status_not_in': 'last_manual_execute_status_not_in',
        'last_manual_execute_success_job_count': 'last_manual_execute_success_job_count',
        'last_manual_execute_success_job_count_gt': 'last_manual_execute_success_job_count_gt',
        'last_manual_execute_success_job_count_gte': 'last_manual_execute_success_job_count_gte',
        'last_manual_execute_success_job_count_in': 'last_manual_execute_success_job_count_in',
        'last_manual_execute_success_job_count_lt': 'last_manual_execute_success_job_count_lt',
        'last_manual_execute_success_job_count_lte': 'last_manual_execute_success_job_count_lte',
        'last_manual_execute_success_job_count_not': 'last_manual_execute_success_job_count_not',
        'last_manual_execute_success_job_count_not_in': 'last_manual_execute_success_job_count_not_in',
        'last_manual_execute_total_job_count': 'last_manual_execute_total_job_count',
        'last_manual_execute_total_job_count_gt': 'last_manual_execute_total_job_count_gt',
        'last_manual_execute_total_job_count_gte': 'last_manual_execute_total_job_count_gte',
        'last_manual_execute_total_job_count_in': 'last_manual_execute_total_job_count_in',
        'last_manual_execute_total_job_count_lt': 'last_manual_execute_total_job_count_lt',
        'last_manual_execute_total_job_count_lte': 'last_manual_execute_total_job_count_lte',
        'last_manual_execute_total_job_count_not': 'last_manual_execute_total_job_count_not',
        'last_manual_execute_total_job_count_not_in': 'last_manual_execute_total_job_count_not_in',
        'last_manual_executed_at': 'last_manual_executed_at',
        'last_manual_executed_at_gt': 'last_manual_executed_at_gt',
        'last_manual_executed_at_gte': 'last_manual_executed_at_gte',
        'last_manual_executed_at_in': 'last_manual_executed_at_in',
        'last_manual_executed_at_lt': 'last_manual_executed_at_lt',
        'last_manual_executed_at_lte': 'last_manual_executed_at_lte',
        'last_manual_executed_at_not': 'last_manual_executed_at_not',
        'last_manual_executed_at_not_in': 'last_manual_executed_at_not_in',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'next_execution_time': 'next_execution_time',
        'next_execution_time_gt': 'next_execution_time_gt',
        'next_execution_time_gte': 'next_execution_time_gte',
        'next_execution_time_in': 'next_execution_time_in',
        'next_execution_time_lt': 'next_execution_time_lt',
        'next_execution_time_lte': 'next_execution_time_lte',
        'next_execution_time_not': 'next_execution_time_not',
        'next_execution_time_not_in': 'next_execution_time_not_in',
        'period': 'period',
        'period_in': 'period_in',
        'period_not': 'period_not',
        'period_not_in': 'period_not_in',
        'phase': 'phase',
        'phase_in': 'phase_in',
        'phase_not': 'phase_not',
        'phase_not_in': 'phase_not_in',
        'replica_name_rule': 'replica_name_rule',
        'replica_name_rule_in': 'replica_name_rule_in',
        'replica_name_rule_not': 'replica_name_rule_not',
        'replica_name_rule_not_in': 'replica_name_rule_not_in',
        'replica_name_setting': 'replica_name_setting',
        'replica_name_setting_contains': 'replica_name_setting_contains',
        'replica_name_setting_ends_with': 'replica_name_setting_ends_with',
        'replica_name_setting_gt': 'replica_name_setting_gt',
        'replica_name_setting_gte': 'replica_name_setting_gte',
        'replica_name_setting_in': 'replica_name_setting_in',
        'replica_name_setting_lt': 'replica_name_setting_lt',
        'replica_name_setting_lte': 'replica_name_setting_lte',
        'replica_name_setting_not': 'replica_name_setting_not',
        'replica_name_setting_not_contains': 'replica_name_setting_not_contains',
        'replica_name_setting_not_ends_with': 'replica_name_setting_not_ends_with',
        'replica_name_setting_not_in': 'replica_name_setting_not_in',
        'replica_name_setting_not_starts_with': 'replica_name_setting_not_starts_with',
        'replica_name_setting_starts_with': 'replica_name_setting_starts_with',
        'replica_num': 'replica_num',
        'replica_num_gt': 'replica_num_gt',
        'replica_num_gte': 'replica_num_gte',
        'replica_num_in': 'replica_num_in',
        'replica_num_lt': 'replica_num_lt',
        'replica_num_lte': 'replica_num_lte',
        'replica_num_not': 'replica_num_not',
        'replica_num_not_in': 'replica_num_not_in',
        'replica_vms_every': 'replica_vms_every',
        'replica_vms_none': 'replica_vms_none',
        'replica_vms_some': 'replica_vms_some',
        'replication_plan_executions_every': 'replication_plan_executions_every',
        'replication_plan_executions_none': 'replication_plan_executions_none',
        'replication_plan_executions_some': 'replication_plan_executions_some',
        'replication_restore_points_every': 'replication_restore_points_every',
        'replication_restore_points_none': 'replication_restore_points_none',
        'replication_restore_points_some': 'replication_restore_points_some',
        'replication_target_executions_every': 'replication_target_executions_every',
        'replication_target_executions_none': 'replication_target_executions_none',
        'replication_target_executions_some': 'replication_target_executions_some',
        'resiliency_type': 'resiliency_type',
        'resiliency_type_in': 'resiliency_type_in',
        'resiliency_type_not': 'resiliency_type_not',
        'resiliency_type_not_in': 'resiliency_type_not_in',
        'snapshot_consistent_type': 'snapshot_consistent_type',
        'snapshot_consistent_type_in': 'snapshot_consistent_type_in',
        'snapshot_consistent_type_not': 'snapshot_consistent_type_not',
        'snapshot_consistent_type_not_in': 'snapshot_consistent_type_not_in',
        'status': 'status',
        'status_in': 'status_in',
        'status_not': 'status_not',
        'status_not_in': 'status_not_in',
        'storage_policy': 'storage_policy',
        'storage_policy_in': 'storage_policy_in',
        'storage_policy_not': 'storage_policy_not',
        'storage_policy_not_in': 'storage_policy_not_in',
        'target_cluster': 'target_cluster',
        'target_replication_service': 'target_replication_service',
        'thin_provision': 'thin_provision',
        'thin_provision_not': 'thin_provision_not',
        'type': 'type',
        'type_in': 'type_in',
        'type_not': 'type_not',
        'type_not_in': 'type_not_in',
        'updated_at': 'updatedAt',
        'updated_at_gt': 'updatedAt_gt',
        'updated_at_gte': 'updatedAt_gte',
        'updated_at_in': 'updatedAt_in',
        'updated_at_lt': 'updatedAt_lt',
        'updated_at_lte': 'updatedAt_lte',
        'updated_at_not': 'updatedAt_not',
        'updated_at_not_in': 'updatedAt_not_in',
        'vms_every': 'vms_every',
        'vms_none': 'vms_none',
        'vms_some': 'vms_some',
        'window_end': 'window_end',
        'window_end_contains': 'window_end_contains',
        'window_end_ends_with': 'window_end_ends_with',
        'window_end_gt': 'window_end_gt',
        'window_end_gte': 'window_end_gte',
        'window_end_in': 'window_end_in',
        'window_end_lt': 'window_end_lt',
        'window_end_lte': 'window_end_lte',
        'window_end_not': 'window_end_not',
        'window_end_not_contains': 'window_end_not_contains',
        'window_end_not_ends_with': 'window_end_not_ends_with',
        'window_end_not_in': 'window_end_not_in',
        'window_end_not_starts_with': 'window_end_not_starts_with',
        'window_end_starts_with': 'window_end_starts_with',
        'window_start': 'window_start',
        'window_start_contains': 'window_start_contains',
        'window_start_ends_with': 'window_start_ends_with',
        'window_start_gt': 'window_start_gt',
        'window_start_gte': 'window_start_gte',
        'window_start_in': 'window_start_in',
        'window_start_lt': 'window_start_lt',
        'window_start_lte': 'window_start_lte',
        'window_start_not': 'window_start_not',
        'window_start_not_contains': 'window_start_not_contains',
        'window_start_not_ends_with': 'window_start_not_ends_with',
        'window_start_not_in': 'window_start_not_in',
        'window_start_not_starts_with': 'window_start_not_starts_with',
        'window_start_starts_with': 'window_start_starts_with'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ReplicationPlanWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._abort_window_unfinished = None
        self._abort_window_unfinished_not = None
        self._activation_timestamp = None
        self._activation_timestamp_gt = None
        self._activation_timestamp_gte = None
        self._activation_timestamp_in = None
        self._activation_timestamp_lt = None
        self._activation_timestamp_lte = None
        self._activation_timestamp_not = None
        self._activation_timestamp_not_in = None
        self._compression = None
        self._compression_not = None
        self._created_at = None
        self._created_at_gt = None
        self._created_at_gte = None
        self._created_at_in = None
        self._created_at_lt = None
        self._created_at_lte = None
        self._created_at_not = None
        self._created_at_not_in = None
        self._delete_strategy = None
        self._delete_strategy_in = None
        self._delete_strategy_not = None
        self._delete_strategy_not_in = None
        self._description = None
        self._description_contains = None
        self._description_ends_with = None
        self._description_gt = None
        self._description_gte = None
        self._description_in = None
        self._description_lt = None
        self._description_lte = None
        self._description_not = None
        self._description_not_contains = None
        self._description_not_ends_with = None
        self._description_not_in = None
        self._description_not_starts_with = None
        self._description_starts_with = None
        self._ec_k = None
        self._ec_k_gt = None
        self._ec_k_gte = None
        self._ec_k_in = None
        self._ec_k_lt = None
        self._ec_k_lte = None
        self._ec_k_not = None
        self._ec_k_not_in = None
        self._ec_m = None
        self._ec_m_gt = None
        self._ec_m_gte = None
        self._ec_m_in = None
        self._ec_m_lt = None
        self._ec_m_lte = None
        self._ec_m_not = None
        self._ec_m_not_in = None
        self._enable_window = None
        self._enable_window_not = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._external_cloudtower = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._inbound = None
        self._inbound_not = None
        self._interval = None
        self._interval_gt = None
        self._interval_gte = None
        self._interval_in = None
        self._interval_lt = None
        self._interval_lte = None
        self._interval_not = None
        self._interval_not_in = None
        self._iscsi_luns_every = None
        self._iscsi_luns_none = None
        self._iscsi_luns_some = None
        self._keep_mac_address = None
        self._keep_mac_address_not = None
        self._keep_policy = None
        self._keep_policy_in = None
        self._keep_policy_not = None
        self._keep_policy_not_in = None
        self._keep_policy_value = None
        self._keep_policy_value_gt = None
        self._keep_policy_value_gte = None
        self._keep_policy_value_in = None
        self._keep_policy_value_lt = None
        self._keep_policy_value_lte = None
        self._keep_policy_value_not = None
        self._keep_policy_value_not_in = None
        self._last_execute_status = None
        self._last_execute_status_in = None
        self._last_execute_status_message = None
        self._last_execute_status_message_contains = None
        self._last_execute_status_message_ends_with = None
        self._last_execute_status_message_gt = None
        self._last_execute_status_message_gte = None
        self._last_execute_status_message_in = None
        self._last_execute_status_message_lt = None
        self._last_execute_status_message_lte = None
        self._last_execute_status_message_not = None
        self._last_execute_status_message_not_contains = None
        self._last_execute_status_message_not_ends_with = None
        self._last_execute_status_message_not_in = None
        self._last_execute_status_message_not_starts_with = None
        self._last_execute_status_message_starts_with = None
        self._last_execute_status_not = None
        self._last_execute_status_not_in = None
        self._last_execute_success_job_count = None
        self._last_execute_success_job_count_gt = None
        self._last_execute_success_job_count_gte = None
        self._last_execute_success_job_count_in = None
        self._last_execute_success_job_count_lt = None
        self._last_execute_success_job_count_lte = None
        self._last_execute_success_job_count_not = None
        self._last_execute_success_job_count_not_in = None
        self._last_execute_total_job_count = None
        self._last_execute_total_job_count_gt = None
        self._last_execute_total_job_count_gte = None
        self._last_execute_total_job_count_in = None
        self._last_execute_total_job_count_lt = None
        self._last_execute_total_job_count_lte = None
        self._last_execute_total_job_count_not = None
        self._last_execute_total_job_count_not_in = None
        self._last_executed_at = None
        self._last_executed_at_gt = None
        self._last_executed_at_gte = None
        self._last_executed_at_in = None
        self._last_executed_at_lt = None
        self._last_executed_at_lte = None
        self._last_executed_at_not = None
        self._last_executed_at_not_in = None
        self._last_manual_execute_status = None
        self._last_manual_execute_status_in = None
        self._last_manual_execute_status_message = None
        self._last_manual_execute_status_message_contains = None
        self._last_manual_execute_status_message_ends_with = None
        self._last_manual_execute_status_message_gt = None
        self._last_manual_execute_status_message_gte = None
        self._last_manual_execute_status_message_in = None
        self._last_manual_execute_status_message_lt = None
        self._last_manual_execute_status_message_lte = None
        self._last_manual_execute_status_message_not = None
        self._last_manual_execute_status_message_not_contains = None
        self._last_manual_execute_status_message_not_ends_with = None
        self._last_manual_execute_status_message_not_in = None
        self._last_manual_execute_status_message_not_starts_with = None
        self._last_manual_execute_status_message_starts_with = None
        self._last_manual_execute_status_not = None
        self._last_manual_execute_status_not_in = None
        self._last_manual_execute_success_job_count = None
        self._last_manual_execute_success_job_count_gt = None
        self._last_manual_execute_success_job_count_gte = None
        self._last_manual_execute_success_job_count_in = None
        self._last_manual_execute_success_job_count_lt = None
        self._last_manual_execute_success_job_count_lte = None
        self._last_manual_execute_success_job_count_not = None
        self._last_manual_execute_success_job_count_not_in = None
        self._last_manual_execute_total_job_count = None
        self._last_manual_execute_total_job_count_gt = None
        self._last_manual_execute_total_job_count_gte = None
        self._last_manual_execute_total_job_count_in = None
        self._last_manual_execute_total_job_count_lt = None
        self._last_manual_execute_total_job_count_lte = None
        self._last_manual_execute_total_job_count_not = None
        self._last_manual_execute_total_job_count_not_in = None
        self._last_manual_executed_at = None
        self._last_manual_executed_at_gt = None
        self._last_manual_executed_at_gte = None
        self._last_manual_executed_at_in = None
        self._last_manual_executed_at_lt = None
        self._last_manual_executed_at_lte = None
        self._last_manual_executed_at_not = None
        self._last_manual_executed_at_not_in = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._next_execution_time = None
        self._next_execution_time_gt = None
        self._next_execution_time_gte = None
        self._next_execution_time_in = None
        self._next_execution_time_lt = None
        self._next_execution_time_lte = None
        self._next_execution_time_not = None
        self._next_execution_time_not_in = None
        self._period = None
        self._period_in = None
        self._period_not = None
        self._period_not_in = None
        self._phase = None
        self._phase_in = None
        self._phase_not = None
        self._phase_not_in = None
        self._replica_name_rule = None
        self._replica_name_rule_in = None
        self._replica_name_rule_not = None
        self._replica_name_rule_not_in = None
        self._replica_name_setting = None
        self._replica_name_setting_contains = None
        self._replica_name_setting_ends_with = None
        self._replica_name_setting_gt = None
        self._replica_name_setting_gte = None
        self._replica_name_setting_in = None
        self._replica_name_setting_lt = None
        self._replica_name_setting_lte = None
        self._replica_name_setting_not = None
        self._replica_name_setting_not_contains = None
        self._replica_name_setting_not_ends_with = None
        self._replica_name_setting_not_in = None
        self._replica_name_setting_not_starts_with = None
        self._replica_name_setting_starts_with = None
        self._replica_num = None
        self._replica_num_gt = None
        self._replica_num_gte = None
        self._replica_num_in = None
        self._replica_num_lt = None
        self._replica_num_lte = None
        self._replica_num_not = None
        self._replica_num_not_in = None
        self._replica_vms_every = None
        self._replica_vms_none = None
        self._replica_vms_some = None
        self._replication_plan_executions_every = None
        self._replication_plan_executions_none = None
        self._replication_plan_executions_some = None
        self._replication_restore_points_every = None
        self._replication_restore_points_none = None
        self._replication_restore_points_some = None
        self._replication_target_executions_every = None
        self._replication_target_executions_none = None
        self._replication_target_executions_some = None
        self._resiliency_type = None
        self._resiliency_type_in = None
        self._resiliency_type_not = None
        self._resiliency_type_not_in = None
        self._snapshot_consistent_type = None
        self._snapshot_consistent_type_in = None
        self._snapshot_consistent_type_not = None
        self._snapshot_consistent_type_not_in = None
        self._status = None
        self._status_in = None
        self._status_not = None
        self._status_not_in = None
        self._storage_policy = None
        self._storage_policy_in = None
        self._storage_policy_not = None
        self._storage_policy_not_in = None
        self._target_cluster = None
        self._target_replication_service = None
        self._thin_provision = None
        self._thin_provision_not = None
        self._type = None
        self._type_in = None
        self._type_not = None
        self._type_not_in = None
        self._updated_at = None
        self._updated_at_gt = None
        self._updated_at_gte = None
        self._updated_at_in = None
        self._updated_at_lt = None
        self._updated_at_lte = None
        self._updated_at_not = None
        self._updated_at_not_in = None
        self._vms_every = None
        self._vms_none = None
        self._vms_some = None
        self._window_end = None
        self._window_end_contains = None
        self._window_end_ends_with = None
        self._window_end_gt = None
        self._window_end_gte = None
        self._window_end_in = None
        self._window_end_lt = None
        self._window_end_lte = None
        self._window_end_not = None
        self._window_end_not_contains = None
        self._window_end_not_ends_with = None
        self._window_end_not_in = None
        self._window_end_not_starts_with = None
        self._window_end_starts_with = None
        self._window_start = None
        self._window_start_contains = None
        self._window_start_ends_with = None
        self._window_start_gt = None
        self._window_start_gte = None
        self._window_start_in = None
        self._window_start_lt = None
        self._window_start_lte = None
        self._window_start_not = None
        self._window_start_not_contains = None
        self._window_start_not_ends_with = None
        self._window_start_not_in = None
        self._window_start_not_starts_with = None
        self._window_start_starts_with = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.abort_window_unfinished = kwargs.get("abort_window_unfinished", None)
        self.abort_window_unfinished_not = kwargs.get("abort_window_unfinished_not", None)
        self.activation_timestamp = kwargs.get("activation_timestamp", None)
        self.activation_timestamp_gt = kwargs.get("activation_timestamp_gt", None)
        self.activation_timestamp_gte = kwargs.get("activation_timestamp_gte", None)
        self.activation_timestamp_in = kwargs.get("activation_timestamp_in", None)
        self.activation_timestamp_lt = kwargs.get("activation_timestamp_lt", None)
        self.activation_timestamp_lte = kwargs.get("activation_timestamp_lte", None)
        self.activation_timestamp_not = kwargs.get("activation_timestamp_not", None)
        self.activation_timestamp_not_in = kwargs.get("activation_timestamp_not_in", None)
        self.compression = kwargs.get("compression", None)
        self.compression_not = kwargs.get("compression_not", None)
        self.created_at = kwargs.get("created_at", None)
        self.created_at_gt = kwargs.get("created_at_gt", None)
        self.created_at_gte = kwargs.get("created_at_gte", None)
        self.created_at_in = kwargs.get("created_at_in", None)
        self.created_at_lt = kwargs.get("created_at_lt", None)
        self.created_at_lte = kwargs.get("created_at_lte", None)
        self.created_at_not = kwargs.get("created_at_not", None)
        self.created_at_not_in = kwargs.get("created_at_not_in", None)
        self.delete_strategy = kwargs.get("delete_strategy", None)
        self.delete_strategy_in = kwargs.get("delete_strategy_in", None)
        self.delete_strategy_not = kwargs.get("delete_strategy_not", None)
        self.delete_strategy_not_in = kwargs.get("delete_strategy_not_in", None)
        self.description = kwargs.get("description", None)
        self.description_contains = kwargs.get("description_contains", None)
        self.description_ends_with = kwargs.get("description_ends_with", None)
        self.description_gt = kwargs.get("description_gt", None)
        self.description_gte = kwargs.get("description_gte", None)
        self.description_in = kwargs.get("description_in", None)
        self.description_lt = kwargs.get("description_lt", None)
        self.description_lte = kwargs.get("description_lte", None)
        self.description_not = kwargs.get("description_not", None)
        self.description_not_contains = kwargs.get("description_not_contains", None)
        self.description_not_ends_with = kwargs.get("description_not_ends_with", None)
        self.description_not_in = kwargs.get("description_not_in", None)
        self.description_not_starts_with = kwargs.get("description_not_starts_with", None)
        self.description_starts_with = kwargs.get("description_starts_with", None)
        self.ec_k = kwargs.get("ec_k", None)
        self.ec_k_gt = kwargs.get("ec_k_gt", None)
        self.ec_k_gte = kwargs.get("ec_k_gte", None)
        self.ec_k_in = kwargs.get("ec_k_in", None)
        self.ec_k_lt = kwargs.get("ec_k_lt", None)
        self.ec_k_lte = kwargs.get("ec_k_lte", None)
        self.ec_k_not = kwargs.get("ec_k_not", None)
        self.ec_k_not_in = kwargs.get("ec_k_not_in", None)
        self.ec_m = kwargs.get("ec_m", None)
        self.ec_m_gt = kwargs.get("ec_m_gt", None)
        self.ec_m_gte = kwargs.get("ec_m_gte", None)
        self.ec_m_in = kwargs.get("ec_m_in", None)
        self.ec_m_lt = kwargs.get("ec_m_lt", None)
        self.ec_m_lte = kwargs.get("ec_m_lte", None)
        self.ec_m_not = kwargs.get("ec_m_not", None)
        self.ec_m_not_in = kwargs.get("ec_m_not_in", None)
        self.enable_window = kwargs.get("enable_window", None)
        self.enable_window_not = kwargs.get("enable_window_not", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.external_cloudtower = kwargs.get("external_cloudtower", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.inbound = kwargs.get("inbound", None)
        self.inbound_not = kwargs.get("inbound_not", None)
        self.interval = kwargs.get("interval", None)
        self.interval_gt = kwargs.get("interval_gt", None)
        self.interval_gte = kwargs.get("interval_gte", None)
        self.interval_in = kwargs.get("interval_in", None)
        self.interval_lt = kwargs.get("interval_lt", None)
        self.interval_lte = kwargs.get("interval_lte", None)
        self.interval_not = kwargs.get("interval_not", None)
        self.interval_not_in = kwargs.get("interval_not_in", None)
        self.iscsi_luns_every = kwargs.get("iscsi_luns_every", None)
        self.iscsi_luns_none = kwargs.get("iscsi_luns_none", None)
        self.iscsi_luns_some = kwargs.get("iscsi_luns_some", None)
        self.keep_mac_address = kwargs.get("keep_mac_address", None)
        self.keep_mac_address_not = kwargs.get("keep_mac_address_not", None)
        self.keep_policy = kwargs.get("keep_policy", None)
        self.keep_policy_in = kwargs.get("keep_policy_in", None)
        self.keep_policy_not = kwargs.get("keep_policy_not", None)
        self.keep_policy_not_in = kwargs.get("keep_policy_not_in", None)
        self.keep_policy_value = kwargs.get("keep_policy_value", None)
        self.keep_policy_value_gt = kwargs.get("keep_policy_value_gt", None)
        self.keep_policy_value_gte = kwargs.get("keep_policy_value_gte", None)
        self.keep_policy_value_in = kwargs.get("keep_policy_value_in", None)
        self.keep_policy_value_lt = kwargs.get("keep_policy_value_lt", None)
        self.keep_policy_value_lte = kwargs.get("keep_policy_value_lte", None)
        self.keep_policy_value_not = kwargs.get("keep_policy_value_not", None)
        self.keep_policy_value_not_in = kwargs.get("keep_policy_value_not_in", None)
        self.last_execute_status = kwargs.get("last_execute_status", None)
        self.last_execute_status_in = kwargs.get("last_execute_status_in", None)
        self.last_execute_status_message = kwargs.get("last_execute_status_message", None)
        self.last_execute_status_message_contains = kwargs.get("last_execute_status_message_contains", None)
        self.last_execute_status_message_ends_with = kwargs.get("last_execute_status_message_ends_with", None)
        self.last_execute_status_message_gt = kwargs.get("last_execute_status_message_gt", None)
        self.last_execute_status_message_gte = kwargs.get("last_execute_status_message_gte", None)
        self.last_execute_status_message_in = kwargs.get("last_execute_status_message_in", None)
        self.last_execute_status_message_lt = kwargs.get("last_execute_status_message_lt", None)
        self.last_execute_status_message_lte = kwargs.get("last_execute_status_message_lte", None)
        self.last_execute_status_message_not = kwargs.get("last_execute_status_message_not", None)
        self.last_execute_status_message_not_contains = kwargs.get("last_execute_status_message_not_contains", None)
        self.last_execute_status_message_not_ends_with = kwargs.get("last_execute_status_message_not_ends_with", None)
        self.last_execute_status_message_not_in = kwargs.get("last_execute_status_message_not_in", None)
        self.last_execute_status_message_not_starts_with = kwargs.get("last_execute_status_message_not_starts_with", None)
        self.last_execute_status_message_starts_with = kwargs.get("last_execute_status_message_starts_with", None)
        self.last_execute_status_not = kwargs.get("last_execute_status_not", None)
        self.last_execute_status_not_in = kwargs.get("last_execute_status_not_in", None)
        self.last_execute_success_job_count = kwargs.get("last_execute_success_job_count", None)
        self.last_execute_success_job_count_gt = kwargs.get("last_execute_success_job_count_gt", None)
        self.last_execute_success_job_count_gte = kwargs.get("last_execute_success_job_count_gte", None)
        self.last_execute_success_job_count_in = kwargs.get("last_execute_success_job_count_in", None)
        self.last_execute_success_job_count_lt = kwargs.get("last_execute_success_job_count_lt", None)
        self.last_execute_success_job_count_lte = kwargs.get("last_execute_success_job_count_lte", None)
        self.last_execute_success_job_count_not = kwargs.get("last_execute_success_job_count_not", None)
        self.last_execute_success_job_count_not_in = kwargs.get("last_execute_success_job_count_not_in", None)
        self.last_execute_total_job_count = kwargs.get("last_execute_total_job_count", None)
        self.last_execute_total_job_count_gt = kwargs.get("last_execute_total_job_count_gt", None)
        self.last_execute_total_job_count_gte = kwargs.get("last_execute_total_job_count_gte", None)
        self.last_execute_total_job_count_in = kwargs.get("last_execute_total_job_count_in", None)
        self.last_execute_total_job_count_lt = kwargs.get("last_execute_total_job_count_lt", None)
        self.last_execute_total_job_count_lte = kwargs.get("last_execute_total_job_count_lte", None)
        self.last_execute_total_job_count_not = kwargs.get("last_execute_total_job_count_not", None)
        self.last_execute_total_job_count_not_in = kwargs.get("last_execute_total_job_count_not_in", None)
        self.last_executed_at = kwargs.get("last_executed_at", None)
        self.last_executed_at_gt = kwargs.get("last_executed_at_gt", None)
        self.last_executed_at_gte = kwargs.get("last_executed_at_gte", None)
        self.last_executed_at_in = kwargs.get("last_executed_at_in", None)
        self.last_executed_at_lt = kwargs.get("last_executed_at_lt", None)
        self.last_executed_at_lte = kwargs.get("last_executed_at_lte", None)
        self.last_executed_at_not = kwargs.get("last_executed_at_not", None)
        self.last_executed_at_not_in = kwargs.get("last_executed_at_not_in", None)
        self.last_manual_execute_status = kwargs.get("last_manual_execute_status", None)
        self.last_manual_execute_status_in = kwargs.get("last_manual_execute_status_in", None)
        self.last_manual_execute_status_message = kwargs.get("last_manual_execute_status_message", None)
        self.last_manual_execute_status_message_contains = kwargs.get("last_manual_execute_status_message_contains", None)
        self.last_manual_execute_status_message_ends_with = kwargs.get("last_manual_execute_status_message_ends_with", None)
        self.last_manual_execute_status_message_gt = kwargs.get("last_manual_execute_status_message_gt", None)
        self.last_manual_execute_status_message_gte = kwargs.get("last_manual_execute_status_message_gte", None)
        self.last_manual_execute_status_message_in = kwargs.get("last_manual_execute_status_message_in", None)
        self.last_manual_execute_status_message_lt = kwargs.get("last_manual_execute_status_message_lt", None)
        self.last_manual_execute_status_message_lte = kwargs.get("last_manual_execute_status_message_lte", None)
        self.last_manual_execute_status_message_not = kwargs.get("last_manual_execute_status_message_not", None)
        self.last_manual_execute_status_message_not_contains = kwargs.get("last_manual_execute_status_message_not_contains", None)
        self.last_manual_execute_status_message_not_ends_with = kwargs.get("last_manual_execute_status_message_not_ends_with", None)
        self.last_manual_execute_status_message_not_in = kwargs.get("last_manual_execute_status_message_not_in", None)
        self.last_manual_execute_status_message_not_starts_with = kwargs.get("last_manual_execute_status_message_not_starts_with", None)
        self.last_manual_execute_status_message_starts_with = kwargs.get("last_manual_execute_status_message_starts_with", None)
        self.last_manual_execute_status_not = kwargs.get("last_manual_execute_status_not", None)
        self.last_manual_execute_status_not_in = kwargs.get("last_manual_execute_status_not_in", None)
        self.last_manual_execute_success_job_count = kwargs.get("last_manual_execute_success_job_count", None)
        self.last_manual_execute_success_job_count_gt = kwargs.get("last_manual_execute_success_job_count_gt", None)
        self.last_manual_execute_success_job_count_gte = kwargs.get("last_manual_execute_success_job_count_gte", None)
        self.last_manual_execute_success_job_count_in = kwargs.get("last_manual_execute_success_job_count_in", None)
        self.last_manual_execute_success_job_count_lt = kwargs.get("last_manual_execute_success_job_count_lt", None)
        self.last_manual_execute_success_job_count_lte = kwargs.get("last_manual_execute_success_job_count_lte", None)
        self.last_manual_execute_success_job_count_not = kwargs.get("last_manual_execute_success_job_count_not", None)
        self.last_manual_execute_success_job_count_not_in = kwargs.get("last_manual_execute_success_job_count_not_in", None)
        self.last_manual_execute_total_job_count = kwargs.get("last_manual_execute_total_job_count", None)
        self.last_manual_execute_total_job_count_gt = kwargs.get("last_manual_execute_total_job_count_gt", None)
        self.last_manual_execute_total_job_count_gte = kwargs.get("last_manual_execute_total_job_count_gte", None)
        self.last_manual_execute_total_job_count_in = kwargs.get("last_manual_execute_total_job_count_in", None)
        self.last_manual_execute_total_job_count_lt = kwargs.get("last_manual_execute_total_job_count_lt", None)
        self.last_manual_execute_total_job_count_lte = kwargs.get("last_manual_execute_total_job_count_lte", None)
        self.last_manual_execute_total_job_count_not = kwargs.get("last_manual_execute_total_job_count_not", None)
        self.last_manual_execute_total_job_count_not_in = kwargs.get("last_manual_execute_total_job_count_not_in", None)
        self.last_manual_executed_at = kwargs.get("last_manual_executed_at", None)
        self.last_manual_executed_at_gt = kwargs.get("last_manual_executed_at_gt", None)
        self.last_manual_executed_at_gte = kwargs.get("last_manual_executed_at_gte", None)
        self.last_manual_executed_at_in = kwargs.get("last_manual_executed_at_in", None)
        self.last_manual_executed_at_lt = kwargs.get("last_manual_executed_at_lt", None)
        self.last_manual_executed_at_lte = kwargs.get("last_manual_executed_at_lte", None)
        self.last_manual_executed_at_not = kwargs.get("last_manual_executed_at_not", None)
        self.last_manual_executed_at_not_in = kwargs.get("last_manual_executed_at_not_in", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.next_execution_time = kwargs.get("next_execution_time", None)
        self.next_execution_time_gt = kwargs.get("next_execution_time_gt", None)
        self.next_execution_time_gte = kwargs.get("next_execution_time_gte", None)
        self.next_execution_time_in = kwargs.get("next_execution_time_in", None)
        self.next_execution_time_lt = kwargs.get("next_execution_time_lt", None)
        self.next_execution_time_lte = kwargs.get("next_execution_time_lte", None)
        self.next_execution_time_not = kwargs.get("next_execution_time_not", None)
        self.next_execution_time_not_in = kwargs.get("next_execution_time_not_in", None)
        self.period = kwargs.get("period", None)
        self.period_in = kwargs.get("period_in", None)
        self.period_not = kwargs.get("period_not", None)
        self.period_not_in = kwargs.get("period_not_in", None)
        self.phase = kwargs.get("phase", None)
        self.phase_in = kwargs.get("phase_in", None)
        self.phase_not = kwargs.get("phase_not", None)
        self.phase_not_in = kwargs.get("phase_not_in", None)
        self.replica_name_rule = kwargs.get("replica_name_rule", None)
        self.replica_name_rule_in = kwargs.get("replica_name_rule_in", None)
        self.replica_name_rule_not = kwargs.get("replica_name_rule_not", None)
        self.replica_name_rule_not_in = kwargs.get("replica_name_rule_not_in", None)
        self.replica_name_setting = kwargs.get("replica_name_setting", None)
        self.replica_name_setting_contains = kwargs.get("replica_name_setting_contains", None)
        self.replica_name_setting_ends_with = kwargs.get("replica_name_setting_ends_with", None)
        self.replica_name_setting_gt = kwargs.get("replica_name_setting_gt", None)
        self.replica_name_setting_gte = kwargs.get("replica_name_setting_gte", None)
        self.replica_name_setting_in = kwargs.get("replica_name_setting_in", None)
        self.replica_name_setting_lt = kwargs.get("replica_name_setting_lt", None)
        self.replica_name_setting_lte = kwargs.get("replica_name_setting_lte", None)
        self.replica_name_setting_not = kwargs.get("replica_name_setting_not", None)
        self.replica_name_setting_not_contains = kwargs.get("replica_name_setting_not_contains", None)
        self.replica_name_setting_not_ends_with = kwargs.get("replica_name_setting_not_ends_with", None)
        self.replica_name_setting_not_in = kwargs.get("replica_name_setting_not_in", None)
        self.replica_name_setting_not_starts_with = kwargs.get("replica_name_setting_not_starts_with", None)
        self.replica_name_setting_starts_with = kwargs.get("replica_name_setting_starts_with", None)
        self.replica_num = kwargs.get("replica_num", None)
        self.replica_num_gt = kwargs.get("replica_num_gt", None)
        self.replica_num_gte = kwargs.get("replica_num_gte", None)
        self.replica_num_in = kwargs.get("replica_num_in", None)
        self.replica_num_lt = kwargs.get("replica_num_lt", None)
        self.replica_num_lte = kwargs.get("replica_num_lte", None)
        self.replica_num_not = kwargs.get("replica_num_not", None)
        self.replica_num_not_in = kwargs.get("replica_num_not_in", None)
        self.replica_vms_every = kwargs.get("replica_vms_every", None)
        self.replica_vms_none = kwargs.get("replica_vms_none", None)
        self.replica_vms_some = kwargs.get("replica_vms_some", None)
        self.replication_plan_executions_every = kwargs.get("replication_plan_executions_every", None)
        self.replication_plan_executions_none = kwargs.get("replication_plan_executions_none", None)
        self.replication_plan_executions_some = kwargs.get("replication_plan_executions_some", None)
        self.replication_restore_points_every = kwargs.get("replication_restore_points_every", None)
        self.replication_restore_points_none = kwargs.get("replication_restore_points_none", None)
        self.replication_restore_points_some = kwargs.get("replication_restore_points_some", None)
        self.replication_target_executions_every = kwargs.get("replication_target_executions_every", None)
        self.replication_target_executions_none = kwargs.get("replication_target_executions_none", None)
        self.replication_target_executions_some = kwargs.get("replication_target_executions_some", None)
        self.resiliency_type = kwargs.get("resiliency_type", None)
        self.resiliency_type_in = kwargs.get("resiliency_type_in", None)
        self.resiliency_type_not = kwargs.get("resiliency_type_not", None)
        self.resiliency_type_not_in = kwargs.get("resiliency_type_not_in", None)
        self.snapshot_consistent_type = kwargs.get("snapshot_consistent_type", None)
        self.snapshot_consistent_type_in = kwargs.get("snapshot_consistent_type_in", None)
        self.snapshot_consistent_type_not = kwargs.get("snapshot_consistent_type_not", None)
        self.snapshot_consistent_type_not_in = kwargs.get("snapshot_consistent_type_not_in", None)
        self.status = kwargs.get("status", None)
        self.status_in = kwargs.get("status_in", None)
        self.status_not = kwargs.get("status_not", None)
        self.status_not_in = kwargs.get("status_not_in", None)
        self.storage_policy = kwargs.get("storage_policy", None)
        self.storage_policy_in = kwargs.get("storage_policy_in", None)
        self.storage_policy_not = kwargs.get("storage_policy_not", None)
        self.storage_policy_not_in = kwargs.get("storage_policy_not_in", None)
        self.target_cluster = kwargs.get("target_cluster", None)
        self.target_replication_service = kwargs.get("target_replication_service", None)
        self.thin_provision = kwargs.get("thin_provision", None)
        self.thin_provision_not = kwargs.get("thin_provision_not", None)
        self.type = kwargs.get("type", None)
        self.type_in = kwargs.get("type_in", None)
        self.type_not = kwargs.get("type_not", None)
        self.type_not_in = kwargs.get("type_not_in", None)
        self.updated_at = kwargs.get("updated_at", None)
        self.updated_at_gt = kwargs.get("updated_at_gt", None)
        self.updated_at_gte = kwargs.get("updated_at_gte", None)
        self.updated_at_in = kwargs.get("updated_at_in", None)
        self.updated_at_lt = kwargs.get("updated_at_lt", None)
        self.updated_at_lte = kwargs.get("updated_at_lte", None)
        self.updated_at_not = kwargs.get("updated_at_not", None)
        self.updated_at_not_in = kwargs.get("updated_at_not_in", None)
        self.vms_every = kwargs.get("vms_every", None)
        self.vms_none = kwargs.get("vms_none", None)
        self.vms_some = kwargs.get("vms_some", None)
        self.window_end = kwargs.get("window_end", None)
        self.window_end_contains = kwargs.get("window_end_contains", None)
        self.window_end_ends_with = kwargs.get("window_end_ends_with", None)
        self.window_end_gt = kwargs.get("window_end_gt", None)
        self.window_end_gte = kwargs.get("window_end_gte", None)
        self.window_end_in = kwargs.get("window_end_in", None)
        self.window_end_lt = kwargs.get("window_end_lt", None)
        self.window_end_lte = kwargs.get("window_end_lte", None)
        self.window_end_not = kwargs.get("window_end_not", None)
        self.window_end_not_contains = kwargs.get("window_end_not_contains", None)
        self.window_end_not_ends_with = kwargs.get("window_end_not_ends_with", None)
        self.window_end_not_in = kwargs.get("window_end_not_in", None)
        self.window_end_not_starts_with = kwargs.get("window_end_not_starts_with", None)
        self.window_end_starts_with = kwargs.get("window_end_starts_with", None)
        self.window_start = kwargs.get("window_start", None)
        self.window_start_contains = kwargs.get("window_start_contains", None)
        self.window_start_ends_with = kwargs.get("window_start_ends_with", None)
        self.window_start_gt = kwargs.get("window_start_gt", None)
        self.window_start_gte = kwargs.get("window_start_gte", None)
        self.window_start_in = kwargs.get("window_start_in", None)
        self.window_start_lt = kwargs.get("window_start_lt", None)
        self.window_start_lte = kwargs.get("window_start_lte", None)
        self.window_start_not = kwargs.get("window_start_not", None)
        self.window_start_not_contains = kwargs.get("window_start_not_contains", None)
        self.window_start_not_ends_with = kwargs.get("window_start_not_ends_with", None)
        self.window_start_not_in = kwargs.get("window_start_not_in", None)
        self.window_start_not_starts_with = kwargs.get("window_start_not_starts_with", None)
        self.window_start_starts_with = kwargs.get("window_start_starts_with", None)

    @property
    def _and(self):
        """Gets the _and of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The _and of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[ReplicationPlanWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this ReplicationPlanWhereInput.


        :param _and: The _and of this ReplicationPlanWhereInput.  # noqa: E501
        :type _and: list[ReplicationPlanWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The _not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[ReplicationPlanWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this ReplicationPlanWhereInput.


        :param _not: The _not of this ReplicationPlanWhereInput.  # noqa: E501
        :type _not: list[ReplicationPlanWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The _or of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[ReplicationPlanWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this ReplicationPlanWhereInput.


        :param _or: The _or of this ReplicationPlanWhereInput.  # noqa: E501
        :type _or: list[ReplicationPlanWhereInput]
        """

        self.__or = _or

    @property
    def abort_window_unfinished(self):
        """Gets the abort_window_unfinished of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The abort_window_unfinished of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._abort_window_unfinished

    @abort_window_unfinished.setter
    def abort_window_unfinished(self, abort_window_unfinished):
        """Sets the abort_window_unfinished of this ReplicationPlanWhereInput.


        :param abort_window_unfinished: The abort_window_unfinished of this ReplicationPlanWhereInput.  # noqa: E501
        :type abort_window_unfinished: bool
        """

        self._abort_window_unfinished = abort_window_unfinished

    @property
    def abort_window_unfinished_not(self):
        """Gets the abort_window_unfinished_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The abort_window_unfinished_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._abort_window_unfinished_not

    @abort_window_unfinished_not.setter
    def abort_window_unfinished_not(self, abort_window_unfinished_not):
        """Sets the abort_window_unfinished_not of this ReplicationPlanWhereInput.


        :param abort_window_unfinished_not: The abort_window_unfinished_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type abort_window_unfinished_not: bool
        """

        self._abort_window_unfinished_not = abort_window_unfinished_not

    @property
    def activation_timestamp(self):
        """Gets the activation_timestamp of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The activation_timestamp of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._activation_timestamp

    @activation_timestamp.setter
    def activation_timestamp(self, activation_timestamp):
        """Sets the activation_timestamp of this ReplicationPlanWhereInput.


        :param activation_timestamp: The activation_timestamp of this ReplicationPlanWhereInput.  # noqa: E501
        :type activation_timestamp: str
        """

        self._activation_timestamp = activation_timestamp

    @property
    def activation_timestamp_gt(self):
        """Gets the activation_timestamp_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The activation_timestamp_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._activation_timestamp_gt

    @activation_timestamp_gt.setter
    def activation_timestamp_gt(self, activation_timestamp_gt):
        """Sets the activation_timestamp_gt of this ReplicationPlanWhereInput.


        :param activation_timestamp_gt: The activation_timestamp_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type activation_timestamp_gt: str
        """

        self._activation_timestamp_gt = activation_timestamp_gt

    @property
    def activation_timestamp_gte(self):
        """Gets the activation_timestamp_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The activation_timestamp_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._activation_timestamp_gte

    @activation_timestamp_gte.setter
    def activation_timestamp_gte(self, activation_timestamp_gte):
        """Sets the activation_timestamp_gte of this ReplicationPlanWhereInput.


        :param activation_timestamp_gte: The activation_timestamp_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type activation_timestamp_gte: str
        """

        self._activation_timestamp_gte = activation_timestamp_gte

    @property
    def activation_timestamp_in(self):
        """Gets the activation_timestamp_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The activation_timestamp_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._activation_timestamp_in

    @activation_timestamp_in.setter
    def activation_timestamp_in(self, activation_timestamp_in):
        """Sets the activation_timestamp_in of this ReplicationPlanWhereInput.


        :param activation_timestamp_in: The activation_timestamp_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type activation_timestamp_in: list[str]
        """

        self._activation_timestamp_in = activation_timestamp_in

    @property
    def activation_timestamp_lt(self):
        """Gets the activation_timestamp_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The activation_timestamp_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._activation_timestamp_lt

    @activation_timestamp_lt.setter
    def activation_timestamp_lt(self, activation_timestamp_lt):
        """Sets the activation_timestamp_lt of this ReplicationPlanWhereInput.


        :param activation_timestamp_lt: The activation_timestamp_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type activation_timestamp_lt: str
        """

        self._activation_timestamp_lt = activation_timestamp_lt

    @property
    def activation_timestamp_lte(self):
        """Gets the activation_timestamp_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The activation_timestamp_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._activation_timestamp_lte

    @activation_timestamp_lte.setter
    def activation_timestamp_lte(self, activation_timestamp_lte):
        """Sets the activation_timestamp_lte of this ReplicationPlanWhereInput.


        :param activation_timestamp_lte: The activation_timestamp_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type activation_timestamp_lte: str
        """

        self._activation_timestamp_lte = activation_timestamp_lte

    @property
    def activation_timestamp_not(self):
        """Gets the activation_timestamp_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The activation_timestamp_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._activation_timestamp_not

    @activation_timestamp_not.setter
    def activation_timestamp_not(self, activation_timestamp_not):
        """Sets the activation_timestamp_not of this ReplicationPlanWhereInput.


        :param activation_timestamp_not: The activation_timestamp_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type activation_timestamp_not: str
        """

        self._activation_timestamp_not = activation_timestamp_not

    @property
    def activation_timestamp_not_in(self):
        """Gets the activation_timestamp_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The activation_timestamp_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._activation_timestamp_not_in

    @activation_timestamp_not_in.setter
    def activation_timestamp_not_in(self, activation_timestamp_not_in):
        """Sets the activation_timestamp_not_in of this ReplicationPlanWhereInput.


        :param activation_timestamp_not_in: The activation_timestamp_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type activation_timestamp_not_in: list[str]
        """

        self._activation_timestamp_not_in = activation_timestamp_not_in

    @property
    def compression(self):
        """Gets the compression of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The compression of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._compression

    @compression.setter
    def compression(self, compression):
        """Sets the compression of this ReplicationPlanWhereInput.


        :param compression: The compression of this ReplicationPlanWhereInput.  # noqa: E501
        :type compression: bool
        """

        self._compression = compression

    @property
    def compression_not(self):
        """Gets the compression_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The compression_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._compression_not

    @compression_not.setter
    def compression_not(self, compression_not):
        """Sets the compression_not of this ReplicationPlanWhereInput.


        :param compression_not: The compression_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type compression_not: bool
        """

        self._compression_not = compression_not

    @property
    def created_at(self):
        """Gets the created_at of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The created_at of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ReplicationPlanWhereInput.


        :param created_at: The created_at of this ReplicationPlanWhereInput.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def created_at_gt(self):
        """Gets the created_at_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The created_at_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_gt

    @created_at_gt.setter
    def created_at_gt(self, created_at_gt):
        """Sets the created_at_gt of this ReplicationPlanWhereInput.


        :param created_at_gt: The created_at_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type created_at_gt: str
        """

        self._created_at_gt = created_at_gt

    @property
    def created_at_gte(self):
        """Gets the created_at_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The created_at_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_gte

    @created_at_gte.setter
    def created_at_gte(self, created_at_gte):
        """Sets the created_at_gte of this ReplicationPlanWhereInput.


        :param created_at_gte: The created_at_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type created_at_gte: str
        """

        self._created_at_gte = created_at_gte

    @property
    def created_at_in(self):
        """Gets the created_at_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The created_at_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._created_at_in

    @created_at_in.setter
    def created_at_in(self, created_at_in):
        """Sets the created_at_in of this ReplicationPlanWhereInput.


        :param created_at_in: The created_at_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type created_at_in: list[str]
        """

        self._created_at_in = created_at_in

    @property
    def created_at_lt(self):
        """Gets the created_at_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The created_at_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_lt

    @created_at_lt.setter
    def created_at_lt(self, created_at_lt):
        """Sets the created_at_lt of this ReplicationPlanWhereInput.


        :param created_at_lt: The created_at_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type created_at_lt: str
        """

        self._created_at_lt = created_at_lt

    @property
    def created_at_lte(self):
        """Gets the created_at_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The created_at_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_lte

    @created_at_lte.setter
    def created_at_lte(self, created_at_lte):
        """Sets the created_at_lte of this ReplicationPlanWhereInput.


        :param created_at_lte: The created_at_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type created_at_lte: str
        """

        self._created_at_lte = created_at_lte

    @property
    def created_at_not(self):
        """Gets the created_at_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The created_at_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_not

    @created_at_not.setter
    def created_at_not(self, created_at_not):
        """Sets the created_at_not of this ReplicationPlanWhereInput.


        :param created_at_not: The created_at_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type created_at_not: str
        """

        self._created_at_not = created_at_not

    @property
    def created_at_not_in(self):
        """Gets the created_at_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The created_at_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._created_at_not_in

    @created_at_not_in.setter
    def created_at_not_in(self, created_at_not_in):
        """Sets the created_at_not_in of this ReplicationPlanWhereInput.


        :param created_at_not_in: The created_at_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type created_at_not_in: list[str]
        """

        self._created_at_not_in = created_at_not_in

    @property
    def delete_strategy(self):
        """Gets the delete_strategy of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The delete_strategy of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanDeleteStrategy
        """
        return self._delete_strategy

    @delete_strategy.setter
    def delete_strategy(self, delete_strategy):
        """Sets the delete_strategy of this ReplicationPlanWhereInput.


        :param delete_strategy: The delete_strategy of this ReplicationPlanWhereInput.  # noqa: E501
        :type delete_strategy: BackupPlanDeleteStrategy
        """

        self._delete_strategy = delete_strategy

    @property
    def delete_strategy_in(self):
        """Gets the delete_strategy_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The delete_strategy_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanDeleteStrategy]
        """
        return self._delete_strategy_in

    @delete_strategy_in.setter
    def delete_strategy_in(self, delete_strategy_in):
        """Sets the delete_strategy_in of this ReplicationPlanWhereInput.


        :param delete_strategy_in: The delete_strategy_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type delete_strategy_in: list[BackupPlanDeleteStrategy]
        """

        self._delete_strategy_in = delete_strategy_in

    @property
    def delete_strategy_not(self):
        """Gets the delete_strategy_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The delete_strategy_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanDeleteStrategy
        """
        return self._delete_strategy_not

    @delete_strategy_not.setter
    def delete_strategy_not(self, delete_strategy_not):
        """Sets the delete_strategy_not of this ReplicationPlanWhereInput.


        :param delete_strategy_not: The delete_strategy_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type delete_strategy_not: BackupPlanDeleteStrategy
        """

        self._delete_strategy_not = delete_strategy_not

    @property
    def delete_strategy_not_in(self):
        """Gets the delete_strategy_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The delete_strategy_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanDeleteStrategy]
        """
        return self._delete_strategy_not_in

    @delete_strategy_not_in.setter
    def delete_strategy_not_in(self, delete_strategy_not_in):
        """Sets the delete_strategy_not_in of this ReplicationPlanWhereInput.


        :param delete_strategy_not_in: The delete_strategy_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type delete_strategy_not_in: list[BackupPlanDeleteStrategy]
        """

        self._delete_strategy_not_in = delete_strategy_not_in

    @property
    def description(self):
        """Gets the description of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The description of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ReplicationPlanWhereInput.


        :param description: The description of this ReplicationPlanWhereInput.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def description_contains(self):
        """Gets the description_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The description_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_contains

    @description_contains.setter
    def description_contains(self, description_contains):
        """Sets the description_contains of this ReplicationPlanWhereInput.


        :param description_contains: The description_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type description_contains: str
        """

        self._description_contains = description_contains

    @property
    def description_ends_with(self):
        """Gets the description_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The description_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_ends_with

    @description_ends_with.setter
    def description_ends_with(self, description_ends_with):
        """Sets the description_ends_with of this ReplicationPlanWhereInput.


        :param description_ends_with: The description_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type description_ends_with: str
        """

        self._description_ends_with = description_ends_with

    @property
    def description_gt(self):
        """Gets the description_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The description_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gt

    @description_gt.setter
    def description_gt(self, description_gt):
        """Sets the description_gt of this ReplicationPlanWhereInput.


        :param description_gt: The description_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type description_gt: str
        """

        self._description_gt = description_gt

    @property
    def description_gte(self):
        """Gets the description_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The description_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gte

    @description_gte.setter
    def description_gte(self, description_gte):
        """Sets the description_gte of this ReplicationPlanWhereInput.


        :param description_gte: The description_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type description_gte: str
        """

        self._description_gte = description_gte

    @property
    def description_in(self):
        """Gets the description_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The description_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_in

    @description_in.setter
    def description_in(self, description_in):
        """Sets the description_in of this ReplicationPlanWhereInput.


        :param description_in: The description_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type description_in: list[str]
        """

        self._description_in = description_in

    @property
    def description_lt(self):
        """Gets the description_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The description_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lt

    @description_lt.setter
    def description_lt(self, description_lt):
        """Sets the description_lt of this ReplicationPlanWhereInput.


        :param description_lt: The description_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type description_lt: str
        """

        self._description_lt = description_lt

    @property
    def description_lte(self):
        """Gets the description_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The description_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lte

    @description_lte.setter
    def description_lte(self, description_lte):
        """Sets the description_lte of this ReplicationPlanWhereInput.


        :param description_lte: The description_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type description_lte: str
        """

        self._description_lte = description_lte

    @property
    def description_not(self):
        """Gets the description_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The description_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not

    @description_not.setter
    def description_not(self, description_not):
        """Sets the description_not of this ReplicationPlanWhereInput.


        :param description_not: The description_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type description_not: str
        """

        self._description_not = description_not

    @property
    def description_not_contains(self):
        """Gets the description_not_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The description_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_contains

    @description_not_contains.setter
    def description_not_contains(self, description_not_contains):
        """Sets the description_not_contains of this ReplicationPlanWhereInput.


        :param description_not_contains: The description_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type description_not_contains: str
        """

        self._description_not_contains = description_not_contains

    @property
    def description_not_ends_with(self):
        """Gets the description_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The description_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_ends_with

    @description_not_ends_with.setter
    def description_not_ends_with(self, description_not_ends_with):
        """Sets the description_not_ends_with of this ReplicationPlanWhereInput.


        :param description_not_ends_with: The description_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type description_not_ends_with: str
        """

        self._description_not_ends_with = description_not_ends_with

    @property
    def description_not_in(self):
        """Gets the description_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The description_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_not_in

    @description_not_in.setter
    def description_not_in(self, description_not_in):
        """Sets the description_not_in of this ReplicationPlanWhereInput.


        :param description_not_in: The description_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type description_not_in: list[str]
        """

        self._description_not_in = description_not_in

    @property
    def description_not_starts_with(self):
        """Gets the description_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The description_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_starts_with

    @description_not_starts_with.setter
    def description_not_starts_with(self, description_not_starts_with):
        """Sets the description_not_starts_with of this ReplicationPlanWhereInput.


        :param description_not_starts_with: The description_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type description_not_starts_with: str
        """

        self._description_not_starts_with = description_not_starts_with

    @property
    def description_starts_with(self):
        """Gets the description_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The description_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_starts_with

    @description_starts_with.setter
    def description_starts_with(self, description_starts_with):
        """Sets the description_starts_with of this ReplicationPlanWhereInput.


        :param description_starts_with: The description_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type description_starts_with: str
        """

        self._description_starts_with = description_starts_with

    @property
    def ec_k(self):
        """Gets the ec_k of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_k of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_k

    @ec_k.setter
    def ec_k(self, ec_k):
        """Sets the ec_k of this ReplicationPlanWhereInput.


        :param ec_k: The ec_k of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_k: int
        """

        self._ec_k = ec_k

    @property
    def ec_k_gt(self):
        """Gets the ec_k_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_k_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_k_gt

    @ec_k_gt.setter
    def ec_k_gt(self, ec_k_gt):
        """Sets the ec_k_gt of this ReplicationPlanWhereInput.


        :param ec_k_gt: The ec_k_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_k_gt: int
        """

        self._ec_k_gt = ec_k_gt

    @property
    def ec_k_gte(self):
        """Gets the ec_k_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_k_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_k_gte

    @ec_k_gte.setter
    def ec_k_gte(self, ec_k_gte):
        """Sets the ec_k_gte of this ReplicationPlanWhereInput.


        :param ec_k_gte: The ec_k_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_k_gte: int
        """

        self._ec_k_gte = ec_k_gte

    @property
    def ec_k_in(self):
        """Gets the ec_k_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_k_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._ec_k_in

    @ec_k_in.setter
    def ec_k_in(self, ec_k_in):
        """Sets the ec_k_in of this ReplicationPlanWhereInput.


        :param ec_k_in: The ec_k_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_k_in: list[int]
        """

        self._ec_k_in = ec_k_in

    @property
    def ec_k_lt(self):
        """Gets the ec_k_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_k_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_k_lt

    @ec_k_lt.setter
    def ec_k_lt(self, ec_k_lt):
        """Sets the ec_k_lt of this ReplicationPlanWhereInput.


        :param ec_k_lt: The ec_k_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_k_lt: int
        """

        self._ec_k_lt = ec_k_lt

    @property
    def ec_k_lte(self):
        """Gets the ec_k_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_k_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_k_lte

    @ec_k_lte.setter
    def ec_k_lte(self, ec_k_lte):
        """Sets the ec_k_lte of this ReplicationPlanWhereInput.


        :param ec_k_lte: The ec_k_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_k_lte: int
        """

        self._ec_k_lte = ec_k_lte

    @property
    def ec_k_not(self):
        """Gets the ec_k_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_k_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_k_not

    @ec_k_not.setter
    def ec_k_not(self, ec_k_not):
        """Sets the ec_k_not of this ReplicationPlanWhereInput.


        :param ec_k_not: The ec_k_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_k_not: int
        """

        self._ec_k_not = ec_k_not

    @property
    def ec_k_not_in(self):
        """Gets the ec_k_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_k_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._ec_k_not_in

    @ec_k_not_in.setter
    def ec_k_not_in(self, ec_k_not_in):
        """Sets the ec_k_not_in of this ReplicationPlanWhereInput.


        :param ec_k_not_in: The ec_k_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_k_not_in: list[int]
        """

        self._ec_k_not_in = ec_k_not_in

    @property
    def ec_m(self):
        """Gets the ec_m of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_m of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_m

    @ec_m.setter
    def ec_m(self, ec_m):
        """Sets the ec_m of this ReplicationPlanWhereInput.


        :param ec_m: The ec_m of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_m: int
        """

        self._ec_m = ec_m

    @property
    def ec_m_gt(self):
        """Gets the ec_m_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_m_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_m_gt

    @ec_m_gt.setter
    def ec_m_gt(self, ec_m_gt):
        """Sets the ec_m_gt of this ReplicationPlanWhereInput.


        :param ec_m_gt: The ec_m_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_m_gt: int
        """

        self._ec_m_gt = ec_m_gt

    @property
    def ec_m_gte(self):
        """Gets the ec_m_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_m_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_m_gte

    @ec_m_gte.setter
    def ec_m_gte(self, ec_m_gte):
        """Sets the ec_m_gte of this ReplicationPlanWhereInput.


        :param ec_m_gte: The ec_m_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_m_gte: int
        """

        self._ec_m_gte = ec_m_gte

    @property
    def ec_m_in(self):
        """Gets the ec_m_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_m_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._ec_m_in

    @ec_m_in.setter
    def ec_m_in(self, ec_m_in):
        """Sets the ec_m_in of this ReplicationPlanWhereInput.


        :param ec_m_in: The ec_m_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_m_in: list[int]
        """

        self._ec_m_in = ec_m_in

    @property
    def ec_m_lt(self):
        """Gets the ec_m_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_m_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_m_lt

    @ec_m_lt.setter
    def ec_m_lt(self, ec_m_lt):
        """Sets the ec_m_lt of this ReplicationPlanWhereInput.


        :param ec_m_lt: The ec_m_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_m_lt: int
        """

        self._ec_m_lt = ec_m_lt

    @property
    def ec_m_lte(self):
        """Gets the ec_m_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_m_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_m_lte

    @ec_m_lte.setter
    def ec_m_lte(self, ec_m_lte):
        """Sets the ec_m_lte of this ReplicationPlanWhereInput.


        :param ec_m_lte: The ec_m_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_m_lte: int
        """

        self._ec_m_lte = ec_m_lte

    @property
    def ec_m_not(self):
        """Gets the ec_m_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_m_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._ec_m_not

    @ec_m_not.setter
    def ec_m_not(self, ec_m_not):
        """Sets the ec_m_not of this ReplicationPlanWhereInput.


        :param ec_m_not: The ec_m_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_m_not: int
        """

        self._ec_m_not = ec_m_not

    @property
    def ec_m_not_in(self):
        """Gets the ec_m_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The ec_m_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._ec_m_not_in

    @ec_m_not_in.setter
    def ec_m_not_in(self, ec_m_not_in):
        """Sets the ec_m_not_in of this ReplicationPlanWhereInput.


        :param ec_m_not_in: The ec_m_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type ec_m_not_in: list[int]
        """

        self._ec_m_not_in = ec_m_not_in

    @property
    def enable_window(self):
        """Gets the enable_window of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The enable_window of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._enable_window

    @enable_window.setter
    def enable_window(self, enable_window):
        """Sets the enable_window of this ReplicationPlanWhereInput.


        :param enable_window: The enable_window of this ReplicationPlanWhereInput.  # noqa: E501
        :type enable_window: bool
        """

        self._enable_window = enable_window

    @property
    def enable_window_not(self):
        """Gets the enable_window_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The enable_window_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._enable_window_not

    @enable_window_not.setter
    def enable_window_not(self, enable_window_not):
        """Sets the enable_window_not of this ReplicationPlanWhereInput.


        :param enable_window_not: The enable_window_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type enable_window_not: bool
        """

        self._enable_window_not = enable_window_not

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The entity_async_status of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this ReplicationPlanWhereInput.


        :param entity_async_status: The entity_async_status of this ReplicationPlanWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this ReplicationPlanWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this ReplicationPlanWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this ReplicationPlanWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def external_cloudtower(self):
        """Gets the external_cloudtower of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The external_cloudtower of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ExternalCloudTowerWhereInput
        """
        return self._external_cloudtower

    @external_cloudtower.setter
    def external_cloudtower(self, external_cloudtower):
        """Sets the external_cloudtower of this ReplicationPlanWhereInput.


        :param external_cloudtower: The external_cloudtower of this ReplicationPlanWhereInput.  # noqa: E501
        :type external_cloudtower: ExternalCloudTowerWhereInput
        """

        self._external_cloudtower = external_cloudtower

    @property
    def id(self):
        """Gets the id of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The id of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ReplicationPlanWhereInput.


        :param id: The id of this ReplicationPlanWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The id_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this ReplicationPlanWhereInput.


        :param id_contains: The id_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The id_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this ReplicationPlanWhereInput.


        :param id_ends_with: The id_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The id_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this ReplicationPlanWhereInput.


        :param id_gt: The id_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The id_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this ReplicationPlanWhereInput.


        :param id_gte: The id_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The id_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this ReplicationPlanWhereInput.


        :param id_in: The id_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The id_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this ReplicationPlanWhereInput.


        :param id_lt: The id_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The id_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this ReplicationPlanWhereInput.


        :param id_lte: The id_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The id_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this ReplicationPlanWhereInput.


        :param id_not: The id_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The id_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this ReplicationPlanWhereInput.


        :param id_not_contains: The id_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this ReplicationPlanWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The id_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this ReplicationPlanWhereInput.


        :param id_not_in: The id_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this ReplicationPlanWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The id_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this ReplicationPlanWhereInput.


        :param id_starts_with: The id_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def inbound(self):
        """Gets the inbound of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The inbound of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._inbound

    @inbound.setter
    def inbound(self, inbound):
        """Sets the inbound of this ReplicationPlanWhereInput.


        :param inbound: The inbound of this ReplicationPlanWhereInput.  # noqa: E501
        :type inbound: bool
        """

        self._inbound = inbound

    @property
    def inbound_not(self):
        """Gets the inbound_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The inbound_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._inbound_not

    @inbound_not.setter
    def inbound_not(self, inbound_not):
        """Sets the inbound_not of this ReplicationPlanWhereInput.


        :param inbound_not: The inbound_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type inbound_not: bool
        """

        self._inbound_not = inbound_not

    @property
    def interval(self):
        """Gets the interval of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The interval of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this ReplicationPlanWhereInput.


        :param interval: The interval of this ReplicationPlanWhereInput.  # noqa: E501
        :type interval: int
        """

        self._interval = interval

    @property
    def interval_gt(self):
        """Gets the interval_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The interval_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._interval_gt

    @interval_gt.setter
    def interval_gt(self, interval_gt):
        """Sets the interval_gt of this ReplicationPlanWhereInput.


        :param interval_gt: The interval_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type interval_gt: int
        """

        self._interval_gt = interval_gt

    @property
    def interval_gte(self):
        """Gets the interval_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The interval_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._interval_gte

    @interval_gte.setter
    def interval_gte(self, interval_gte):
        """Sets the interval_gte of this ReplicationPlanWhereInput.


        :param interval_gte: The interval_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type interval_gte: int
        """

        self._interval_gte = interval_gte

    @property
    def interval_in(self):
        """Gets the interval_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The interval_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._interval_in

    @interval_in.setter
    def interval_in(self, interval_in):
        """Sets the interval_in of this ReplicationPlanWhereInput.


        :param interval_in: The interval_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type interval_in: list[int]
        """

        self._interval_in = interval_in

    @property
    def interval_lt(self):
        """Gets the interval_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The interval_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._interval_lt

    @interval_lt.setter
    def interval_lt(self, interval_lt):
        """Sets the interval_lt of this ReplicationPlanWhereInput.


        :param interval_lt: The interval_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type interval_lt: int
        """

        self._interval_lt = interval_lt

    @property
    def interval_lte(self):
        """Gets the interval_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The interval_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._interval_lte

    @interval_lte.setter
    def interval_lte(self, interval_lte):
        """Sets the interval_lte of this ReplicationPlanWhereInput.


        :param interval_lte: The interval_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type interval_lte: int
        """

        self._interval_lte = interval_lte

    @property
    def interval_not(self):
        """Gets the interval_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The interval_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._interval_not

    @interval_not.setter
    def interval_not(self, interval_not):
        """Sets the interval_not of this ReplicationPlanWhereInput.


        :param interval_not: The interval_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type interval_not: int
        """

        self._interval_not = interval_not

    @property
    def interval_not_in(self):
        """Gets the interval_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The interval_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._interval_not_in

    @interval_not_in.setter
    def interval_not_in(self, interval_not_in):
        """Sets the interval_not_in of this ReplicationPlanWhereInput.


        :param interval_not_in: The interval_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type interval_not_in: list[int]
        """

        self._interval_not_in = interval_not_in

    @property
    def iscsi_luns_every(self):
        """Gets the iscsi_luns_every of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The iscsi_luns_every of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: IscsiLunWhereInput
        """
        return self._iscsi_luns_every

    @iscsi_luns_every.setter
    def iscsi_luns_every(self, iscsi_luns_every):
        """Sets the iscsi_luns_every of this ReplicationPlanWhereInput.


        :param iscsi_luns_every: The iscsi_luns_every of this ReplicationPlanWhereInput.  # noqa: E501
        :type iscsi_luns_every: IscsiLunWhereInput
        """

        self._iscsi_luns_every = iscsi_luns_every

    @property
    def iscsi_luns_none(self):
        """Gets the iscsi_luns_none of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The iscsi_luns_none of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: IscsiLunWhereInput
        """
        return self._iscsi_luns_none

    @iscsi_luns_none.setter
    def iscsi_luns_none(self, iscsi_luns_none):
        """Sets the iscsi_luns_none of this ReplicationPlanWhereInput.


        :param iscsi_luns_none: The iscsi_luns_none of this ReplicationPlanWhereInput.  # noqa: E501
        :type iscsi_luns_none: IscsiLunWhereInput
        """

        self._iscsi_luns_none = iscsi_luns_none

    @property
    def iscsi_luns_some(self):
        """Gets the iscsi_luns_some of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The iscsi_luns_some of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: IscsiLunWhereInput
        """
        return self._iscsi_luns_some

    @iscsi_luns_some.setter
    def iscsi_luns_some(self, iscsi_luns_some):
        """Sets the iscsi_luns_some of this ReplicationPlanWhereInput.


        :param iscsi_luns_some: The iscsi_luns_some of this ReplicationPlanWhereInput.  # noqa: E501
        :type iscsi_luns_some: IscsiLunWhereInput
        """

        self._iscsi_luns_some = iscsi_luns_some

    @property
    def keep_mac_address(self):
        """Gets the keep_mac_address of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The keep_mac_address of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._keep_mac_address

    @keep_mac_address.setter
    def keep_mac_address(self, keep_mac_address):
        """Sets the keep_mac_address of this ReplicationPlanWhereInput.


        :param keep_mac_address: The keep_mac_address of this ReplicationPlanWhereInput.  # noqa: E501
        :type keep_mac_address: bool
        """

        self._keep_mac_address = keep_mac_address

    @property
    def keep_mac_address_not(self):
        """Gets the keep_mac_address_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The keep_mac_address_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._keep_mac_address_not

    @keep_mac_address_not.setter
    def keep_mac_address_not(self, keep_mac_address_not):
        """Sets the keep_mac_address_not of this ReplicationPlanWhereInput.


        :param keep_mac_address_not: The keep_mac_address_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type keep_mac_address_not: bool
        """

        self._keep_mac_address_not = keep_mac_address_not

    @property
    def keep_policy(self):
        """Gets the keep_policy of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The keep_policy of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanKeepPolicy
        """
        return self._keep_policy

    @keep_policy.setter
    def keep_policy(self, keep_policy):
        """Sets the keep_policy of this ReplicationPlanWhereInput.


        :param keep_policy: The keep_policy of this ReplicationPlanWhereInput.  # noqa: E501
        :type keep_policy: BackupPlanKeepPolicy
        """

        self._keep_policy = keep_policy

    @property
    def keep_policy_in(self):
        """Gets the keep_policy_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The keep_policy_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanKeepPolicy]
        """
        return self._keep_policy_in

    @keep_policy_in.setter
    def keep_policy_in(self, keep_policy_in):
        """Sets the keep_policy_in of this ReplicationPlanWhereInput.


        :param keep_policy_in: The keep_policy_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type keep_policy_in: list[BackupPlanKeepPolicy]
        """

        self._keep_policy_in = keep_policy_in

    @property
    def keep_policy_not(self):
        """Gets the keep_policy_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The keep_policy_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanKeepPolicy
        """
        return self._keep_policy_not

    @keep_policy_not.setter
    def keep_policy_not(self, keep_policy_not):
        """Sets the keep_policy_not of this ReplicationPlanWhereInput.


        :param keep_policy_not: The keep_policy_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type keep_policy_not: BackupPlanKeepPolicy
        """

        self._keep_policy_not = keep_policy_not

    @property
    def keep_policy_not_in(self):
        """Gets the keep_policy_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The keep_policy_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanKeepPolicy]
        """
        return self._keep_policy_not_in

    @keep_policy_not_in.setter
    def keep_policy_not_in(self, keep_policy_not_in):
        """Sets the keep_policy_not_in of this ReplicationPlanWhereInput.


        :param keep_policy_not_in: The keep_policy_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type keep_policy_not_in: list[BackupPlanKeepPolicy]
        """

        self._keep_policy_not_in = keep_policy_not_in

    @property
    def keep_policy_value(self):
        """Gets the keep_policy_value of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value

    @keep_policy_value.setter
    def keep_policy_value(self, keep_policy_value):
        """Sets the keep_policy_value of this ReplicationPlanWhereInput.


        :param keep_policy_value: The keep_policy_value of this ReplicationPlanWhereInput.  # noqa: E501
        :type keep_policy_value: int
        """

        self._keep_policy_value = keep_policy_value

    @property
    def keep_policy_value_gt(self):
        """Gets the keep_policy_value_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value_gt

    @keep_policy_value_gt.setter
    def keep_policy_value_gt(self, keep_policy_value_gt):
        """Sets the keep_policy_value_gt of this ReplicationPlanWhereInput.


        :param keep_policy_value_gt: The keep_policy_value_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type keep_policy_value_gt: int
        """

        self._keep_policy_value_gt = keep_policy_value_gt

    @property
    def keep_policy_value_gte(self):
        """Gets the keep_policy_value_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value_gte

    @keep_policy_value_gte.setter
    def keep_policy_value_gte(self, keep_policy_value_gte):
        """Sets the keep_policy_value_gte of this ReplicationPlanWhereInput.


        :param keep_policy_value_gte: The keep_policy_value_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type keep_policy_value_gte: int
        """

        self._keep_policy_value_gte = keep_policy_value_gte

    @property
    def keep_policy_value_in(self):
        """Gets the keep_policy_value_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._keep_policy_value_in

    @keep_policy_value_in.setter
    def keep_policy_value_in(self, keep_policy_value_in):
        """Sets the keep_policy_value_in of this ReplicationPlanWhereInput.


        :param keep_policy_value_in: The keep_policy_value_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type keep_policy_value_in: list[int]
        """

        self._keep_policy_value_in = keep_policy_value_in

    @property
    def keep_policy_value_lt(self):
        """Gets the keep_policy_value_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value_lt

    @keep_policy_value_lt.setter
    def keep_policy_value_lt(self, keep_policy_value_lt):
        """Sets the keep_policy_value_lt of this ReplicationPlanWhereInput.


        :param keep_policy_value_lt: The keep_policy_value_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type keep_policy_value_lt: int
        """

        self._keep_policy_value_lt = keep_policy_value_lt

    @property
    def keep_policy_value_lte(self):
        """Gets the keep_policy_value_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value_lte

    @keep_policy_value_lte.setter
    def keep_policy_value_lte(self, keep_policy_value_lte):
        """Sets the keep_policy_value_lte of this ReplicationPlanWhereInput.


        :param keep_policy_value_lte: The keep_policy_value_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type keep_policy_value_lte: int
        """

        self._keep_policy_value_lte = keep_policy_value_lte

    @property
    def keep_policy_value_not(self):
        """Gets the keep_policy_value_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value_not

    @keep_policy_value_not.setter
    def keep_policy_value_not(self, keep_policy_value_not):
        """Sets the keep_policy_value_not of this ReplicationPlanWhereInput.


        :param keep_policy_value_not: The keep_policy_value_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type keep_policy_value_not: int
        """

        self._keep_policy_value_not = keep_policy_value_not

    @property
    def keep_policy_value_not_in(self):
        """Gets the keep_policy_value_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._keep_policy_value_not_in

    @keep_policy_value_not_in.setter
    def keep_policy_value_not_in(self, keep_policy_value_not_in):
        """Sets the keep_policy_value_not_in of this ReplicationPlanWhereInput.


        :param keep_policy_value_not_in: The keep_policy_value_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type keep_policy_value_not_in: list[int]
        """

        self._keep_policy_value_not_in = keep_policy_value_not_in

    @property
    def last_execute_status(self):
        """Gets the last_execute_status of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._last_execute_status

    @last_execute_status.setter
    def last_execute_status(self, last_execute_status):
        """Sets the last_execute_status of this ReplicationPlanWhereInput.


        :param last_execute_status: The last_execute_status of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status: BackupPlanExecutionStatus
        """

        self._last_execute_status = last_execute_status

    @property
    def last_execute_status_in(self):
        """Gets the last_execute_status_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionStatus]
        """
        return self._last_execute_status_in

    @last_execute_status_in.setter
    def last_execute_status_in(self, last_execute_status_in):
        """Sets the last_execute_status_in of this ReplicationPlanWhereInput.


        :param last_execute_status_in: The last_execute_status_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_in: list[BackupPlanExecutionStatus]
        """

        self._last_execute_status_in = last_execute_status_in

    @property
    def last_execute_status_message(self):
        """Gets the last_execute_status_message of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message

    @last_execute_status_message.setter
    def last_execute_status_message(self, last_execute_status_message):
        """Sets the last_execute_status_message of this ReplicationPlanWhereInput.


        :param last_execute_status_message: The last_execute_status_message of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_message: str
        """

        self._last_execute_status_message = last_execute_status_message

    @property
    def last_execute_status_message_contains(self):
        """Gets the last_execute_status_message_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_contains

    @last_execute_status_message_contains.setter
    def last_execute_status_message_contains(self, last_execute_status_message_contains):
        """Sets the last_execute_status_message_contains of this ReplicationPlanWhereInput.


        :param last_execute_status_message_contains: The last_execute_status_message_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_contains: str
        """

        self._last_execute_status_message_contains = last_execute_status_message_contains

    @property
    def last_execute_status_message_ends_with(self):
        """Gets the last_execute_status_message_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_ends_with

    @last_execute_status_message_ends_with.setter
    def last_execute_status_message_ends_with(self, last_execute_status_message_ends_with):
        """Sets the last_execute_status_message_ends_with of this ReplicationPlanWhereInput.


        :param last_execute_status_message_ends_with: The last_execute_status_message_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_ends_with: str
        """

        self._last_execute_status_message_ends_with = last_execute_status_message_ends_with

    @property
    def last_execute_status_message_gt(self):
        """Gets the last_execute_status_message_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_gt

    @last_execute_status_message_gt.setter
    def last_execute_status_message_gt(self, last_execute_status_message_gt):
        """Sets the last_execute_status_message_gt of this ReplicationPlanWhereInput.


        :param last_execute_status_message_gt: The last_execute_status_message_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_gt: str
        """

        self._last_execute_status_message_gt = last_execute_status_message_gt

    @property
    def last_execute_status_message_gte(self):
        """Gets the last_execute_status_message_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_gte

    @last_execute_status_message_gte.setter
    def last_execute_status_message_gte(self, last_execute_status_message_gte):
        """Sets the last_execute_status_message_gte of this ReplicationPlanWhereInput.


        :param last_execute_status_message_gte: The last_execute_status_message_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_gte: str
        """

        self._last_execute_status_message_gte = last_execute_status_message_gte

    @property
    def last_execute_status_message_in(self):
        """Gets the last_execute_status_message_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_execute_status_message_in

    @last_execute_status_message_in.setter
    def last_execute_status_message_in(self, last_execute_status_message_in):
        """Sets the last_execute_status_message_in of this ReplicationPlanWhereInput.


        :param last_execute_status_message_in: The last_execute_status_message_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_in: list[str]
        """

        self._last_execute_status_message_in = last_execute_status_message_in

    @property
    def last_execute_status_message_lt(self):
        """Gets the last_execute_status_message_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_lt

    @last_execute_status_message_lt.setter
    def last_execute_status_message_lt(self, last_execute_status_message_lt):
        """Sets the last_execute_status_message_lt of this ReplicationPlanWhereInput.


        :param last_execute_status_message_lt: The last_execute_status_message_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_lt: str
        """

        self._last_execute_status_message_lt = last_execute_status_message_lt

    @property
    def last_execute_status_message_lte(self):
        """Gets the last_execute_status_message_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_lte

    @last_execute_status_message_lte.setter
    def last_execute_status_message_lte(self, last_execute_status_message_lte):
        """Sets the last_execute_status_message_lte of this ReplicationPlanWhereInput.


        :param last_execute_status_message_lte: The last_execute_status_message_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_lte: str
        """

        self._last_execute_status_message_lte = last_execute_status_message_lte

    @property
    def last_execute_status_message_not(self):
        """Gets the last_execute_status_message_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_not

    @last_execute_status_message_not.setter
    def last_execute_status_message_not(self, last_execute_status_message_not):
        """Sets the last_execute_status_message_not of this ReplicationPlanWhereInput.


        :param last_execute_status_message_not: The last_execute_status_message_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_not: str
        """

        self._last_execute_status_message_not = last_execute_status_message_not

    @property
    def last_execute_status_message_not_contains(self):
        """Gets the last_execute_status_message_not_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_not_contains

    @last_execute_status_message_not_contains.setter
    def last_execute_status_message_not_contains(self, last_execute_status_message_not_contains):
        """Sets the last_execute_status_message_not_contains of this ReplicationPlanWhereInput.


        :param last_execute_status_message_not_contains: The last_execute_status_message_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_not_contains: str
        """

        self._last_execute_status_message_not_contains = last_execute_status_message_not_contains

    @property
    def last_execute_status_message_not_ends_with(self):
        """Gets the last_execute_status_message_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_not_ends_with

    @last_execute_status_message_not_ends_with.setter
    def last_execute_status_message_not_ends_with(self, last_execute_status_message_not_ends_with):
        """Sets the last_execute_status_message_not_ends_with of this ReplicationPlanWhereInput.


        :param last_execute_status_message_not_ends_with: The last_execute_status_message_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_not_ends_with: str
        """

        self._last_execute_status_message_not_ends_with = last_execute_status_message_not_ends_with

    @property
    def last_execute_status_message_not_in(self):
        """Gets the last_execute_status_message_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_execute_status_message_not_in

    @last_execute_status_message_not_in.setter
    def last_execute_status_message_not_in(self, last_execute_status_message_not_in):
        """Sets the last_execute_status_message_not_in of this ReplicationPlanWhereInput.


        :param last_execute_status_message_not_in: The last_execute_status_message_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_not_in: list[str]
        """

        self._last_execute_status_message_not_in = last_execute_status_message_not_in

    @property
    def last_execute_status_message_not_starts_with(self):
        """Gets the last_execute_status_message_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_not_starts_with

    @last_execute_status_message_not_starts_with.setter
    def last_execute_status_message_not_starts_with(self, last_execute_status_message_not_starts_with):
        """Sets the last_execute_status_message_not_starts_with of this ReplicationPlanWhereInput.


        :param last_execute_status_message_not_starts_with: The last_execute_status_message_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_not_starts_with: str
        """

        self._last_execute_status_message_not_starts_with = last_execute_status_message_not_starts_with

    @property
    def last_execute_status_message_starts_with(self):
        """Gets the last_execute_status_message_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_starts_with

    @last_execute_status_message_starts_with.setter
    def last_execute_status_message_starts_with(self, last_execute_status_message_starts_with):
        """Sets the last_execute_status_message_starts_with of this ReplicationPlanWhereInput.


        :param last_execute_status_message_starts_with: The last_execute_status_message_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_starts_with: str
        """

        self._last_execute_status_message_starts_with = last_execute_status_message_starts_with

    @property
    def last_execute_status_not(self):
        """Gets the last_execute_status_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._last_execute_status_not

    @last_execute_status_not.setter
    def last_execute_status_not(self, last_execute_status_not):
        """Sets the last_execute_status_not of this ReplicationPlanWhereInput.


        :param last_execute_status_not: The last_execute_status_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_not: BackupPlanExecutionStatus
        """

        self._last_execute_status_not = last_execute_status_not

    @property
    def last_execute_status_not_in(self):
        """Gets the last_execute_status_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionStatus]
        """
        return self._last_execute_status_not_in

    @last_execute_status_not_in.setter
    def last_execute_status_not_in(self, last_execute_status_not_in):
        """Sets the last_execute_status_not_in of this ReplicationPlanWhereInput.


        :param last_execute_status_not_in: The last_execute_status_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_status_not_in: list[BackupPlanExecutionStatus]
        """

        self._last_execute_status_not_in = last_execute_status_not_in

    @property
    def last_execute_success_job_count(self):
        """Gets the last_execute_success_job_count of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_success_job_count

    @last_execute_success_job_count.setter
    def last_execute_success_job_count(self, last_execute_success_job_count):
        """Sets the last_execute_success_job_count of this ReplicationPlanWhereInput.


        :param last_execute_success_job_count: The last_execute_success_job_count of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count: int
        """

        self._last_execute_success_job_count = last_execute_success_job_count

    @property
    def last_execute_success_job_count_gt(self):
        """Gets the last_execute_success_job_count_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_success_job_count_gt

    @last_execute_success_job_count_gt.setter
    def last_execute_success_job_count_gt(self, last_execute_success_job_count_gt):
        """Sets the last_execute_success_job_count_gt of this ReplicationPlanWhereInput.


        :param last_execute_success_job_count_gt: The last_execute_success_job_count_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count_gt: int
        """

        self._last_execute_success_job_count_gt = last_execute_success_job_count_gt

    @property
    def last_execute_success_job_count_gte(self):
        """Gets the last_execute_success_job_count_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_success_job_count_gte

    @last_execute_success_job_count_gte.setter
    def last_execute_success_job_count_gte(self, last_execute_success_job_count_gte):
        """Sets the last_execute_success_job_count_gte of this ReplicationPlanWhereInput.


        :param last_execute_success_job_count_gte: The last_execute_success_job_count_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count_gte: int
        """

        self._last_execute_success_job_count_gte = last_execute_success_job_count_gte

    @property
    def last_execute_success_job_count_in(self):
        """Gets the last_execute_success_job_count_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_execute_success_job_count_in

    @last_execute_success_job_count_in.setter
    def last_execute_success_job_count_in(self, last_execute_success_job_count_in):
        """Sets the last_execute_success_job_count_in of this ReplicationPlanWhereInput.


        :param last_execute_success_job_count_in: The last_execute_success_job_count_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count_in: list[int]
        """

        self._last_execute_success_job_count_in = last_execute_success_job_count_in

    @property
    def last_execute_success_job_count_lt(self):
        """Gets the last_execute_success_job_count_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_success_job_count_lt

    @last_execute_success_job_count_lt.setter
    def last_execute_success_job_count_lt(self, last_execute_success_job_count_lt):
        """Sets the last_execute_success_job_count_lt of this ReplicationPlanWhereInput.


        :param last_execute_success_job_count_lt: The last_execute_success_job_count_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count_lt: int
        """

        self._last_execute_success_job_count_lt = last_execute_success_job_count_lt

    @property
    def last_execute_success_job_count_lte(self):
        """Gets the last_execute_success_job_count_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_success_job_count_lte

    @last_execute_success_job_count_lte.setter
    def last_execute_success_job_count_lte(self, last_execute_success_job_count_lte):
        """Sets the last_execute_success_job_count_lte of this ReplicationPlanWhereInput.


        :param last_execute_success_job_count_lte: The last_execute_success_job_count_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count_lte: int
        """

        self._last_execute_success_job_count_lte = last_execute_success_job_count_lte

    @property
    def last_execute_success_job_count_not(self):
        """Gets the last_execute_success_job_count_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_success_job_count_not

    @last_execute_success_job_count_not.setter
    def last_execute_success_job_count_not(self, last_execute_success_job_count_not):
        """Sets the last_execute_success_job_count_not of this ReplicationPlanWhereInput.


        :param last_execute_success_job_count_not: The last_execute_success_job_count_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count_not: int
        """

        self._last_execute_success_job_count_not = last_execute_success_job_count_not

    @property
    def last_execute_success_job_count_not_in(self):
        """Gets the last_execute_success_job_count_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_execute_success_job_count_not_in

    @last_execute_success_job_count_not_in.setter
    def last_execute_success_job_count_not_in(self, last_execute_success_job_count_not_in):
        """Sets the last_execute_success_job_count_not_in of this ReplicationPlanWhereInput.


        :param last_execute_success_job_count_not_in: The last_execute_success_job_count_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count_not_in: list[int]
        """

        self._last_execute_success_job_count_not_in = last_execute_success_job_count_not_in

    @property
    def last_execute_total_job_count(self):
        """Gets the last_execute_total_job_count of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_total_job_count

    @last_execute_total_job_count.setter
    def last_execute_total_job_count(self, last_execute_total_job_count):
        """Sets the last_execute_total_job_count of this ReplicationPlanWhereInput.


        :param last_execute_total_job_count: The last_execute_total_job_count of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count: int
        """

        self._last_execute_total_job_count = last_execute_total_job_count

    @property
    def last_execute_total_job_count_gt(self):
        """Gets the last_execute_total_job_count_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_total_job_count_gt

    @last_execute_total_job_count_gt.setter
    def last_execute_total_job_count_gt(self, last_execute_total_job_count_gt):
        """Sets the last_execute_total_job_count_gt of this ReplicationPlanWhereInput.


        :param last_execute_total_job_count_gt: The last_execute_total_job_count_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count_gt: int
        """

        self._last_execute_total_job_count_gt = last_execute_total_job_count_gt

    @property
    def last_execute_total_job_count_gte(self):
        """Gets the last_execute_total_job_count_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_total_job_count_gte

    @last_execute_total_job_count_gte.setter
    def last_execute_total_job_count_gte(self, last_execute_total_job_count_gte):
        """Sets the last_execute_total_job_count_gte of this ReplicationPlanWhereInput.


        :param last_execute_total_job_count_gte: The last_execute_total_job_count_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count_gte: int
        """

        self._last_execute_total_job_count_gte = last_execute_total_job_count_gte

    @property
    def last_execute_total_job_count_in(self):
        """Gets the last_execute_total_job_count_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_execute_total_job_count_in

    @last_execute_total_job_count_in.setter
    def last_execute_total_job_count_in(self, last_execute_total_job_count_in):
        """Sets the last_execute_total_job_count_in of this ReplicationPlanWhereInput.


        :param last_execute_total_job_count_in: The last_execute_total_job_count_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count_in: list[int]
        """

        self._last_execute_total_job_count_in = last_execute_total_job_count_in

    @property
    def last_execute_total_job_count_lt(self):
        """Gets the last_execute_total_job_count_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_total_job_count_lt

    @last_execute_total_job_count_lt.setter
    def last_execute_total_job_count_lt(self, last_execute_total_job_count_lt):
        """Sets the last_execute_total_job_count_lt of this ReplicationPlanWhereInput.


        :param last_execute_total_job_count_lt: The last_execute_total_job_count_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count_lt: int
        """

        self._last_execute_total_job_count_lt = last_execute_total_job_count_lt

    @property
    def last_execute_total_job_count_lte(self):
        """Gets the last_execute_total_job_count_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_total_job_count_lte

    @last_execute_total_job_count_lte.setter
    def last_execute_total_job_count_lte(self, last_execute_total_job_count_lte):
        """Sets the last_execute_total_job_count_lte of this ReplicationPlanWhereInput.


        :param last_execute_total_job_count_lte: The last_execute_total_job_count_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count_lte: int
        """

        self._last_execute_total_job_count_lte = last_execute_total_job_count_lte

    @property
    def last_execute_total_job_count_not(self):
        """Gets the last_execute_total_job_count_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_total_job_count_not

    @last_execute_total_job_count_not.setter
    def last_execute_total_job_count_not(self, last_execute_total_job_count_not):
        """Sets the last_execute_total_job_count_not of this ReplicationPlanWhereInput.


        :param last_execute_total_job_count_not: The last_execute_total_job_count_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count_not: int
        """

        self._last_execute_total_job_count_not = last_execute_total_job_count_not

    @property
    def last_execute_total_job_count_not_in(self):
        """Gets the last_execute_total_job_count_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_execute_total_job_count_not_in

    @last_execute_total_job_count_not_in.setter
    def last_execute_total_job_count_not_in(self, last_execute_total_job_count_not_in):
        """Sets the last_execute_total_job_count_not_in of this ReplicationPlanWhereInput.


        :param last_execute_total_job_count_not_in: The last_execute_total_job_count_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count_not_in: list[int]
        """

        self._last_execute_total_job_count_not_in = last_execute_total_job_count_not_in

    @property
    def last_executed_at(self):
        """Gets the last_executed_at of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_executed_at of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at

    @last_executed_at.setter
    def last_executed_at(self, last_executed_at):
        """Sets the last_executed_at of this ReplicationPlanWhereInput.


        :param last_executed_at: The last_executed_at of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_executed_at: str
        """

        self._last_executed_at = last_executed_at

    @property
    def last_executed_at_gt(self):
        """Gets the last_executed_at_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_executed_at_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_gt

    @last_executed_at_gt.setter
    def last_executed_at_gt(self, last_executed_at_gt):
        """Sets the last_executed_at_gt of this ReplicationPlanWhereInput.


        :param last_executed_at_gt: The last_executed_at_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_executed_at_gt: str
        """

        self._last_executed_at_gt = last_executed_at_gt

    @property
    def last_executed_at_gte(self):
        """Gets the last_executed_at_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_executed_at_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_gte

    @last_executed_at_gte.setter
    def last_executed_at_gte(self, last_executed_at_gte):
        """Sets the last_executed_at_gte of this ReplicationPlanWhereInput.


        :param last_executed_at_gte: The last_executed_at_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_executed_at_gte: str
        """

        self._last_executed_at_gte = last_executed_at_gte

    @property
    def last_executed_at_in(self):
        """Gets the last_executed_at_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_executed_at_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_executed_at_in

    @last_executed_at_in.setter
    def last_executed_at_in(self, last_executed_at_in):
        """Sets the last_executed_at_in of this ReplicationPlanWhereInput.


        :param last_executed_at_in: The last_executed_at_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_executed_at_in: list[str]
        """

        self._last_executed_at_in = last_executed_at_in

    @property
    def last_executed_at_lt(self):
        """Gets the last_executed_at_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_executed_at_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_lt

    @last_executed_at_lt.setter
    def last_executed_at_lt(self, last_executed_at_lt):
        """Sets the last_executed_at_lt of this ReplicationPlanWhereInput.


        :param last_executed_at_lt: The last_executed_at_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_executed_at_lt: str
        """

        self._last_executed_at_lt = last_executed_at_lt

    @property
    def last_executed_at_lte(self):
        """Gets the last_executed_at_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_executed_at_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_lte

    @last_executed_at_lte.setter
    def last_executed_at_lte(self, last_executed_at_lte):
        """Sets the last_executed_at_lte of this ReplicationPlanWhereInput.


        :param last_executed_at_lte: The last_executed_at_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_executed_at_lte: str
        """

        self._last_executed_at_lte = last_executed_at_lte

    @property
    def last_executed_at_not(self):
        """Gets the last_executed_at_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_executed_at_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_not

    @last_executed_at_not.setter
    def last_executed_at_not(self, last_executed_at_not):
        """Sets the last_executed_at_not of this ReplicationPlanWhereInput.


        :param last_executed_at_not: The last_executed_at_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_executed_at_not: str
        """

        self._last_executed_at_not = last_executed_at_not

    @property
    def last_executed_at_not_in(self):
        """Gets the last_executed_at_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_executed_at_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_executed_at_not_in

    @last_executed_at_not_in.setter
    def last_executed_at_not_in(self, last_executed_at_not_in):
        """Sets the last_executed_at_not_in of this ReplicationPlanWhereInput.


        :param last_executed_at_not_in: The last_executed_at_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_executed_at_not_in: list[str]
        """

        self._last_executed_at_not_in = last_executed_at_not_in

    @property
    def last_manual_execute_status(self):
        """Gets the last_manual_execute_status of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._last_manual_execute_status

    @last_manual_execute_status.setter
    def last_manual_execute_status(self, last_manual_execute_status):
        """Sets the last_manual_execute_status of this ReplicationPlanWhereInput.


        :param last_manual_execute_status: The last_manual_execute_status of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status: BackupPlanExecutionStatus
        """

        self._last_manual_execute_status = last_manual_execute_status

    @property
    def last_manual_execute_status_in(self):
        """Gets the last_manual_execute_status_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionStatus]
        """
        return self._last_manual_execute_status_in

    @last_manual_execute_status_in.setter
    def last_manual_execute_status_in(self, last_manual_execute_status_in):
        """Sets the last_manual_execute_status_in of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_in: The last_manual_execute_status_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_in: list[BackupPlanExecutionStatus]
        """

        self._last_manual_execute_status_in = last_manual_execute_status_in

    @property
    def last_manual_execute_status_message(self):
        """Gets the last_manual_execute_status_message of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message

    @last_manual_execute_status_message.setter
    def last_manual_execute_status_message(self, last_manual_execute_status_message):
        """Sets the last_manual_execute_status_message of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_message: The last_manual_execute_status_message of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message: str
        """

        self._last_manual_execute_status_message = last_manual_execute_status_message

    @property
    def last_manual_execute_status_message_contains(self):
        """Gets the last_manual_execute_status_message_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_contains

    @last_manual_execute_status_message_contains.setter
    def last_manual_execute_status_message_contains(self, last_manual_execute_status_message_contains):
        """Sets the last_manual_execute_status_message_contains of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_message_contains: The last_manual_execute_status_message_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_contains: str
        """

        self._last_manual_execute_status_message_contains = last_manual_execute_status_message_contains

    @property
    def last_manual_execute_status_message_ends_with(self):
        """Gets the last_manual_execute_status_message_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_ends_with

    @last_manual_execute_status_message_ends_with.setter
    def last_manual_execute_status_message_ends_with(self, last_manual_execute_status_message_ends_with):
        """Sets the last_manual_execute_status_message_ends_with of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_message_ends_with: The last_manual_execute_status_message_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_ends_with: str
        """

        self._last_manual_execute_status_message_ends_with = last_manual_execute_status_message_ends_with

    @property
    def last_manual_execute_status_message_gt(self):
        """Gets the last_manual_execute_status_message_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_gt

    @last_manual_execute_status_message_gt.setter
    def last_manual_execute_status_message_gt(self, last_manual_execute_status_message_gt):
        """Sets the last_manual_execute_status_message_gt of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_message_gt: The last_manual_execute_status_message_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_gt: str
        """

        self._last_manual_execute_status_message_gt = last_manual_execute_status_message_gt

    @property
    def last_manual_execute_status_message_gte(self):
        """Gets the last_manual_execute_status_message_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_gte

    @last_manual_execute_status_message_gte.setter
    def last_manual_execute_status_message_gte(self, last_manual_execute_status_message_gte):
        """Sets the last_manual_execute_status_message_gte of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_message_gte: The last_manual_execute_status_message_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_gte: str
        """

        self._last_manual_execute_status_message_gte = last_manual_execute_status_message_gte

    @property
    def last_manual_execute_status_message_in(self):
        """Gets the last_manual_execute_status_message_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_manual_execute_status_message_in

    @last_manual_execute_status_message_in.setter
    def last_manual_execute_status_message_in(self, last_manual_execute_status_message_in):
        """Sets the last_manual_execute_status_message_in of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_message_in: The last_manual_execute_status_message_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_in: list[str]
        """

        self._last_manual_execute_status_message_in = last_manual_execute_status_message_in

    @property
    def last_manual_execute_status_message_lt(self):
        """Gets the last_manual_execute_status_message_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_lt

    @last_manual_execute_status_message_lt.setter
    def last_manual_execute_status_message_lt(self, last_manual_execute_status_message_lt):
        """Sets the last_manual_execute_status_message_lt of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_message_lt: The last_manual_execute_status_message_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_lt: str
        """

        self._last_manual_execute_status_message_lt = last_manual_execute_status_message_lt

    @property
    def last_manual_execute_status_message_lte(self):
        """Gets the last_manual_execute_status_message_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_lte

    @last_manual_execute_status_message_lte.setter
    def last_manual_execute_status_message_lte(self, last_manual_execute_status_message_lte):
        """Sets the last_manual_execute_status_message_lte of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_message_lte: The last_manual_execute_status_message_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_lte: str
        """

        self._last_manual_execute_status_message_lte = last_manual_execute_status_message_lte

    @property
    def last_manual_execute_status_message_not(self):
        """Gets the last_manual_execute_status_message_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_not

    @last_manual_execute_status_message_not.setter
    def last_manual_execute_status_message_not(self, last_manual_execute_status_message_not):
        """Sets the last_manual_execute_status_message_not of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_message_not: The last_manual_execute_status_message_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_not: str
        """

        self._last_manual_execute_status_message_not = last_manual_execute_status_message_not

    @property
    def last_manual_execute_status_message_not_contains(self):
        """Gets the last_manual_execute_status_message_not_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_not_contains

    @last_manual_execute_status_message_not_contains.setter
    def last_manual_execute_status_message_not_contains(self, last_manual_execute_status_message_not_contains):
        """Sets the last_manual_execute_status_message_not_contains of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_message_not_contains: The last_manual_execute_status_message_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_not_contains: str
        """

        self._last_manual_execute_status_message_not_contains = last_manual_execute_status_message_not_contains

    @property
    def last_manual_execute_status_message_not_ends_with(self):
        """Gets the last_manual_execute_status_message_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_not_ends_with

    @last_manual_execute_status_message_not_ends_with.setter
    def last_manual_execute_status_message_not_ends_with(self, last_manual_execute_status_message_not_ends_with):
        """Sets the last_manual_execute_status_message_not_ends_with of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_message_not_ends_with: The last_manual_execute_status_message_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_not_ends_with: str
        """

        self._last_manual_execute_status_message_not_ends_with = last_manual_execute_status_message_not_ends_with

    @property
    def last_manual_execute_status_message_not_in(self):
        """Gets the last_manual_execute_status_message_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_manual_execute_status_message_not_in

    @last_manual_execute_status_message_not_in.setter
    def last_manual_execute_status_message_not_in(self, last_manual_execute_status_message_not_in):
        """Sets the last_manual_execute_status_message_not_in of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_message_not_in: The last_manual_execute_status_message_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_not_in: list[str]
        """

        self._last_manual_execute_status_message_not_in = last_manual_execute_status_message_not_in

    @property
    def last_manual_execute_status_message_not_starts_with(self):
        """Gets the last_manual_execute_status_message_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_not_starts_with

    @last_manual_execute_status_message_not_starts_with.setter
    def last_manual_execute_status_message_not_starts_with(self, last_manual_execute_status_message_not_starts_with):
        """Sets the last_manual_execute_status_message_not_starts_with of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_message_not_starts_with: The last_manual_execute_status_message_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_not_starts_with: str
        """

        self._last_manual_execute_status_message_not_starts_with = last_manual_execute_status_message_not_starts_with

    @property
    def last_manual_execute_status_message_starts_with(self):
        """Gets the last_manual_execute_status_message_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_starts_with

    @last_manual_execute_status_message_starts_with.setter
    def last_manual_execute_status_message_starts_with(self, last_manual_execute_status_message_starts_with):
        """Sets the last_manual_execute_status_message_starts_with of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_message_starts_with: The last_manual_execute_status_message_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_starts_with: str
        """

        self._last_manual_execute_status_message_starts_with = last_manual_execute_status_message_starts_with

    @property
    def last_manual_execute_status_not(self):
        """Gets the last_manual_execute_status_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._last_manual_execute_status_not

    @last_manual_execute_status_not.setter
    def last_manual_execute_status_not(self, last_manual_execute_status_not):
        """Sets the last_manual_execute_status_not of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_not: The last_manual_execute_status_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_not: BackupPlanExecutionStatus
        """

        self._last_manual_execute_status_not = last_manual_execute_status_not

    @property
    def last_manual_execute_status_not_in(self):
        """Gets the last_manual_execute_status_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionStatus]
        """
        return self._last_manual_execute_status_not_in

    @last_manual_execute_status_not_in.setter
    def last_manual_execute_status_not_in(self, last_manual_execute_status_not_in):
        """Sets the last_manual_execute_status_not_in of this ReplicationPlanWhereInput.


        :param last_manual_execute_status_not_in: The last_manual_execute_status_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_not_in: list[BackupPlanExecutionStatus]
        """

        self._last_manual_execute_status_not_in = last_manual_execute_status_not_in

    @property
    def last_manual_execute_success_job_count(self):
        """Gets the last_manual_execute_success_job_count of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_success_job_count

    @last_manual_execute_success_job_count.setter
    def last_manual_execute_success_job_count(self, last_manual_execute_success_job_count):
        """Sets the last_manual_execute_success_job_count of this ReplicationPlanWhereInput.


        :param last_manual_execute_success_job_count: The last_manual_execute_success_job_count of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count: int
        """

        self._last_manual_execute_success_job_count = last_manual_execute_success_job_count

    @property
    def last_manual_execute_success_job_count_gt(self):
        """Gets the last_manual_execute_success_job_count_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_success_job_count_gt

    @last_manual_execute_success_job_count_gt.setter
    def last_manual_execute_success_job_count_gt(self, last_manual_execute_success_job_count_gt):
        """Sets the last_manual_execute_success_job_count_gt of this ReplicationPlanWhereInput.


        :param last_manual_execute_success_job_count_gt: The last_manual_execute_success_job_count_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count_gt: int
        """

        self._last_manual_execute_success_job_count_gt = last_manual_execute_success_job_count_gt

    @property
    def last_manual_execute_success_job_count_gte(self):
        """Gets the last_manual_execute_success_job_count_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_success_job_count_gte

    @last_manual_execute_success_job_count_gte.setter
    def last_manual_execute_success_job_count_gte(self, last_manual_execute_success_job_count_gte):
        """Sets the last_manual_execute_success_job_count_gte of this ReplicationPlanWhereInput.


        :param last_manual_execute_success_job_count_gte: The last_manual_execute_success_job_count_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count_gte: int
        """

        self._last_manual_execute_success_job_count_gte = last_manual_execute_success_job_count_gte

    @property
    def last_manual_execute_success_job_count_in(self):
        """Gets the last_manual_execute_success_job_count_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_manual_execute_success_job_count_in

    @last_manual_execute_success_job_count_in.setter
    def last_manual_execute_success_job_count_in(self, last_manual_execute_success_job_count_in):
        """Sets the last_manual_execute_success_job_count_in of this ReplicationPlanWhereInput.


        :param last_manual_execute_success_job_count_in: The last_manual_execute_success_job_count_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count_in: list[int]
        """

        self._last_manual_execute_success_job_count_in = last_manual_execute_success_job_count_in

    @property
    def last_manual_execute_success_job_count_lt(self):
        """Gets the last_manual_execute_success_job_count_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_success_job_count_lt

    @last_manual_execute_success_job_count_lt.setter
    def last_manual_execute_success_job_count_lt(self, last_manual_execute_success_job_count_lt):
        """Sets the last_manual_execute_success_job_count_lt of this ReplicationPlanWhereInput.


        :param last_manual_execute_success_job_count_lt: The last_manual_execute_success_job_count_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count_lt: int
        """

        self._last_manual_execute_success_job_count_lt = last_manual_execute_success_job_count_lt

    @property
    def last_manual_execute_success_job_count_lte(self):
        """Gets the last_manual_execute_success_job_count_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_success_job_count_lte

    @last_manual_execute_success_job_count_lte.setter
    def last_manual_execute_success_job_count_lte(self, last_manual_execute_success_job_count_lte):
        """Sets the last_manual_execute_success_job_count_lte of this ReplicationPlanWhereInput.


        :param last_manual_execute_success_job_count_lte: The last_manual_execute_success_job_count_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count_lte: int
        """

        self._last_manual_execute_success_job_count_lte = last_manual_execute_success_job_count_lte

    @property
    def last_manual_execute_success_job_count_not(self):
        """Gets the last_manual_execute_success_job_count_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_success_job_count_not

    @last_manual_execute_success_job_count_not.setter
    def last_manual_execute_success_job_count_not(self, last_manual_execute_success_job_count_not):
        """Sets the last_manual_execute_success_job_count_not of this ReplicationPlanWhereInput.


        :param last_manual_execute_success_job_count_not: The last_manual_execute_success_job_count_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count_not: int
        """

        self._last_manual_execute_success_job_count_not = last_manual_execute_success_job_count_not

    @property
    def last_manual_execute_success_job_count_not_in(self):
        """Gets the last_manual_execute_success_job_count_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_manual_execute_success_job_count_not_in

    @last_manual_execute_success_job_count_not_in.setter
    def last_manual_execute_success_job_count_not_in(self, last_manual_execute_success_job_count_not_in):
        """Sets the last_manual_execute_success_job_count_not_in of this ReplicationPlanWhereInput.


        :param last_manual_execute_success_job_count_not_in: The last_manual_execute_success_job_count_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count_not_in: list[int]
        """

        self._last_manual_execute_success_job_count_not_in = last_manual_execute_success_job_count_not_in

    @property
    def last_manual_execute_total_job_count(self):
        """Gets the last_manual_execute_total_job_count of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_total_job_count

    @last_manual_execute_total_job_count.setter
    def last_manual_execute_total_job_count(self, last_manual_execute_total_job_count):
        """Sets the last_manual_execute_total_job_count of this ReplicationPlanWhereInput.


        :param last_manual_execute_total_job_count: The last_manual_execute_total_job_count of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count: int
        """

        self._last_manual_execute_total_job_count = last_manual_execute_total_job_count

    @property
    def last_manual_execute_total_job_count_gt(self):
        """Gets the last_manual_execute_total_job_count_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_total_job_count_gt

    @last_manual_execute_total_job_count_gt.setter
    def last_manual_execute_total_job_count_gt(self, last_manual_execute_total_job_count_gt):
        """Sets the last_manual_execute_total_job_count_gt of this ReplicationPlanWhereInput.


        :param last_manual_execute_total_job_count_gt: The last_manual_execute_total_job_count_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count_gt: int
        """

        self._last_manual_execute_total_job_count_gt = last_manual_execute_total_job_count_gt

    @property
    def last_manual_execute_total_job_count_gte(self):
        """Gets the last_manual_execute_total_job_count_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_total_job_count_gte

    @last_manual_execute_total_job_count_gte.setter
    def last_manual_execute_total_job_count_gte(self, last_manual_execute_total_job_count_gte):
        """Sets the last_manual_execute_total_job_count_gte of this ReplicationPlanWhereInput.


        :param last_manual_execute_total_job_count_gte: The last_manual_execute_total_job_count_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count_gte: int
        """

        self._last_manual_execute_total_job_count_gte = last_manual_execute_total_job_count_gte

    @property
    def last_manual_execute_total_job_count_in(self):
        """Gets the last_manual_execute_total_job_count_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_manual_execute_total_job_count_in

    @last_manual_execute_total_job_count_in.setter
    def last_manual_execute_total_job_count_in(self, last_manual_execute_total_job_count_in):
        """Sets the last_manual_execute_total_job_count_in of this ReplicationPlanWhereInput.


        :param last_manual_execute_total_job_count_in: The last_manual_execute_total_job_count_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count_in: list[int]
        """

        self._last_manual_execute_total_job_count_in = last_manual_execute_total_job_count_in

    @property
    def last_manual_execute_total_job_count_lt(self):
        """Gets the last_manual_execute_total_job_count_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_total_job_count_lt

    @last_manual_execute_total_job_count_lt.setter
    def last_manual_execute_total_job_count_lt(self, last_manual_execute_total_job_count_lt):
        """Sets the last_manual_execute_total_job_count_lt of this ReplicationPlanWhereInput.


        :param last_manual_execute_total_job_count_lt: The last_manual_execute_total_job_count_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count_lt: int
        """

        self._last_manual_execute_total_job_count_lt = last_manual_execute_total_job_count_lt

    @property
    def last_manual_execute_total_job_count_lte(self):
        """Gets the last_manual_execute_total_job_count_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_total_job_count_lte

    @last_manual_execute_total_job_count_lte.setter
    def last_manual_execute_total_job_count_lte(self, last_manual_execute_total_job_count_lte):
        """Sets the last_manual_execute_total_job_count_lte of this ReplicationPlanWhereInput.


        :param last_manual_execute_total_job_count_lte: The last_manual_execute_total_job_count_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count_lte: int
        """

        self._last_manual_execute_total_job_count_lte = last_manual_execute_total_job_count_lte

    @property
    def last_manual_execute_total_job_count_not(self):
        """Gets the last_manual_execute_total_job_count_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_total_job_count_not

    @last_manual_execute_total_job_count_not.setter
    def last_manual_execute_total_job_count_not(self, last_manual_execute_total_job_count_not):
        """Sets the last_manual_execute_total_job_count_not of this ReplicationPlanWhereInput.


        :param last_manual_execute_total_job_count_not: The last_manual_execute_total_job_count_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count_not: int
        """

        self._last_manual_execute_total_job_count_not = last_manual_execute_total_job_count_not

    @property
    def last_manual_execute_total_job_count_not_in(self):
        """Gets the last_manual_execute_total_job_count_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_manual_execute_total_job_count_not_in

    @last_manual_execute_total_job_count_not_in.setter
    def last_manual_execute_total_job_count_not_in(self, last_manual_execute_total_job_count_not_in):
        """Sets the last_manual_execute_total_job_count_not_in of this ReplicationPlanWhereInput.


        :param last_manual_execute_total_job_count_not_in: The last_manual_execute_total_job_count_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count_not_in: list[int]
        """

        self._last_manual_execute_total_job_count_not_in = last_manual_execute_total_job_count_not_in

    @property
    def last_manual_executed_at(self):
        """Gets the last_manual_executed_at of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_executed_at

    @last_manual_executed_at.setter
    def last_manual_executed_at(self, last_manual_executed_at):
        """Sets the last_manual_executed_at of this ReplicationPlanWhereInput.


        :param last_manual_executed_at: The last_manual_executed_at of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at: str
        """

        self._last_manual_executed_at = last_manual_executed_at

    @property
    def last_manual_executed_at_gt(self):
        """Gets the last_manual_executed_at_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_executed_at_gt

    @last_manual_executed_at_gt.setter
    def last_manual_executed_at_gt(self, last_manual_executed_at_gt):
        """Sets the last_manual_executed_at_gt of this ReplicationPlanWhereInput.


        :param last_manual_executed_at_gt: The last_manual_executed_at_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at_gt: str
        """

        self._last_manual_executed_at_gt = last_manual_executed_at_gt

    @property
    def last_manual_executed_at_gte(self):
        """Gets the last_manual_executed_at_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_executed_at_gte

    @last_manual_executed_at_gte.setter
    def last_manual_executed_at_gte(self, last_manual_executed_at_gte):
        """Sets the last_manual_executed_at_gte of this ReplicationPlanWhereInput.


        :param last_manual_executed_at_gte: The last_manual_executed_at_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at_gte: str
        """

        self._last_manual_executed_at_gte = last_manual_executed_at_gte

    @property
    def last_manual_executed_at_in(self):
        """Gets the last_manual_executed_at_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_manual_executed_at_in

    @last_manual_executed_at_in.setter
    def last_manual_executed_at_in(self, last_manual_executed_at_in):
        """Sets the last_manual_executed_at_in of this ReplicationPlanWhereInput.


        :param last_manual_executed_at_in: The last_manual_executed_at_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at_in: list[str]
        """

        self._last_manual_executed_at_in = last_manual_executed_at_in

    @property
    def last_manual_executed_at_lt(self):
        """Gets the last_manual_executed_at_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_executed_at_lt

    @last_manual_executed_at_lt.setter
    def last_manual_executed_at_lt(self, last_manual_executed_at_lt):
        """Sets the last_manual_executed_at_lt of this ReplicationPlanWhereInput.


        :param last_manual_executed_at_lt: The last_manual_executed_at_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at_lt: str
        """

        self._last_manual_executed_at_lt = last_manual_executed_at_lt

    @property
    def last_manual_executed_at_lte(self):
        """Gets the last_manual_executed_at_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_executed_at_lte

    @last_manual_executed_at_lte.setter
    def last_manual_executed_at_lte(self, last_manual_executed_at_lte):
        """Sets the last_manual_executed_at_lte of this ReplicationPlanWhereInput.


        :param last_manual_executed_at_lte: The last_manual_executed_at_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at_lte: str
        """

        self._last_manual_executed_at_lte = last_manual_executed_at_lte

    @property
    def last_manual_executed_at_not(self):
        """Gets the last_manual_executed_at_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_executed_at_not

    @last_manual_executed_at_not.setter
    def last_manual_executed_at_not(self, last_manual_executed_at_not):
        """Sets the last_manual_executed_at_not of this ReplicationPlanWhereInput.


        :param last_manual_executed_at_not: The last_manual_executed_at_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at_not: str
        """

        self._last_manual_executed_at_not = last_manual_executed_at_not

    @property
    def last_manual_executed_at_not_in(self):
        """Gets the last_manual_executed_at_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_manual_executed_at_not_in

    @last_manual_executed_at_not_in.setter
    def last_manual_executed_at_not_in(self, last_manual_executed_at_not_in):
        """Sets the last_manual_executed_at_not_in of this ReplicationPlanWhereInput.


        :param last_manual_executed_at_not_in: The last_manual_executed_at_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at_not_in: list[str]
        """

        self._last_manual_executed_at_not_in = last_manual_executed_at_not_in

    @property
    def name(self):
        """Gets the name of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The name of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ReplicationPlanWhereInput.


        :param name: The name of this ReplicationPlanWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The name_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this ReplicationPlanWhereInput.


        :param name_contains: The name_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The name_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this ReplicationPlanWhereInput.


        :param name_ends_with: The name_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The name_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this ReplicationPlanWhereInput.


        :param name_gt: The name_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The name_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this ReplicationPlanWhereInput.


        :param name_gte: The name_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The name_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this ReplicationPlanWhereInput.


        :param name_in: The name_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The name_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this ReplicationPlanWhereInput.


        :param name_lt: The name_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The name_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this ReplicationPlanWhereInput.


        :param name_lte: The name_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The name_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this ReplicationPlanWhereInput.


        :param name_not: The name_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The name_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this ReplicationPlanWhereInput.


        :param name_not_contains: The name_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this ReplicationPlanWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The name_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this ReplicationPlanWhereInput.


        :param name_not_in: The name_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this ReplicationPlanWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The name_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this ReplicationPlanWhereInput.


        :param name_starts_with: The name_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def next_execution_time(self):
        """Gets the next_execution_time of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The next_execution_time of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._next_execution_time

    @next_execution_time.setter
    def next_execution_time(self, next_execution_time):
        """Sets the next_execution_time of this ReplicationPlanWhereInput.


        :param next_execution_time: The next_execution_time of this ReplicationPlanWhereInput.  # noqa: E501
        :type next_execution_time: str
        """

        self._next_execution_time = next_execution_time

    @property
    def next_execution_time_gt(self):
        """Gets the next_execution_time_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The next_execution_time_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._next_execution_time_gt

    @next_execution_time_gt.setter
    def next_execution_time_gt(self, next_execution_time_gt):
        """Sets the next_execution_time_gt of this ReplicationPlanWhereInput.


        :param next_execution_time_gt: The next_execution_time_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type next_execution_time_gt: str
        """

        self._next_execution_time_gt = next_execution_time_gt

    @property
    def next_execution_time_gte(self):
        """Gets the next_execution_time_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The next_execution_time_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._next_execution_time_gte

    @next_execution_time_gte.setter
    def next_execution_time_gte(self, next_execution_time_gte):
        """Sets the next_execution_time_gte of this ReplicationPlanWhereInput.


        :param next_execution_time_gte: The next_execution_time_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type next_execution_time_gte: str
        """

        self._next_execution_time_gte = next_execution_time_gte

    @property
    def next_execution_time_in(self):
        """Gets the next_execution_time_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The next_execution_time_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._next_execution_time_in

    @next_execution_time_in.setter
    def next_execution_time_in(self, next_execution_time_in):
        """Sets the next_execution_time_in of this ReplicationPlanWhereInput.


        :param next_execution_time_in: The next_execution_time_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type next_execution_time_in: list[str]
        """

        self._next_execution_time_in = next_execution_time_in

    @property
    def next_execution_time_lt(self):
        """Gets the next_execution_time_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The next_execution_time_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._next_execution_time_lt

    @next_execution_time_lt.setter
    def next_execution_time_lt(self, next_execution_time_lt):
        """Sets the next_execution_time_lt of this ReplicationPlanWhereInput.


        :param next_execution_time_lt: The next_execution_time_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type next_execution_time_lt: str
        """

        self._next_execution_time_lt = next_execution_time_lt

    @property
    def next_execution_time_lte(self):
        """Gets the next_execution_time_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The next_execution_time_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._next_execution_time_lte

    @next_execution_time_lte.setter
    def next_execution_time_lte(self, next_execution_time_lte):
        """Sets the next_execution_time_lte of this ReplicationPlanWhereInput.


        :param next_execution_time_lte: The next_execution_time_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type next_execution_time_lte: str
        """

        self._next_execution_time_lte = next_execution_time_lte

    @property
    def next_execution_time_not(self):
        """Gets the next_execution_time_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The next_execution_time_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._next_execution_time_not

    @next_execution_time_not.setter
    def next_execution_time_not(self, next_execution_time_not):
        """Sets the next_execution_time_not of this ReplicationPlanWhereInput.


        :param next_execution_time_not: The next_execution_time_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type next_execution_time_not: str
        """

        self._next_execution_time_not = next_execution_time_not

    @property
    def next_execution_time_not_in(self):
        """Gets the next_execution_time_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The next_execution_time_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._next_execution_time_not_in

    @next_execution_time_not_in.setter
    def next_execution_time_not_in(self, next_execution_time_not_in):
        """Sets the next_execution_time_not_in of this ReplicationPlanWhereInput.


        :param next_execution_time_not_in: The next_execution_time_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type next_execution_time_not_in: list[str]
        """

        self._next_execution_time_not_in = next_execution_time_not_in

    @property
    def period(self):
        """Gets the period of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The period of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicationPlanPeriod
        """
        return self._period

    @period.setter
    def period(self, period):
        """Sets the period of this ReplicationPlanWhereInput.


        :param period: The period of this ReplicationPlanWhereInput.  # noqa: E501
        :type period: ReplicationPlanPeriod
        """

        self._period = period

    @property
    def period_in(self):
        """Gets the period_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The period_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[ReplicationPlanPeriod]
        """
        return self._period_in

    @period_in.setter
    def period_in(self, period_in):
        """Sets the period_in of this ReplicationPlanWhereInput.


        :param period_in: The period_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type period_in: list[ReplicationPlanPeriod]
        """

        self._period_in = period_in

    @property
    def period_not(self):
        """Gets the period_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The period_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicationPlanPeriod
        """
        return self._period_not

    @period_not.setter
    def period_not(self, period_not):
        """Sets the period_not of this ReplicationPlanWhereInput.


        :param period_not: The period_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type period_not: ReplicationPlanPeriod
        """

        self._period_not = period_not

    @property
    def period_not_in(self):
        """Gets the period_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The period_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[ReplicationPlanPeriod]
        """
        return self._period_not_in

    @period_not_in.setter
    def period_not_in(self, period_not_in):
        """Sets the period_not_in of this ReplicationPlanWhereInput.


        :param period_not_in: The period_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type period_not_in: list[ReplicationPlanPeriod]
        """

        self._period_not_in = period_not_in

    @property
    def phase(self):
        """Gets the phase of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The phase of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanPhase
        """
        return self._phase

    @phase.setter
    def phase(self, phase):
        """Sets the phase of this ReplicationPlanWhereInput.


        :param phase: The phase of this ReplicationPlanWhereInput.  # noqa: E501
        :type phase: BackupPlanPhase
        """

        self._phase = phase

    @property
    def phase_in(self):
        """Gets the phase_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The phase_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanPhase]
        """
        return self._phase_in

    @phase_in.setter
    def phase_in(self, phase_in):
        """Sets the phase_in of this ReplicationPlanWhereInput.


        :param phase_in: The phase_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type phase_in: list[BackupPlanPhase]
        """

        self._phase_in = phase_in

    @property
    def phase_not(self):
        """Gets the phase_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The phase_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanPhase
        """
        return self._phase_not

    @phase_not.setter
    def phase_not(self, phase_not):
        """Sets the phase_not of this ReplicationPlanWhereInput.


        :param phase_not: The phase_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type phase_not: BackupPlanPhase
        """

        self._phase_not = phase_not

    @property
    def phase_not_in(self):
        """Gets the phase_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The phase_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanPhase]
        """
        return self._phase_not_in

    @phase_not_in.setter
    def phase_not_in(self, phase_not_in):
        """Sets the phase_not_in of this ReplicationPlanWhereInput.


        :param phase_not_in: The phase_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type phase_not_in: list[BackupPlanPhase]
        """

        self._phase_not_in = phase_not_in

    @property
    def replica_name_rule(self):
        """Gets the replica_name_rule of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_rule of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicaNameRule
        """
        return self._replica_name_rule

    @replica_name_rule.setter
    def replica_name_rule(self, replica_name_rule):
        """Sets the replica_name_rule of this ReplicationPlanWhereInput.


        :param replica_name_rule: The replica_name_rule of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_rule: ReplicaNameRule
        """

        self._replica_name_rule = replica_name_rule

    @property
    def replica_name_rule_in(self):
        """Gets the replica_name_rule_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_rule_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[ReplicaNameRule]
        """
        return self._replica_name_rule_in

    @replica_name_rule_in.setter
    def replica_name_rule_in(self, replica_name_rule_in):
        """Sets the replica_name_rule_in of this ReplicationPlanWhereInput.


        :param replica_name_rule_in: The replica_name_rule_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_rule_in: list[ReplicaNameRule]
        """

        self._replica_name_rule_in = replica_name_rule_in

    @property
    def replica_name_rule_not(self):
        """Gets the replica_name_rule_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_rule_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicaNameRule
        """
        return self._replica_name_rule_not

    @replica_name_rule_not.setter
    def replica_name_rule_not(self, replica_name_rule_not):
        """Sets the replica_name_rule_not of this ReplicationPlanWhereInput.


        :param replica_name_rule_not: The replica_name_rule_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_rule_not: ReplicaNameRule
        """

        self._replica_name_rule_not = replica_name_rule_not

    @property
    def replica_name_rule_not_in(self):
        """Gets the replica_name_rule_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_rule_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[ReplicaNameRule]
        """
        return self._replica_name_rule_not_in

    @replica_name_rule_not_in.setter
    def replica_name_rule_not_in(self, replica_name_rule_not_in):
        """Sets the replica_name_rule_not_in of this ReplicationPlanWhereInput.


        :param replica_name_rule_not_in: The replica_name_rule_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_rule_not_in: list[ReplicaNameRule]
        """

        self._replica_name_rule_not_in = replica_name_rule_not_in

    @property
    def replica_name_setting(self):
        """Gets the replica_name_setting of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_setting of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._replica_name_setting

    @replica_name_setting.setter
    def replica_name_setting(self, replica_name_setting):
        """Sets the replica_name_setting of this ReplicationPlanWhereInput.


        :param replica_name_setting: The replica_name_setting of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_setting: str
        """

        self._replica_name_setting = replica_name_setting

    @property
    def replica_name_setting_contains(self):
        """Gets the replica_name_setting_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_setting_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._replica_name_setting_contains

    @replica_name_setting_contains.setter
    def replica_name_setting_contains(self, replica_name_setting_contains):
        """Sets the replica_name_setting_contains of this ReplicationPlanWhereInput.


        :param replica_name_setting_contains: The replica_name_setting_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_setting_contains: str
        """

        self._replica_name_setting_contains = replica_name_setting_contains

    @property
    def replica_name_setting_ends_with(self):
        """Gets the replica_name_setting_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_setting_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._replica_name_setting_ends_with

    @replica_name_setting_ends_with.setter
    def replica_name_setting_ends_with(self, replica_name_setting_ends_with):
        """Sets the replica_name_setting_ends_with of this ReplicationPlanWhereInput.


        :param replica_name_setting_ends_with: The replica_name_setting_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_setting_ends_with: str
        """

        self._replica_name_setting_ends_with = replica_name_setting_ends_with

    @property
    def replica_name_setting_gt(self):
        """Gets the replica_name_setting_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_setting_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._replica_name_setting_gt

    @replica_name_setting_gt.setter
    def replica_name_setting_gt(self, replica_name_setting_gt):
        """Sets the replica_name_setting_gt of this ReplicationPlanWhereInput.


        :param replica_name_setting_gt: The replica_name_setting_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_setting_gt: str
        """

        self._replica_name_setting_gt = replica_name_setting_gt

    @property
    def replica_name_setting_gte(self):
        """Gets the replica_name_setting_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_setting_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._replica_name_setting_gte

    @replica_name_setting_gte.setter
    def replica_name_setting_gte(self, replica_name_setting_gte):
        """Sets the replica_name_setting_gte of this ReplicationPlanWhereInput.


        :param replica_name_setting_gte: The replica_name_setting_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_setting_gte: str
        """

        self._replica_name_setting_gte = replica_name_setting_gte

    @property
    def replica_name_setting_in(self):
        """Gets the replica_name_setting_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_setting_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._replica_name_setting_in

    @replica_name_setting_in.setter
    def replica_name_setting_in(self, replica_name_setting_in):
        """Sets the replica_name_setting_in of this ReplicationPlanWhereInput.


        :param replica_name_setting_in: The replica_name_setting_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_setting_in: list[str]
        """

        self._replica_name_setting_in = replica_name_setting_in

    @property
    def replica_name_setting_lt(self):
        """Gets the replica_name_setting_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_setting_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._replica_name_setting_lt

    @replica_name_setting_lt.setter
    def replica_name_setting_lt(self, replica_name_setting_lt):
        """Sets the replica_name_setting_lt of this ReplicationPlanWhereInput.


        :param replica_name_setting_lt: The replica_name_setting_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_setting_lt: str
        """

        self._replica_name_setting_lt = replica_name_setting_lt

    @property
    def replica_name_setting_lte(self):
        """Gets the replica_name_setting_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_setting_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._replica_name_setting_lte

    @replica_name_setting_lte.setter
    def replica_name_setting_lte(self, replica_name_setting_lte):
        """Sets the replica_name_setting_lte of this ReplicationPlanWhereInput.


        :param replica_name_setting_lte: The replica_name_setting_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_setting_lte: str
        """

        self._replica_name_setting_lte = replica_name_setting_lte

    @property
    def replica_name_setting_not(self):
        """Gets the replica_name_setting_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_setting_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._replica_name_setting_not

    @replica_name_setting_not.setter
    def replica_name_setting_not(self, replica_name_setting_not):
        """Sets the replica_name_setting_not of this ReplicationPlanWhereInput.


        :param replica_name_setting_not: The replica_name_setting_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_setting_not: str
        """

        self._replica_name_setting_not = replica_name_setting_not

    @property
    def replica_name_setting_not_contains(self):
        """Gets the replica_name_setting_not_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_setting_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._replica_name_setting_not_contains

    @replica_name_setting_not_contains.setter
    def replica_name_setting_not_contains(self, replica_name_setting_not_contains):
        """Sets the replica_name_setting_not_contains of this ReplicationPlanWhereInput.


        :param replica_name_setting_not_contains: The replica_name_setting_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_setting_not_contains: str
        """

        self._replica_name_setting_not_contains = replica_name_setting_not_contains

    @property
    def replica_name_setting_not_ends_with(self):
        """Gets the replica_name_setting_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_setting_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._replica_name_setting_not_ends_with

    @replica_name_setting_not_ends_with.setter
    def replica_name_setting_not_ends_with(self, replica_name_setting_not_ends_with):
        """Sets the replica_name_setting_not_ends_with of this ReplicationPlanWhereInput.


        :param replica_name_setting_not_ends_with: The replica_name_setting_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_setting_not_ends_with: str
        """

        self._replica_name_setting_not_ends_with = replica_name_setting_not_ends_with

    @property
    def replica_name_setting_not_in(self):
        """Gets the replica_name_setting_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_setting_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._replica_name_setting_not_in

    @replica_name_setting_not_in.setter
    def replica_name_setting_not_in(self, replica_name_setting_not_in):
        """Sets the replica_name_setting_not_in of this ReplicationPlanWhereInput.


        :param replica_name_setting_not_in: The replica_name_setting_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_setting_not_in: list[str]
        """

        self._replica_name_setting_not_in = replica_name_setting_not_in

    @property
    def replica_name_setting_not_starts_with(self):
        """Gets the replica_name_setting_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_setting_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._replica_name_setting_not_starts_with

    @replica_name_setting_not_starts_with.setter
    def replica_name_setting_not_starts_with(self, replica_name_setting_not_starts_with):
        """Sets the replica_name_setting_not_starts_with of this ReplicationPlanWhereInput.


        :param replica_name_setting_not_starts_with: The replica_name_setting_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_setting_not_starts_with: str
        """

        self._replica_name_setting_not_starts_with = replica_name_setting_not_starts_with

    @property
    def replica_name_setting_starts_with(self):
        """Gets the replica_name_setting_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_name_setting_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._replica_name_setting_starts_with

    @replica_name_setting_starts_with.setter
    def replica_name_setting_starts_with(self, replica_name_setting_starts_with):
        """Sets the replica_name_setting_starts_with of this ReplicationPlanWhereInput.


        :param replica_name_setting_starts_with: The replica_name_setting_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_name_setting_starts_with: str
        """

        self._replica_name_setting_starts_with = replica_name_setting_starts_with

    @property
    def replica_num(self):
        """Gets the replica_num of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_num of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._replica_num

    @replica_num.setter
    def replica_num(self, replica_num):
        """Sets the replica_num of this ReplicationPlanWhereInput.


        :param replica_num: The replica_num of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_num: int
        """

        self._replica_num = replica_num

    @property
    def replica_num_gt(self):
        """Gets the replica_num_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_num_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._replica_num_gt

    @replica_num_gt.setter
    def replica_num_gt(self, replica_num_gt):
        """Sets the replica_num_gt of this ReplicationPlanWhereInput.


        :param replica_num_gt: The replica_num_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_num_gt: int
        """

        self._replica_num_gt = replica_num_gt

    @property
    def replica_num_gte(self):
        """Gets the replica_num_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_num_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._replica_num_gte

    @replica_num_gte.setter
    def replica_num_gte(self, replica_num_gte):
        """Sets the replica_num_gte of this ReplicationPlanWhereInput.


        :param replica_num_gte: The replica_num_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_num_gte: int
        """

        self._replica_num_gte = replica_num_gte

    @property
    def replica_num_in(self):
        """Gets the replica_num_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_num_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._replica_num_in

    @replica_num_in.setter
    def replica_num_in(self, replica_num_in):
        """Sets the replica_num_in of this ReplicationPlanWhereInput.


        :param replica_num_in: The replica_num_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_num_in: list[int]
        """

        self._replica_num_in = replica_num_in

    @property
    def replica_num_lt(self):
        """Gets the replica_num_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_num_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._replica_num_lt

    @replica_num_lt.setter
    def replica_num_lt(self, replica_num_lt):
        """Sets the replica_num_lt of this ReplicationPlanWhereInput.


        :param replica_num_lt: The replica_num_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_num_lt: int
        """

        self._replica_num_lt = replica_num_lt

    @property
    def replica_num_lte(self):
        """Gets the replica_num_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_num_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._replica_num_lte

    @replica_num_lte.setter
    def replica_num_lte(self, replica_num_lte):
        """Sets the replica_num_lte of this ReplicationPlanWhereInput.


        :param replica_num_lte: The replica_num_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_num_lte: int
        """

        self._replica_num_lte = replica_num_lte

    @property
    def replica_num_not(self):
        """Gets the replica_num_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_num_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._replica_num_not

    @replica_num_not.setter
    def replica_num_not(self, replica_num_not):
        """Sets the replica_num_not of this ReplicationPlanWhereInput.


        :param replica_num_not: The replica_num_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_num_not: int
        """

        self._replica_num_not = replica_num_not

    @property
    def replica_num_not_in(self):
        """Gets the replica_num_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_num_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._replica_num_not_in

    @replica_num_not_in.setter
    def replica_num_not_in(self, replica_num_not_in):
        """Sets the replica_num_not_in of this ReplicationPlanWhereInput.


        :param replica_num_not_in: The replica_num_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_num_not_in: list[int]
        """

        self._replica_num_not_in = replica_num_not_in

    @property
    def replica_vms_every(self):
        """Gets the replica_vms_every of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_vms_every of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicaVmWhereInput
        """
        return self._replica_vms_every

    @replica_vms_every.setter
    def replica_vms_every(self, replica_vms_every):
        """Sets the replica_vms_every of this ReplicationPlanWhereInput.


        :param replica_vms_every: The replica_vms_every of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_vms_every: ReplicaVmWhereInput
        """

        self._replica_vms_every = replica_vms_every

    @property
    def replica_vms_none(self):
        """Gets the replica_vms_none of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_vms_none of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicaVmWhereInput
        """
        return self._replica_vms_none

    @replica_vms_none.setter
    def replica_vms_none(self, replica_vms_none):
        """Sets the replica_vms_none of this ReplicationPlanWhereInput.


        :param replica_vms_none: The replica_vms_none of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_vms_none: ReplicaVmWhereInput
        """

        self._replica_vms_none = replica_vms_none

    @property
    def replica_vms_some(self):
        """Gets the replica_vms_some of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replica_vms_some of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicaVmWhereInput
        """
        return self._replica_vms_some

    @replica_vms_some.setter
    def replica_vms_some(self, replica_vms_some):
        """Sets the replica_vms_some of this ReplicationPlanWhereInput.


        :param replica_vms_some: The replica_vms_some of this ReplicationPlanWhereInput.  # noqa: E501
        :type replica_vms_some: ReplicaVmWhereInput
        """

        self._replica_vms_some = replica_vms_some

    @property
    def replication_plan_executions_every(self):
        """Gets the replication_plan_executions_every of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replication_plan_executions_every of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicationPlanExecutionWhereInput
        """
        return self._replication_plan_executions_every

    @replication_plan_executions_every.setter
    def replication_plan_executions_every(self, replication_plan_executions_every):
        """Sets the replication_plan_executions_every of this ReplicationPlanWhereInput.


        :param replication_plan_executions_every: The replication_plan_executions_every of this ReplicationPlanWhereInput.  # noqa: E501
        :type replication_plan_executions_every: ReplicationPlanExecutionWhereInput
        """

        self._replication_plan_executions_every = replication_plan_executions_every

    @property
    def replication_plan_executions_none(self):
        """Gets the replication_plan_executions_none of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replication_plan_executions_none of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicationPlanExecutionWhereInput
        """
        return self._replication_plan_executions_none

    @replication_plan_executions_none.setter
    def replication_plan_executions_none(self, replication_plan_executions_none):
        """Sets the replication_plan_executions_none of this ReplicationPlanWhereInput.


        :param replication_plan_executions_none: The replication_plan_executions_none of this ReplicationPlanWhereInput.  # noqa: E501
        :type replication_plan_executions_none: ReplicationPlanExecutionWhereInput
        """

        self._replication_plan_executions_none = replication_plan_executions_none

    @property
    def replication_plan_executions_some(self):
        """Gets the replication_plan_executions_some of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replication_plan_executions_some of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicationPlanExecutionWhereInput
        """
        return self._replication_plan_executions_some

    @replication_plan_executions_some.setter
    def replication_plan_executions_some(self, replication_plan_executions_some):
        """Sets the replication_plan_executions_some of this ReplicationPlanWhereInput.


        :param replication_plan_executions_some: The replication_plan_executions_some of this ReplicationPlanWhereInput.  # noqa: E501
        :type replication_plan_executions_some: ReplicationPlanExecutionWhereInput
        """

        self._replication_plan_executions_some = replication_plan_executions_some

    @property
    def replication_restore_points_every(self):
        """Gets the replication_restore_points_every of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replication_restore_points_every of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicationRestorePointWhereInput
        """
        return self._replication_restore_points_every

    @replication_restore_points_every.setter
    def replication_restore_points_every(self, replication_restore_points_every):
        """Sets the replication_restore_points_every of this ReplicationPlanWhereInput.


        :param replication_restore_points_every: The replication_restore_points_every of this ReplicationPlanWhereInput.  # noqa: E501
        :type replication_restore_points_every: ReplicationRestorePointWhereInput
        """

        self._replication_restore_points_every = replication_restore_points_every

    @property
    def replication_restore_points_none(self):
        """Gets the replication_restore_points_none of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replication_restore_points_none of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicationRestorePointWhereInput
        """
        return self._replication_restore_points_none

    @replication_restore_points_none.setter
    def replication_restore_points_none(self, replication_restore_points_none):
        """Sets the replication_restore_points_none of this ReplicationPlanWhereInput.


        :param replication_restore_points_none: The replication_restore_points_none of this ReplicationPlanWhereInput.  # noqa: E501
        :type replication_restore_points_none: ReplicationRestorePointWhereInput
        """

        self._replication_restore_points_none = replication_restore_points_none

    @property
    def replication_restore_points_some(self):
        """Gets the replication_restore_points_some of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replication_restore_points_some of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicationRestorePointWhereInput
        """
        return self._replication_restore_points_some

    @replication_restore_points_some.setter
    def replication_restore_points_some(self, replication_restore_points_some):
        """Sets the replication_restore_points_some of this ReplicationPlanWhereInput.


        :param replication_restore_points_some: The replication_restore_points_some of this ReplicationPlanWhereInput.  # noqa: E501
        :type replication_restore_points_some: ReplicationRestorePointWhereInput
        """

        self._replication_restore_points_some = replication_restore_points_some

    @property
    def replication_target_executions_every(self):
        """Gets the replication_target_executions_every of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replication_target_executions_every of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicationTargetExecutionWhereInput
        """
        return self._replication_target_executions_every

    @replication_target_executions_every.setter
    def replication_target_executions_every(self, replication_target_executions_every):
        """Sets the replication_target_executions_every of this ReplicationPlanWhereInput.


        :param replication_target_executions_every: The replication_target_executions_every of this ReplicationPlanWhereInput.  # noqa: E501
        :type replication_target_executions_every: ReplicationTargetExecutionWhereInput
        """

        self._replication_target_executions_every = replication_target_executions_every

    @property
    def replication_target_executions_none(self):
        """Gets the replication_target_executions_none of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replication_target_executions_none of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicationTargetExecutionWhereInput
        """
        return self._replication_target_executions_none

    @replication_target_executions_none.setter
    def replication_target_executions_none(self, replication_target_executions_none):
        """Sets the replication_target_executions_none of this ReplicationPlanWhereInput.


        :param replication_target_executions_none: The replication_target_executions_none of this ReplicationPlanWhereInput.  # noqa: E501
        :type replication_target_executions_none: ReplicationTargetExecutionWhereInput
        """

        self._replication_target_executions_none = replication_target_executions_none

    @property
    def replication_target_executions_some(self):
        """Gets the replication_target_executions_some of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The replication_target_executions_some of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicationTargetExecutionWhereInput
        """
        return self._replication_target_executions_some

    @replication_target_executions_some.setter
    def replication_target_executions_some(self, replication_target_executions_some):
        """Sets the replication_target_executions_some of this ReplicationPlanWhereInput.


        :param replication_target_executions_some: The replication_target_executions_some of this ReplicationPlanWhereInput.  # noqa: E501
        :type replication_target_executions_some: ReplicationTargetExecutionWhereInput
        """

        self._replication_target_executions_some = replication_target_executions_some

    @property
    def resiliency_type(self):
        """Gets the resiliency_type of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The resiliency_type of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ResiliencyType
        """
        return self._resiliency_type

    @resiliency_type.setter
    def resiliency_type(self, resiliency_type):
        """Sets the resiliency_type of this ReplicationPlanWhereInput.


        :param resiliency_type: The resiliency_type of this ReplicationPlanWhereInput.  # noqa: E501
        :type resiliency_type: ResiliencyType
        """

        self._resiliency_type = resiliency_type

    @property
    def resiliency_type_in(self):
        """Gets the resiliency_type_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The resiliency_type_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[ResiliencyType]
        """
        return self._resiliency_type_in

    @resiliency_type_in.setter
    def resiliency_type_in(self, resiliency_type_in):
        """Sets the resiliency_type_in of this ReplicationPlanWhereInput.


        :param resiliency_type_in: The resiliency_type_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type resiliency_type_in: list[ResiliencyType]
        """

        self._resiliency_type_in = resiliency_type_in

    @property
    def resiliency_type_not(self):
        """Gets the resiliency_type_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The resiliency_type_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ResiliencyType
        """
        return self._resiliency_type_not

    @resiliency_type_not.setter
    def resiliency_type_not(self, resiliency_type_not):
        """Sets the resiliency_type_not of this ReplicationPlanWhereInput.


        :param resiliency_type_not: The resiliency_type_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type resiliency_type_not: ResiliencyType
        """

        self._resiliency_type_not = resiliency_type_not

    @property
    def resiliency_type_not_in(self):
        """Gets the resiliency_type_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The resiliency_type_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[ResiliencyType]
        """
        return self._resiliency_type_not_in

    @resiliency_type_not_in.setter
    def resiliency_type_not_in(self, resiliency_type_not_in):
        """Sets the resiliency_type_not_in of this ReplicationPlanWhereInput.


        :param resiliency_type_not_in: The resiliency_type_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type resiliency_type_not_in: list[ResiliencyType]
        """

        self._resiliency_type_not_in = resiliency_type_not_in

    @property
    def snapshot_consistent_type(self):
        """Gets the snapshot_consistent_type of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ConsistentType
        """
        return self._snapshot_consistent_type

    @snapshot_consistent_type.setter
    def snapshot_consistent_type(self, snapshot_consistent_type):
        """Sets the snapshot_consistent_type of this ReplicationPlanWhereInput.


        :param snapshot_consistent_type: The snapshot_consistent_type of this ReplicationPlanWhereInput.  # noqa: E501
        :type snapshot_consistent_type: ConsistentType
        """

        self._snapshot_consistent_type = snapshot_consistent_type

    @property
    def snapshot_consistent_type_in(self):
        """Gets the snapshot_consistent_type_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[ConsistentType]
        """
        return self._snapshot_consistent_type_in

    @snapshot_consistent_type_in.setter
    def snapshot_consistent_type_in(self, snapshot_consistent_type_in):
        """Sets the snapshot_consistent_type_in of this ReplicationPlanWhereInput.


        :param snapshot_consistent_type_in: The snapshot_consistent_type_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type snapshot_consistent_type_in: list[ConsistentType]
        """

        self._snapshot_consistent_type_in = snapshot_consistent_type_in

    @property
    def snapshot_consistent_type_not(self):
        """Gets the snapshot_consistent_type_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ConsistentType
        """
        return self._snapshot_consistent_type_not

    @snapshot_consistent_type_not.setter
    def snapshot_consistent_type_not(self, snapshot_consistent_type_not):
        """Sets the snapshot_consistent_type_not of this ReplicationPlanWhereInput.


        :param snapshot_consistent_type_not: The snapshot_consistent_type_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type snapshot_consistent_type_not: ConsistentType
        """

        self._snapshot_consistent_type_not = snapshot_consistent_type_not

    @property
    def snapshot_consistent_type_not_in(self):
        """Gets the snapshot_consistent_type_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[ConsistentType]
        """
        return self._snapshot_consistent_type_not_in

    @snapshot_consistent_type_not_in.setter
    def snapshot_consistent_type_not_in(self, snapshot_consistent_type_not_in):
        """Sets the snapshot_consistent_type_not_in of this ReplicationPlanWhereInput.


        :param snapshot_consistent_type_not_in: The snapshot_consistent_type_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type snapshot_consistent_type_not_in: list[ConsistentType]
        """

        self._snapshot_consistent_type_not_in = snapshot_consistent_type_not_in

    @property
    def status(self):
        """Gets the status of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The status of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ReplicationPlanWhereInput.


        :param status: The status of this ReplicationPlanWhereInput.  # noqa: E501
        :type status: BackupPlanStatus
        """

        self._status = status

    @property
    def status_in(self):
        """Gets the status_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The status_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanStatus]
        """
        return self._status_in

    @status_in.setter
    def status_in(self, status_in):
        """Sets the status_in of this ReplicationPlanWhereInput.


        :param status_in: The status_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type status_in: list[BackupPlanStatus]
        """

        self._status_in = status_in

    @property
    def status_not(self):
        """Gets the status_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The status_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanStatus
        """
        return self._status_not

    @status_not.setter
    def status_not(self, status_not):
        """Sets the status_not of this ReplicationPlanWhereInput.


        :param status_not: The status_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type status_not: BackupPlanStatus
        """

        self._status_not = status_not

    @property
    def status_not_in(self):
        """Gets the status_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The status_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanStatus]
        """
        return self._status_not_in

    @status_not_in.setter
    def status_not_in(self, status_not_in):
        """Sets the status_not_in of this ReplicationPlanWhereInput.


        :param status_not_in: The status_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type status_not_in: list[BackupPlanStatus]
        """

        self._status_not_in = status_not_in

    @property
    def storage_policy(self):
        """Gets the storage_policy of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The storage_policy of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._storage_policy

    @storage_policy.setter
    def storage_policy(self, storage_policy):
        """Sets the storage_policy of this ReplicationPlanWhereInput.


        :param storage_policy: The storage_policy of this ReplicationPlanWhereInput.  # noqa: E501
        :type storage_policy: VmVolumeElfStoragePolicyType
        """

        self._storage_policy = storage_policy

    @property
    def storage_policy_in(self):
        """Gets the storage_policy_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The storage_policy_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[VmVolumeElfStoragePolicyType]
        """
        return self._storage_policy_in

    @storage_policy_in.setter
    def storage_policy_in(self, storage_policy_in):
        """Sets the storage_policy_in of this ReplicationPlanWhereInput.


        :param storage_policy_in: The storage_policy_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type storage_policy_in: list[VmVolumeElfStoragePolicyType]
        """

        self._storage_policy_in = storage_policy_in

    @property
    def storage_policy_not(self):
        """Gets the storage_policy_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The storage_policy_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._storage_policy_not

    @storage_policy_not.setter
    def storage_policy_not(self, storage_policy_not):
        """Sets the storage_policy_not of this ReplicationPlanWhereInput.


        :param storage_policy_not: The storage_policy_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type storage_policy_not: VmVolumeElfStoragePolicyType
        """

        self._storage_policy_not = storage_policy_not

    @property
    def storage_policy_not_in(self):
        """Gets the storage_policy_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The storage_policy_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[VmVolumeElfStoragePolicyType]
        """
        return self._storage_policy_not_in

    @storage_policy_not_in.setter
    def storage_policy_not_in(self, storage_policy_not_in):
        """Sets the storage_policy_not_in of this ReplicationPlanWhereInput.


        :param storage_policy_not_in: The storage_policy_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type storage_policy_not_in: list[VmVolumeElfStoragePolicyType]
        """

        self._storage_policy_not_in = storage_policy_not_in

    @property
    def target_cluster(self):
        """Gets the target_cluster of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The target_cluster of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._target_cluster

    @target_cluster.setter
    def target_cluster(self, target_cluster):
        """Sets the target_cluster of this ReplicationPlanWhereInput.


        :param target_cluster: The target_cluster of this ReplicationPlanWhereInput.  # noqa: E501
        :type target_cluster: ClusterWhereInput
        """

        self._target_cluster = target_cluster

    @property
    def target_replication_service(self):
        """Gets the target_replication_service of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The target_replication_service of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicationServiceWhereInput
        """
        return self._target_replication_service

    @target_replication_service.setter
    def target_replication_service(self, target_replication_service):
        """Sets the target_replication_service of this ReplicationPlanWhereInput.


        :param target_replication_service: The target_replication_service of this ReplicationPlanWhereInput.  # noqa: E501
        :type target_replication_service: ReplicationServiceWhereInput
        """

        self._target_replication_service = target_replication_service

    @property
    def thin_provision(self):
        """Gets the thin_provision of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The thin_provision of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._thin_provision

    @thin_provision.setter
    def thin_provision(self, thin_provision):
        """Sets the thin_provision of this ReplicationPlanWhereInput.


        :param thin_provision: The thin_provision of this ReplicationPlanWhereInput.  # noqa: E501
        :type thin_provision: bool
        """

        self._thin_provision = thin_provision

    @property
    def thin_provision_not(self):
        """Gets the thin_provision_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The thin_provision_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._thin_provision_not

    @thin_provision_not.setter
    def thin_provision_not(self, thin_provision_not):
        """Sets the thin_provision_not of this ReplicationPlanWhereInput.


        :param thin_provision_not: The thin_provision_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type thin_provision_not: bool
        """

        self._thin_provision_not = thin_provision_not

    @property
    def type(self):
        """Gets the type of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The type of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicationPlanType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ReplicationPlanWhereInput.


        :param type: The type of this ReplicationPlanWhereInput.  # noqa: E501
        :type type: ReplicationPlanType
        """

        self._type = type

    @property
    def type_in(self):
        """Gets the type_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The type_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[ReplicationPlanType]
        """
        return self._type_in

    @type_in.setter
    def type_in(self, type_in):
        """Sets the type_in of this ReplicationPlanWhereInput.


        :param type_in: The type_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type type_in: list[ReplicationPlanType]
        """

        self._type_in = type_in

    @property
    def type_not(self):
        """Gets the type_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The type_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: ReplicationPlanType
        """
        return self._type_not

    @type_not.setter
    def type_not(self, type_not):
        """Sets the type_not of this ReplicationPlanWhereInput.


        :param type_not: The type_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type type_not: ReplicationPlanType
        """

        self._type_not = type_not

    @property
    def type_not_in(self):
        """Gets the type_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The type_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[ReplicationPlanType]
        """
        return self._type_not_in

    @type_not_in.setter
    def type_not_in(self, type_not_in):
        """Sets the type_not_in of this ReplicationPlanWhereInput.


        :param type_not_in: The type_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type type_not_in: list[ReplicationPlanType]
        """

        self._type_not_in = type_not_in

    @property
    def updated_at(self):
        """Gets the updated_at of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The updated_at of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this ReplicationPlanWhereInput.


        :param updated_at: The updated_at of this ReplicationPlanWhereInput.  # noqa: E501
        :type updated_at: str
        """

        self._updated_at = updated_at

    @property
    def updated_at_gt(self):
        """Gets the updated_at_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The updated_at_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_gt

    @updated_at_gt.setter
    def updated_at_gt(self, updated_at_gt):
        """Sets the updated_at_gt of this ReplicationPlanWhereInput.


        :param updated_at_gt: The updated_at_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type updated_at_gt: str
        """

        self._updated_at_gt = updated_at_gt

    @property
    def updated_at_gte(self):
        """Gets the updated_at_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The updated_at_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_gte

    @updated_at_gte.setter
    def updated_at_gte(self, updated_at_gte):
        """Sets the updated_at_gte of this ReplicationPlanWhereInput.


        :param updated_at_gte: The updated_at_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type updated_at_gte: str
        """

        self._updated_at_gte = updated_at_gte

    @property
    def updated_at_in(self):
        """Gets the updated_at_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The updated_at_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._updated_at_in

    @updated_at_in.setter
    def updated_at_in(self, updated_at_in):
        """Sets the updated_at_in of this ReplicationPlanWhereInput.


        :param updated_at_in: The updated_at_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type updated_at_in: list[str]
        """

        self._updated_at_in = updated_at_in

    @property
    def updated_at_lt(self):
        """Gets the updated_at_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The updated_at_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_lt

    @updated_at_lt.setter
    def updated_at_lt(self, updated_at_lt):
        """Sets the updated_at_lt of this ReplicationPlanWhereInput.


        :param updated_at_lt: The updated_at_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type updated_at_lt: str
        """

        self._updated_at_lt = updated_at_lt

    @property
    def updated_at_lte(self):
        """Gets the updated_at_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The updated_at_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_lte

    @updated_at_lte.setter
    def updated_at_lte(self, updated_at_lte):
        """Sets the updated_at_lte of this ReplicationPlanWhereInput.


        :param updated_at_lte: The updated_at_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type updated_at_lte: str
        """

        self._updated_at_lte = updated_at_lte

    @property
    def updated_at_not(self):
        """Gets the updated_at_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The updated_at_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_not

    @updated_at_not.setter
    def updated_at_not(self, updated_at_not):
        """Sets the updated_at_not of this ReplicationPlanWhereInput.


        :param updated_at_not: The updated_at_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type updated_at_not: str
        """

        self._updated_at_not = updated_at_not

    @property
    def updated_at_not_in(self):
        """Gets the updated_at_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The updated_at_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._updated_at_not_in

    @updated_at_not_in.setter
    def updated_at_not_in(self, updated_at_not_in):
        """Sets the updated_at_not_in of this ReplicationPlanWhereInput.


        :param updated_at_not_in: The updated_at_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type updated_at_not_in: list[str]
        """

        self._updated_at_not_in = updated_at_not_in

    @property
    def vms_every(self):
        """Gets the vms_every of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The vms_every of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vms_every

    @vms_every.setter
    def vms_every(self, vms_every):
        """Sets the vms_every of this ReplicationPlanWhereInput.


        :param vms_every: The vms_every of this ReplicationPlanWhereInput.  # noqa: E501
        :type vms_every: VmWhereInput
        """

        self._vms_every = vms_every

    @property
    def vms_none(self):
        """Gets the vms_none of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The vms_none of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vms_none

    @vms_none.setter
    def vms_none(self, vms_none):
        """Sets the vms_none of this ReplicationPlanWhereInput.


        :param vms_none: The vms_none of this ReplicationPlanWhereInput.  # noqa: E501
        :type vms_none: VmWhereInput
        """

        self._vms_none = vms_none

    @property
    def vms_some(self):
        """Gets the vms_some of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The vms_some of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vms_some

    @vms_some.setter
    def vms_some(self, vms_some):
        """Sets the vms_some of this ReplicationPlanWhereInput.


        :param vms_some: The vms_some of this ReplicationPlanWhereInput.  # noqa: E501
        :type vms_some: VmWhereInput
        """

        self._vms_some = vms_some

    @property
    def window_end(self):
        """Gets the window_end of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_end of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end

    @window_end.setter
    def window_end(self, window_end):
        """Sets the window_end of this ReplicationPlanWhereInput.


        :param window_end: The window_end of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_end: str
        """

        self._window_end = window_end

    @property
    def window_end_contains(self):
        """Gets the window_end_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_end_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_contains

    @window_end_contains.setter
    def window_end_contains(self, window_end_contains):
        """Sets the window_end_contains of this ReplicationPlanWhereInput.


        :param window_end_contains: The window_end_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_end_contains: str
        """

        self._window_end_contains = window_end_contains

    @property
    def window_end_ends_with(self):
        """Gets the window_end_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_end_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_ends_with

    @window_end_ends_with.setter
    def window_end_ends_with(self, window_end_ends_with):
        """Sets the window_end_ends_with of this ReplicationPlanWhereInput.


        :param window_end_ends_with: The window_end_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_end_ends_with: str
        """

        self._window_end_ends_with = window_end_ends_with

    @property
    def window_end_gt(self):
        """Gets the window_end_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_end_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_gt

    @window_end_gt.setter
    def window_end_gt(self, window_end_gt):
        """Sets the window_end_gt of this ReplicationPlanWhereInput.


        :param window_end_gt: The window_end_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_end_gt: str
        """

        self._window_end_gt = window_end_gt

    @property
    def window_end_gte(self):
        """Gets the window_end_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_end_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_gte

    @window_end_gte.setter
    def window_end_gte(self, window_end_gte):
        """Sets the window_end_gte of this ReplicationPlanWhereInput.


        :param window_end_gte: The window_end_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_end_gte: str
        """

        self._window_end_gte = window_end_gte

    @property
    def window_end_in(self):
        """Gets the window_end_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_end_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._window_end_in

    @window_end_in.setter
    def window_end_in(self, window_end_in):
        """Sets the window_end_in of this ReplicationPlanWhereInput.


        :param window_end_in: The window_end_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_end_in: list[str]
        """

        self._window_end_in = window_end_in

    @property
    def window_end_lt(self):
        """Gets the window_end_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_end_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_lt

    @window_end_lt.setter
    def window_end_lt(self, window_end_lt):
        """Sets the window_end_lt of this ReplicationPlanWhereInput.


        :param window_end_lt: The window_end_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_end_lt: str
        """

        self._window_end_lt = window_end_lt

    @property
    def window_end_lte(self):
        """Gets the window_end_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_end_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_lte

    @window_end_lte.setter
    def window_end_lte(self, window_end_lte):
        """Sets the window_end_lte of this ReplicationPlanWhereInput.


        :param window_end_lte: The window_end_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_end_lte: str
        """

        self._window_end_lte = window_end_lte

    @property
    def window_end_not(self):
        """Gets the window_end_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_end_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_not

    @window_end_not.setter
    def window_end_not(self, window_end_not):
        """Sets the window_end_not of this ReplicationPlanWhereInput.


        :param window_end_not: The window_end_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_end_not: str
        """

        self._window_end_not = window_end_not

    @property
    def window_end_not_contains(self):
        """Gets the window_end_not_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_end_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_not_contains

    @window_end_not_contains.setter
    def window_end_not_contains(self, window_end_not_contains):
        """Sets the window_end_not_contains of this ReplicationPlanWhereInput.


        :param window_end_not_contains: The window_end_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_end_not_contains: str
        """

        self._window_end_not_contains = window_end_not_contains

    @property
    def window_end_not_ends_with(self):
        """Gets the window_end_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_end_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_not_ends_with

    @window_end_not_ends_with.setter
    def window_end_not_ends_with(self, window_end_not_ends_with):
        """Sets the window_end_not_ends_with of this ReplicationPlanWhereInput.


        :param window_end_not_ends_with: The window_end_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_end_not_ends_with: str
        """

        self._window_end_not_ends_with = window_end_not_ends_with

    @property
    def window_end_not_in(self):
        """Gets the window_end_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_end_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._window_end_not_in

    @window_end_not_in.setter
    def window_end_not_in(self, window_end_not_in):
        """Sets the window_end_not_in of this ReplicationPlanWhereInput.


        :param window_end_not_in: The window_end_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_end_not_in: list[str]
        """

        self._window_end_not_in = window_end_not_in

    @property
    def window_end_not_starts_with(self):
        """Gets the window_end_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_end_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_not_starts_with

    @window_end_not_starts_with.setter
    def window_end_not_starts_with(self, window_end_not_starts_with):
        """Sets the window_end_not_starts_with of this ReplicationPlanWhereInput.


        :param window_end_not_starts_with: The window_end_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_end_not_starts_with: str
        """

        self._window_end_not_starts_with = window_end_not_starts_with

    @property
    def window_end_starts_with(self):
        """Gets the window_end_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_end_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_starts_with

    @window_end_starts_with.setter
    def window_end_starts_with(self, window_end_starts_with):
        """Sets the window_end_starts_with of this ReplicationPlanWhereInput.


        :param window_end_starts_with: The window_end_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_end_starts_with: str
        """

        self._window_end_starts_with = window_end_starts_with

    @property
    def window_start(self):
        """Gets the window_start of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_start of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start

    @window_start.setter
    def window_start(self, window_start):
        """Sets the window_start of this ReplicationPlanWhereInput.


        :param window_start: The window_start of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_start: str
        """

        self._window_start = window_start

    @property
    def window_start_contains(self):
        """Gets the window_start_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_start_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_contains

    @window_start_contains.setter
    def window_start_contains(self, window_start_contains):
        """Sets the window_start_contains of this ReplicationPlanWhereInput.


        :param window_start_contains: The window_start_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_start_contains: str
        """

        self._window_start_contains = window_start_contains

    @property
    def window_start_ends_with(self):
        """Gets the window_start_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_start_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_ends_with

    @window_start_ends_with.setter
    def window_start_ends_with(self, window_start_ends_with):
        """Sets the window_start_ends_with of this ReplicationPlanWhereInput.


        :param window_start_ends_with: The window_start_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_start_ends_with: str
        """

        self._window_start_ends_with = window_start_ends_with

    @property
    def window_start_gt(self):
        """Gets the window_start_gt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_start_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_gt

    @window_start_gt.setter
    def window_start_gt(self, window_start_gt):
        """Sets the window_start_gt of this ReplicationPlanWhereInput.


        :param window_start_gt: The window_start_gt of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_start_gt: str
        """

        self._window_start_gt = window_start_gt

    @property
    def window_start_gte(self):
        """Gets the window_start_gte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_start_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_gte

    @window_start_gte.setter
    def window_start_gte(self, window_start_gte):
        """Sets the window_start_gte of this ReplicationPlanWhereInput.


        :param window_start_gte: The window_start_gte of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_start_gte: str
        """

        self._window_start_gte = window_start_gte

    @property
    def window_start_in(self):
        """Gets the window_start_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_start_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._window_start_in

    @window_start_in.setter
    def window_start_in(self, window_start_in):
        """Sets the window_start_in of this ReplicationPlanWhereInput.


        :param window_start_in: The window_start_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_start_in: list[str]
        """

        self._window_start_in = window_start_in

    @property
    def window_start_lt(self):
        """Gets the window_start_lt of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_start_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_lt

    @window_start_lt.setter
    def window_start_lt(self, window_start_lt):
        """Sets the window_start_lt of this ReplicationPlanWhereInput.


        :param window_start_lt: The window_start_lt of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_start_lt: str
        """

        self._window_start_lt = window_start_lt

    @property
    def window_start_lte(self):
        """Gets the window_start_lte of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_start_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_lte

    @window_start_lte.setter
    def window_start_lte(self, window_start_lte):
        """Sets the window_start_lte of this ReplicationPlanWhereInput.


        :param window_start_lte: The window_start_lte of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_start_lte: str
        """

        self._window_start_lte = window_start_lte

    @property
    def window_start_not(self):
        """Gets the window_start_not of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_start_not of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_not

    @window_start_not.setter
    def window_start_not(self, window_start_not):
        """Sets the window_start_not of this ReplicationPlanWhereInput.


        :param window_start_not: The window_start_not of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_start_not: str
        """

        self._window_start_not = window_start_not

    @property
    def window_start_not_contains(self):
        """Gets the window_start_not_contains of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_start_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_not_contains

    @window_start_not_contains.setter
    def window_start_not_contains(self, window_start_not_contains):
        """Sets the window_start_not_contains of this ReplicationPlanWhereInput.


        :param window_start_not_contains: The window_start_not_contains of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_start_not_contains: str
        """

        self._window_start_not_contains = window_start_not_contains

    @property
    def window_start_not_ends_with(self):
        """Gets the window_start_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_start_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_not_ends_with

    @window_start_not_ends_with.setter
    def window_start_not_ends_with(self, window_start_not_ends_with):
        """Sets the window_start_not_ends_with of this ReplicationPlanWhereInput.


        :param window_start_not_ends_with: The window_start_not_ends_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_start_not_ends_with: str
        """

        self._window_start_not_ends_with = window_start_not_ends_with

    @property
    def window_start_not_in(self):
        """Gets the window_start_not_in of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_start_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._window_start_not_in

    @window_start_not_in.setter
    def window_start_not_in(self, window_start_not_in):
        """Sets the window_start_not_in of this ReplicationPlanWhereInput.


        :param window_start_not_in: The window_start_not_in of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_start_not_in: list[str]
        """

        self._window_start_not_in = window_start_not_in

    @property
    def window_start_not_starts_with(self):
        """Gets the window_start_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_start_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_not_starts_with

    @window_start_not_starts_with.setter
    def window_start_not_starts_with(self, window_start_not_starts_with):
        """Sets the window_start_not_starts_with of this ReplicationPlanWhereInput.


        :param window_start_not_starts_with: The window_start_not_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_start_not_starts_with: str
        """

        self._window_start_not_starts_with = window_start_not_starts_with

    @property
    def window_start_starts_with(self):
        """Gets the window_start_starts_with of this ReplicationPlanWhereInput.  # noqa: E501


        :return: The window_start_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_starts_with

    @window_start_starts_with.setter
    def window_start_starts_with(self, window_start_starts_with):
        """Sets the window_start_starts_with of this ReplicationPlanWhereInput.


        :param window_start_starts_with: The window_start_starts_with of this ReplicationPlanWhereInput.  # noqa: E501
        :type window_start_starts_with: str
        """

        self._window_start_starts_with = window_start_starts_with

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReplicationPlanWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ReplicationPlanWhereInput):
            return True

        return self.to_dict() != other.to_dict()
