# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ReplicationRestorePointWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[ReplicationRestorePointWhereInput]',
        '_not': 'list[ReplicationRestorePointWhereInput]',
        '_or': 'list[ReplicationRestorePointWhereInput]',
        'cluster_local_id': 'str',
        'cluster_local_id_contains': 'str',
        'cluster_local_id_ends_with': 'str',
        'cluster_local_id_gt': 'str',
        'cluster_local_id_gte': 'str',
        'cluster_local_id_in': 'list[str]',
        'cluster_local_id_lt': 'str',
        'cluster_local_id_lte': 'str',
        'cluster_local_id_not': 'str',
        'cluster_local_id_not_contains': 'str',
        'cluster_local_id_not_ends_with': 'str',
        'cluster_local_id_not_in': 'list[str]',
        'cluster_local_id_not_starts_with': 'str',
        'cluster_local_id_starts_with': 'str',
        'creation': 'BackupRestorePointCreation',
        'creation_in': 'list[BackupRestorePointCreation]',
        'creation_not': 'BackupRestorePointCreation',
        'creation_not_in': 'list[BackupRestorePointCreation]',
        'dedup': 'BackupDedupMode',
        'dedup_in': 'list[BackupDedupMode]',
        'dedup_not': 'BackupDedupMode',
        'dedup_not_in': 'list[BackupDedupMode]',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'failover_executions_every': 'FailoverExecutionWhereInput',
        'failover_executions_none': 'FailoverExecutionWhereInput',
        'failover_executions_some': 'FailoverExecutionWhereInput',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'iscsi_lun': 'IscsiLunWhereInput',
        'local_created_at': 'str',
        'local_created_at_gt': 'str',
        'local_created_at_gte': 'str',
        'local_created_at_in': 'list[str]',
        'local_created_at_lt': 'str',
        'local_created_at_lte': 'str',
        'local_created_at_not': 'str',
        'local_created_at_not_in': 'list[str]',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'parent_restore_point': 'str',
        'parent_restore_point_contains': 'str',
        'parent_restore_point_ends_with': 'str',
        'parent_restore_point_gt': 'str',
        'parent_restore_point_gte': 'str',
        'parent_restore_point_in': 'list[str]',
        'parent_restore_point_lt': 'str',
        'parent_restore_point_lte': 'str',
        'parent_restore_point_not': 'str',
        'parent_restore_point_not_contains': 'str',
        'parent_restore_point_not_ends_with': 'str',
        'parent_restore_point_not_in': 'list[str]',
        'parent_restore_point_not_starts_with': 'str',
        'parent_restore_point_starts_with': 'str',
        'replica_vm': 'ReplicaVmWhereInput',
        'replication_plan': 'ReplicationPlanWhereInput',
        'replication_service': 'ReplicationServiceWhereInput',
        'replication_target_execution': 'ReplicationTargetExecutionWhereInput',
        'resource_version': 'int',
        'resource_version_gt': 'int',
        'resource_version_gte': 'int',
        'resource_version_in': 'list[int]',
        'resource_version_lt': 'int',
        'resource_version_lte': 'int',
        'resource_version_not': 'int',
        'resource_version_not_in': 'list[int]',
        'slice': 'str',
        'slice_contains': 'str',
        'slice_ends_with': 'str',
        'slice_gt': 'str',
        'slice_gte': 'str',
        'slice_in': 'list[str]',
        'slice_lt': 'str',
        'slice_lte': 'str',
        'slice_not': 'str',
        'slice_not_contains': 'str',
        'slice_not_ends_with': 'str',
        'slice_not_in': 'list[str]',
        'slice_not_starts_with': 'str',
        'slice_starts_with': 'str',
        'snapshot_consistent_type': 'ConsistentType',
        'snapshot_consistent_type_in': 'list[ConsistentType]',
        'snapshot_consistent_type_not': 'ConsistentType',
        'snapshot_consistent_type_not_in': 'list[ConsistentType]',
        'tower_deploy_id': 'str',
        'tower_deploy_id_contains': 'str',
        'tower_deploy_id_ends_with': 'str',
        'tower_deploy_id_gt': 'str',
        'tower_deploy_id_gte': 'str',
        'tower_deploy_id_in': 'list[str]',
        'tower_deploy_id_lt': 'str',
        'tower_deploy_id_lte': 'str',
        'tower_deploy_id_not': 'str',
        'tower_deploy_id_not_contains': 'str',
        'tower_deploy_id_not_ends_with': 'str',
        'tower_deploy_id_not_in': 'list[str]',
        'tower_deploy_id_not_starts_with': 'str',
        'tower_deploy_id_starts_with': 'str',
        'type': 'BackupRestorePointType',
        'type_in': 'list[BackupRestorePointType]',
        'type_not': 'BackupRestorePointType',
        'type_not_in': 'list[BackupRestorePointType]',
        'vm': 'VmWhereInput',
        'vm_local_id': 'str',
        'vm_local_id_contains': 'str',
        'vm_local_id_ends_with': 'str',
        'vm_local_id_gt': 'str',
        'vm_local_id_gte': 'str',
        'vm_local_id_in': 'list[str]',
        'vm_local_id_lt': 'str',
        'vm_local_id_lte': 'str',
        'vm_local_id_not': 'str',
        'vm_local_id_not_contains': 'str',
        'vm_local_id_not_ends_with': 'str',
        'vm_local_id_not_in': 'list[str]',
        'vm_local_id_not_starts_with': 'str',
        'vm_local_id_starts_with': 'str',
        'vm_name': 'str',
        'vm_name_contains': 'str',
        'vm_name_ends_with': 'str',
        'vm_name_gt': 'str',
        'vm_name_gte': 'str',
        'vm_name_in': 'list[str]',
        'vm_name_lt': 'str',
        'vm_name_lte': 'str',
        'vm_name_not': 'str',
        'vm_name_not_contains': 'str',
        'vm_name_not_ends_with': 'str',
        'vm_name_not_in': 'list[str]',
        'vm_name_not_starts_with': 'str',
        'vm_name_starts_with': 'str'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'cluster_local_id': 'cluster_local_id',
        'cluster_local_id_contains': 'cluster_local_id_contains',
        'cluster_local_id_ends_with': 'cluster_local_id_ends_with',
        'cluster_local_id_gt': 'cluster_local_id_gt',
        'cluster_local_id_gte': 'cluster_local_id_gte',
        'cluster_local_id_in': 'cluster_local_id_in',
        'cluster_local_id_lt': 'cluster_local_id_lt',
        'cluster_local_id_lte': 'cluster_local_id_lte',
        'cluster_local_id_not': 'cluster_local_id_not',
        'cluster_local_id_not_contains': 'cluster_local_id_not_contains',
        'cluster_local_id_not_ends_with': 'cluster_local_id_not_ends_with',
        'cluster_local_id_not_in': 'cluster_local_id_not_in',
        'cluster_local_id_not_starts_with': 'cluster_local_id_not_starts_with',
        'cluster_local_id_starts_with': 'cluster_local_id_starts_with',
        'creation': 'creation',
        'creation_in': 'creation_in',
        'creation_not': 'creation_not',
        'creation_not_in': 'creation_not_in',
        'dedup': 'dedup',
        'dedup_in': 'dedup_in',
        'dedup_not': 'dedup_not',
        'dedup_not_in': 'dedup_not_in',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'failover_executions_every': 'failover_executions_every',
        'failover_executions_none': 'failover_executions_none',
        'failover_executions_some': 'failover_executions_some',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'iscsi_lun': 'iscsi_lun',
        'local_created_at': 'local_created_at',
        'local_created_at_gt': 'local_created_at_gt',
        'local_created_at_gte': 'local_created_at_gte',
        'local_created_at_in': 'local_created_at_in',
        'local_created_at_lt': 'local_created_at_lt',
        'local_created_at_lte': 'local_created_at_lte',
        'local_created_at_not': 'local_created_at_not',
        'local_created_at_not_in': 'local_created_at_not_in',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'parent_restore_point': 'parent_restore_point',
        'parent_restore_point_contains': 'parent_restore_point_contains',
        'parent_restore_point_ends_with': 'parent_restore_point_ends_with',
        'parent_restore_point_gt': 'parent_restore_point_gt',
        'parent_restore_point_gte': 'parent_restore_point_gte',
        'parent_restore_point_in': 'parent_restore_point_in',
        'parent_restore_point_lt': 'parent_restore_point_lt',
        'parent_restore_point_lte': 'parent_restore_point_lte',
        'parent_restore_point_not': 'parent_restore_point_not',
        'parent_restore_point_not_contains': 'parent_restore_point_not_contains',
        'parent_restore_point_not_ends_with': 'parent_restore_point_not_ends_with',
        'parent_restore_point_not_in': 'parent_restore_point_not_in',
        'parent_restore_point_not_starts_with': 'parent_restore_point_not_starts_with',
        'parent_restore_point_starts_with': 'parent_restore_point_starts_with',
        'replica_vm': 'replica_vm',
        'replication_plan': 'replication_plan',
        'replication_service': 'replication_service',
        'replication_target_execution': 'replication_target_execution',
        'resource_version': 'resource_version',
        'resource_version_gt': 'resource_version_gt',
        'resource_version_gte': 'resource_version_gte',
        'resource_version_in': 'resource_version_in',
        'resource_version_lt': 'resource_version_lt',
        'resource_version_lte': 'resource_version_lte',
        'resource_version_not': 'resource_version_not',
        'resource_version_not_in': 'resource_version_not_in',
        'slice': 'slice',
        'slice_contains': 'slice_contains',
        'slice_ends_with': 'slice_ends_with',
        'slice_gt': 'slice_gt',
        'slice_gte': 'slice_gte',
        'slice_in': 'slice_in',
        'slice_lt': 'slice_lt',
        'slice_lte': 'slice_lte',
        'slice_not': 'slice_not',
        'slice_not_contains': 'slice_not_contains',
        'slice_not_ends_with': 'slice_not_ends_with',
        'slice_not_in': 'slice_not_in',
        'slice_not_starts_with': 'slice_not_starts_with',
        'slice_starts_with': 'slice_starts_with',
        'snapshot_consistent_type': 'snapshot_consistent_type',
        'snapshot_consistent_type_in': 'snapshot_consistent_type_in',
        'snapshot_consistent_type_not': 'snapshot_consistent_type_not',
        'snapshot_consistent_type_not_in': 'snapshot_consistent_type_not_in',
        'tower_deploy_id': 'tower_deploy_id',
        'tower_deploy_id_contains': 'tower_deploy_id_contains',
        'tower_deploy_id_ends_with': 'tower_deploy_id_ends_with',
        'tower_deploy_id_gt': 'tower_deploy_id_gt',
        'tower_deploy_id_gte': 'tower_deploy_id_gte',
        'tower_deploy_id_in': 'tower_deploy_id_in',
        'tower_deploy_id_lt': 'tower_deploy_id_lt',
        'tower_deploy_id_lte': 'tower_deploy_id_lte',
        'tower_deploy_id_not': 'tower_deploy_id_not',
        'tower_deploy_id_not_contains': 'tower_deploy_id_not_contains',
        'tower_deploy_id_not_ends_with': 'tower_deploy_id_not_ends_with',
        'tower_deploy_id_not_in': 'tower_deploy_id_not_in',
        'tower_deploy_id_not_starts_with': 'tower_deploy_id_not_starts_with',
        'tower_deploy_id_starts_with': 'tower_deploy_id_starts_with',
        'type': 'type',
        'type_in': 'type_in',
        'type_not': 'type_not',
        'type_not_in': 'type_not_in',
        'vm': 'vm',
        'vm_local_id': 'vm_local_id',
        'vm_local_id_contains': 'vm_local_id_contains',
        'vm_local_id_ends_with': 'vm_local_id_ends_with',
        'vm_local_id_gt': 'vm_local_id_gt',
        'vm_local_id_gte': 'vm_local_id_gte',
        'vm_local_id_in': 'vm_local_id_in',
        'vm_local_id_lt': 'vm_local_id_lt',
        'vm_local_id_lte': 'vm_local_id_lte',
        'vm_local_id_not': 'vm_local_id_not',
        'vm_local_id_not_contains': 'vm_local_id_not_contains',
        'vm_local_id_not_ends_with': 'vm_local_id_not_ends_with',
        'vm_local_id_not_in': 'vm_local_id_not_in',
        'vm_local_id_not_starts_with': 'vm_local_id_not_starts_with',
        'vm_local_id_starts_with': 'vm_local_id_starts_with',
        'vm_name': 'vm_name',
        'vm_name_contains': 'vm_name_contains',
        'vm_name_ends_with': 'vm_name_ends_with',
        'vm_name_gt': 'vm_name_gt',
        'vm_name_gte': 'vm_name_gte',
        'vm_name_in': 'vm_name_in',
        'vm_name_lt': 'vm_name_lt',
        'vm_name_lte': 'vm_name_lte',
        'vm_name_not': 'vm_name_not',
        'vm_name_not_contains': 'vm_name_not_contains',
        'vm_name_not_ends_with': 'vm_name_not_ends_with',
        'vm_name_not_in': 'vm_name_not_in',
        'vm_name_not_starts_with': 'vm_name_not_starts_with',
        'vm_name_starts_with': 'vm_name_starts_with'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ReplicationRestorePointWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._cluster_local_id = None
        self._cluster_local_id_contains = None
        self._cluster_local_id_ends_with = None
        self._cluster_local_id_gt = None
        self._cluster_local_id_gte = None
        self._cluster_local_id_in = None
        self._cluster_local_id_lt = None
        self._cluster_local_id_lte = None
        self._cluster_local_id_not = None
        self._cluster_local_id_not_contains = None
        self._cluster_local_id_not_ends_with = None
        self._cluster_local_id_not_in = None
        self._cluster_local_id_not_starts_with = None
        self._cluster_local_id_starts_with = None
        self._creation = None
        self._creation_in = None
        self._creation_not = None
        self._creation_not_in = None
        self._dedup = None
        self._dedup_in = None
        self._dedup_not = None
        self._dedup_not_in = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._failover_executions_every = None
        self._failover_executions_none = None
        self._failover_executions_some = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._iscsi_lun = None
        self._local_created_at = None
        self._local_created_at_gt = None
        self._local_created_at_gte = None
        self._local_created_at_in = None
        self._local_created_at_lt = None
        self._local_created_at_lte = None
        self._local_created_at_not = None
        self._local_created_at_not_in = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._parent_restore_point = None
        self._parent_restore_point_contains = None
        self._parent_restore_point_ends_with = None
        self._parent_restore_point_gt = None
        self._parent_restore_point_gte = None
        self._parent_restore_point_in = None
        self._parent_restore_point_lt = None
        self._parent_restore_point_lte = None
        self._parent_restore_point_not = None
        self._parent_restore_point_not_contains = None
        self._parent_restore_point_not_ends_with = None
        self._parent_restore_point_not_in = None
        self._parent_restore_point_not_starts_with = None
        self._parent_restore_point_starts_with = None
        self._replica_vm = None
        self._replication_plan = None
        self._replication_service = None
        self._replication_target_execution = None
        self._resource_version = None
        self._resource_version_gt = None
        self._resource_version_gte = None
        self._resource_version_in = None
        self._resource_version_lt = None
        self._resource_version_lte = None
        self._resource_version_not = None
        self._resource_version_not_in = None
        self._slice = None
        self._slice_contains = None
        self._slice_ends_with = None
        self._slice_gt = None
        self._slice_gte = None
        self._slice_in = None
        self._slice_lt = None
        self._slice_lte = None
        self._slice_not = None
        self._slice_not_contains = None
        self._slice_not_ends_with = None
        self._slice_not_in = None
        self._slice_not_starts_with = None
        self._slice_starts_with = None
        self._snapshot_consistent_type = None
        self._snapshot_consistent_type_in = None
        self._snapshot_consistent_type_not = None
        self._snapshot_consistent_type_not_in = None
        self._tower_deploy_id = None
        self._tower_deploy_id_contains = None
        self._tower_deploy_id_ends_with = None
        self._tower_deploy_id_gt = None
        self._tower_deploy_id_gte = None
        self._tower_deploy_id_in = None
        self._tower_deploy_id_lt = None
        self._tower_deploy_id_lte = None
        self._tower_deploy_id_not = None
        self._tower_deploy_id_not_contains = None
        self._tower_deploy_id_not_ends_with = None
        self._tower_deploy_id_not_in = None
        self._tower_deploy_id_not_starts_with = None
        self._tower_deploy_id_starts_with = None
        self._type = None
        self._type_in = None
        self._type_not = None
        self._type_not_in = None
        self._vm = None
        self._vm_local_id = None
        self._vm_local_id_contains = None
        self._vm_local_id_ends_with = None
        self._vm_local_id_gt = None
        self._vm_local_id_gte = None
        self._vm_local_id_in = None
        self._vm_local_id_lt = None
        self._vm_local_id_lte = None
        self._vm_local_id_not = None
        self._vm_local_id_not_contains = None
        self._vm_local_id_not_ends_with = None
        self._vm_local_id_not_in = None
        self._vm_local_id_not_starts_with = None
        self._vm_local_id_starts_with = None
        self._vm_name = None
        self._vm_name_contains = None
        self._vm_name_ends_with = None
        self._vm_name_gt = None
        self._vm_name_gte = None
        self._vm_name_in = None
        self._vm_name_lt = None
        self._vm_name_lte = None
        self._vm_name_not = None
        self._vm_name_not_contains = None
        self._vm_name_not_ends_with = None
        self._vm_name_not_in = None
        self._vm_name_not_starts_with = None
        self._vm_name_starts_with = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.cluster_local_id = kwargs.get("cluster_local_id", None)
        self.cluster_local_id_contains = kwargs.get("cluster_local_id_contains", None)
        self.cluster_local_id_ends_with = kwargs.get("cluster_local_id_ends_with", None)
        self.cluster_local_id_gt = kwargs.get("cluster_local_id_gt", None)
        self.cluster_local_id_gte = kwargs.get("cluster_local_id_gte", None)
        self.cluster_local_id_in = kwargs.get("cluster_local_id_in", None)
        self.cluster_local_id_lt = kwargs.get("cluster_local_id_lt", None)
        self.cluster_local_id_lte = kwargs.get("cluster_local_id_lte", None)
        self.cluster_local_id_not = kwargs.get("cluster_local_id_not", None)
        self.cluster_local_id_not_contains = kwargs.get("cluster_local_id_not_contains", None)
        self.cluster_local_id_not_ends_with = kwargs.get("cluster_local_id_not_ends_with", None)
        self.cluster_local_id_not_in = kwargs.get("cluster_local_id_not_in", None)
        self.cluster_local_id_not_starts_with = kwargs.get("cluster_local_id_not_starts_with", None)
        self.cluster_local_id_starts_with = kwargs.get("cluster_local_id_starts_with", None)
        self.creation = kwargs.get("creation", None)
        self.creation_in = kwargs.get("creation_in", None)
        self.creation_not = kwargs.get("creation_not", None)
        self.creation_not_in = kwargs.get("creation_not_in", None)
        self.dedup = kwargs.get("dedup", None)
        self.dedup_in = kwargs.get("dedup_in", None)
        self.dedup_not = kwargs.get("dedup_not", None)
        self.dedup_not_in = kwargs.get("dedup_not_in", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.failover_executions_every = kwargs.get("failover_executions_every", None)
        self.failover_executions_none = kwargs.get("failover_executions_none", None)
        self.failover_executions_some = kwargs.get("failover_executions_some", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.iscsi_lun = kwargs.get("iscsi_lun", None)
        self.local_created_at = kwargs.get("local_created_at", None)
        self.local_created_at_gt = kwargs.get("local_created_at_gt", None)
        self.local_created_at_gte = kwargs.get("local_created_at_gte", None)
        self.local_created_at_in = kwargs.get("local_created_at_in", None)
        self.local_created_at_lt = kwargs.get("local_created_at_lt", None)
        self.local_created_at_lte = kwargs.get("local_created_at_lte", None)
        self.local_created_at_not = kwargs.get("local_created_at_not", None)
        self.local_created_at_not_in = kwargs.get("local_created_at_not_in", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.parent_restore_point = kwargs.get("parent_restore_point", None)
        self.parent_restore_point_contains = kwargs.get("parent_restore_point_contains", None)
        self.parent_restore_point_ends_with = kwargs.get("parent_restore_point_ends_with", None)
        self.parent_restore_point_gt = kwargs.get("parent_restore_point_gt", None)
        self.parent_restore_point_gte = kwargs.get("parent_restore_point_gte", None)
        self.parent_restore_point_in = kwargs.get("parent_restore_point_in", None)
        self.parent_restore_point_lt = kwargs.get("parent_restore_point_lt", None)
        self.parent_restore_point_lte = kwargs.get("parent_restore_point_lte", None)
        self.parent_restore_point_not = kwargs.get("parent_restore_point_not", None)
        self.parent_restore_point_not_contains = kwargs.get("parent_restore_point_not_contains", None)
        self.parent_restore_point_not_ends_with = kwargs.get("parent_restore_point_not_ends_with", None)
        self.parent_restore_point_not_in = kwargs.get("parent_restore_point_not_in", None)
        self.parent_restore_point_not_starts_with = kwargs.get("parent_restore_point_not_starts_with", None)
        self.parent_restore_point_starts_with = kwargs.get("parent_restore_point_starts_with", None)
        self.replica_vm = kwargs.get("replica_vm", None)
        self.replication_plan = kwargs.get("replication_plan", None)
        self.replication_service = kwargs.get("replication_service", None)
        self.replication_target_execution = kwargs.get("replication_target_execution", None)
        self.resource_version = kwargs.get("resource_version", None)
        self.resource_version_gt = kwargs.get("resource_version_gt", None)
        self.resource_version_gte = kwargs.get("resource_version_gte", None)
        self.resource_version_in = kwargs.get("resource_version_in", None)
        self.resource_version_lt = kwargs.get("resource_version_lt", None)
        self.resource_version_lte = kwargs.get("resource_version_lte", None)
        self.resource_version_not = kwargs.get("resource_version_not", None)
        self.resource_version_not_in = kwargs.get("resource_version_not_in", None)
        self.slice = kwargs.get("slice", None)
        self.slice_contains = kwargs.get("slice_contains", None)
        self.slice_ends_with = kwargs.get("slice_ends_with", None)
        self.slice_gt = kwargs.get("slice_gt", None)
        self.slice_gte = kwargs.get("slice_gte", None)
        self.slice_in = kwargs.get("slice_in", None)
        self.slice_lt = kwargs.get("slice_lt", None)
        self.slice_lte = kwargs.get("slice_lte", None)
        self.slice_not = kwargs.get("slice_not", None)
        self.slice_not_contains = kwargs.get("slice_not_contains", None)
        self.slice_not_ends_with = kwargs.get("slice_not_ends_with", None)
        self.slice_not_in = kwargs.get("slice_not_in", None)
        self.slice_not_starts_with = kwargs.get("slice_not_starts_with", None)
        self.slice_starts_with = kwargs.get("slice_starts_with", None)
        self.snapshot_consistent_type = kwargs.get("snapshot_consistent_type", None)
        self.snapshot_consistent_type_in = kwargs.get("snapshot_consistent_type_in", None)
        self.snapshot_consistent_type_not = kwargs.get("snapshot_consistent_type_not", None)
        self.snapshot_consistent_type_not_in = kwargs.get("snapshot_consistent_type_not_in", None)
        self.tower_deploy_id = kwargs.get("tower_deploy_id", None)
        self.tower_deploy_id_contains = kwargs.get("tower_deploy_id_contains", None)
        self.tower_deploy_id_ends_with = kwargs.get("tower_deploy_id_ends_with", None)
        self.tower_deploy_id_gt = kwargs.get("tower_deploy_id_gt", None)
        self.tower_deploy_id_gte = kwargs.get("tower_deploy_id_gte", None)
        self.tower_deploy_id_in = kwargs.get("tower_deploy_id_in", None)
        self.tower_deploy_id_lt = kwargs.get("tower_deploy_id_lt", None)
        self.tower_deploy_id_lte = kwargs.get("tower_deploy_id_lte", None)
        self.tower_deploy_id_not = kwargs.get("tower_deploy_id_not", None)
        self.tower_deploy_id_not_contains = kwargs.get("tower_deploy_id_not_contains", None)
        self.tower_deploy_id_not_ends_with = kwargs.get("tower_deploy_id_not_ends_with", None)
        self.tower_deploy_id_not_in = kwargs.get("tower_deploy_id_not_in", None)
        self.tower_deploy_id_not_starts_with = kwargs.get("tower_deploy_id_not_starts_with", None)
        self.tower_deploy_id_starts_with = kwargs.get("tower_deploy_id_starts_with", None)
        self.type = kwargs.get("type", None)
        self.type_in = kwargs.get("type_in", None)
        self.type_not = kwargs.get("type_not", None)
        self.type_not_in = kwargs.get("type_not_in", None)
        self.vm = kwargs.get("vm", None)
        self.vm_local_id = kwargs.get("vm_local_id", None)
        self.vm_local_id_contains = kwargs.get("vm_local_id_contains", None)
        self.vm_local_id_ends_with = kwargs.get("vm_local_id_ends_with", None)
        self.vm_local_id_gt = kwargs.get("vm_local_id_gt", None)
        self.vm_local_id_gte = kwargs.get("vm_local_id_gte", None)
        self.vm_local_id_in = kwargs.get("vm_local_id_in", None)
        self.vm_local_id_lt = kwargs.get("vm_local_id_lt", None)
        self.vm_local_id_lte = kwargs.get("vm_local_id_lte", None)
        self.vm_local_id_not = kwargs.get("vm_local_id_not", None)
        self.vm_local_id_not_contains = kwargs.get("vm_local_id_not_contains", None)
        self.vm_local_id_not_ends_with = kwargs.get("vm_local_id_not_ends_with", None)
        self.vm_local_id_not_in = kwargs.get("vm_local_id_not_in", None)
        self.vm_local_id_not_starts_with = kwargs.get("vm_local_id_not_starts_with", None)
        self.vm_local_id_starts_with = kwargs.get("vm_local_id_starts_with", None)
        self.vm_name = kwargs.get("vm_name", None)
        self.vm_name_contains = kwargs.get("vm_name_contains", None)
        self.vm_name_ends_with = kwargs.get("vm_name_ends_with", None)
        self.vm_name_gt = kwargs.get("vm_name_gt", None)
        self.vm_name_gte = kwargs.get("vm_name_gte", None)
        self.vm_name_in = kwargs.get("vm_name_in", None)
        self.vm_name_lt = kwargs.get("vm_name_lt", None)
        self.vm_name_lte = kwargs.get("vm_name_lte", None)
        self.vm_name_not = kwargs.get("vm_name_not", None)
        self.vm_name_not_contains = kwargs.get("vm_name_not_contains", None)
        self.vm_name_not_ends_with = kwargs.get("vm_name_not_ends_with", None)
        self.vm_name_not_in = kwargs.get("vm_name_not_in", None)
        self.vm_name_not_starts_with = kwargs.get("vm_name_not_starts_with", None)
        self.vm_name_starts_with = kwargs.get("vm_name_starts_with", None)

    @property
    def _and(self):
        """Gets the _and of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The _and of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[ReplicationRestorePointWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this ReplicationRestorePointWhereInput.


        :param _and: The _and of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type _and: list[ReplicationRestorePointWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The _not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[ReplicationRestorePointWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this ReplicationRestorePointWhereInput.


        :param _not: The _not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type _not: list[ReplicationRestorePointWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The _or of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[ReplicationRestorePointWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this ReplicationRestorePointWhereInput.


        :param _or: The _or of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type _or: list[ReplicationRestorePointWhereInput]
        """

        self.__or = _or

    @property
    def cluster_local_id(self):
        """Gets the cluster_local_id of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id

    @cluster_local_id.setter
    def cluster_local_id(self, cluster_local_id):
        """Sets the cluster_local_id of this ReplicationRestorePointWhereInput.


        :param cluster_local_id: The cluster_local_id of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id: str
        """

        self._cluster_local_id = cluster_local_id

    @property
    def cluster_local_id_contains(self):
        """Gets the cluster_local_id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_contains

    @cluster_local_id_contains.setter
    def cluster_local_id_contains(self, cluster_local_id_contains):
        """Sets the cluster_local_id_contains of this ReplicationRestorePointWhereInput.


        :param cluster_local_id_contains: The cluster_local_id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_contains: str
        """

        self._cluster_local_id_contains = cluster_local_id_contains

    @property
    def cluster_local_id_ends_with(self):
        """Gets the cluster_local_id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_ends_with

    @cluster_local_id_ends_with.setter
    def cluster_local_id_ends_with(self, cluster_local_id_ends_with):
        """Sets the cluster_local_id_ends_with of this ReplicationRestorePointWhereInput.


        :param cluster_local_id_ends_with: The cluster_local_id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_ends_with: str
        """

        self._cluster_local_id_ends_with = cluster_local_id_ends_with

    @property
    def cluster_local_id_gt(self):
        """Gets the cluster_local_id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_gt

    @cluster_local_id_gt.setter
    def cluster_local_id_gt(self, cluster_local_id_gt):
        """Sets the cluster_local_id_gt of this ReplicationRestorePointWhereInput.


        :param cluster_local_id_gt: The cluster_local_id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_gt: str
        """

        self._cluster_local_id_gt = cluster_local_id_gt

    @property
    def cluster_local_id_gte(self):
        """Gets the cluster_local_id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_gte

    @cluster_local_id_gte.setter
    def cluster_local_id_gte(self, cluster_local_id_gte):
        """Sets the cluster_local_id_gte of this ReplicationRestorePointWhereInput.


        :param cluster_local_id_gte: The cluster_local_id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_gte: str
        """

        self._cluster_local_id_gte = cluster_local_id_gte

    @property
    def cluster_local_id_in(self):
        """Gets the cluster_local_id_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._cluster_local_id_in

    @cluster_local_id_in.setter
    def cluster_local_id_in(self, cluster_local_id_in):
        """Sets the cluster_local_id_in of this ReplicationRestorePointWhereInput.


        :param cluster_local_id_in: The cluster_local_id_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_in: list[str]
        """

        self._cluster_local_id_in = cluster_local_id_in

    @property
    def cluster_local_id_lt(self):
        """Gets the cluster_local_id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_lt

    @cluster_local_id_lt.setter
    def cluster_local_id_lt(self, cluster_local_id_lt):
        """Sets the cluster_local_id_lt of this ReplicationRestorePointWhereInput.


        :param cluster_local_id_lt: The cluster_local_id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_lt: str
        """

        self._cluster_local_id_lt = cluster_local_id_lt

    @property
    def cluster_local_id_lte(self):
        """Gets the cluster_local_id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_lte

    @cluster_local_id_lte.setter
    def cluster_local_id_lte(self, cluster_local_id_lte):
        """Sets the cluster_local_id_lte of this ReplicationRestorePointWhereInput.


        :param cluster_local_id_lte: The cluster_local_id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_lte: str
        """

        self._cluster_local_id_lte = cluster_local_id_lte

    @property
    def cluster_local_id_not(self):
        """Gets the cluster_local_id_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_not

    @cluster_local_id_not.setter
    def cluster_local_id_not(self, cluster_local_id_not):
        """Sets the cluster_local_id_not of this ReplicationRestorePointWhereInput.


        :param cluster_local_id_not: The cluster_local_id_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_not: str
        """

        self._cluster_local_id_not = cluster_local_id_not

    @property
    def cluster_local_id_not_contains(self):
        """Gets the cluster_local_id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_not_contains

    @cluster_local_id_not_contains.setter
    def cluster_local_id_not_contains(self, cluster_local_id_not_contains):
        """Sets the cluster_local_id_not_contains of this ReplicationRestorePointWhereInput.


        :param cluster_local_id_not_contains: The cluster_local_id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_not_contains: str
        """

        self._cluster_local_id_not_contains = cluster_local_id_not_contains

    @property
    def cluster_local_id_not_ends_with(self):
        """Gets the cluster_local_id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_not_ends_with

    @cluster_local_id_not_ends_with.setter
    def cluster_local_id_not_ends_with(self, cluster_local_id_not_ends_with):
        """Sets the cluster_local_id_not_ends_with of this ReplicationRestorePointWhereInput.


        :param cluster_local_id_not_ends_with: The cluster_local_id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_not_ends_with: str
        """

        self._cluster_local_id_not_ends_with = cluster_local_id_not_ends_with

    @property
    def cluster_local_id_not_in(self):
        """Gets the cluster_local_id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._cluster_local_id_not_in

    @cluster_local_id_not_in.setter
    def cluster_local_id_not_in(self, cluster_local_id_not_in):
        """Sets the cluster_local_id_not_in of this ReplicationRestorePointWhereInput.


        :param cluster_local_id_not_in: The cluster_local_id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_not_in: list[str]
        """

        self._cluster_local_id_not_in = cluster_local_id_not_in

    @property
    def cluster_local_id_not_starts_with(self):
        """Gets the cluster_local_id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_not_starts_with

    @cluster_local_id_not_starts_with.setter
    def cluster_local_id_not_starts_with(self, cluster_local_id_not_starts_with):
        """Sets the cluster_local_id_not_starts_with of this ReplicationRestorePointWhereInput.


        :param cluster_local_id_not_starts_with: The cluster_local_id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_not_starts_with: str
        """

        self._cluster_local_id_not_starts_with = cluster_local_id_not_starts_with

    @property
    def cluster_local_id_starts_with(self):
        """Gets the cluster_local_id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_starts_with

    @cluster_local_id_starts_with.setter
    def cluster_local_id_starts_with(self, cluster_local_id_starts_with):
        """Sets the cluster_local_id_starts_with of this ReplicationRestorePointWhereInput.


        :param cluster_local_id_starts_with: The cluster_local_id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_starts_with: str
        """

        self._cluster_local_id_starts_with = cluster_local_id_starts_with

    @property
    def creation(self):
        """Gets the creation of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The creation of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: BackupRestorePointCreation
        """
        return self._creation

    @creation.setter
    def creation(self, creation):
        """Sets the creation of this ReplicationRestorePointWhereInput.


        :param creation: The creation of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type creation: BackupRestorePointCreation
        """

        self._creation = creation

    @property
    def creation_in(self):
        """Gets the creation_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The creation_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[BackupRestorePointCreation]
        """
        return self._creation_in

    @creation_in.setter
    def creation_in(self, creation_in):
        """Sets the creation_in of this ReplicationRestorePointWhereInput.


        :param creation_in: The creation_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type creation_in: list[BackupRestorePointCreation]
        """

        self._creation_in = creation_in

    @property
    def creation_not(self):
        """Gets the creation_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The creation_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: BackupRestorePointCreation
        """
        return self._creation_not

    @creation_not.setter
    def creation_not(self, creation_not):
        """Sets the creation_not of this ReplicationRestorePointWhereInput.


        :param creation_not: The creation_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type creation_not: BackupRestorePointCreation
        """

        self._creation_not = creation_not

    @property
    def creation_not_in(self):
        """Gets the creation_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The creation_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[BackupRestorePointCreation]
        """
        return self._creation_not_in

    @creation_not_in.setter
    def creation_not_in(self, creation_not_in):
        """Sets the creation_not_in of this ReplicationRestorePointWhereInput.


        :param creation_not_in: The creation_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type creation_not_in: list[BackupRestorePointCreation]
        """

        self._creation_not_in = creation_not_in

    @property
    def dedup(self):
        """Gets the dedup of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The dedup of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: BackupDedupMode
        """
        return self._dedup

    @dedup.setter
    def dedup(self, dedup):
        """Sets the dedup of this ReplicationRestorePointWhereInput.


        :param dedup: The dedup of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type dedup: BackupDedupMode
        """

        self._dedup = dedup

    @property
    def dedup_in(self):
        """Gets the dedup_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The dedup_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[BackupDedupMode]
        """
        return self._dedup_in

    @dedup_in.setter
    def dedup_in(self, dedup_in):
        """Sets the dedup_in of this ReplicationRestorePointWhereInput.


        :param dedup_in: The dedup_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type dedup_in: list[BackupDedupMode]
        """

        self._dedup_in = dedup_in

    @property
    def dedup_not(self):
        """Gets the dedup_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The dedup_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: BackupDedupMode
        """
        return self._dedup_not

    @dedup_not.setter
    def dedup_not(self, dedup_not):
        """Sets the dedup_not of this ReplicationRestorePointWhereInput.


        :param dedup_not: The dedup_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type dedup_not: BackupDedupMode
        """

        self._dedup_not = dedup_not

    @property
    def dedup_not_in(self):
        """Gets the dedup_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The dedup_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[BackupDedupMode]
        """
        return self._dedup_not_in

    @dedup_not_in.setter
    def dedup_not_in(self, dedup_not_in):
        """Sets the dedup_not_in of this ReplicationRestorePointWhereInput.


        :param dedup_not_in: The dedup_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type dedup_not_in: list[BackupDedupMode]
        """

        self._dedup_not_in = dedup_not_in

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The entity_async_status of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this ReplicationRestorePointWhereInput.


        :param entity_async_status: The entity_async_status of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this ReplicationRestorePointWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this ReplicationRestorePointWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this ReplicationRestorePointWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def failover_executions_every(self):
        """Gets the failover_executions_every of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The failover_executions_every of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: FailoverExecutionWhereInput
        """
        return self._failover_executions_every

    @failover_executions_every.setter
    def failover_executions_every(self, failover_executions_every):
        """Sets the failover_executions_every of this ReplicationRestorePointWhereInput.


        :param failover_executions_every: The failover_executions_every of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type failover_executions_every: FailoverExecutionWhereInput
        """

        self._failover_executions_every = failover_executions_every

    @property
    def failover_executions_none(self):
        """Gets the failover_executions_none of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The failover_executions_none of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: FailoverExecutionWhereInput
        """
        return self._failover_executions_none

    @failover_executions_none.setter
    def failover_executions_none(self, failover_executions_none):
        """Sets the failover_executions_none of this ReplicationRestorePointWhereInput.


        :param failover_executions_none: The failover_executions_none of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type failover_executions_none: FailoverExecutionWhereInput
        """

        self._failover_executions_none = failover_executions_none

    @property
    def failover_executions_some(self):
        """Gets the failover_executions_some of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The failover_executions_some of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: FailoverExecutionWhereInput
        """
        return self._failover_executions_some

    @failover_executions_some.setter
    def failover_executions_some(self, failover_executions_some):
        """Sets the failover_executions_some of this ReplicationRestorePointWhereInput.


        :param failover_executions_some: The failover_executions_some of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type failover_executions_some: FailoverExecutionWhereInput
        """

        self._failover_executions_some = failover_executions_some

    @property
    def id(self):
        """Gets the id of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The id of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ReplicationRestorePointWhereInput.


        :param id: The id of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this ReplicationRestorePointWhereInput.


        :param id_contains: The id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this ReplicationRestorePointWhereInput.


        :param id_ends_with: The id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this ReplicationRestorePointWhereInput.


        :param id_gt: The id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this ReplicationRestorePointWhereInput.


        :param id_gte: The id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The id_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this ReplicationRestorePointWhereInput.


        :param id_in: The id_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this ReplicationRestorePointWhereInput.


        :param id_lt: The id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this ReplicationRestorePointWhereInput.


        :param id_lte: The id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The id_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this ReplicationRestorePointWhereInput.


        :param id_not: The id_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this ReplicationRestorePointWhereInput.


        :param id_not_contains: The id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this ReplicationRestorePointWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this ReplicationRestorePointWhereInput.


        :param id_not_in: The id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this ReplicationRestorePointWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this ReplicationRestorePointWhereInput.


        :param id_starts_with: The id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def iscsi_lun(self):
        """Gets the iscsi_lun of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The iscsi_lun of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: IscsiLunWhereInput
        """
        return self._iscsi_lun

    @iscsi_lun.setter
    def iscsi_lun(self, iscsi_lun):
        """Sets the iscsi_lun of this ReplicationRestorePointWhereInput.


        :param iscsi_lun: The iscsi_lun of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type iscsi_lun: IscsiLunWhereInput
        """

        self._iscsi_lun = iscsi_lun

    @property
    def local_created_at(self):
        """Gets the local_created_at of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this ReplicationRestorePointWhereInput.


        :param local_created_at: The local_created_at of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_created_at: str
        """

        self._local_created_at = local_created_at

    @property
    def local_created_at_gt(self):
        """Gets the local_created_at_gt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gt

    @local_created_at_gt.setter
    def local_created_at_gt(self, local_created_at_gt):
        """Sets the local_created_at_gt of this ReplicationRestorePointWhereInput.


        :param local_created_at_gt: The local_created_at_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_created_at_gt: str
        """

        self._local_created_at_gt = local_created_at_gt

    @property
    def local_created_at_gte(self):
        """Gets the local_created_at_gte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gte

    @local_created_at_gte.setter
    def local_created_at_gte(self, local_created_at_gte):
        """Sets the local_created_at_gte of this ReplicationRestorePointWhereInput.


        :param local_created_at_gte: The local_created_at_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_created_at_gte: str
        """

        self._local_created_at_gte = local_created_at_gte

    @property
    def local_created_at_in(self):
        """Gets the local_created_at_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_in

    @local_created_at_in.setter
    def local_created_at_in(self, local_created_at_in):
        """Sets the local_created_at_in of this ReplicationRestorePointWhereInput.


        :param local_created_at_in: The local_created_at_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_created_at_in: list[str]
        """

        self._local_created_at_in = local_created_at_in

    @property
    def local_created_at_lt(self):
        """Gets the local_created_at_lt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lt

    @local_created_at_lt.setter
    def local_created_at_lt(self, local_created_at_lt):
        """Sets the local_created_at_lt of this ReplicationRestorePointWhereInput.


        :param local_created_at_lt: The local_created_at_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_created_at_lt: str
        """

        self._local_created_at_lt = local_created_at_lt

    @property
    def local_created_at_lte(self):
        """Gets the local_created_at_lte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lte

    @local_created_at_lte.setter
    def local_created_at_lte(self, local_created_at_lte):
        """Sets the local_created_at_lte of this ReplicationRestorePointWhereInput.


        :param local_created_at_lte: The local_created_at_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_created_at_lte: str
        """

        self._local_created_at_lte = local_created_at_lte

    @property
    def local_created_at_not(self):
        """Gets the local_created_at_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_not

    @local_created_at_not.setter
    def local_created_at_not(self, local_created_at_not):
        """Sets the local_created_at_not of this ReplicationRestorePointWhereInput.


        :param local_created_at_not: The local_created_at_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_created_at_not: str
        """

        self._local_created_at_not = local_created_at_not

    @property
    def local_created_at_not_in(self):
        """Gets the local_created_at_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_not_in

    @local_created_at_not_in.setter
    def local_created_at_not_in(self, local_created_at_not_in):
        """Sets the local_created_at_not_in of this ReplicationRestorePointWhereInput.


        :param local_created_at_not_in: The local_created_at_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_created_at_not_in: list[str]
        """

        self._local_created_at_not_in = local_created_at_not_in

    @property
    def local_id(self):
        """Gets the local_id of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_id of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this ReplicationRestorePointWhereInput.


        :param local_id: The local_id of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this ReplicationRestorePointWhereInput.


        :param local_id_contains: The local_id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this ReplicationRestorePointWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this ReplicationRestorePointWhereInput.


        :param local_id_gt: The local_id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this ReplicationRestorePointWhereInput.


        :param local_id_gte: The local_id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_id_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this ReplicationRestorePointWhereInput.


        :param local_id_in: The local_id_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this ReplicationRestorePointWhereInput.


        :param local_id_lt: The local_id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this ReplicationRestorePointWhereInput.


        :param local_id_lte: The local_id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_id_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this ReplicationRestorePointWhereInput.


        :param local_id_not: The local_id_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this ReplicationRestorePointWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this ReplicationRestorePointWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this ReplicationRestorePointWhereInput.


        :param local_id_not_in: The local_id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this ReplicationRestorePointWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this ReplicationRestorePointWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def parent_restore_point(self):
        """Gets the parent_restore_point of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point

    @parent_restore_point.setter
    def parent_restore_point(self, parent_restore_point):
        """Sets the parent_restore_point of this ReplicationRestorePointWhereInput.


        :param parent_restore_point: The parent_restore_point of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point: str
        """

        self._parent_restore_point = parent_restore_point

    @property
    def parent_restore_point_contains(self):
        """Gets the parent_restore_point_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_contains

    @parent_restore_point_contains.setter
    def parent_restore_point_contains(self, parent_restore_point_contains):
        """Sets the parent_restore_point_contains of this ReplicationRestorePointWhereInput.


        :param parent_restore_point_contains: The parent_restore_point_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_contains: str
        """

        self._parent_restore_point_contains = parent_restore_point_contains

    @property
    def parent_restore_point_ends_with(self):
        """Gets the parent_restore_point_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_ends_with

    @parent_restore_point_ends_with.setter
    def parent_restore_point_ends_with(self, parent_restore_point_ends_with):
        """Sets the parent_restore_point_ends_with of this ReplicationRestorePointWhereInput.


        :param parent_restore_point_ends_with: The parent_restore_point_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_ends_with: str
        """

        self._parent_restore_point_ends_with = parent_restore_point_ends_with

    @property
    def parent_restore_point_gt(self):
        """Gets the parent_restore_point_gt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_gt

    @parent_restore_point_gt.setter
    def parent_restore_point_gt(self, parent_restore_point_gt):
        """Sets the parent_restore_point_gt of this ReplicationRestorePointWhereInput.


        :param parent_restore_point_gt: The parent_restore_point_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_gt: str
        """

        self._parent_restore_point_gt = parent_restore_point_gt

    @property
    def parent_restore_point_gte(self):
        """Gets the parent_restore_point_gte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_gte

    @parent_restore_point_gte.setter
    def parent_restore_point_gte(self, parent_restore_point_gte):
        """Sets the parent_restore_point_gte of this ReplicationRestorePointWhereInput.


        :param parent_restore_point_gte: The parent_restore_point_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_gte: str
        """

        self._parent_restore_point_gte = parent_restore_point_gte

    @property
    def parent_restore_point_in(self):
        """Gets the parent_restore_point_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._parent_restore_point_in

    @parent_restore_point_in.setter
    def parent_restore_point_in(self, parent_restore_point_in):
        """Sets the parent_restore_point_in of this ReplicationRestorePointWhereInput.


        :param parent_restore_point_in: The parent_restore_point_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_in: list[str]
        """

        self._parent_restore_point_in = parent_restore_point_in

    @property
    def parent_restore_point_lt(self):
        """Gets the parent_restore_point_lt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_lt

    @parent_restore_point_lt.setter
    def parent_restore_point_lt(self, parent_restore_point_lt):
        """Sets the parent_restore_point_lt of this ReplicationRestorePointWhereInput.


        :param parent_restore_point_lt: The parent_restore_point_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_lt: str
        """

        self._parent_restore_point_lt = parent_restore_point_lt

    @property
    def parent_restore_point_lte(self):
        """Gets the parent_restore_point_lte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_lte

    @parent_restore_point_lte.setter
    def parent_restore_point_lte(self, parent_restore_point_lte):
        """Sets the parent_restore_point_lte of this ReplicationRestorePointWhereInput.


        :param parent_restore_point_lte: The parent_restore_point_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_lte: str
        """

        self._parent_restore_point_lte = parent_restore_point_lte

    @property
    def parent_restore_point_not(self):
        """Gets the parent_restore_point_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_not

    @parent_restore_point_not.setter
    def parent_restore_point_not(self, parent_restore_point_not):
        """Sets the parent_restore_point_not of this ReplicationRestorePointWhereInput.


        :param parent_restore_point_not: The parent_restore_point_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_not: str
        """

        self._parent_restore_point_not = parent_restore_point_not

    @property
    def parent_restore_point_not_contains(self):
        """Gets the parent_restore_point_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_not_contains

    @parent_restore_point_not_contains.setter
    def parent_restore_point_not_contains(self, parent_restore_point_not_contains):
        """Sets the parent_restore_point_not_contains of this ReplicationRestorePointWhereInput.


        :param parent_restore_point_not_contains: The parent_restore_point_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_not_contains: str
        """

        self._parent_restore_point_not_contains = parent_restore_point_not_contains

    @property
    def parent_restore_point_not_ends_with(self):
        """Gets the parent_restore_point_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_not_ends_with

    @parent_restore_point_not_ends_with.setter
    def parent_restore_point_not_ends_with(self, parent_restore_point_not_ends_with):
        """Sets the parent_restore_point_not_ends_with of this ReplicationRestorePointWhereInput.


        :param parent_restore_point_not_ends_with: The parent_restore_point_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_not_ends_with: str
        """

        self._parent_restore_point_not_ends_with = parent_restore_point_not_ends_with

    @property
    def parent_restore_point_not_in(self):
        """Gets the parent_restore_point_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._parent_restore_point_not_in

    @parent_restore_point_not_in.setter
    def parent_restore_point_not_in(self, parent_restore_point_not_in):
        """Sets the parent_restore_point_not_in of this ReplicationRestorePointWhereInput.


        :param parent_restore_point_not_in: The parent_restore_point_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_not_in: list[str]
        """

        self._parent_restore_point_not_in = parent_restore_point_not_in

    @property
    def parent_restore_point_not_starts_with(self):
        """Gets the parent_restore_point_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_not_starts_with

    @parent_restore_point_not_starts_with.setter
    def parent_restore_point_not_starts_with(self, parent_restore_point_not_starts_with):
        """Sets the parent_restore_point_not_starts_with of this ReplicationRestorePointWhereInput.


        :param parent_restore_point_not_starts_with: The parent_restore_point_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_not_starts_with: str
        """

        self._parent_restore_point_not_starts_with = parent_restore_point_not_starts_with

    @property
    def parent_restore_point_starts_with(self):
        """Gets the parent_restore_point_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_starts_with

    @parent_restore_point_starts_with.setter
    def parent_restore_point_starts_with(self, parent_restore_point_starts_with):
        """Sets the parent_restore_point_starts_with of this ReplicationRestorePointWhereInput.


        :param parent_restore_point_starts_with: The parent_restore_point_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_starts_with: str
        """

        self._parent_restore_point_starts_with = parent_restore_point_starts_with

    @property
    def replica_vm(self):
        """Gets the replica_vm of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The replica_vm of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: ReplicaVmWhereInput
        """
        return self._replica_vm

    @replica_vm.setter
    def replica_vm(self, replica_vm):
        """Sets the replica_vm of this ReplicationRestorePointWhereInput.


        :param replica_vm: The replica_vm of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type replica_vm: ReplicaVmWhereInput
        """

        self._replica_vm = replica_vm

    @property
    def replication_plan(self):
        """Gets the replication_plan of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The replication_plan of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: ReplicationPlanWhereInput
        """
        return self._replication_plan

    @replication_plan.setter
    def replication_plan(self, replication_plan):
        """Sets the replication_plan of this ReplicationRestorePointWhereInput.


        :param replication_plan: The replication_plan of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type replication_plan: ReplicationPlanWhereInput
        """

        self._replication_plan = replication_plan

    @property
    def replication_service(self):
        """Gets the replication_service of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The replication_service of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: ReplicationServiceWhereInput
        """
        return self._replication_service

    @replication_service.setter
    def replication_service(self, replication_service):
        """Sets the replication_service of this ReplicationRestorePointWhereInput.


        :param replication_service: The replication_service of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type replication_service: ReplicationServiceWhereInput
        """

        self._replication_service = replication_service

    @property
    def replication_target_execution(self):
        """Gets the replication_target_execution of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The replication_target_execution of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: ReplicationTargetExecutionWhereInput
        """
        return self._replication_target_execution

    @replication_target_execution.setter
    def replication_target_execution(self, replication_target_execution):
        """Sets the replication_target_execution of this ReplicationRestorePointWhereInput.


        :param replication_target_execution: The replication_target_execution of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type replication_target_execution: ReplicationTargetExecutionWhereInput
        """

        self._replication_target_execution = replication_target_execution

    @property
    def resource_version(self):
        """Gets the resource_version of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The resource_version of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version

    @resource_version.setter
    def resource_version(self, resource_version):
        """Sets the resource_version of this ReplicationRestorePointWhereInput.


        :param resource_version: The resource_version of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type resource_version: int
        """

        self._resource_version = resource_version

    @property
    def resource_version_gt(self):
        """Gets the resource_version_gt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The resource_version_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_gt

    @resource_version_gt.setter
    def resource_version_gt(self, resource_version_gt):
        """Sets the resource_version_gt of this ReplicationRestorePointWhereInput.


        :param resource_version_gt: The resource_version_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type resource_version_gt: int
        """

        self._resource_version_gt = resource_version_gt

    @property
    def resource_version_gte(self):
        """Gets the resource_version_gte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The resource_version_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_gte

    @resource_version_gte.setter
    def resource_version_gte(self, resource_version_gte):
        """Sets the resource_version_gte of this ReplicationRestorePointWhereInput.


        :param resource_version_gte: The resource_version_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type resource_version_gte: int
        """

        self._resource_version_gte = resource_version_gte

    @property
    def resource_version_in(self):
        """Gets the resource_version_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The resource_version_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._resource_version_in

    @resource_version_in.setter
    def resource_version_in(self, resource_version_in):
        """Sets the resource_version_in of this ReplicationRestorePointWhereInput.


        :param resource_version_in: The resource_version_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type resource_version_in: list[int]
        """

        self._resource_version_in = resource_version_in

    @property
    def resource_version_lt(self):
        """Gets the resource_version_lt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The resource_version_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_lt

    @resource_version_lt.setter
    def resource_version_lt(self, resource_version_lt):
        """Sets the resource_version_lt of this ReplicationRestorePointWhereInput.


        :param resource_version_lt: The resource_version_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type resource_version_lt: int
        """

        self._resource_version_lt = resource_version_lt

    @property
    def resource_version_lte(self):
        """Gets the resource_version_lte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The resource_version_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_lte

    @resource_version_lte.setter
    def resource_version_lte(self, resource_version_lte):
        """Sets the resource_version_lte of this ReplicationRestorePointWhereInput.


        :param resource_version_lte: The resource_version_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type resource_version_lte: int
        """

        self._resource_version_lte = resource_version_lte

    @property
    def resource_version_not(self):
        """Gets the resource_version_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The resource_version_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_not

    @resource_version_not.setter
    def resource_version_not(self, resource_version_not):
        """Sets the resource_version_not of this ReplicationRestorePointWhereInput.


        :param resource_version_not: The resource_version_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type resource_version_not: int
        """

        self._resource_version_not = resource_version_not

    @property
    def resource_version_not_in(self):
        """Gets the resource_version_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The resource_version_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._resource_version_not_in

    @resource_version_not_in.setter
    def resource_version_not_in(self, resource_version_not_in):
        """Sets the resource_version_not_in of this ReplicationRestorePointWhereInput.


        :param resource_version_not_in: The resource_version_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type resource_version_not_in: list[int]
        """

        self._resource_version_not_in = resource_version_not_in

    @property
    def slice(self):
        """Gets the slice of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The slice of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice

    @slice.setter
    def slice(self, slice):
        """Sets the slice of this ReplicationRestorePointWhereInput.


        :param slice: The slice of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type slice: str
        """

        self._slice = slice

    @property
    def slice_contains(self):
        """Gets the slice_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The slice_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_contains

    @slice_contains.setter
    def slice_contains(self, slice_contains):
        """Sets the slice_contains of this ReplicationRestorePointWhereInput.


        :param slice_contains: The slice_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type slice_contains: str
        """

        self._slice_contains = slice_contains

    @property
    def slice_ends_with(self):
        """Gets the slice_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The slice_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_ends_with

    @slice_ends_with.setter
    def slice_ends_with(self, slice_ends_with):
        """Sets the slice_ends_with of this ReplicationRestorePointWhereInput.


        :param slice_ends_with: The slice_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type slice_ends_with: str
        """

        self._slice_ends_with = slice_ends_with

    @property
    def slice_gt(self):
        """Gets the slice_gt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The slice_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_gt

    @slice_gt.setter
    def slice_gt(self, slice_gt):
        """Sets the slice_gt of this ReplicationRestorePointWhereInput.


        :param slice_gt: The slice_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type slice_gt: str
        """

        self._slice_gt = slice_gt

    @property
    def slice_gte(self):
        """Gets the slice_gte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The slice_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_gte

    @slice_gte.setter
    def slice_gte(self, slice_gte):
        """Sets the slice_gte of this ReplicationRestorePointWhereInput.


        :param slice_gte: The slice_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type slice_gte: str
        """

        self._slice_gte = slice_gte

    @property
    def slice_in(self):
        """Gets the slice_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The slice_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._slice_in

    @slice_in.setter
    def slice_in(self, slice_in):
        """Sets the slice_in of this ReplicationRestorePointWhereInput.


        :param slice_in: The slice_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type slice_in: list[str]
        """

        self._slice_in = slice_in

    @property
    def slice_lt(self):
        """Gets the slice_lt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The slice_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_lt

    @slice_lt.setter
    def slice_lt(self, slice_lt):
        """Sets the slice_lt of this ReplicationRestorePointWhereInput.


        :param slice_lt: The slice_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type slice_lt: str
        """

        self._slice_lt = slice_lt

    @property
    def slice_lte(self):
        """Gets the slice_lte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The slice_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_lte

    @slice_lte.setter
    def slice_lte(self, slice_lte):
        """Sets the slice_lte of this ReplicationRestorePointWhereInput.


        :param slice_lte: The slice_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type slice_lte: str
        """

        self._slice_lte = slice_lte

    @property
    def slice_not(self):
        """Gets the slice_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The slice_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_not

    @slice_not.setter
    def slice_not(self, slice_not):
        """Sets the slice_not of this ReplicationRestorePointWhereInput.


        :param slice_not: The slice_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type slice_not: str
        """

        self._slice_not = slice_not

    @property
    def slice_not_contains(self):
        """Gets the slice_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The slice_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_not_contains

    @slice_not_contains.setter
    def slice_not_contains(self, slice_not_contains):
        """Sets the slice_not_contains of this ReplicationRestorePointWhereInput.


        :param slice_not_contains: The slice_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type slice_not_contains: str
        """

        self._slice_not_contains = slice_not_contains

    @property
    def slice_not_ends_with(self):
        """Gets the slice_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The slice_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_not_ends_with

    @slice_not_ends_with.setter
    def slice_not_ends_with(self, slice_not_ends_with):
        """Sets the slice_not_ends_with of this ReplicationRestorePointWhereInput.


        :param slice_not_ends_with: The slice_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type slice_not_ends_with: str
        """

        self._slice_not_ends_with = slice_not_ends_with

    @property
    def slice_not_in(self):
        """Gets the slice_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The slice_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._slice_not_in

    @slice_not_in.setter
    def slice_not_in(self, slice_not_in):
        """Sets the slice_not_in of this ReplicationRestorePointWhereInput.


        :param slice_not_in: The slice_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type slice_not_in: list[str]
        """

        self._slice_not_in = slice_not_in

    @property
    def slice_not_starts_with(self):
        """Gets the slice_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The slice_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_not_starts_with

    @slice_not_starts_with.setter
    def slice_not_starts_with(self, slice_not_starts_with):
        """Sets the slice_not_starts_with of this ReplicationRestorePointWhereInput.


        :param slice_not_starts_with: The slice_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type slice_not_starts_with: str
        """

        self._slice_not_starts_with = slice_not_starts_with

    @property
    def slice_starts_with(self):
        """Gets the slice_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The slice_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_starts_with

    @slice_starts_with.setter
    def slice_starts_with(self, slice_starts_with):
        """Sets the slice_starts_with of this ReplicationRestorePointWhereInput.


        :param slice_starts_with: The slice_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type slice_starts_with: str
        """

        self._slice_starts_with = slice_starts_with

    @property
    def snapshot_consistent_type(self):
        """Gets the snapshot_consistent_type of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: ConsistentType
        """
        return self._snapshot_consistent_type

    @snapshot_consistent_type.setter
    def snapshot_consistent_type(self, snapshot_consistent_type):
        """Sets the snapshot_consistent_type of this ReplicationRestorePointWhereInput.


        :param snapshot_consistent_type: The snapshot_consistent_type of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type snapshot_consistent_type: ConsistentType
        """

        self._snapshot_consistent_type = snapshot_consistent_type

    @property
    def snapshot_consistent_type_in(self):
        """Gets the snapshot_consistent_type_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[ConsistentType]
        """
        return self._snapshot_consistent_type_in

    @snapshot_consistent_type_in.setter
    def snapshot_consistent_type_in(self, snapshot_consistent_type_in):
        """Sets the snapshot_consistent_type_in of this ReplicationRestorePointWhereInput.


        :param snapshot_consistent_type_in: The snapshot_consistent_type_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type snapshot_consistent_type_in: list[ConsistentType]
        """

        self._snapshot_consistent_type_in = snapshot_consistent_type_in

    @property
    def snapshot_consistent_type_not(self):
        """Gets the snapshot_consistent_type_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: ConsistentType
        """
        return self._snapshot_consistent_type_not

    @snapshot_consistent_type_not.setter
    def snapshot_consistent_type_not(self, snapshot_consistent_type_not):
        """Sets the snapshot_consistent_type_not of this ReplicationRestorePointWhereInput.


        :param snapshot_consistent_type_not: The snapshot_consistent_type_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type snapshot_consistent_type_not: ConsistentType
        """

        self._snapshot_consistent_type_not = snapshot_consistent_type_not

    @property
    def snapshot_consistent_type_not_in(self):
        """Gets the snapshot_consistent_type_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[ConsistentType]
        """
        return self._snapshot_consistent_type_not_in

    @snapshot_consistent_type_not_in.setter
    def snapshot_consistent_type_not_in(self, snapshot_consistent_type_not_in):
        """Sets the snapshot_consistent_type_not_in of this ReplicationRestorePointWhereInput.


        :param snapshot_consistent_type_not_in: The snapshot_consistent_type_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type snapshot_consistent_type_not_in: list[ConsistentType]
        """

        self._snapshot_consistent_type_not_in = snapshot_consistent_type_not_in

    @property
    def tower_deploy_id(self):
        """Gets the tower_deploy_id of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The tower_deploy_id of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._tower_deploy_id

    @tower_deploy_id.setter
    def tower_deploy_id(self, tower_deploy_id):
        """Sets the tower_deploy_id of this ReplicationRestorePointWhereInput.


        :param tower_deploy_id: The tower_deploy_id of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type tower_deploy_id: str
        """

        self._tower_deploy_id = tower_deploy_id

    @property
    def tower_deploy_id_contains(self):
        """Gets the tower_deploy_id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The tower_deploy_id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._tower_deploy_id_contains

    @tower_deploy_id_contains.setter
    def tower_deploy_id_contains(self, tower_deploy_id_contains):
        """Sets the tower_deploy_id_contains of this ReplicationRestorePointWhereInput.


        :param tower_deploy_id_contains: The tower_deploy_id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type tower_deploy_id_contains: str
        """

        self._tower_deploy_id_contains = tower_deploy_id_contains

    @property
    def tower_deploy_id_ends_with(self):
        """Gets the tower_deploy_id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The tower_deploy_id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._tower_deploy_id_ends_with

    @tower_deploy_id_ends_with.setter
    def tower_deploy_id_ends_with(self, tower_deploy_id_ends_with):
        """Sets the tower_deploy_id_ends_with of this ReplicationRestorePointWhereInput.


        :param tower_deploy_id_ends_with: The tower_deploy_id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type tower_deploy_id_ends_with: str
        """

        self._tower_deploy_id_ends_with = tower_deploy_id_ends_with

    @property
    def tower_deploy_id_gt(self):
        """Gets the tower_deploy_id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The tower_deploy_id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._tower_deploy_id_gt

    @tower_deploy_id_gt.setter
    def tower_deploy_id_gt(self, tower_deploy_id_gt):
        """Sets the tower_deploy_id_gt of this ReplicationRestorePointWhereInput.


        :param tower_deploy_id_gt: The tower_deploy_id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type tower_deploy_id_gt: str
        """

        self._tower_deploy_id_gt = tower_deploy_id_gt

    @property
    def tower_deploy_id_gte(self):
        """Gets the tower_deploy_id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The tower_deploy_id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._tower_deploy_id_gte

    @tower_deploy_id_gte.setter
    def tower_deploy_id_gte(self, tower_deploy_id_gte):
        """Sets the tower_deploy_id_gte of this ReplicationRestorePointWhereInput.


        :param tower_deploy_id_gte: The tower_deploy_id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type tower_deploy_id_gte: str
        """

        self._tower_deploy_id_gte = tower_deploy_id_gte

    @property
    def tower_deploy_id_in(self):
        """Gets the tower_deploy_id_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The tower_deploy_id_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._tower_deploy_id_in

    @tower_deploy_id_in.setter
    def tower_deploy_id_in(self, tower_deploy_id_in):
        """Sets the tower_deploy_id_in of this ReplicationRestorePointWhereInput.


        :param tower_deploy_id_in: The tower_deploy_id_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type tower_deploy_id_in: list[str]
        """

        self._tower_deploy_id_in = tower_deploy_id_in

    @property
    def tower_deploy_id_lt(self):
        """Gets the tower_deploy_id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The tower_deploy_id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._tower_deploy_id_lt

    @tower_deploy_id_lt.setter
    def tower_deploy_id_lt(self, tower_deploy_id_lt):
        """Sets the tower_deploy_id_lt of this ReplicationRestorePointWhereInput.


        :param tower_deploy_id_lt: The tower_deploy_id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type tower_deploy_id_lt: str
        """

        self._tower_deploy_id_lt = tower_deploy_id_lt

    @property
    def tower_deploy_id_lte(self):
        """Gets the tower_deploy_id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The tower_deploy_id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._tower_deploy_id_lte

    @tower_deploy_id_lte.setter
    def tower_deploy_id_lte(self, tower_deploy_id_lte):
        """Sets the tower_deploy_id_lte of this ReplicationRestorePointWhereInput.


        :param tower_deploy_id_lte: The tower_deploy_id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type tower_deploy_id_lte: str
        """

        self._tower_deploy_id_lte = tower_deploy_id_lte

    @property
    def tower_deploy_id_not(self):
        """Gets the tower_deploy_id_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The tower_deploy_id_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._tower_deploy_id_not

    @tower_deploy_id_not.setter
    def tower_deploy_id_not(self, tower_deploy_id_not):
        """Sets the tower_deploy_id_not of this ReplicationRestorePointWhereInput.


        :param tower_deploy_id_not: The tower_deploy_id_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type tower_deploy_id_not: str
        """

        self._tower_deploy_id_not = tower_deploy_id_not

    @property
    def tower_deploy_id_not_contains(self):
        """Gets the tower_deploy_id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The tower_deploy_id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._tower_deploy_id_not_contains

    @tower_deploy_id_not_contains.setter
    def tower_deploy_id_not_contains(self, tower_deploy_id_not_contains):
        """Sets the tower_deploy_id_not_contains of this ReplicationRestorePointWhereInput.


        :param tower_deploy_id_not_contains: The tower_deploy_id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type tower_deploy_id_not_contains: str
        """

        self._tower_deploy_id_not_contains = tower_deploy_id_not_contains

    @property
    def tower_deploy_id_not_ends_with(self):
        """Gets the tower_deploy_id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The tower_deploy_id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._tower_deploy_id_not_ends_with

    @tower_deploy_id_not_ends_with.setter
    def tower_deploy_id_not_ends_with(self, tower_deploy_id_not_ends_with):
        """Sets the tower_deploy_id_not_ends_with of this ReplicationRestorePointWhereInput.


        :param tower_deploy_id_not_ends_with: The tower_deploy_id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type tower_deploy_id_not_ends_with: str
        """

        self._tower_deploy_id_not_ends_with = tower_deploy_id_not_ends_with

    @property
    def tower_deploy_id_not_in(self):
        """Gets the tower_deploy_id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The tower_deploy_id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._tower_deploy_id_not_in

    @tower_deploy_id_not_in.setter
    def tower_deploy_id_not_in(self, tower_deploy_id_not_in):
        """Sets the tower_deploy_id_not_in of this ReplicationRestorePointWhereInput.


        :param tower_deploy_id_not_in: The tower_deploy_id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type tower_deploy_id_not_in: list[str]
        """

        self._tower_deploy_id_not_in = tower_deploy_id_not_in

    @property
    def tower_deploy_id_not_starts_with(self):
        """Gets the tower_deploy_id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The tower_deploy_id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._tower_deploy_id_not_starts_with

    @tower_deploy_id_not_starts_with.setter
    def tower_deploy_id_not_starts_with(self, tower_deploy_id_not_starts_with):
        """Sets the tower_deploy_id_not_starts_with of this ReplicationRestorePointWhereInput.


        :param tower_deploy_id_not_starts_with: The tower_deploy_id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type tower_deploy_id_not_starts_with: str
        """

        self._tower_deploy_id_not_starts_with = tower_deploy_id_not_starts_with

    @property
    def tower_deploy_id_starts_with(self):
        """Gets the tower_deploy_id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The tower_deploy_id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._tower_deploy_id_starts_with

    @tower_deploy_id_starts_with.setter
    def tower_deploy_id_starts_with(self, tower_deploy_id_starts_with):
        """Sets the tower_deploy_id_starts_with of this ReplicationRestorePointWhereInput.


        :param tower_deploy_id_starts_with: The tower_deploy_id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type tower_deploy_id_starts_with: str
        """

        self._tower_deploy_id_starts_with = tower_deploy_id_starts_with

    @property
    def type(self):
        """Gets the type of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The type of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: BackupRestorePointType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ReplicationRestorePointWhereInput.


        :param type: The type of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type type: BackupRestorePointType
        """

        self._type = type

    @property
    def type_in(self):
        """Gets the type_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The type_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[BackupRestorePointType]
        """
        return self._type_in

    @type_in.setter
    def type_in(self, type_in):
        """Sets the type_in of this ReplicationRestorePointWhereInput.


        :param type_in: The type_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type type_in: list[BackupRestorePointType]
        """

        self._type_in = type_in

    @property
    def type_not(self):
        """Gets the type_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The type_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: BackupRestorePointType
        """
        return self._type_not

    @type_not.setter
    def type_not(self, type_not):
        """Sets the type_not of this ReplicationRestorePointWhereInput.


        :param type_not: The type_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type type_not: BackupRestorePointType
        """

        self._type_not = type_not

    @property
    def type_not_in(self):
        """Gets the type_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The type_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[BackupRestorePointType]
        """
        return self._type_not_in

    @type_not_in.setter
    def type_not_in(self, type_not_in):
        """Sets the type_not_in of this ReplicationRestorePointWhereInput.


        :param type_not_in: The type_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type type_not_in: list[BackupRestorePointType]
        """

        self._type_not_in = type_not_in

    @property
    def vm(self):
        """Gets the vm of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vm

    @vm.setter
    def vm(self, vm):
        """Sets the vm of this ReplicationRestorePointWhereInput.


        :param vm: The vm of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm: VmWhereInput
        """

        self._vm = vm

    @property
    def vm_local_id(self):
        """Gets the vm_local_id of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id

    @vm_local_id.setter
    def vm_local_id(self, vm_local_id):
        """Sets the vm_local_id of this ReplicationRestorePointWhereInput.


        :param vm_local_id: The vm_local_id of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_local_id: str
        """

        self._vm_local_id = vm_local_id

    @property
    def vm_local_id_contains(self):
        """Gets the vm_local_id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_contains

    @vm_local_id_contains.setter
    def vm_local_id_contains(self, vm_local_id_contains):
        """Sets the vm_local_id_contains of this ReplicationRestorePointWhereInput.


        :param vm_local_id_contains: The vm_local_id_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_contains: str
        """

        self._vm_local_id_contains = vm_local_id_contains

    @property
    def vm_local_id_ends_with(self):
        """Gets the vm_local_id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_ends_with

    @vm_local_id_ends_with.setter
    def vm_local_id_ends_with(self, vm_local_id_ends_with):
        """Sets the vm_local_id_ends_with of this ReplicationRestorePointWhereInput.


        :param vm_local_id_ends_with: The vm_local_id_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_ends_with: str
        """

        self._vm_local_id_ends_with = vm_local_id_ends_with

    @property
    def vm_local_id_gt(self):
        """Gets the vm_local_id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_gt

    @vm_local_id_gt.setter
    def vm_local_id_gt(self, vm_local_id_gt):
        """Sets the vm_local_id_gt of this ReplicationRestorePointWhereInput.


        :param vm_local_id_gt: The vm_local_id_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_gt: str
        """

        self._vm_local_id_gt = vm_local_id_gt

    @property
    def vm_local_id_gte(self):
        """Gets the vm_local_id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_gte

    @vm_local_id_gte.setter
    def vm_local_id_gte(self, vm_local_id_gte):
        """Sets the vm_local_id_gte of this ReplicationRestorePointWhereInput.


        :param vm_local_id_gte: The vm_local_id_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_gte: str
        """

        self._vm_local_id_gte = vm_local_id_gte

    @property
    def vm_local_id_in(self):
        """Gets the vm_local_id_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._vm_local_id_in

    @vm_local_id_in.setter
    def vm_local_id_in(self, vm_local_id_in):
        """Sets the vm_local_id_in of this ReplicationRestorePointWhereInput.


        :param vm_local_id_in: The vm_local_id_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_in: list[str]
        """

        self._vm_local_id_in = vm_local_id_in

    @property
    def vm_local_id_lt(self):
        """Gets the vm_local_id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_lt

    @vm_local_id_lt.setter
    def vm_local_id_lt(self, vm_local_id_lt):
        """Sets the vm_local_id_lt of this ReplicationRestorePointWhereInput.


        :param vm_local_id_lt: The vm_local_id_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_lt: str
        """

        self._vm_local_id_lt = vm_local_id_lt

    @property
    def vm_local_id_lte(self):
        """Gets the vm_local_id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_lte

    @vm_local_id_lte.setter
    def vm_local_id_lte(self, vm_local_id_lte):
        """Sets the vm_local_id_lte of this ReplicationRestorePointWhereInput.


        :param vm_local_id_lte: The vm_local_id_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_lte: str
        """

        self._vm_local_id_lte = vm_local_id_lte

    @property
    def vm_local_id_not(self):
        """Gets the vm_local_id_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_not

    @vm_local_id_not.setter
    def vm_local_id_not(self, vm_local_id_not):
        """Sets the vm_local_id_not of this ReplicationRestorePointWhereInput.


        :param vm_local_id_not: The vm_local_id_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_not: str
        """

        self._vm_local_id_not = vm_local_id_not

    @property
    def vm_local_id_not_contains(self):
        """Gets the vm_local_id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_not_contains

    @vm_local_id_not_contains.setter
    def vm_local_id_not_contains(self, vm_local_id_not_contains):
        """Sets the vm_local_id_not_contains of this ReplicationRestorePointWhereInput.


        :param vm_local_id_not_contains: The vm_local_id_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_not_contains: str
        """

        self._vm_local_id_not_contains = vm_local_id_not_contains

    @property
    def vm_local_id_not_ends_with(self):
        """Gets the vm_local_id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_not_ends_with

    @vm_local_id_not_ends_with.setter
    def vm_local_id_not_ends_with(self, vm_local_id_not_ends_with):
        """Sets the vm_local_id_not_ends_with of this ReplicationRestorePointWhereInput.


        :param vm_local_id_not_ends_with: The vm_local_id_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_not_ends_with: str
        """

        self._vm_local_id_not_ends_with = vm_local_id_not_ends_with

    @property
    def vm_local_id_not_in(self):
        """Gets the vm_local_id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._vm_local_id_not_in

    @vm_local_id_not_in.setter
    def vm_local_id_not_in(self, vm_local_id_not_in):
        """Sets the vm_local_id_not_in of this ReplicationRestorePointWhereInput.


        :param vm_local_id_not_in: The vm_local_id_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_not_in: list[str]
        """

        self._vm_local_id_not_in = vm_local_id_not_in

    @property
    def vm_local_id_not_starts_with(self):
        """Gets the vm_local_id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_not_starts_with

    @vm_local_id_not_starts_with.setter
    def vm_local_id_not_starts_with(self, vm_local_id_not_starts_with):
        """Sets the vm_local_id_not_starts_with of this ReplicationRestorePointWhereInput.


        :param vm_local_id_not_starts_with: The vm_local_id_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_not_starts_with: str
        """

        self._vm_local_id_not_starts_with = vm_local_id_not_starts_with

    @property
    def vm_local_id_starts_with(self):
        """Gets the vm_local_id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_starts_with

    @vm_local_id_starts_with.setter
    def vm_local_id_starts_with(self, vm_local_id_starts_with):
        """Sets the vm_local_id_starts_with of this ReplicationRestorePointWhereInput.


        :param vm_local_id_starts_with: The vm_local_id_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_starts_with: str
        """

        self._vm_local_id_starts_with = vm_local_id_starts_with

    @property
    def vm_name(self):
        """Gets the vm_name of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_name of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name

    @vm_name.setter
    def vm_name(self, vm_name):
        """Sets the vm_name of this ReplicationRestorePointWhereInput.


        :param vm_name: The vm_name of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_name: str
        """

        self._vm_name = vm_name

    @property
    def vm_name_contains(self):
        """Gets the vm_name_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_contains

    @vm_name_contains.setter
    def vm_name_contains(self, vm_name_contains):
        """Sets the vm_name_contains of this ReplicationRestorePointWhereInput.


        :param vm_name_contains: The vm_name_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_name_contains: str
        """

        self._vm_name_contains = vm_name_contains

    @property
    def vm_name_ends_with(self):
        """Gets the vm_name_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_ends_with

    @vm_name_ends_with.setter
    def vm_name_ends_with(self, vm_name_ends_with):
        """Sets the vm_name_ends_with of this ReplicationRestorePointWhereInput.


        :param vm_name_ends_with: The vm_name_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_name_ends_with: str
        """

        self._vm_name_ends_with = vm_name_ends_with

    @property
    def vm_name_gt(self):
        """Gets the vm_name_gt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_gt

    @vm_name_gt.setter
    def vm_name_gt(self, vm_name_gt):
        """Sets the vm_name_gt of this ReplicationRestorePointWhereInput.


        :param vm_name_gt: The vm_name_gt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_name_gt: str
        """

        self._vm_name_gt = vm_name_gt

    @property
    def vm_name_gte(self):
        """Gets the vm_name_gte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_gte

    @vm_name_gte.setter
    def vm_name_gte(self, vm_name_gte):
        """Sets the vm_name_gte of this ReplicationRestorePointWhereInput.


        :param vm_name_gte: The vm_name_gte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_name_gte: str
        """

        self._vm_name_gte = vm_name_gte

    @property
    def vm_name_in(self):
        """Gets the vm_name_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._vm_name_in

    @vm_name_in.setter
    def vm_name_in(self, vm_name_in):
        """Sets the vm_name_in of this ReplicationRestorePointWhereInput.


        :param vm_name_in: The vm_name_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_name_in: list[str]
        """

        self._vm_name_in = vm_name_in

    @property
    def vm_name_lt(self):
        """Gets the vm_name_lt of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_lt

    @vm_name_lt.setter
    def vm_name_lt(self, vm_name_lt):
        """Sets the vm_name_lt of this ReplicationRestorePointWhereInput.


        :param vm_name_lt: The vm_name_lt of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_name_lt: str
        """

        self._vm_name_lt = vm_name_lt

    @property
    def vm_name_lte(self):
        """Gets the vm_name_lte of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_lte

    @vm_name_lte.setter
    def vm_name_lte(self, vm_name_lte):
        """Sets the vm_name_lte of this ReplicationRestorePointWhereInput.


        :param vm_name_lte: The vm_name_lte of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_name_lte: str
        """

        self._vm_name_lte = vm_name_lte

    @property
    def vm_name_not(self):
        """Gets the vm_name_not of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_not

    @vm_name_not.setter
    def vm_name_not(self, vm_name_not):
        """Sets the vm_name_not of this ReplicationRestorePointWhereInput.


        :param vm_name_not: The vm_name_not of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_name_not: str
        """

        self._vm_name_not = vm_name_not

    @property
    def vm_name_not_contains(self):
        """Gets the vm_name_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_not_contains

    @vm_name_not_contains.setter
    def vm_name_not_contains(self, vm_name_not_contains):
        """Sets the vm_name_not_contains of this ReplicationRestorePointWhereInput.


        :param vm_name_not_contains: The vm_name_not_contains of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_name_not_contains: str
        """

        self._vm_name_not_contains = vm_name_not_contains

    @property
    def vm_name_not_ends_with(self):
        """Gets the vm_name_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_not_ends_with

    @vm_name_not_ends_with.setter
    def vm_name_not_ends_with(self, vm_name_not_ends_with):
        """Sets the vm_name_not_ends_with of this ReplicationRestorePointWhereInput.


        :param vm_name_not_ends_with: The vm_name_not_ends_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_name_not_ends_with: str
        """

        self._vm_name_not_ends_with = vm_name_not_ends_with

    @property
    def vm_name_not_in(self):
        """Gets the vm_name_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._vm_name_not_in

    @vm_name_not_in.setter
    def vm_name_not_in(self, vm_name_not_in):
        """Sets the vm_name_not_in of this ReplicationRestorePointWhereInput.


        :param vm_name_not_in: The vm_name_not_in of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_name_not_in: list[str]
        """

        self._vm_name_not_in = vm_name_not_in

    @property
    def vm_name_not_starts_with(self):
        """Gets the vm_name_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_not_starts_with

    @vm_name_not_starts_with.setter
    def vm_name_not_starts_with(self, vm_name_not_starts_with):
        """Sets the vm_name_not_starts_with of this ReplicationRestorePointWhereInput.


        :param vm_name_not_starts_with: The vm_name_not_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_name_not_starts_with: str
        """

        self._vm_name_not_starts_with = vm_name_not_starts_with

    @property
    def vm_name_starts_with(self):
        """Gets the vm_name_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_starts_with

    @vm_name_starts_with.setter
    def vm_name_starts_with(self, vm_name_starts_with):
        """Sets the vm_name_starts_with of this ReplicationRestorePointWhereInput.


        :param vm_name_starts_with: The vm_name_starts_with of this ReplicationRestorePointWhereInput.  # noqa: E501
        :type vm_name_starts_with: str
        """

        self._vm_name_starts_with = vm_name_starts_with

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReplicationRestorePointWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ReplicationRestorePointWhereInput):
            return True

        return self.to_dict() != other.to_dict()
