# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ReplicationService(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'application': 'NestedCloudTowerApplication',
        'created_at': 'str',
        'description': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'failover_executions': 'list[NestedFailoverExecution]',
        'id': 'str',
        'kube_config': 'str',
        'management_network': 'NestedReplicationServiceNetwork',
        'max_failback_jobs': 'int',
        'max_failback_speed_limit': 'float',
        'max_replication_jobs': 'int',
        'max_replication_speed_limit': 'float',
        'max_retry_times': 'int',
        'name': 'str',
        'permanent_failover_execution': 'list[NestedPermanentFailoverExecution]',
        'replication_clusters': 'list[NestedCluster]',
        'replication_clusters_descriptor': 'list[NestedReplicationClusterDescriptor]',
        'replication_network': 'NestedReplicationServiceNetwork',
        'replication_plans': 'list[NestedReplicationPlan]',
        'retry_interval': 'int',
        'storage_network': 'NestedReplicationServiceNetwork',
        'updated_at': 'str'
    }

    attribute_map = {
        'application': 'application',
        'created_at': 'createdAt',
        'description': 'description',
        'entity_async_status': 'entityAsyncStatus',
        'failover_executions': 'failover_executions',
        'id': 'id',
        'kube_config': 'kube_config',
        'management_network': 'management_network',
        'max_failback_jobs': 'max_failback_jobs',
        'max_failback_speed_limit': 'max_failback_speed_limit',
        'max_replication_jobs': 'max_replication_jobs',
        'max_replication_speed_limit': 'max_replication_speed_limit',
        'max_retry_times': 'max_retry_times',
        'name': 'name',
        'permanent_failover_execution': 'permanent_failover_execution',
        'replication_clusters': 'replication_clusters',
        'replication_clusters_descriptor': 'replication_clusters_descriptor',
        'replication_network': 'replication_network',
        'replication_plans': 'replication_plans',
        'retry_interval': 'retry_interval',
        'storage_network': 'storage_network',
        'updated_at': 'updatedAt'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ReplicationService - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._application = None
        self._created_at = None
        self._description = None
        self._entity_async_status = None
        self._failover_executions = None
        self._id = None
        self._kube_config = None
        self._management_network = None
        self._max_failback_jobs = None
        self._max_failback_speed_limit = None
        self._max_replication_jobs = None
        self._max_replication_speed_limit = None
        self._max_retry_times = None
        self._name = None
        self._permanent_failover_execution = None
        self._replication_clusters = None
        self._replication_clusters_descriptor = None
        self._replication_network = None
        self._replication_plans = None
        self._retry_interval = None
        self._storage_network = None
        self._updated_at = None
        self.discriminator = None

        self.application = kwargs.get("application", None)
        if "created_at" in kwargs:
            self.created_at = kwargs["created_at"]
        self.description = kwargs.get("description", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.failover_executions = kwargs.get("failover_executions", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "kube_config" in kwargs:
            self.kube_config = kwargs["kube_config"]
        if "management_network" in kwargs:
            self.management_network = kwargs["management_network"]
        self.max_failback_jobs = kwargs.get("max_failback_jobs", None)
        self.max_failback_speed_limit = kwargs.get("max_failback_speed_limit", None)
        self.max_replication_jobs = kwargs.get("max_replication_jobs", None)
        self.max_replication_speed_limit = kwargs.get("max_replication_speed_limit", None)
        self.max_retry_times = kwargs.get("max_retry_times", None)
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.permanent_failover_execution = kwargs.get("permanent_failover_execution", None)
        self.replication_clusters = kwargs.get("replication_clusters", None)
        if "replication_clusters_descriptor" in kwargs:
            self.replication_clusters_descriptor = kwargs["replication_clusters_descriptor"]
        if "replication_network" in kwargs:
            self.replication_network = kwargs["replication_network"]
        self.replication_plans = kwargs.get("replication_plans", None)
        self.retry_interval = kwargs.get("retry_interval", None)
        if "storage_network" in kwargs:
            self.storage_network = kwargs["storage_network"]
        if "updated_at" in kwargs:
            self.updated_at = kwargs["updated_at"]

    @property
    def application(self):
        """Gets the application of this ReplicationService.  # noqa: E501


        :return: The application of this ReplicationService.  # noqa: E501
        :rtype: NestedCloudTowerApplication
        """
        return self._application

    @application.setter
    def application(self, application):
        """Sets the application of this ReplicationService.


        :param application: The application of this ReplicationService.  # noqa: E501
        :type application: NestedCloudTowerApplication
        """

        self._application = application

    @property
    def created_at(self):
        """Gets the created_at of this ReplicationService.  # noqa: E501


        :return: The created_at of this ReplicationService.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ReplicationService.


        :param created_at: The created_at of this ReplicationService.  # noqa: E501
        :type created_at: str
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def description(self):
        """Gets the description of this ReplicationService.  # noqa: E501


        :return: The description of this ReplicationService.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ReplicationService.


        :param description: The description of this ReplicationService.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this ReplicationService.  # noqa: E501


        :return: The entity_async_status of this ReplicationService.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this ReplicationService.


        :param entity_async_status: The entity_async_status of this ReplicationService.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def failover_executions(self):
        """Gets the failover_executions of this ReplicationService.  # noqa: E501


        :return: The failover_executions of this ReplicationService.  # noqa: E501
        :rtype: list[NestedFailoverExecution]
        """
        return self._failover_executions

    @failover_executions.setter
    def failover_executions(self, failover_executions):
        """Sets the failover_executions of this ReplicationService.


        :param failover_executions: The failover_executions of this ReplicationService.  # noqa: E501
        :type failover_executions: list[NestedFailoverExecution]
        """

        self._failover_executions = failover_executions

    @property
    def id(self):
        """Gets the id of this ReplicationService.  # noqa: E501


        :return: The id of this ReplicationService.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ReplicationService.


        :param id: The id of this ReplicationService.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def kube_config(self):
        """Gets the kube_config of this ReplicationService.  # noqa: E501


        :return: The kube_config of this ReplicationService.  # noqa: E501
        :rtype: str
        """
        return self._kube_config

    @kube_config.setter
    def kube_config(self, kube_config):
        """Sets the kube_config of this ReplicationService.


        :param kube_config: The kube_config of this ReplicationService.  # noqa: E501
        :type kube_config: str
        """
        if self.local_vars_configuration.client_side_validation and kube_config is None:  # noqa: E501
            raise ValueError("Invalid value for `kube_config`, must not be `None`")  # noqa: E501

        self._kube_config = kube_config

    @property
    def management_network(self):
        """Gets the management_network of this ReplicationService.  # noqa: E501


        :return: The management_network of this ReplicationService.  # noqa: E501
        :rtype: NestedReplicationServiceNetwork
        """
        return self._management_network

    @management_network.setter
    def management_network(self, management_network):
        """Sets the management_network of this ReplicationService.


        :param management_network: The management_network of this ReplicationService.  # noqa: E501
        :type management_network: NestedReplicationServiceNetwork
        """
        if self.local_vars_configuration.client_side_validation and management_network is None:  # noqa: E501
            raise ValueError("Invalid value for `management_network`, must not be `None`")  # noqa: E501

        self._management_network = management_network

    @property
    def max_failback_jobs(self):
        """Gets the max_failback_jobs of this ReplicationService.  # noqa: E501


        :return: The max_failback_jobs of this ReplicationService.  # noqa: E501
        :rtype: int
        """
        return self._max_failback_jobs

    @max_failback_jobs.setter
    def max_failback_jobs(self, max_failback_jobs):
        """Sets the max_failback_jobs of this ReplicationService.


        :param max_failback_jobs: The max_failback_jobs of this ReplicationService.  # noqa: E501
        :type max_failback_jobs: int
        """

        self._max_failback_jobs = max_failback_jobs

    @property
    def max_failback_speed_limit(self):
        """Gets the max_failback_speed_limit of this ReplicationService.  # noqa: E501


        :return: The max_failback_speed_limit of this ReplicationService.  # noqa: E501
        :rtype: float
        """
        return self._max_failback_speed_limit

    @max_failback_speed_limit.setter
    def max_failback_speed_limit(self, max_failback_speed_limit):
        """Sets the max_failback_speed_limit of this ReplicationService.


        :param max_failback_speed_limit: The max_failback_speed_limit of this ReplicationService.  # noqa: E501
        :type max_failback_speed_limit: float
        """

        self._max_failback_speed_limit = max_failback_speed_limit

    @property
    def max_replication_jobs(self):
        """Gets the max_replication_jobs of this ReplicationService.  # noqa: E501


        :return: The max_replication_jobs of this ReplicationService.  # noqa: E501
        :rtype: int
        """
        return self._max_replication_jobs

    @max_replication_jobs.setter
    def max_replication_jobs(self, max_replication_jobs):
        """Sets the max_replication_jobs of this ReplicationService.


        :param max_replication_jobs: The max_replication_jobs of this ReplicationService.  # noqa: E501
        :type max_replication_jobs: int
        """

        self._max_replication_jobs = max_replication_jobs

    @property
    def max_replication_speed_limit(self):
        """Gets the max_replication_speed_limit of this ReplicationService.  # noqa: E501


        :return: The max_replication_speed_limit of this ReplicationService.  # noqa: E501
        :rtype: float
        """
        return self._max_replication_speed_limit

    @max_replication_speed_limit.setter
    def max_replication_speed_limit(self, max_replication_speed_limit):
        """Sets the max_replication_speed_limit of this ReplicationService.


        :param max_replication_speed_limit: The max_replication_speed_limit of this ReplicationService.  # noqa: E501
        :type max_replication_speed_limit: float
        """

        self._max_replication_speed_limit = max_replication_speed_limit

    @property
    def max_retry_times(self):
        """Gets the max_retry_times of this ReplicationService.  # noqa: E501


        :return: The max_retry_times of this ReplicationService.  # noqa: E501
        :rtype: int
        """
        return self._max_retry_times

    @max_retry_times.setter
    def max_retry_times(self, max_retry_times):
        """Sets the max_retry_times of this ReplicationService.


        :param max_retry_times: The max_retry_times of this ReplicationService.  # noqa: E501
        :type max_retry_times: int
        """

        self._max_retry_times = max_retry_times

    @property
    def name(self):
        """Gets the name of this ReplicationService.  # noqa: E501


        :return: The name of this ReplicationService.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ReplicationService.


        :param name: The name of this ReplicationService.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def permanent_failover_execution(self):
        """Gets the permanent_failover_execution of this ReplicationService.  # noqa: E501


        :return: The permanent_failover_execution of this ReplicationService.  # noqa: E501
        :rtype: list[NestedPermanentFailoverExecution]
        """
        return self._permanent_failover_execution

    @permanent_failover_execution.setter
    def permanent_failover_execution(self, permanent_failover_execution):
        """Sets the permanent_failover_execution of this ReplicationService.


        :param permanent_failover_execution: The permanent_failover_execution of this ReplicationService.  # noqa: E501
        :type permanent_failover_execution: list[NestedPermanentFailoverExecution]
        """

        self._permanent_failover_execution = permanent_failover_execution

    @property
    def replication_clusters(self):
        """Gets the replication_clusters of this ReplicationService.  # noqa: E501


        :return: The replication_clusters of this ReplicationService.  # noqa: E501
        :rtype: list[NestedCluster]
        """
        return self._replication_clusters

    @replication_clusters.setter
    def replication_clusters(self, replication_clusters):
        """Sets the replication_clusters of this ReplicationService.


        :param replication_clusters: The replication_clusters of this ReplicationService.  # noqa: E501
        :type replication_clusters: list[NestedCluster]
        """

        self._replication_clusters = replication_clusters

    @property
    def replication_clusters_descriptor(self):
        """Gets the replication_clusters_descriptor of this ReplicationService.  # noqa: E501


        :return: The replication_clusters_descriptor of this ReplicationService.  # noqa: E501
        :rtype: list[NestedReplicationClusterDescriptor]
        """
        return self._replication_clusters_descriptor

    @replication_clusters_descriptor.setter
    def replication_clusters_descriptor(self, replication_clusters_descriptor):
        """Sets the replication_clusters_descriptor of this ReplicationService.


        :param replication_clusters_descriptor: The replication_clusters_descriptor of this ReplicationService.  # noqa: E501
        :type replication_clusters_descriptor: list[NestedReplicationClusterDescriptor]
        """
        if self.local_vars_configuration.client_side_validation and replication_clusters_descriptor is None:  # noqa: E501
            raise ValueError("Invalid value for `replication_clusters_descriptor`, must not be `None`")  # noqa: E501

        self._replication_clusters_descriptor = replication_clusters_descriptor

    @property
    def replication_network(self):
        """Gets the replication_network of this ReplicationService.  # noqa: E501


        :return: The replication_network of this ReplicationService.  # noqa: E501
        :rtype: NestedReplicationServiceNetwork
        """
        return self._replication_network

    @replication_network.setter
    def replication_network(self, replication_network):
        """Sets the replication_network of this ReplicationService.


        :param replication_network: The replication_network of this ReplicationService.  # noqa: E501
        :type replication_network: NestedReplicationServiceNetwork
        """
        if self.local_vars_configuration.client_side_validation and replication_network is None:  # noqa: E501
            raise ValueError("Invalid value for `replication_network`, must not be `None`")  # noqa: E501

        self._replication_network = replication_network

    @property
    def replication_plans(self):
        """Gets the replication_plans of this ReplicationService.  # noqa: E501


        :return: The replication_plans of this ReplicationService.  # noqa: E501
        :rtype: list[NestedReplicationPlan]
        """
        return self._replication_plans

    @replication_plans.setter
    def replication_plans(self, replication_plans):
        """Sets the replication_plans of this ReplicationService.


        :param replication_plans: The replication_plans of this ReplicationService.  # noqa: E501
        :type replication_plans: list[NestedReplicationPlan]
        """

        self._replication_plans = replication_plans

    @property
    def retry_interval(self):
        """Gets the retry_interval of this ReplicationService.  # noqa: E501


        :return: The retry_interval of this ReplicationService.  # noqa: E501
        :rtype: int
        """
        return self._retry_interval

    @retry_interval.setter
    def retry_interval(self, retry_interval):
        """Sets the retry_interval of this ReplicationService.


        :param retry_interval: The retry_interval of this ReplicationService.  # noqa: E501
        :type retry_interval: int
        """

        self._retry_interval = retry_interval

    @property
    def storage_network(self):
        """Gets the storage_network of this ReplicationService.  # noqa: E501


        :return: The storage_network of this ReplicationService.  # noqa: E501
        :rtype: NestedReplicationServiceNetwork
        """
        return self._storage_network

    @storage_network.setter
    def storage_network(self, storage_network):
        """Sets the storage_network of this ReplicationService.


        :param storage_network: The storage_network of this ReplicationService.  # noqa: E501
        :type storage_network: NestedReplicationServiceNetwork
        """
        if self.local_vars_configuration.client_side_validation and storage_network is None:  # noqa: E501
            raise ValueError("Invalid value for `storage_network`, must not be `None`")  # noqa: E501

        self._storage_network = storage_network

    @property
    def updated_at(self):
        """Gets the updated_at of this ReplicationService.  # noqa: E501


        :return: The updated_at of this ReplicationService.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this ReplicationService.


        :param updated_at: The updated_at of this ReplicationService.  # noqa: E501
        :type updated_at: str
        """
        if self.local_vars_configuration.client_side_validation and updated_at is None:  # noqa: E501
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501

        self._updated_at = updated_at

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReplicationService):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ReplicationService):
            return True

        return self.to_dict() != other.to_dict()
