# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ReplicationServiceWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[ReplicationServiceWhereInput]',
        '_not': 'list[ReplicationServiceWhereInput]',
        '_or': 'list[ReplicationServiceWhereInput]',
        'application': 'CloudTowerApplicationWhereInput',
        'created_at': 'str',
        'created_at_gt': 'str',
        'created_at_gte': 'str',
        'created_at_in': 'list[str]',
        'created_at_lt': 'str',
        'created_at_lte': 'str',
        'created_at_not': 'str',
        'created_at_not_in': 'list[str]',
        'description': 'str',
        'description_contains': 'str',
        'description_ends_with': 'str',
        'description_gt': 'str',
        'description_gte': 'str',
        'description_in': 'list[str]',
        'description_lt': 'str',
        'description_lte': 'str',
        'description_not': 'str',
        'description_not_contains': 'str',
        'description_not_ends_with': 'str',
        'description_not_in': 'list[str]',
        'description_not_starts_with': 'str',
        'description_starts_with': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'failover_executions_every': 'FailoverExecutionWhereInput',
        'failover_executions_none': 'FailoverExecutionWhereInput',
        'failover_executions_some': 'FailoverExecutionWhereInput',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'kube_config': 'str',
        'kube_config_contains': 'str',
        'kube_config_ends_with': 'str',
        'kube_config_gt': 'str',
        'kube_config_gte': 'str',
        'kube_config_in': 'list[str]',
        'kube_config_lt': 'str',
        'kube_config_lte': 'str',
        'kube_config_not': 'str',
        'kube_config_not_contains': 'str',
        'kube_config_not_ends_with': 'str',
        'kube_config_not_in': 'list[str]',
        'kube_config_not_starts_with': 'str',
        'kube_config_starts_with': 'str',
        'max_failback_jobs': 'int',
        'max_failback_jobs_gt': 'int',
        'max_failback_jobs_gte': 'int',
        'max_failback_jobs_in': 'list[int]',
        'max_failback_jobs_lt': 'int',
        'max_failback_jobs_lte': 'int',
        'max_failback_jobs_not': 'int',
        'max_failback_jobs_not_in': 'list[int]',
        'max_failback_speed_limit': 'float',
        'max_failback_speed_limit_gt': 'float',
        'max_failback_speed_limit_gte': 'float',
        'max_failback_speed_limit_in': 'list[float]',
        'max_failback_speed_limit_lt': 'float',
        'max_failback_speed_limit_lte': 'float',
        'max_failback_speed_limit_not': 'float',
        'max_failback_speed_limit_not_in': 'list[float]',
        'max_replication_jobs': 'int',
        'max_replication_jobs_gt': 'int',
        'max_replication_jobs_gte': 'int',
        'max_replication_jobs_in': 'list[int]',
        'max_replication_jobs_lt': 'int',
        'max_replication_jobs_lte': 'int',
        'max_replication_jobs_not': 'int',
        'max_replication_jobs_not_in': 'list[int]',
        'max_replication_speed_limit': 'float',
        'max_replication_speed_limit_gt': 'float',
        'max_replication_speed_limit_gte': 'float',
        'max_replication_speed_limit_in': 'list[float]',
        'max_replication_speed_limit_lt': 'float',
        'max_replication_speed_limit_lte': 'float',
        'max_replication_speed_limit_not': 'float',
        'max_replication_speed_limit_not_in': 'list[float]',
        'max_retry_times': 'int',
        'max_retry_times_gt': 'int',
        'max_retry_times_gte': 'int',
        'max_retry_times_in': 'list[int]',
        'max_retry_times_lt': 'int',
        'max_retry_times_lte': 'int',
        'max_retry_times_not': 'int',
        'max_retry_times_not_in': 'list[int]',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'permanent_failover_execution_every': 'PermanentFailoverExecutionWhereInput',
        'permanent_failover_execution_none': 'PermanentFailoverExecutionWhereInput',
        'permanent_failover_execution_some': 'PermanentFailoverExecutionWhereInput',
        'replication_clusters_every': 'ClusterWhereInput',
        'replication_clusters_none': 'ClusterWhereInput',
        'replication_clusters_some': 'ClusterWhereInput',
        'replication_plans_every': 'ReplicationPlanWhereInput',
        'replication_plans_none': 'ReplicationPlanWhereInput',
        'replication_plans_some': 'ReplicationPlanWhereInput',
        'retry_interval': 'int',
        'retry_interval_gt': 'int',
        'retry_interval_gte': 'int',
        'retry_interval_in': 'list[int]',
        'retry_interval_lt': 'int',
        'retry_interval_lte': 'int',
        'retry_interval_not': 'int',
        'retry_interval_not_in': 'list[int]',
        'updated_at': 'str',
        'updated_at_gt': 'str',
        'updated_at_gte': 'str',
        'updated_at_in': 'list[str]',
        'updated_at_lt': 'str',
        'updated_at_lte': 'str',
        'updated_at_not': 'str',
        'updated_at_not_in': 'list[str]'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'application': 'application',
        'created_at': 'createdAt',
        'created_at_gt': 'createdAt_gt',
        'created_at_gte': 'createdAt_gte',
        'created_at_in': 'createdAt_in',
        'created_at_lt': 'createdAt_lt',
        'created_at_lte': 'createdAt_lte',
        'created_at_not': 'createdAt_not',
        'created_at_not_in': 'createdAt_not_in',
        'description': 'description',
        'description_contains': 'description_contains',
        'description_ends_with': 'description_ends_with',
        'description_gt': 'description_gt',
        'description_gte': 'description_gte',
        'description_in': 'description_in',
        'description_lt': 'description_lt',
        'description_lte': 'description_lte',
        'description_not': 'description_not',
        'description_not_contains': 'description_not_contains',
        'description_not_ends_with': 'description_not_ends_with',
        'description_not_in': 'description_not_in',
        'description_not_starts_with': 'description_not_starts_with',
        'description_starts_with': 'description_starts_with',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'failover_executions_every': 'failover_executions_every',
        'failover_executions_none': 'failover_executions_none',
        'failover_executions_some': 'failover_executions_some',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'kube_config': 'kube_config',
        'kube_config_contains': 'kube_config_contains',
        'kube_config_ends_with': 'kube_config_ends_with',
        'kube_config_gt': 'kube_config_gt',
        'kube_config_gte': 'kube_config_gte',
        'kube_config_in': 'kube_config_in',
        'kube_config_lt': 'kube_config_lt',
        'kube_config_lte': 'kube_config_lte',
        'kube_config_not': 'kube_config_not',
        'kube_config_not_contains': 'kube_config_not_contains',
        'kube_config_not_ends_with': 'kube_config_not_ends_with',
        'kube_config_not_in': 'kube_config_not_in',
        'kube_config_not_starts_with': 'kube_config_not_starts_with',
        'kube_config_starts_with': 'kube_config_starts_with',
        'max_failback_jobs': 'max_failback_jobs',
        'max_failback_jobs_gt': 'max_failback_jobs_gt',
        'max_failback_jobs_gte': 'max_failback_jobs_gte',
        'max_failback_jobs_in': 'max_failback_jobs_in',
        'max_failback_jobs_lt': 'max_failback_jobs_lt',
        'max_failback_jobs_lte': 'max_failback_jobs_lte',
        'max_failback_jobs_not': 'max_failback_jobs_not',
        'max_failback_jobs_not_in': 'max_failback_jobs_not_in',
        'max_failback_speed_limit': 'max_failback_speed_limit',
        'max_failback_speed_limit_gt': 'max_failback_speed_limit_gt',
        'max_failback_speed_limit_gte': 'max_failback_speed_limit_gte',
        'max_failback_speed_limit_in': 'max_failback_speed_limit_in',
        'max_failback_speed_limit_lt': 'max_failback_speed_limit_lt',
        'max_failback_speed_limit_lte': 'max_failback_speed_limit_lte',
        'max_failback_speed_limit_not': 'max_failback_speed_limit_not',
        'max_failback_speed_limit_not_in': 'max_failback_speed_limit_not_in',
        'max_replication_jobs': 'max_replication_jobs',
        'max_replication_jobs_gt': 'max_replication_jobs_gt',
        'max_replication_jobs_gte': 'max_replication_jobs_gte',
        'max_replication_jobs_in': 'max_replication_jobs_in',
        'max_replication_jobs_lt': 'max_replication_jobs_lt',
        'max_replication_jobs_lte': 'max_replication_jobs_lte',
        'max_replication_jobs_not': 'max_replication_jobs_not',
        'max_replication_jobs_not_in': 'max_replication_jobs_not_in',
        'max_replication_speed_limit': 'max_replication_speed_limit',
        'max_replication_speed_limit_gt': 'max_replication_speed_limit_gt',
        'max_replication_speed_limit_gte': 'max_replication_speed_limit_gte',
        'max_replication_speed_limit_in': 'max_replication_speed_limit_in',
        'max_replication_speed_limit_lt': 'max_replication_speed_limit_lt',
        'max_replication_speed_limit_lte': 'max_replication_speed_limit_lte',
        'max_replication_speed_limit_not': 'max_replication_speed_limit_not',
        'max_replication_speed_limit_not_in': 'max_replication_speed_limit_not_in',
        'max_retry_times': 'max_retry_times',
        'max_retry_times_gt': 'max_retry_times_gt',
        'max_retry_times_gte': 'max_retry_times_gte',
        'max_retry_times_in': 'max_retry_times_in',
        'max_retry_times_lt': 'max_retry_times_lt',
        'max_retry_times_lte': 'max_retry_times_lte',
        'max_retry_times_not': 'max_retry_times_not',
        'max_retry_times_not_in': 'max_retry_times_not_in',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'permanent_failover_execution_every': 'permanent_failover_execution_every',
        'permanent_failover_execution_none': 'permanent_failover_execution_none',
        'permanent_failover_execution_some': 'permanent_failover_execution_some',
        'replication_clusters_every': 'replication_clusters_every',
        'replication_clusters_none': 'replication_clusters_none',
        'replication_clusters_some': 'replication_clusters_some',
        'replication_plans_every': 'replication_plans_every',
        'replication_plans_none': 'replication_plans_none',
        'replication_plans_some': 'replication_plans_some',
        'retry_interval': 'retry_interval',
        'retry_interval_gt': 'retry_interval_gt',
        'retry_interval_gte': 'retry_interval_gte',
        'retry_interval_in': 'retry_interval_in',
        'retry_interval_lt': 'retry_interval_lt',
        'retry_interval_lte': 'retry_interval_lte',
        'retry_interval_not': 'retry_interval_not',
        'retry_interval_not_in': 'retry_interval_not_in',
        'updated_at': 'updatedAt',
        'updated_at_gt': 'updatedAt_gt',
        'updated_at_gte': 'updatedAt_gte',
        'updated_at_in': 'updatedAt_in',
        'updated_at_lt': 'updatedAt_lt',
        'updated_at_lte': 'updatedAt_lte',
        'updated_at_not': 'updatedAt_not',
        'updated_at_not_in': 'updatedAt_not_in'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ReplicationServiceWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._application = None
        self._created_at = None
        self._created_at_gt = None
        self._created_at_gte = None
        self._created_at_in = None
        self._created_at_lt = None
        self._created_at_lte = None
        self._created_at_not = None
        self._created_at_not_in = None
        self._description = None
        self._description_contains = None
        self._description_ends_with = None
        self._description_gt = None
        self._description_gte = None
        self._description_in = None
        self._description_lt = None
        self._description_lte = None
        self._description_not = None
        self._description_not_contains = None
        self._description_not_ends_with = None
        self._description_not_in = None
        self._description_not_starts_with = None
        self._description_starts_with = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._failover_executions_every = None
        self._failover_executions_none = None
        self._failover_executions_some = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._kube_config = None
        self._kube_config_contains = None
        self._kube_config_ends_with = None
        self._kube_config_gt = None
        self._kube_config_gte = None
        self._kube_config_in = None
        self._kube_config_lt = None
        self._kube_config_lte = None
        self._kube_config_not = None
        self._kube_config_not_contains = None
        self._kube_config_not_ends_with = None
        self._kube_config_not_in = None
        self._kube_config_not_starts_with = None
        self._kube_config_starts_with = None
        self._max_failback_jobs = None
        self._max_failback_jobs_gt = None
        self._max_failback_jobs_gte = None
        self._max_failback_jobs_in = None
        self._max_failback_jobs_lt = None
        self._max_failback_jobs_lte = None
        self._max_failback_jobs_not = None
        self._max_failback_jobs_not_in = None
        self._max_failback_speed_limit = None
        self._max_failback_speed_limit_gt = None
        self._max_failback_speed_limit_gte = None
        self._max_failback_speed_limit_in = None
        self._max_failback_speed_limit_lt = None
        self._max_failback_speed_limit_lte = None
        self._max_failback_speed_limit_not = None
        self._max_failback_speed_limit_not_in = None
        self._max_replication_jobs = None
        self._max_replication_jobs_gt = None
        self._max_replication_jobs_gte = None
        self._max_replication_jobs_in = None
        self._max_replication_jobs_lt = None
        self._max_replication_jobs_lte = None
        self._max_replication_jobs_not = None
        self._max_replication_jobs_not_in = None
        self._max_replication_speed_limit = None
        self._max_replication_speed_limit_gt = None
        self._max_replication_speed_limit_gte = None
        self._max_replication_speed_limit_in = None
        self._max_replication_speed_limit_lt = None
        self._max_replication_speed_limit_lte = None
        self._max_replication_speed_limit_not = None
        self._max_replication_speed_limit_not_in = None
        self._max_retry_times = None
        self._max_retry_times_gt = None
        self._max_retry_times_gte = None
        self._max_retry_times_in = None
        self._max_retry_times_lt = None
        self._max_retry_times_lte = None
        self._max_retry_times_not = None
        self._max_retry_times_not_in = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._permanent_failover_execution_every = None
        self._permanent_failover_execution_none = None
        self._permanent_failover_execution_some = None
        self._replication_clusters_every = None
        self._replication_clusters_none = None
        self._replication_clusters_some = None
        self._replication_plans_every = None
        self._replication_plans_none = None
        self._replication_plans_some = None
        self._retry_interval = None
        self._retry_interval_gt = None
        self._retry_interval_gte = None
        self._retry_interval_in = None
        self._retry_interval_lt = None
        self._retry_interval_lte = None
        self._retry_interval_not = None
        self._retry_interval_not_in = None
        self._updated_at = None
        self._updated_at_gt = None
        self._updated_at_gte = None
        self._updated_at_in = None
        self._updated_at_lt = None
        self._updated_at_lte = None
        self._updated_at_not = None
        self._updated_at_not_in = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.application = kwargs.get("application", None)
        self.created_at = kwargs.get("created_at", None)
        self.created_at_gt = kwargs.get("created_at_gt", None)
        self.created_at_gte = kwargs.get("created_at_gte", None)
        self.created_at_in = kwargs.get("created_at_in", None)
        self.created_at_lt = kwargs.get("created_at_lt", None)
        self.created_at_lte = kwargs.get("created_at_lte", None)
        self.created_at_not = kwargs.get("created_at_not", None)
        self.created_at_not_in = kwargs.get("created_at_not_in", None)
        self.description = kwargs.get("description", None)
        self.description_contains = kwargs.get("description_contains", None)
        self.description_ends_with = kwargs.get("description_ends_with", None)
        self.description_gt = kwargs.get("description_gt", None)
        self.description_gte = kwargs.get("description_gte", None)
        self.description_in = kwargs.get("description_in", None)
        self.description_lt = kwargs.get("description_lt", None)
        self.description_lte = kwargs.get("description_lte", None)
        self.description_not = kwargs.get("description_not", None)
        self.description_not_contains = kwargs.get("description_not_contains", None)
        self.description_not_ends_with = kwargs.get("description_not_ends_with", None)
        self.description_not_in = kwargs.get("description_not_in", None)
        self.description_not_starts_with = kwargs.get("description_not_starts_with", None)
        self.description_starts_with = kwargs.get("description_starts_with", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.failover_executions_every = kwargs.get("failover_executions_every", None)
        self.failover_executions_none = kwargs.get("failover_executions_none", None)
        self.failover_executions_some = kwargs.get("failover_executions_some", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.kube_config = kwargs.get("kube_config", None)
        self.kube_config_contains = kwargs.get("kube_config_contains", None)
        self.kube_config_ends_with = kwargs.get("kube_config_ends_with", None)
        self.kube_config_gt = kwargs.get("kube_config_gt", None)
        self.kube_config_gte = kwargs.get("kube_config_gte", None)
        self.kube_config_in = kwargs.get("kube_config_in", None)
        self.kube_config_lt = kwargs.get("kube_config_lt", None)
        self.kube_config_lte = kwargs.get("kube_config_lte", None)
        self.kube_config_not = kwargs.get("kube_config_not", None)
        self.kube_config_not_contains = kwargs.get("kube_config_not_contains", None)
        self.kube_config_not_ends_with = kwargs.get("kube_config_not_ends_with", None)
        self.kube_config_not_in = kwargs.get("kube_config_not_in", None)
        self.kube_config_not_starts_with = kwargs.get("kube_config_not_starts_with", None)
        self.kube_config_starts_with = kwargs.get("kube_config_starts_with", None)
        self.max_failback_jobs = kwargs.get("max_failback_jobs", None)
        self.max_failback_jobs_gt = kwargs.get("max_failback_jobs_gt", None)
        self.max_failback_jobs_gte = kwargs.get("max_failback_jobs_gte", None)
        self.max_failback_jobs_in = kwargs.get("max_failback_jobs_in", None)
        self.max_failback_jobs_lt = kwargs.get("max_failback_jobs_lt", None)
        self.max_failback_jobs_lte = kwargs.get("max_failback_jobs_lte", None)
        self.max_failback_jobs_not = kwargs.get("max_failback_jobs_not", None)
        self.max_failback_jobs_not_in = kwargs.get("max_failback_jobs_not_in", None)
        self.max_failback_speed_limit = kwargs.get("max_failback_speed_limit", None)
        self.max_failback_speed_limit_gt = kwargs.get("max_failback_speed_limit_gt", None)
        self.max_failback_speed_limit_gte = kwargs.get("max_failback_speed_limit_gte", None)
        self.max_failback_speed_limit_in = kwargs.get("max_failback_speed_limit_in", None)
        self.max_failback_speed_limit_lt = kwargs.get("max_failback_speed_limit_lt", None)
        self.max_failback_speed_limit_lte = kwargs.get("max_failback_speed_limit_lte", None)
        self.max_failback_speed_limit_not = kwargs.get("max_failback_speed_limit_not", None)
        self.max_failback_speed_limit_not_in = kwargs.get("max_failback_speed_limit_not_in", None)
        self.max_replication_jobs = kwargs.get("max_replication_jobs", None)
        self.max_replication_jobs_gt = kwargs.get("max_replication_jobs_gt", None)
        self.max_replication_jobs_gte = kwargs.get("max_replication_jobs_gte", None)
        self.max_replication_jobs_in = kwargs.get("max_replication_jobs_in", None)
        self.max_replication_jobs_lt = kwargs.get("max_replication_jobs_lt", None)
        self.max_replication_jobs_lte = kwargs.get("max_replication_jobs_lte", None)
        self.max_replication_jobs_not = kwargs.get("max_replication_jobs_not", None)
        self.max_replication_jobs_not_in = kwargs.get("max_replication_jobs_not_in", None)
        self.max_replication_speed_limit = kwargs.get("max_replication_speed_limit", None)
        self.max_replication_speed_limit_gt = kwargs.get("max_replication_speed_limit_gt", None)
        self.max_replication_speed_limit_gte = kwargs.get("max_replication_speed_limit_gte", None)
        self.max_replication_speed_limit_in = kwargs.get("max_replication_speed_limit_in", None)
        self.max_replication_speed_limit_lt = kwargs.get("max_replication_speed_limit_lt", None)
        self.max_replication_speed_limit_lte = kwargs.get("max_replication_speed_limit_lte", None)
        self.max_replication_speed_limit_not = kwargs.get("max_replication_speed_limit_not", None)
        self.max_replication_speed_limit_not_in = kwargs.get("max_replication_speed_limit_not_in", None)
        self.max_retry_times = kwargs.get("max_retry_times", None)
        self.max_retry_times_gt = kwargs.get("max_retry_times_gt", None)
        self.max_retry_times_gte = kwargs.get("max_retry_times_gte", None)
        self.max_retry_times_in = kwargs.get("max_retry_times_in", None)
        self.max_retry_times_lt = kwargs.get("max_retry_times_lt", None)
        self.max_retry_times_lte = kwargs.get("max_retry_times_lte", None)
        self.max_retry_times_not = kwargs.get("max_retry_times_not", None)
        self.max_retry_times_not_in = kwargs.get("max_retry_times_not_in", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.permanent_failover_execution_every = kwargs.get("permanent_failover_execution_every", None)
        self.permanent_failover_execution_none = kwargs.get("permanent_failover_execution_none", None)
        self.permanent_failover_execution_some = kwargs.get("permanent_failover_execution_some", None)
        self.replication_clusters_every = kwargs.get("replication_clusters_every", None)
        self.replication_clusters_none = kwargs.get("replication_clusters_none", None)
        self.replication_clusters_some = kwargs.get("replication_clusters_some", None)
        self.replication_plans_every = kwargs.get("replication_plans_every", None)
        self.replication_plans_none = kwargs.get("replication_plans_none", None)
        self.replication_plans_some = kwargs.get("replication_plans_some", None)
        self.retry_interval = kwargs.get("retry_interval", None)
        self.retry_interval_gt = kwargs.get("retry_interval_gt", None)
        self.retry_interval_gte = kwargs.get("retry_interval_gte", None)
        self.retry_interval_in = kwargs.get("retry_interval_in", None)
        self.retry_interval_lt = kwargs.get("retry_interval_lt", None)
        self.retry_interval_lte = kwargs.get("retry_interval_lte", None)
        self.retry_interval_not = kwargs.get("retry_interval_not", None)
        self.retry_interval_not_in = kwargs.get("retry_interval_not_in", None)
        self.updated_at = kwargs.get("updated_at", None)
        self.updated_at_gt = kwargs.get("updated_at_gt", None)
        self.updated_at_gte = kwargs.get("updated_at_gte", None)
        self.updated_at_in = kwargs.get("updated_at_in", None)
        self.updated_at_lt = kwargs.get("updated_at_lt", None)
        self.updated_at_lte = kwargs.get("updated_at_lte", None)
        self.updated_at_not = kwargs.get("updated_at_not", None)
        self.updated_at_not_in = kwargs.get("updated_at_not_in", None)

    @property
    def _and(self):
        """Gets the _and of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The _and of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[ReplicationServiceWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this ReplicationServiceWhereInput.


        :param _and: The _and of this ReplicationServiceWhereInput.  # noqa: E501
        :type _and: list[ReplicationServiceWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The _not of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[ReplicationServiceWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this ReplicationServiceWhereInput.


        :param _not: The _not of this ReplicationServiceWhereInput.  # noqa: E501
        :type _not: list[ReplicationServiceWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The _or of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[ReplicationServiceWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this ReplicationServiceWhereInput.


        :param _or: The _or of this ReplicationServiceWhereInput.  # noqa: E501
        :type _or: list[ReplicationServiceWhereInput]
        """

        self.__or = _or

    @property
    def application(self):
        """Gets the application of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The application of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: CloudTowerApplicationWhereInput
        """
        return self._application

    @application.setter
    def application(self, application):
        """Sets the application of this ReplicationServiceWhereInput.


        :param application: The application of this ReplicationServiceWhereInput.  # noqa: E501
        :type application: CloudTowerApplicationWhereInput
        """

        self._application = application

    @property
    def created_at(self):
        """Gets the created_at of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The created_at of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ReplicationServiceWhereInput.


        :param created_at: The created_at of this ReplicationServiceWhereInput.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def created_at_gt(self):
        """Gets the created_at_gt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The created_at_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_gt

    @created_at_gt.setter
    def created_at_gt(self, created_at_gt):
        """Sets the created_at_gt of this ReplicationServiceWhereInput.


        :param created_at_gt: The created_at_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :type created_at_gt: str
        """

        self._created_at_gt = created_at_gt

    @property
    def created_at_gte(self):
        """Gets the created_at_gte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The created_at_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_gte

    @created_at_gte.setter
    def created_at_gte(self, created_at_gte):
        """Sets the created_at_gte of this ReplicationServiceWhereInput.


        :param created_at_gte: The created_at_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :type created_at_gte: str
        """

        self._created_at_gte = created_at_gte

    @property
    def created_at_in(self):
        """Gets the created_at_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The created_at_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._created_at_in

    @created_at_in.setter
    def created_at_in(self, created_at_in):
        """Sets the created_at_in of this ReplicationServiceWhereInput.


        :param created_at_in: The created_at_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type created_at_in: list[str]
        """

        self._created_at_in = created_at_in

    @property
    def created_at_lt(self):
        """Gets the created_at_lt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The created_at_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_lt

    @created_at_lt.setter
    def created_at_lt(self, created_at_lt):
        """Sets the created_at_lt of this ReplicationServiceWhereInput.


        :param created_at_lt: The created_at_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :type created_at_lt: str
        """

        self._created_at_lt = created_at_lt

    @property
    def created_at_lte(self):
        """Gets the created_at_lte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The created_at_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_lte

    @created_at_lte.setter
    def created_at_lte(self, created_at_lte):
        """Sets the created_at_lte of this ReplicationServiceWhereInput.


        :param created_at_lte: The created_at_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :type created_at_lte: str
        """

        self._created_at_lte = created_at_lte

    @property
    def created_at_not(self):
        """Gets the created_at_not of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The created_at_not of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_not

    @created_at_not.setter
    def created_at_not(self, created_at_not):
        """Sets the created_at_not of this ReplicationServiceWhereInput.


        :param created_at_not: The created_at_not of this ReplicationServiceWhereInput.  # noqa: E501
        :type created_at_not: str
        """

        self._created_at_not = created_at_not

    @property
    def created_at_not_in(self):
        """Gets the created_at_not_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The created_at_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._created_at_not_in

    @created_at_not_in.setter
    def created_at_not_in(self, created_at_not_in):
        """Sets the created_at_not_in of this ReplicationServiceWhereInput.


        :param created_at_not_in: The created_at_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type created_at_not_in: list[str]
        """

        self._created_at_not_in = created_at_not_in

    @property
    def description(self):
        """Gets the description of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The description of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ReplicationServiceWhereInput.


        :param description: The description of this ReplicationServiceWhereInput.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def description_contains(self):
        """Gets the description_contains of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The description_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_contains

    @description_contains.setter
    def description_contains(self, description_contains):
        """Sets the description_contains of this ReplicationServiceWhereInput.


        :param description_contains: The description_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :type description_contains: str
        """

        self._description_contains = description_contains

    @property
    def description_ends_with(self):
        """Gets the description_ends_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The description_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_ends_with

    @description_ends_with.setter
    def description_ends_with(self, description_ends_with):
        """Sets the description_ends_with of this ReplicationServiceWhereInput.


        :param description_ends_with: The description_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type description_ends_with: str
        """

        self._description_ends_with = description_ends_with

    @property
    def description_gt(self):
        """Gets the description_gt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The description_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gt

    @description_gt.setter
    def description_gt(self, description_gt):
        """Sets the description_gt of this ReplicationServiceWhereInput.


        :param description_gt: The description_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :type description_gt: str
        """

        self._description_gt = description_gt

    @property
    def description_gte(self):
        """Gets the description_gte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The description_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gte

    @description_gte.setter
    def description_gte(self, description_gte):
        """Sets the description_gte of this ReplicationServiceWhereInput.


        :param description_gte: The description_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :type description_gte: str
        """

        self._description_gte = description_gte

    @property
    def description_in(self):
        """Gets the description_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The description_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_in

    @description_in.setter
    def description_in(self, description_in):
        """Sets the description_in of this ReplicationServiceWhereInput.


        :param description_in: The description_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type description_in: list[str]
        """

        self._description_in = description_in

    @property
    def description_lt(self):
        """Gets the description_lt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The description_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lt

    @description_lt.setter
    def description_lt(self, description_lt):
        """Sets the description_lt of this ReplicationServiceWhereInput.


        :param description_lt: The description_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :type description_lt: str
        """

        self._description_lt = description_lt

    @property
    def description_lte(self):
        """Gets the description_lte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The description_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lte

    @description_lte.setter
    def description_lte(self, description_lte):
        """Sets the description_lte of this ReplicationServiceWhereInput.


        :param description_lte: The description_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :type description_lte: str
        """

        self._description_lte = description_lte

    @property
    def description_not(self):
        """Gets the description_not of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The description_not of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not

    @description_not.setter
    def description_not(self, description_not):
        """Sets the description_not of this ReplicationServiceWhereInput.


        :param description_not: The description_not of this ReplicationServiceWhereInput.  # noqa: E501
        :type description_not: str
        """

        self._description_not = description_not

    @property
    def description_not_contains(self):
        """Gets the description_not_contains of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The description_not_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_contains

    @description_not_contains.setter
    def description_not_contains(self, description_not_contains):
        """Sets the description_not_contains of this ReplicationServiceWhereInput.


        :param description_not_contains: The description_not_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :type description_not_contains: str
        """

        self._description_not_contains = description_not_contains

    @property
    def description_not_ends_with(self):
        """Gets the description_not_ends_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The description_not_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_ends_with

    @description_not_ends_with.setter
    def description_not_ends_with(self, description_not_ends_with):
        """Sets the description_not_ends_with of this ReplicationServiceWhereInput.


        :param description_not_ends_with: The description_not_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type description_not_ends_with: str
        """

        self._description_not_ends_with = description_not_ends_with

    @property
    def description_not_in(self):
        """Gets the description_not_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The description_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_not_in

    @description_not_in.setter
    def description_not_in(self, description_not_in):
        """Sets the description_not_in of this ReplicationServiceWhereInput.


        :param description_not_in: The description_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type description_not_in: list[str]
        """

        self._description_not_in = description_not_in

    @property
    def description_not_starts_with(self):
        """Gets the description_not_starts_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The description_not_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_starts_with

    @description_not_starts_with.setter
    def description_not_starts_with(self, description_not_starts_with):
        """Sets the description_not_starts_with of this ReplicationServiceWhereInput.


        :param description_not_starts_with: The description_not_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type description_not_starts_with: str
        """

        self._description_not_starts_with = description_not_starts_with

    @property
    def description_starts_with(self):
        """Gets the description_starts_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The description_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_starts_with

    @description_starts_with.setter
    def description_starts_with(self, description_starts_with):
        """Sets the description_starts_with of this ReplicationServiceWhereInput.


        :param description_starts_with: The description_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type description_starts_with: str
        """

        self._description_starts_with = description_starts_with

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The entity_async_status of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this ReplicationServiceWhereInput.


        :param entity_async_status: The entity_async_status of this ReplicationServiceWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this ReplicationServiceWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this ReplicationServiceWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this ReplicationServiceWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this ReplicationServiceWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def failover_executions_every(self):
        """Gets the failover_executions_every of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The failover_executions_every of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: FailoverExecutionWhereInput
        """
        return self._failover_executions_every

    @failover_executions_every.setter
    def failover_executions_every(self, failover_executions_every):
        """Sets the failover_executions_every of this ReplicationServiceWhereInput.


        :param failover_executions_every: The failover_executions_every of this ReplicationServiceWhereInput.  # noqa: E501
        :type failover_executions_every: FailoverExecutionWhereInput
        """

        self._failover_executions_every = failover_executions_every

    @property
    def failover_executions_none(self):
        """Gets the failover_executions_none of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The failover_executions_none of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: FailoverExecutionWhereInput
        """
        return self._failover_executions_none

    @failover_executions_none.setter
    def failover_executions_none(self, failover_executions_none):
        """Sets the failover_executions_none of this ReplicationServiceWhereInput.


        :param failover_executions_none: The failover_executions_none of this ReplicationServiceWhereInput.  # noqa: E501
        :type failover_executions_none: FailoverExecutionWhereInput
        """

        self._failover_executions_none = failover_executions_none

    @property
    def failover_executions_some(self):
        """Gets the failover_executions_some of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The failover_executions_some of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: FailoverExecutionWhereInput
        """
        return self._failover_executions_some

    @failover_executions_some.setter
    def failover_executions_some(self, failover_executions_some):
        """Sets the failover_executions_some of this ReplicationServiceWhereInput.


        :param failover_executions_some: The failover_executions_some of this ReplicationServiceWhereInput.  # noqa: E501
        :type failover_executions_some: FailoverExecutionWhereInput
        """

        self._failover_executions_some = failover_executions_some

    @property
    def id(self):
        """Gets the id of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The id of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ReplicationServiceWhereInput.


        :param id: The id of this ReplicationServiceWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The id_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this ReplicationServiceWhereInput.


        :param id_contains: The id_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The id_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this ReplicationServiceWhereInput.


        :param id_ends_with: The id_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The id_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this ReplicationServiceWhereInput.


        :param id_gt: The id_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The id_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this ReplicationServiceWhereInput.


        :param id_gte: The id_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The id_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this ReplicationServiceWhereInput.


        :param id_in: The id_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The id_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this ReplicationServiceWhereInput.


        :param id_lt: The id_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The id_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this ReplicationServiceWhereInput.


        :param id_lte: The id_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The id_not of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this ReplicationServiceWhereInput.


        :param id_not: The id_not of this ReplicationServiceWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The id_not_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this ReplicationServiceWhereInput.


        :param id_not_contains: The id_not_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this ReplicationServiceWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The id_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this ReplicationServiceWhereInput.


        :param id_not_in: The id_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this ReplicationServiceWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The id_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this ReplicationServiceWhereInput.


        :param id_starts_with: The id_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def kube_config(self):
        """Gets the kube_config of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The kube_config of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config

    @kube_config.setter
    def kube_config(self, kube_config):
        """Sets the kube_config of this ReplicationServiceWhereInput.


        :param kube_config: The kube_config of this ReplicationServiceWhereInput.  # noqa: E501
        :type kube_config: str
        """

        self._kube_config = kube_config

    @property
    def kube_config_contains(self):
        """Gets the kube_config_contains of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The kube_config_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_contains

    @kube_config_contains.setter
    def kube_config_contains(self, kube_config_contains):
        """Sets the kube_config_contains of this ReplicationServiceWhereInput.


        :param kube_config_contains: The kube_config_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :type kube_config_contains: str
        """

        self._kube_config_contains = kube_config_contains

    @property
    def kube_config_ends_with(self):
        """Gets the kube_config_ends_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The kube_config_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_ends_with

    @kube_config_ends_with.setter
    def kube_config_ends_with(self, kube_config_ends_with):
        """Sets the kube_config_ends_with of this ReplicationServiceWhereInput.


        :param kube_config_ends_with: The kube_config_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type kube_config_ends_with: str
        """

        self._kube_config_ends_with = kube_config_ends_with

    @property
    def kube_config_gt(self):
        """Gets the kube_config_gt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The kube_config_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_gt

    @kube_config_gt.setter
    def kube_config_gt(self, kube_config_gt):
        """Sets the kube_config_gt of this ReplicationServiceWhereInput.


        :param kube_config_gt: The kube_config_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :type kube_config_gt: str
        """

        self._kube_config_gt = kube_config_gt

    @property
    def kube_config_gte(self):
        """Gets the kube_config_gte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The kube_config_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_gte

    @kube_config_gte.setter
    def kube_config_gte(self, kube_config_gte):
        """Sets the kube_config_gte of this ReplicationServiceWhereInput.


        :param kube_config_gte: The kube_config_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :type kube_config_gte: str
        """

        self._kube_config_gte = kube_config_gte

    @property
    def kube_config_in(self):
        """Gets the kube_config_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The kube_config_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._kube_config_in

    @kube_config_in.setter
    def kube_config_in(self, kube_config_in):
        """Sets the kube_config_in of this ReplicationServiceWhereInput.


        :param kube_config_in: The kube_config_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type kube_config_in: list[str]
        """

        self._kube_config_in = kube_config_in

    @property
    def kube_config_lt(self):
        """Gets the kube_config_lt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The kube_config_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_lt

    @kube_config_lt.setter
    def kube_config_lt(self, kube_config_lt):
        """Sets the kube_config_lt of this ReplicationServiceWhereInput.


        :param kube_config_lt: The kube_config_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :type kube_config_lt: str
        """

        self._kube_config_lt = kube_config_lt

    @property
    def kube_config_lte(self):
        """Gets the kube_config_lte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The kube_config_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_lte

    @kube_config_lte.setter
    def kube_config_lte(self, kube_config_lte):
        """Sets the kube_config_lte of this ReplicationServiceWhereInput.


        :param kube_config_lte: The kube_config_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :type kube_config_lte: str
        """

        self._kube_config_lte = kube_config_lte

    @property
    def kube_config_not(self):
        """Gets the kube_config_not of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The kube_config_not of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_not

    @kube_config_not.setter
    def kube_config_not(self, kube_config_not):
        """Sets the kube_config_not of this ReplicationServiceWhereInput.


        :param kube_config_not: The kube_config_not of this ReplicationServiceWhereInput.  # noqa: E501
        :type kube_config_not: str
        """

        self._kube_config_not = kube_config_not

    @property
    def kube_config_not_contains(self):
        """Gets the kube_config_not_contains of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The kube_config_not_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_not_contains

    @kube_config_not_contains.setter
    def kube_config_not_contains(self, kube_config_not_contains):
        """Sets the kube_config_not_contains of this ReplicationServiceWhereInput.


        :param kube_config_not_contains: The kube_config_not_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :type kube_config_not_contains: str
        """

        self._kube_config_not_contains = kube_config_not_contains

    @property
    def kube_config_not_ends_with(self):
        """Gets the kube_config_not_ends_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The kube_config_not_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_not_ends_with

    @kube_config_not_ends_with.setter
    def kube_config_not_ends_with(self, kube_config_not_ends_with):
        """Sets the kube_config_not_ends_with of this ReplicationServiceWhereInput.


        :param kube_config_not_ends_with: The kube_config_not_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type kube_config_not_ends_with: str
        """

        self._kube_config_not_ends_with = kube_config_not_ends_with

    @property
    def kube_config_not_in(self):
        """Gets the kube_config_not_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The kube_config_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._kube_config_not_in

    @kube_config_not_in.setter
    def kube_config_not_in(self, kube_config_not_in):
        """Sets the kube_config_not_in of this ReplicationServiceWhereInput.


        :param kube_config_not_in: The kube_config_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type kube_config_not_in: list[str]
        """

        self._kube_config_not_in = kube_config_not_in

    @property
    def kube_config_not_starts_with(self):
        """Gets the kube_config_not_starts_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The kube_config_not_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_not_starts_with

    @kube_config_not_starts_with.setter
    def kube_config_not_starts_with(self, kube_config_not_starts_with):
        """Sets the kube_config_not_starts_with of this ReplicationServiceWhereInput.


        :param kube_config_not_starts_with: The kube_config_not_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type kube_config_not_starts_with: str
        """

        self._kube_config_not_starts_with = kube_config_not_starts_with

    @property
    def kube_config_starts_with(self):
        """Gets the kube_config_starts_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The kube_config_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_starts_with

    @kube_config_starts_with.setter
    def kube_config_starts_with(self, kube_config_starts_with):
        """Sets the kube_config_starts_with of this ReplicationServiceWhereInput.


        :param kube_config_starts_with: The kube_config_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type kube_config_starts_with: str
        """

        self._kube_config_starts_with = kube_config_starts_with

    @property
    def max_failback_jobs(self):
        """Gets the max_failback_jobs of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_jobs of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_failback_jobs

    @max_failback_jobs.setter
    def max_failback_jobs(self, max_failback_jobs):
        """Sets the max_failback_jobs of this ReplicationServiceWhereInput.


        :param max_failback_jobs: The max_failback_jobs of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_jobs: int
        """

        self._max_failback_jobs = max_failback_jobs

    @property
    def max_failback_jobs_gt(self):
        """Gets the max_failback_jobs_gt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_jobs_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_failback_jobs_gt

    @max_failback_jobs_gt.setter
    def max_failback_jobs_gt(self, max_failback_jobs_gt):
        """Sets the max_failback_jobs_gt of this ReplicationServiceWhereInput.


        :param max_failback_jobs_gt: The max_failback_jobs_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_jobs_gt: int
        """

        self._max_failback_jobs_gt = max_failback_jobs_gt

    @property
    def max_failback_jobs_gte(self):
        """Gets the max_failback_jobs_gte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_jobs_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_failback_jobs_gte

    @max_failback_jobs_gte.setter
    def max_failback_jobs_gte(self, max_failback_jobs_gte):
        """Sets the max_failback_jobs_gte of this ReplicationServiceWhereInput.


        :param max_failback_jobs_gte: The max_failback_jobs_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_jobs_gte: int
        """

        self._max_failback_jobs_gte = max_failback_jobs_gte

    @property
    def max_failback_jobs_in(self):
        """Gets the max_failback_jobs_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_jobs_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_failback_jobs_in

    @max_failback_jobs_in.setter
    def max_failback_jobs_in(self, max_failback_jobs_in):
        """Sets the max_failback_jobs_in of this ReplicationServiceWhereInput.


        :param max_failback_jobs_in: The max_failback_jobs_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_jobs_in: list[int]
        """

        self._max_failback_jobs_in = max_failback_jobs_in

    @property
    def max_failback_jobs_lt(self):
        """Gets the max_failback_jobs_lt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_jobs_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_failback_jobs_lt

    @max_failback_jobs_lt.setter
    def max_failback_jobs_lt(self, max_failback_jobs_lt):
        """Sets the max_failback_jobs_lt of this ReplicationServiceWhereInput.


        :param max_failback_jobs_lt: The max_failback_jobs_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_jobs_lt: int
        """

        self._max_failback_jobs_lt = max_failback_jobs_lt

    @property
    def max_failback_jobs_lte(self):
        """Gets the max_failback_jobs_lte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_jobs_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_failback_jobs_lte

    @max_failback_jobs_lte.setter
    def max_failback_jobs_lte(self, max_failback_jobs_lte):
        """Sets the max_failback_jobs_lte of this ReplicationServiceWhereInput.


        :param max_failback_jobs_lte: The max_failback_jobs_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_jobs_lte: int
        """

        self._max_failback_jobs_lte = max_failback_jobs_lte

    @property
    def max_failback_jobs_not(self):
        """Gets the max_failback_jobs_not of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_jobs_not of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_failback_jobs_not

    @max_failback_jobs_not.setter
    def max_failback_jobs_not(self, max_failback_jobs_not):
        """Sets the max_failback_jobs_not of this ReplicationServiceWhereInput.


        :param max_failback_jobs_not: The max_failback_jobs_not of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_jobs_not: int
        """

        self._max_failback_jobs_not = max_failback_jobs_not

    @property
    def max_failback_jobs_not_in(self):
        """Gets the max_failback_jobs_not_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_jobs_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_failback_jobs_not_in

    @max_failback_jobs_not_in.setter
    def max_failback_jobs_not_in(self, max_failback_jobs_not_in):
        """Sets the max_failback_jobs_not_in of this ReplicationServiceWhereInput.


        :param max_failback_jobs_not_in: The max_failback_jobs_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_jobs_not_in: list[int]
        """

        self._max_failback_jobs_not_in = max_failback_jobs_not_in

    @property
    def max_failback_speed_limit(self):
        """Gets the max_failback_speed_limit of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_speed_limit of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._max_failback_speed_limit

    @max_failback_speed_limit.setter
    def max_failback_speed_limit(self, max_failback_speed_limit):
        """Sets the max_failback_speed_limit of this ReplicationServiceWhereInput.


        :param max_failback_speed_limit: The max_failback_speed_limit of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_speed_limit: float
        """

        self._max_failback_speed_limit = max_failback_speed_limit

    @property
    def max_failback_speed_limit_gt(self):
        """Gets the max_failback_speed_limit_gt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_speed_limit_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._max_failback_speed_limit_gt

    @max_failback_speed_limit_gt.setter
    def max_failback_speed_limit_gt(self, max_failback_speed_limit_gt):
        """Sets the max_failback_speed_limit_gt of this ReplicationServiceWhereInput.


        :param max_failback_speed_limit_gt: The max_failback_speed_limit_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_speed_limit_gt: float
        """

        self._max_failback_speed_limit_gt = max_failback_speed_limit_gt

    @property
    def max_failback_speed_limit_gte(self):
        """Gets the max_failback_speed_limit_gte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_speed_limit_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._max_failback_speed_limit_gte

    @max_failback_speed_limit_gte.setter
    def max_failback_speed_limit_gte(self, max_failback_speed_limit_gte):
        """Sets the max_failback_speed_limit_gte of this ReplicationServiceWhereInput.


        :param max_failback_speed_limit_gte: The max_failback_speed_limit_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_speed_limit_gte: float
        """

        self._max_failback_speed_limit_gte = max_failback_speed_limit_gte

    @property
    def max_failback_speed_limit_in(self):
        """Gets the max_failback_speed_limit_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_speed_limit_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._max_failback_speed_limit_in

    @max_failback_speed_limit_in.setter
    def max_failback_speed_limit_in(self, max_failback_speed_limit_in):
        """Sets the max_failback_speed_limit_in of this ReplicationServiceWhereInput.


        :param max_failback_speed_limit_in: The max_failback_speed_limit_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_speed_limit_in: list[float]
        """

        self._max_failback_speed_limit_in = max_failback_speed_limit_in

    @property
    def max_failback_speed_limit_lt(self):
        """Gets the max_failback_speed_limit_lt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_speed_limit_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._max_failback_speed_limit_lt

    @max_failback_speed_limit_lt.setter
    def max_failback_speed_limit_lt(self, max_failback_speed_limit_lt):
        """Sets the max_failback_speed_limit_lt of this ReplicationServiceWhereInput.


        :param max_failback_speed_limit_lt: The max_failback_speed_limit_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_speed_limit_lt: float
        """

        self._max_failback_speed_limit_lt = max_failback_speed_limit_lt

    @property
    def max_failback_speed_limit_lte(self):
        """Gets the max_failback_speed_limit_lte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_speed_limit_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._max_failback_speed_limit_lte

    @max_failback_speed_limit_lte.setter
    def max_failback_speed_limit_lte(self, max_failback_speed_limit_lte):
        """Sets the max_failback_speed_limit_lte of this ReplicationServiceWhereInput.


        :param max_failback_speed_limit_lte: The max_failback_speed_limit_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_speed_limit_lte: float
        """

        self._max_failback_speed_limit_lte = max_failback_speed_limit_lte

    @property
    def max_failback_speed_limit_not(self):
        """Gets the max_failback_speed_limit_not of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_speed_limit_not of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._max_failback_speed_limit_not

    @max_failback_speed_limit_not.setter
    def max_failback_speed_limit_not(self, max_failback_speed_limit_not):
        """Sets the max_failback_speed_limit_not of this ReplicationServiceWhereInput.


        :param max_failback_speed_limit_not: The max_failback_speed_limit_not of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_speed_limit_not: float
        """

        self._max_failback_speed_limit_not = max_failback_speed_limit_not

    @property
    def max_failback_speed_limit_not_in(self):
        """Gets the max_failback_speed_limit_not_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_failback_speed_limit_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._max_failback_speed_limit_not_in

    @max_failback_speed_limit_not_in.setter
    def max_failback_speed_limit_not_in(self, max_failback_speed_limit_not_in):
        """Sets the max_failback_speed_limit_not_in of this ReplicationServiceWhereInput.


        :param max_failback_speed_limit_not_in: The max_failback_speed_limit_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_failback_speed_limit_not_in: list[float]
        """

        self._max_failback_speed_limit_not_in = max_failback_speed_limit_not_in

    @property
    def max_replication_jobs(self):
        """Gets the max_replication_jobs of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_jobs of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_replication_jobs

    @max_replication_jobs.setter
    def max_replication_jobs(self, max_replication_jobs):
        """Sets the max_replication_jobs of this ReplicationServiceWhereInput.


        :param max_replication_jobs: The max_replication_jobs of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_jobs: int
        """

        self._max_replication_jobs = max_replication_jobs

    @property
    def max_replication_jobs_gt(self):
        """Gets the max_replication_jobs_gt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_jobs_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_replication_jobs_gt

    @max_replication_jobs_gt.setter
    def max_replication_jobs_gt(self, max_replication_jobs_gt):
        """Sets the max_replication_jobs_gt of this ReplicationServiceWhereInput.


        :param max_replication_jobs_gt: The max_replication_jobs_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_jobs_gt: int
        """

        self._max_replication_jobs_gt = max_replication_jobs_gt

    @property
    def max_replication_jobs_gte(self):
        """Gets the max_replication_jobs_gte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_jobs_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_replication_jobs_gte

    @max_replication_jobs_gte.setter
    def max_replication_jobs_gte(self, max_replication_jobs_gte):
        """Sets the max_replication_jobs_gte of this ReplicationServiceWhereInput.


        :param max_replication_jobs_gte: The max_replication_jobs_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_jobs_gte: int
        """

        self._max_replication_jobs_gte = max_replication_jobs_gte

    @property
    def max_replication_jobs_in(self):
        """Gets the max_replication_jobs_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_jobs_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_replication_jobs_in

    @max_replication_jobs_in.setter
    def max_replication_jobs_in(self, max_replication_jobs_in):
        """Sets the max_replication_jobs_in of this ReplicationServiceWhereInput.


        :param max_replication_jobs_in: The max_replication_jobs_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_jobs_in: list[int]
        """

        self._max_replication_jobs_in = max_replication_jobs_in

    @property
    def max_replication_jobs_lt(self):
        """Gets the max_replication_jobs_lt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_jobs_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_replication_jobs_lt

    @max_replication_jobs_lt.setter
    def max_replication_jobs_lt(self, max_replication_jobs_lt):
        """Sets the max_replication_jobs_lt of this ReplicationServiceWhereInput.


        :param max_replication_jobs_lt: The max_replication_jobs_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_jobs_lt: int
        """

        self._max_replication_jobs_lt = max_replication_jobs_lt

    @property
    def max_replication_jobs_lte(self):
        """Gets the max_replication_jobs_lte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_jobs_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_replication_jobs_lte

    @max_replication_jobs_lte.setter
    def max_replication_jobs_lte(self, max_replication_jobs_lte):
        """Sets the max_replication_jobs_lte of this ReplicationServiceWhereInput.


        :param max_replication_jobs_lte: The max_replication_jobs_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_jobs_lte: int
        """

        self._max_replication_jobs_lte = max_replication_jobs_lte

    @property
    def max_replication_jobs_not(self):
        """Gets the max_replication_jobs_not of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_jobs_not of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_replication_jobs_not

    @max_replication_jobs_not.setter
    def max_replication_jobs_not(self, max_replication_jobs_not):
        """Sets the max_replication_jobs_not of this ReplicationServiceWhereInput.


        :param max_replication_jobs_not: The max_replication_jobs_not of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_jobs_not: int
        """

        self._max_replication_jobs_not = max_replication_jobs_not

    @property
    def max_replication_jobs_not_in(self):
        """Gets the max_replication_jobs_not_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_jobs_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_replication_jobs_not_in

    @max_replication_jobs_not_in.setter
    def max_replication_jobs_not_in(self, max_replication_jobs_not_in):
        """Sets the max_replication_jobs_not_in of this ReplicationServiceWhereInput.


        :param max_replication_jobs_not_in: The max_replication_jobs_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_jobs_not_in: list[int]
        """

        self._max_replication_jobs_not_in = max_replication_jobs_not_in

    @property
    def max_replication_speed_limit(self):
        """Gets the max_replication_speed_limit of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_speed_limit of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._max_replication_speed_limit

    @max_replication_speed_limit.setter
    def max_replication_speed_limit(self, max_replication_speed_limit):
        """Sets the max_replication_speed_limit of this ReplicationServiceWhereInput.


        :param max_replication_speed_limit: The max_replication_speed_limit of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_speed_limit: float
        """

        self._max_replication_speed_limit = max_replication_speed_limit

    @property
    def max_replication_speed_limit_gt(self):
        """Gets the max_replication_speed_limit_gt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_speed_limit_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._max_replication_speed_limit_gt

    @max_replication_speed_limit_gt.setter
    def max_replication_speed_limit_gt(self, max_replication_speed_limit_gt):
        """Sets the max_replication_speed_limit_gt of this ReplicationServiceWhereInput.


        :param max_replication_speed_limit_gt: The max_replication_speed_limit_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_speed_limit_gt: float
        """

        self._max_replication_speed_limit_gt = max_replication_speed_limit_gt

    @property
    def max_replication_speed_limit_gte(self):
        """Gets the max_replication_speed_limit_gte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_speed_limit_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._max_replication_speed_limit_gte

    @max_replication_speed_limit_gte.setter
    def max_replication_speed_limit_gte(self, max_replication_speed_limit_gte):
        """Sets the max_replication_speed_limit_gte of this ReplicationServiceWhereInput.


        :param max_replication_speed_limit_gte: The max_replication_speed_limit_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_speed_limit_gte: float
        """

        self._max_replication_speed_limit_gte = max_replication_speed_limit_gte

    @property
    def max_replication_speed_limit_in(self):
        """Gets the max_replication_speed_limit_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_speed_limit_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._max_replication_speed_limit_in

    @max_replication_speed_limit_in.setter
    def max_replication_speed_limit_in(self, max_replication_speed_limit_in):
        """Sets the max_replication_speed_limit_in of this ReplicationServiceWhereInput.


        :param max_replication_speed_limit_in: The max_replication_speed_limit_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_speed_limit_in: list[float]
        """

        self._max_replication_speed_limit_in = max_replication_speed_limit_in

    @property
    def max_replication_speed_limit_lt(self):
        """Gets the max_replication_speed_limit_lt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_speed_limit_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._max_replication_speed_limit_lt

    @max_replication_speed_limit_lt.setter
    def max_replication_speed_limit_lt(self, max_replication_speed_limit_lt):
        """Sets the max_replication_speed_limit_lt of this ReplicationServiceWhereInput.


        :param max_replication_speed_limit_lt: The max_replication_speed_limit_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_speed_limit_lt: float
        """

        self._max_replication_speed_limit_lt = max_replication_speed_limit_lt

    @property
    def max_replication_speed_limit_lte(self):
        """Gets the max_replication_speed_limit_lte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_speed_limit_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._max_replication_speed_limit_lte

    @max_replication_speed_limit_lte.setter
    def max_replication_speed_limit_lte(self, max_replication_speed_limit_lte):
        """Sets the max_replication_speed_limit_lte of this ReplicationServiceWhereInput.


        :param max_replication_speed_limit_lte: The max_replication_speed_limit_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_speed_limit_lte: float
        """

        self._max_replication_speed_limit_lte = max_replication_speed_limit_lte

    @property
    def max_replication_speed_limit_not(self):
        """Gets the max_replication_speed_limit_not of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_speed_limit_not of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._max_replication_speed_limit_not

    @max_replication_speed_limit_not.setter
    def max_replication_speed_limit_not(self, max_replication_speed_limit_not):
        """Sets the max_replication_speed_limit_not of this ReplicationServiceWhereInput.


        :param max_replication_speed_limit_not: The max_replication_speed_limit_not of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_speed_limit_not: float
        """

        self._max_replication_speed_limit_not = max_replication_speed_limit_not

    @property
    def max_replication_speed_limit_not_in(self):
        """Gets the max_replication_speed_limit_not_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_replication_speed_limit_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._max_replication_speed_limit_not_in

    @max_replication_speed_limit_not_in.setter
    def max_replication_speed_limit_not_in(self, max_replication_speed_limit_not_in):
        """Sets the max_replication_speed_limit_not_in of this ReplicationServiceWhereInput.


        :param max_replication_speed_limit_not_in: The max_replication_speed_limit_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_replication_speed_limit_not_in: list[float]
        """

        self._max_replication_speed_limit_not_in = max_replication_speed_limit_not_in

    @property
    def max_retry_times(self):
        """Gets the max_retry_times of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_retry_times of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_retry_times

    @max_retry_times.setter
    def max_retry_times(self, max_retry_times):
        """Sets the max_retry_times of this ReplicationServiceWhereInput.


        :param max_retry_times: The max_retry_times of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_retry_times: int
        """

        self._max_retry_times = max_retry_times

    @property
    def max_retry_times_gt(self):
        """Gets the max_retry_times_gt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_retry_times_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_retry_times_gt

    @max_retry_times_gt.setter
    def max_retry_times_gt(self, max_retry_times_gt):
        """Sets the max_retry_times_gt of this ReplicationServiceWhereInput.


        :param max_retry_times_gt: The max_retry_times_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_retry_times_gt: int
        """

        self._max_retry_times_gt = max_retry_times_gt

    @property
    def max_retry_times_gte(self):
        """Gets the max_retry_times_gte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_retry_times_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_retry_times_gte

    @max_retry_times_gte.setter
    def max_retry_times_gte(self, max_retry_times_gte):
        """Sets the max_retry_times_gte of this ReplicationServiceWhereInput.


        :param max_retry_times_gte: The max_retry_times_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_retry_times_gte: int
        """

        self._max_retry_times_gte = max_retry_times_gte

    @property
    def max_retry_times_in(self):
        """Gets the max_retry_times_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_retry_times_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_retry_times_in

    @max_retry_times_in.setter
    def max_retry_times_in(self, max_retry_times_in):
        """Sets the max_retry_times_in of this ReplicationServiceWhereInput.


        :param max_retry_times_in: The max_retry_times_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_retry_times_in: list[int]
        """

        self._max_retry_times_in = max_retry_times_in

    @property
    def max_retry_times_lt(self):
        """Gets the max_retry_times_lt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_retry_times_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_retry_times_lt

    @max_retry_times_lt.setter
    def max_retry_times_lt(self, max_retry_times_lt):
        """Sets the max_retry_times_lt of this ReplicationServiceWhereInput.


        :param max_retry_times_lt: The max_retry_times_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_retry_times_lt: int
        """

        self._max_retry_times_lt = max_retry_times_lt

    @property
    def max_retry_times_lte(self):
        """Gets the max_retry_times_lte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_retry_times_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_retry_times_lte

    @max_retry_times_lte.setter
    def max_retry_times_lte(self, max_retry_times_lte):
        """Sets the max_retry_times_lte of this ReplicationServiceWhereInput.


        :param max_retry_times_lte: The max_retry_times_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_retry_times_lte: int
        """

        self._max_retry_times_lte = max_retry_times_lte

    @property
    def max_retry_times_not(self):
        """Gets the max_retry_times_not of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_retry_times_not of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_retry_times_not

    @max_retry_times_not.setter
    def max_retry_times_not(self, max_retry_times_not):
        """Sets the max_retry_times_not of this ReplicationServiceWhereInput.


        :param max_retry_times_not: The max_retry_times_not of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_retry_times_not: int
        """

        self._max_retry_times_not = max_retry_times_not

    @property
    def max_retry_times_not_in(self):
        """Gets the max_retry_times_not_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The max_retry_times_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_retry_times_not_in

    @max_retry_times_not_in.setter
    def max_retry_times_not_in(self, max_retry_times_not_in):
        """Sets the max_retry_times_not_in of this ReplicationServiceWhereInput.


        :param max_retry_times_not_in: The max_retry_times_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type max_retry_times_not_in: list[int]
        """

        self._max_retry_times_not_in = max_retry_times_not_in

    @property
    def name(self):
        """Gets the name of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The name of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ReplicationServiceWhereInput.


        :param name: The name of this ReplicationServiceWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The name_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this ReplicationServiceWhereInput.


        :param name_contains: The name_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The name_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this ReplicationServiceWhereInput.


        :param name_ends_with: The name_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The name_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this ReplicationServiceWhereInput.


        :param name_gt: The name_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The name_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this ReplicationServiceWhereInput.


        :param name_gte: The name_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The name_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this ReplicationServiceWhereInput.


        :param name_in: The name_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The name_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this ReplicationServiceWhereInput.


        :param name_lt: The name_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The name_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this ReplicationServiceWhereInput.


        :param name_lte: The name_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The name_not of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this ReplicationServiceWhereInput.


        :param name_not: The name_not of this ReplicationServiceWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The name_not_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this ReplicationServiceWhereInput.


        :param name_not_contains: The name_not_contains of this ReplicationServiceWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this ReplicationServiceWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The name_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this ReplicationServiceWhereInput.


        :param name_not_in: The name_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this ReplicationServiceWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The name_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this ReplicationServiceWhereInput.


        :param name_starts_with: The name_starts_with of this ReplicationServiceWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def permanent_failover_execution_every(self):
        """Gets the permanent_failover_execution_every of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The permanent_failover_execution_every of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: PermanentFailoverExecutionWhereInput
        """
        return self._permanent_failover_execution_every

    @permanent_failover_execution_every.setter
    def permanent_failover_execution_every(self, permanent_failover_execution_every):
        """Sets the permanent_failover_execution_every of this ReplicationServiceWhereInput.


        :param permanent_failover_execution_every: The permanent_failover_execution_every of this ReplicationServiceWhereInput.  # noqa: E501
        :type permanent_failover_execution_every: PermanentFailoverExecutionWhereInput
        """

        self._permanent_failover_execution_every = permanent_failover_execution_every

    @property
    def permanent_failover_execution_none(self):
        """Gets the permanent_failover_execution_none of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The permanent_failover_execution_none of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: PermanentFailoverExecutionWhereInput
        """
        return self._permanent_failover_execution_none

    @permanent_failover_execution_none.setter
    def permanent_failover_execution_none(self, permanent_failover_execution_none):
        """Sets the permanent_failover_execution_none of this ReplicationServiceWhereInput.


        :param permanent_failover_execution_none: The permanent_failover_execution_none of this ReplicationServiceWhereInput.  # noqa: E501
        :type permanent_failover_execution_none: PermanentFailoverExecutionWhereInput
        """

        self._permanent_failover_execution_none = permanent_failover_execution_none

    @property
    def permanent_failover_execution_some(self):
        """Gets the permanent_failover_execution_some of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The permanent_failover_execution_some of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: PermanentFailoverExecutionWhereInput
        """
        return self._permanent_failover_execution_some

    @permanent_failover_execution_some.setter
    def permanent_failover_execution_some(self, permanent_failover_execution_some):
        """Sets the permanent_failover_execution_some of this ReplicationServiceWhereInput.


        :param permanent_failover_execution_some: The permanent_failover_execution_some of this ReplicationServiceWhereInput.  # noqa: E501
        :type permanent_failover_execution_some: PermanentFailoverExecutionWhereInput
        """

        self._permanent_failover_execution_some = permanent_failover_execution_some

    @property
    def replication_clusters_every(self):
        """Gets the replication_clusters_every of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The replication_clusters_every of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._replication_clusters_every

    @replication_clusters_every.setter
    def replication_clusters_every(self, replication_clusters_every):
        """Sets the replication_clusters_every of this ReplicationServiceWhereInput.


        :param replication_clusters_every: The replication_clusters_every of this ReplicationServiceWhereInput.  # noqa: E501
        :type replication_clusters_every: ClusterWhereInput
        """

        self._replication_clusters_every = replication_clusters_every

    @property
    def replication_clusters_none(self):
        """Gets the replication_clusters_none of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The replication_clusters_none of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._replication_clusters_none

    @replication_clusters_none.setter
    def replication_clusters_none(self, replication_clusters_none):
        """Sets the replication_clusters_none of this ReplicationServiceWhereInput.


        :param replication_clusters_none: The replication_clusters_none of this ReplicationServiceWhereInput.  # noqa: E501
        :type replication_clusters_none: ClusterWhereInput
        """

        self._replication_clusters_none = replication_clusters_none

    @property
    def replication_clusters_some(self):
        """Gets the replication_clusters_some of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The replication_clusters_some of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._replication_clusters_some

    @replication_clusters_some.setter
    def replication_clusters_some(self, replication_clusters_some):
        """Sets the replication_clusters_some of this ReplicationServiceWhereInput.


        :param replication_clusters_some: The replication_clusters_some of this ReplicationServiceWhereInput.  # noqa: E501
        :type replication_clusters_some: ClusterWhereInput
        """

        self._replication_clusters_some = replication_clusters_some

    @property
    def replication_plans_every(self):
        """Gets the replication_plans_every of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The replication_plans_every of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: ReplicationPlanWhereInput
        """
        return self._replication_plans_every

    @replication_plans_every.setter
    def replication_plans_every(self, replication_plans_every):
        """Sets the replication_plans_every of this ReplicationServiceWhereInput.


        :param replication_plans_every: The replication_plans_every of this ReplicationServiceWhereInput.  # noqa: E501
        :type replication_plans_every: ReplicationPlanWhereInput
        """

        self._replication_plans_every = replication_plans_every

    @property
    def replication_plans_none(self):
        """Gets the replication_plans_none of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The replication_plans_none of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: ReplicationPlanWhereInput
        """
        return self._replication_plans_none

    @replication_plans_none.setter
    def replication_plans_none(self, replication_plans_none):
        """Sets the replication_plans_none of this ReplicationServiceWhereInput.


        :param replication_plans_none: The replication_plans_none of this ReplicationServiceWhereInput.  # noqa: E501
        :type replication_plans_none: ReplicationPlanWhereInput
        """

        self._replication_plans_none = replication_plans_none

    @property
    def replication_plans_some(self):
        """Gets the replication_plans_some of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The replication_plans_some of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: ReplicationPlanWhereInput
        """
        return self._replication_plans_some

    @replication_plans_some.setter
    def replication_plans_some(self, replication_plans_some):
        """Sets the replication_plans_some of this ReplicationServiceWhereInput.


        :param replication_plans_some: The replication_plans_some of this ReplicationServiceWhereInput.  # noqa: E501
        :type replication_plans_some: ReplicationPlanWhereInput
        """

        self._replication_plans_some = replication_plans_some

    @property
    def retry_interval(self):
        """Gets the retry_interval of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The retry_interval of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_interval

    @retry_interval.setter
    def retry_interval(self, retry_interval):
        """Sets the retry_interval of this ReplicationServiceWhereInput.


        :param retry_interval: The retry_interval of this ReplicationServiceWhereInput.  # noqa: E501
        :type retry_interval: int
        """

        self._retry_interval = retry_interval

    @property
    def retry_interval_gt(self):
        """Gets the retry_interval_gt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The retry_interval_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_interval_gt

    @retry_interval_gt.setter
    def retry_interval_gt(self, retry_interval_gt):
        """Sets the retry_interval_gt of this ReplicationServiceWhereInput.


        :param retry_interval_gt: The retry_interval_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :type retry_interval_gt: int
        """

        self._retry_interval_gt = retry_interval_gt

    @property
    def retry_interval_gte(self):
        """Gets the retry_interval_gte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The retry_interval_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_interval_gte

    @retry_interval_gte.setter
    def retry_interval_gte(self, retry_interval_gte):
        """Sets the retry_interval_gte of this ReplicationServiceWhereInput.


        :param retry_interval_gte: The retry_interval_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :type retry_interval_gte: int
        """

        self._retry_interval_gte = retry_interval_gte

    @property
    def retry_interval_in(self):
        """Gets the retry_interval_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The retry_interval_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._retry_interval_in

    @retry_interval_in.setter
    def retry_interval_in(self, retry_interval_in):
        """Sets the retry_interval_in of this ReplicationServiceWhereInput.


        :param retry_interval_in: The retry_interval_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type retry_interval_in: list[int]
        """

        self._retry_interval_in = retry_interval_in

    @property
    def retry_interval_lt(self):
        """Gets the retry_interval_lt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The retry_interval_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_interval_lt

    @retry_interval_lt.setter
    def retry_interval_lt(self, retry_interval_lt):
        """Sets the retry_interval_lt of this ReplicationServiceWhereInput.


        :param retry_interval_lt: The retry_interval_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :type retry_interval_lt: int
        """

        self._retry_interval_lt = retry_interval_lt

    @property
    def retry_interval_lte(self):
        """Gets the retry_interval_lte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The retry_interval_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_interval_lte

    @retry_interval_lte.setter
    def retry_interval_lte(self, retry_interval_lte):
        """Sets the retry_interval_lte of this ReplicationServiceWhereInput.


        :param retry_interval_lte: The retry_interval_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :type retry_interval_lte: int
        """

        self._retry_interval_lte = retry_interval_lte

    @property
    def retry_interval_not(self):
        """Gets the retry_interval_not of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The retry_interval_not of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_interval_not

    @retry_interval_not.setter
    def retry_interval_not(self, retry_interval_not):
        """Sets the retry_interval_not of this ReplicationServiceWhereInput.


        :param retry_interval_not: The retry_interval_not of this ReplicationServiceWhereInput.  # noqa: E501
        :type retry_interval_not: int
        """

        self._retry_interval_not = retry_interval_not

    @property
    def retry_interval_not_in(self):
        """Gets the retry_interval_not_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The retry_interval_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._retry_interval_not_in

    @retry_interval_not_in.setter
    def retry_interval_not_in(self, retry_interval_not_in):
        """Sets the retry_interval_not_in of this ReplicationServiceWhereInput.


        :param retry_interval_not_in: The retry_interval_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type retry_interval_not_in: list[int]
        """

        self._retry_interval_not_in = retry_interval_not_in

    @property
    def updated_at(self):
        """Gets the updated_at of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The updated_at of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this ReplicationServiceWhereInput.


        :param updated_at: The updated_at of this ReplicationServiceWhereInput.  # noqa: E501
        :type updated_at: str
        """

        self._updated_at = updated_at

    @property
    def updated_at_gt(self):
        """Gets the updated_at_gt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The updated_at_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_gt

    @updated_at_gt.setter
    def updated_at_gt(self, updated_at_gt):
        """Sets the updated_at_gt of this ReplicationServiceWhereInput.


        :param updated_at_gt: The updated_at_gt of this ReplicationServiceWhereInput.  # noqa: E501
        :type updated_at_gt: str
        """

        self._updated_at_gt = updated_at_gt

    @property
    def updated_at_gte(self):
        """Gets the updated_at_gte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The updated_at_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_gte

    @updated_at_gte.setter
    def updated_at_gte(self, updated_at_gte):
        """Sets the updated_at_gte of this ReplicationServiceWhereInput.


        :param updated_at_gte: The updated_at_gte of this ReplicationServiceWhereInput.  # noqa: E501
        :type updated_at_gte: str
        """

        self._updated_at_gte = updated_at_gte

    @property
    def updated_at_in(self):
        """Gets the updated_at_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The updated_at_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._updated_at_in

    @updated_at_in.setter
    def updated_at_in(self, updated_at_in):
        """Sets the updated_at_in of this ReplicationServiceWhereInput.


        :param updated_at_in: The updated_at_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type updated_at_in: list[str]
        """

        self._updated_at_in = updated_at_in

    @property
    def updated_at_lt(self):
        """Gets the updated_at_lt of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The updated_at_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_lt

    @updated_at_lt.setter
    def updated_at_lt(self, updated_at_lt):
        """Sets the updated_at_lt of this ReplicationServiceWhereInput.


        :param updated_at_lt: The updated_at_lt of this ReplicationServiceWhereInput.  # noqa: E501
        :type updated_at_lt: str
        """

        self._updated_at_lt = updated_at_lt

    @property
    def updated_at_lte(self):
        """Gets the updated_at_lte of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The updated_at_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_lte

    @updated_at_lte.setter
    def updated_at_lte(self, updated_at_lte):
        """Sets the updated_at_lte of this ReplicationServiceWhereInput.


        :param updated_at_lte: The updated_at_lte of this ReplicationServiceWhereInput.  # noqa: E501
        :type updated_at_lte: str
        """

        self._updated_at_lte = updated_at_lte

    @property
    def updated_at_not(self):
        """Gets the updated_at_not of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The updated_at_not of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_not

    @updated_at_not.setter
    def updated_at_not(self, updated_at_not):
        """Sets the updated_at_not of this ReplicationServiceWhereInput.


        :param updated_at_not: The updated_at_not of this ReplicationServiceWhereInput.  # noqa: E501
        :type updated_at_not: str
        """

        self._updated_at_not = updated_at_not

    @property
    def updated_at_not_in(self):
        """Gets the updated_at_not_in of this ReplicationServiceWhereInput.  # noqa: E501


        :return: The updated_at_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._updated_at_not_in

    @updated_at_not_in.setter
    def updated_at_not_in(self, updated_at_not_in):
        """Sets the updated_at_not_in of this ReplicationServiceWhereInput.


        :param updated_at_not_in: The updated_at_not_in of this ReplicationServiceWhereInput.  # noqa: E501
        :type updated_at_not_in: list[str]
        """

        self._updated_at_not_in = updated_at_not_in

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReplicationServiceWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ReplicationServiceWhereInput):
            return True

        return self.to_dict() != other.to_dict()
