# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ReplicationTargetExecutionWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[ReplicationTargetExecutionWhereInput]',
        '_not': 'list[ReplicationTargetExecutionWhereInput]',
        '_or': 'list[ReplicationTargetExecutionWhereInput]',
        'creation': 'ReplicationTargetExecutionCreation',
        'creation_in': 'list[ReplicationTargetExecutionCreation]',
        'creation_not': 'ReplicationTargetExecutionCreation',
        'creation_not_in': 'list[ReplicationTargetExecutionCreation]',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'finished_at': 'str',
        'finished_at_gt': 'str',
        'finished_at_gte': 'str',
        'finished_at_in': 'list[str]',
        'finished_at_lt': 'str',
        'finished_at_lte': 'str',
        'finished_at_not': 'str',
        'finished_at_not_in': 'list[str]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'phase': 'BackupJobPhase',
        'phase_in': 'list[BackupJobPhase]',
        'phase_not': 'BackupJobPhase',
        'phase_not_in': 'list[BackupJobPhase]',
        'replica_vm': 'ReplicaVmWhereInput',
        'replication_plan': 'ReplicationPlanWhereInput',
        'replication_plan_execution': 'ReplicationPlanExecutionWhereInput',
        'resource_version': 'int',
        'resource_version_gt': 'int',
        'resource_version_gte': 'int',
        'resource_version_in': 'list[int]',
        'resource_version_lt': 'int',
        'resource_version_lte': 'int',
        'resource_version_not': 'int',
        'resource_version_not_in': 'list[int]',
        'started_at': 'str',
        'started_at_gt': 'str',
        'started_at_gte': 'str',
        'started_at_in': 'list[str]',
        'started_at_lt': 'str',
        'started_at_lte': 'str',
        'started_at_not': 'str',
        'started_at_not_in': 'list[str]',
        'type': 'BackupExecutionType',
        'type_in': 'list[BackupExecutionType]',
        'type_not': 'BackupExecutionType',
        'type_not_in': 'list[BackupExecutionType]'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'creation': 'creation',
        'creation_in': 'creation_in',
        'creation_not': 'creation_not',
        'creation_not_in': 'creation_not_in',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'finished_at': 'finished_at',
        'finished_at_gt': 'finished_at_gt',
        'finished_at_gte': 'finished_at_gte',
        'finished_at_in': 'finished_at_in',
        'finished_at_lt': 'finished_at_lt',
        'finished_at_lte': 'finished_at_lte',
        'finished_at_not': 'finished_at_not',
        'finished_at_not_in': 'finished_at_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'phase': 'phase',
        'phase_in': 'phase_in',
        'phase_not': 'phase_not',
        'phase_not_in': 'phase_not_in',
        'replica_vm': 'replica_vm',
        'replication_plan': 'replication_plan',
        'replication_plan_execution': 'replication_plan_execution',
        'resource_version': 'resource_version',
        'resource_version_gt': 'resource_version_gt',
        'resource_version_gte': 'resource_version_gte',
        'resource_version_in': 'resource_version_in',
        'resource_version_lt': 'resource_version_lt',
        'resource_version_lte': 'resource_version_lte',
        'resource_version_not': 'resource_version_not',
        'resource_version_not_in': 'resource_version_not_in',
        'started_at': 'started_at',
        'started_at_gt': 'started_at_gt',
        'started_at_gte': 'started_at_gte',
        'started_at_in': 'started_at_in',
        'started_at_lt': 'started_at_lt',
        'started_at_lte': 'started_at_lte',
        'started_at_not': 'started_at_not',
        'started_at_not_in': 'started_at_not_in',
        'type': 'type',
        'type_in': 'type_in',
        'type_not': 'type_not',
        'type_not_in': 'type_not_in'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ReplicationTargetExecutionWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._creation = None
        self._creation_in = None
        self._creation_not = None
        self._creation_not_in = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._finished_at = None
        self._finished_at_gt = None
        self._finished_at_gte = None
        self._finished_at_in = None
        self._finished_at_lt = None
        self._finished_at_lte = None
        self._finished_at_not = None
        self._finished_at_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._phase = None
        self._phase_in = None
        self._phase_not = None
        self._phase_not_in = None
        self._replica_vm = None
        self._replication_plan = None
        self._replication_plan_execution = None
        self._resource_version = None
        self._resource_version_gt = None
        self._resource_version_gte = None
        self._resource_version_in = None
        self._resource_version_lt = None
        self._resource_version_lte = None
        self._resource_version_not = None
        self._resource_version_not_in = None
        self._started_at = None
        self._started_at_gt = None
        self._started_at_gte = None
        self._started_at_in = None
        self._started_at_lt = None
        self._started_at_lte = None
        self._started_at_not = None
        self._started_at_not_in = None
        self._type = None
        self._type_in = None
        self._type_not = None
        self._type_not_in = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.creation = kwargs.get("creation", None)
        self.creation_in = kwargs.get("creation_in", None)
        self.creation_not = kwargs.get("creation_not", None)
        self.creation_not_in = kwargs.get("creation_not_in", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.finished_at = kwargs.get("finished_at", None)
        self.finished_at_gt = kwargs.get("finished_at_gt", None)
        self.finished_at_gte = kwargs.get("finished_at_gte", None)
        self.finished_at_in = kwargs.get("finished_at_in", None)
        self.finished_at_lt = kwargs.get("finished_at_lt", None)
        self.finished_at_lte = kwargs.get("finished_at_lte", None)
        self.finished_at_not = kwargs.get("finished_at_not", None)
        self.finished_at_not_in = kwargs.get("finished_at_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.phase = kwargs.get("phase", None)
        self.phase_in = kwargs.get("phase_in", None)
        self.phase_not = kwargs.get("phase_not", None)
        self.phase_not_in = kwargs.get("phase_not_in", None)
        self.replica_vm = kwargs.get("replica_vm", None)
        self.replication_plan = kwargs.get("replication_plan", None)
        self.replication_plan_execution = kwargs.get("replication_plan_execution", None)
        self.resource_version = kwargs.get("resource_version", None)
        self.resource_version_gt = kwargs.get("resource_version_gt", None)
        self.resource_version_gte = kwargs.get("resource_version_gte", None)
        self.resource_version_in = kwargs.get("resource_version_in", None)
        self.resource_version_lt = kwargs.get("resource_version_lt", None)
        self.resource_version_lte = kwargs.get("resource_version_lte", None)
        self.resource_version_not = kwargs.get("resource_version_not", None)
        self.resource_version_not_in = kwargs.get("resource_version_not_in", None)
        self.started_at = kwargs.get("started_at", None)
        self.started_at_gt = kwargs.get("started_at_gt", None)
        self.started_at_gte = kwargs.get("started_at_gte", None)
        self.started_at_in = kwargs.get("started_at_in", None)
        self.started_at_lt = kwargs.get("started_at_lt", None)
        self.started_at_lte = kwargs.get("started_at_lte", None)
        self.started_at_not = kwargs.get("started_at_not", None)
        self.started_at_not_in = kwargs.get("started_at_not_in", None)
        self.type = kwargs.get("type", None)
        self.type_in = kwargs.get("type_in", None)
        self.type_not = kwargs.get("type_not", None)
        self.type_not_in = kwargs.get("type_not_in", None)

    @property
    def _and(self):
        """Gets the _and of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The _and of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[ReplicationTargetExecutionWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this ReplicationTargetExecutionWhereInput.


        :param _and: The _and of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type _and: list[ReplicationTargetExecutionWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The _not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[ReplicationTargetExecutionWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this ReplicationTargetExecutionWhereInput.


        :param _not: The _not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type _not: list[ReplicationTargetExecutionWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The _or of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[ReplicationTargetExecutionWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this ReplicationTargetExecutionWhereInput.


        :param _or: The _or of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type _or: list[ReplicationTargetExecutionWhereInput]
        """

        self.__or = _or

    @property
    def creation(self):
        """Gets the creation of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The creation of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: ReplicationTargetExecutionCreation
        """
        return self._creation

    @creation.setter
    def creation(self, creation):
        """Sets the creation of this ReplicationTargetExecutionWhereInput.


        :param creation: The creation of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type creation: ReplicationTargetExecutionCreation
        """

        self._creation = creation

    @property
    def creation_in(self):
        """Gets the creation_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The creation_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[ReplicationTargetExecutionCreation]
        """
        return self._creation_in

    @creation_in.setter
    def creation_in(self, creation_in):
        """Sets the creation_in of this ReplicationTargetExecutionWhereInput.


        :param creation_in: The creation_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type creation_in: list[ReplicationTargetExecutionCreation]
        """

        self._creation_in = creation_in

    @property
    def creation_not(self):
        """Gets the creation_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The creation_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: ReplicationTargetExecutionCreation
        """
        return self._creation_not

    @creation_not.setter
    def creation_not(self, creation_not):
        """Sets the creation_not of this ReplicationTargetExecutionWhereInput.


        :param creation_not: The creation_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type creation_not: ReplicationTargetExecutionCreation
        """

        self._creation_not = creation_not

    @property
    def creation_not_in(self):
        """Gets the creation_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The creation_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[ReplicationTargetExecutionCreation]
        """
        return self._creation_not_in

    @creation_not_in.setter
    def creation_not_in(self, creation_not_in):
        """Sets the creation_not_in of this ReplicationTargetExecutionWhereInput.


        :param creation_not_in: The creation_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type creation_not_in: list[ReplicationTargetExecutionCreation]
        """

        self._creation_not_in = creation_not_in

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this ReplicationTargetExecutionWhereInput.


        :param entity_async_status: The entity_async_status of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this ReplicationTargetExecutionWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this ReplicationTargetExecutionWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this ReplicationTargetExecutionWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def finished_at(self):
        """Gets the finished_at of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The finished_at of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """Sets the finished_at of this ReplicationTargetExecutionWhereInput.


        :param finished_at: The finished_at of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type finished_at: str
        """

        self._finished_at = finished_at

    @property
    def finished_at_gt(self):
        """Gets the finished_at_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The finished_at_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_gt

    @finished_at_gt.setter
    def finished_at_gt(self, finished_at_gt):
        """Sets the finished_at_gt of this ReplicationTargetExecutionWhereInput.


        :param finished_at_gt: The finished_at_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type finished_at_gt: str
        """

        self._finished_at_gt = finished_at_gt

    @property
    def finished_at_gte(self):
        """Gets the finished_at_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The finished_at_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_gte

    @finished_at_gte.setter
    def finished_at_gte(self, finished_at_gte):
        """Sets the finished_at_gte of this ReplicationTargetExecutionWhereInput.


        :param finished_at_gte: The finished_at_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type finished_at_gte: str
        """

        self._finished_at_gte = finished_at_gte

    @property
    def finished_at_in(self):
        """Gets the finished_at_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The finished_at_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._finished_at_in

    @finished_at_in.setter
    def finished_at_in(self, finished_at_in):
        """Sets the finished_at_in of this ReplicationTargetExecutionWhereInput.


        :param finished_at_in: The finished_at_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type finished_at_in: list[str]
        """

        self._finished_at_in = finished_at_in

    @property
    def finished_at_lt(self):
        """Gets the finished_at_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The finished_at_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_lt

    @finished_at_lt.setter
    def finished_at_lt(self, finished_at_lt):
        """Sets the finished_at_lt of this ReplicationTargetExecutionWhereInput.


        :param finished_at_lt: The finished_at_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type finished_at_lt: str
        """

        self._finished_at_lt = finished_at_lt

    @property
    def finished_at_lte(self):
        """Gets the finished_at_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The finished_at_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_lte

    @finished_at_lte.setter
    def finished_at_lte(self, finished_at_lte):
        """Sets the finished_at_lte of this ReplicationTargetExecutionWhereInput.


        :param finished_at_lte: The finished_at_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type finished_at_lte: str
        """

        self._finished_at_lte = finished_at_lte

    @property
    def finished_at_not(self):
        """Gets the finished_at_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The finished_at_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_not

    @finished_at_not.setter
    def finished_at_not(self, finished_at_not):
        """Sets the finished_at_not of this ReplicationTargetExecutionWhereInput.


        :param finished_at_not: The finished_at_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type finished_at_not: str
        """

        self._finished_at_not = finished_at_not

    @property
    def finished_at_not_in(self):
        """Gets the finished_at_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The finished_at_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._finished_at_not_in

    @finished_at_not_in.setter
    def finished_at_not_in(self, finished_at_not_in):
        """Sets the finished_at_not_in of this ReplicationTargetExecutionWhereInput.


        :param finished_at_not_in: The finished_at_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type finished_at_not_in: list[str]
        """

        self._finished_at_not_in = finished_at_not_in

    @property
    def id(self):
        """Gets the id of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The id of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ReplicationTargetExecutionWhereInput.


        :param id: The id of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The id_contains of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this ReplicationTargetExecutionWhereInput.


        :param id_contains: The id_contains of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The id_ends_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this ReplicationTargetExecutionWhereInput.


        :param id_ends_with: The id_ends_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The id_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this ReplicationTargetExecutionWhereInput.


        :param id_gt: The id_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The id_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this ReplicationTargetExecutionWhereInput.


        :param id_gte: The id_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The id_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this ReplicationTargetExecutionWhereInput.


        :param id_in: The id_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The id_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this ReplicationTargetExecutionWhereInput.


        :param id_lt: The id_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The id_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this ReplicationTargetExecutionWhereInput.


        :param id_lte: The id_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The id_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this ReplicationTargetExecutionWhereInput.


        :param id_not: The id_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The id_not_contains of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this ReplicationTargetExecutionWhereInput.


        :param id_not_contains: The id_not_contains of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this ReplicationTargetExecutionWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The id_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this ReplicationTargetExecutionWhereInput.


        :param id_not_in: The id_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this ReplicationTargetExecutionWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The id_starts_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this ReplicationTargetExecutionWhereInput.


        :param id_starts_with: The id_starts_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def local_id(self):
        """Gets the local_id of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this ReplicationTargetExecutionWhereInput.


        :param local_id: The local_id of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_contains of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this ReplicationTargetExecutionWhereInput.


        :param local_id_contains: The local_id_contains of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this ReplicationTargetExecutionWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this ReplicationTargetExecutionWhereInput.


        :param local_id_gt: The local_id_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this ReplicationTargetExecutionWhereInput.


        :param local_id_gte: The local_id_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this ReplicationTargetExecutionWhereInput.


        :param local_id_in: The local_id_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this ReplicationTargetExecutionWhereInput.


        :param local_id_lt: The local_id_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this ReplicationTargetExecutionWhereInput.


        :param local_id_lte: The local_id_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this ReplicationTargetExecutionWhereInput.


        :param local_id_not: The local_id_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this ReplicationTargetExecutionWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this ReplicationTargetExecutionWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this ReplicationTargetExecutionWhereInput.


        :param local_id_not_in: The local_id_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this ReplicationTargetExecutionWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this ReplicationTargetExecutionWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def phase(self):
        """Gets the phase of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The phase of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: BackupJobPhase
        """
        return self._phase

    @phase.setter
    def phase(self, phase):
        """Sets the phase of this ReplicationTargetExecutionWhereInput.


        :param phase: The phase of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type phase: BackupJobPhase
        """

        self._phase = phase

    @property
    def phase_in(self):
        """Gets the phase_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The phase_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupJobPhase]
        """
        return self._phase_in

    @phase_in.setter
    def phase_in(self, phase_in):
        """Sets the phase_in of this ReplicationTargetExecutionWhereInput.


        :param phase_in: The phase_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type phase_in: list[BackupJobPhase]
        """

        self._phase_in = phase_in

    @property
    def phase_not(self):
        """Gets the phase_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The phase_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: BackupJobPhase
        """
        return self._phase_not

    @phase_not.setter
    def phase_not(self, phase_not):
        """Sets the phase_not of this ReplicationTargetExecutionWhereInput.


        :param phase_not: The phase_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type phase_not: BackupJobPhase
        """

        self._phase_not = phase_not

    @property
    def phase_not_in(self):
        """Gets the phase_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The phase_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupJobPhase]
        """
        return self._phase_not_in

    @phase_not_in.setter
    def phase_not_in(self, phase_not_in):
        """Sets the phase_not_in of this ReplicationTargetExecutionWhereInput.


        :param phase_not_in: The phase_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type phase_not_in: list[BackupJobPhase]
        """

        self._phase_not_in = phase_not_in

    @property
    def replica_vm(self):
        """Gets the replica_vm of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The replica_vm of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: ReplicaVmWhereInput
        """
        return self._replica_vm

    @replica_vm.setter
    def replica_vm(self, replica_vm):
        """Sets the replica_vm of this ReplicationTargetExecutionWhereInput.


        :param replica_vm: The replica_vm of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type replica_vm: ReplicaVmWhereInput
        """

        self._replica_vm = replica_vm

    @property
    def replication_plan(self):
        """Gets the replication_plan of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The replication_plan of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: ReplicationPlanWhereInput
        """
        return self._replication_plan

    @replication_plan.setter
    def replication_plan(self, replication_plan):
        """Sets the replication_plan of this ReplicationTargetExecutionWhereInput.


        :param replication_plan: The replication_plan of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type replication_plan: ReplicationPlanWhereInput
        """

        self._replication_plan = replication_plan

    @property
    def replication_plan_execution(self):
        """Gets the replication_plan_execution of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The replication_plan_execution of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: ReplicationPlanExecutionWhereInput
        """
        return self._replication_plan_execution

    @replication_plan_execution.setter
    def replication_plan_execution(self, replication_plan_execution):
        """Sets the replication_plan_execution of this ReplicationTargetExecutionWhereInput.


        :param replication_plan_execution: The replication_plan_execution of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type replication_plan_execution: ReplicationPlanExecutionWhereInput
        """

        self._replication_plan_execution = replication_plan_execution

    @property
    def resource_version(self):
        """Gets the resource_version of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The resource_version of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version

    @resource_version.setter
    def resource_version(self, resource_version):
        """Sets the resource_version of this ReplicationTargetExecutionWhereInput.


        :param resource_version: The resource_version of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type resource_version: int
        """

        self._resource_version = resource_version

    @property
    def resource_version_gt(self):
        """Gets the resource_version_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The resource_version_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_gt

    @resource_version_gt.setter
    def resource_version_gt(self, resource_version_gt):
        """Sets the resource_version_gt of this ReplicationTargetExecutionWhereInput.


        :param resource_version_gt: The resource_version_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type resource_version_gt: int
        """

        self._resource_version_gt = resource_version_gt

    @property
    def resource_version_gte(self):
        """Gets the resource_version_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The resource_version_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_gte

    @resource_version_gte.setter
    def resource_version_gte(self, resource_version_gte):
        """Sets the resource_version_gte of this ReplicationTargetExecutionWhereInput.


        :param resource_version_gte: The resource_version_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type resource_version_gte: int
        """

        self._resource_version_gte = resource_version_gte

    @property
    def resource_version_in(self):
        """Gets the resource_version_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The resource_version_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._resource_version_in

    @resource_version_in.setter
    def resource_version_in(self, resource_version_in):
        """Sets the resource_version_in of this ReplicationTargetExecutionWhereInput.


        :param resource_version_in: The resource_version_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type resource_version_in: list[int]
        """

        self._resource_version_in = resource_version_in

    @property
    def resource_version_lt(self):
        """Gets the resource_version_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The resource_version_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_lt

    @resource_version_lt.setter
    def resource_version_lt(self, resource_version_lt):
        """Sets the resource_version_lt of this ReplicationTargetExecutionWhereInput.


        :param resource_version_lt: The resource_version_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type resource_version_lt: int
        """

        self._resource_version_lt = resource_version_lt

    @property
    def resource_version_lte(self):
        """Gets the resource_version_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The resource_version_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_lte

    @resource_version_lte.setter
    def resource_version_lte(self, resource_version_lte):
        """Sets the resource_version_lte of this ReplicationTargetExecutionWhereInput.


        :param resource_version_lte: The resource_version_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type resource_version_lte: int
        """

        self._resource_version_lte = resource_version_lte

    @property
    def resource_version_not(self):
        """Gets the resource_version_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The resource_version_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_not

    @resource_version_not.setter
    def resource_version_not(self, resource_version_not):
        """Sets the resource_version_not of this ReplicationTargetExecutionWhereInput.


        :param resource_version_not: The resource_version_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type resource_version_not: int
        """

        self._resource_version_not = resource_version_not

    @property
    def resource_version_not_in(self):
        """Gets the resource_version_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The resource_version_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._resource_version_not_in

    @resource_version_not_in.setter
    def resource_version_not_in(self, resource_version_not_in):
        """Sets the resource_version_not_in of this ReplicationTargetExecutionWhereInput.


        :param resource_version_not_in: The resource_version_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type resource_version_not_in: list[int]
        """

        self._resource_version_not_in = resource_version_not_in

    @property
    def started_at(self):
        """Gets the started_at of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The started_at of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """Sets the started_at of this ReplicationTargetExecutionWhereInput.


        :param started_at: The started_at of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type started_at: str
        """

        self._started_at = started_at

    @property
    def started_at_gt(self):
        """Gets the started_at_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The started_at_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._started_at_gt

    @started_at_gt.setter
    def started_at_gt(self, started_at_gt):
        """Sets the started_at_gt of this ReplicationTargetExecutionWhereInput.


        :param started_at_gt: The started_at_gt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type started_at_gt: str
        """

        self._started_at_gt = started_at_gt

    @property
    def started_at_gte(self):
        """Gets the started_at_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The started_at_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._started_at_gte

    @started_at_gte.setter
    def started_at_gte(self, started_at_gte):
        """Sets the started_at_gte of this ReplicationTargetExecutionWhereInput.


        :param started_at_gte: The started_at_gte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type started_at_gte: str
        """

        self._started_at_gte = started_at_gte

    @property
    def started_at_in(self):
        """Gets the started_at_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The started_at_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._started_at_in

    @started_at_in.setter
    def started_at_in(self, started_at_in):
        """Sets the started_at_in of this ReplicationTargetExecutionWhereInput.


        :param started_at_in: The started_at_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type started_at_in: list[str]
        """

        self._started_at_in = started_at_in

    @property
    def started_at_lt(self):
        """Gets the started_at_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The started_at_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._started_at_lt

    @started_at_lt.setter
    def started_at_lt(self, started_at_lt):
        """Sets the started_at_lt of this ReplicationTargetExecutionWhereInput.


        :param started_at_lt: The started_at_lt of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type started_at_lt: str
        """

        self._started_at_lt = started_at_lt

    @property
    def started_at_lte(self):
        """Gets the started_at_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The started_at_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._started_at_lte

    @started_at_lte.setter
    def started_at_lte(self, started_at_lte):
        """Sets the started_at_lte of this ReplicationTargetExecutionWhereInput.


        :param started_at_lte: The started_at_lte of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type started_at_lte: str
        """

        self._started_at_lte = started_at_lte

    @property
    def started_at_not(self):
        """Gets the started_at_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The started_at_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._started_at_not

    @started_at_not.setter
    def started_at_not(self, started_at_not):
        """Sets the started_at_not of this ReplicationTargetExecutionWhereInput.


        :param started_at_not: The started_at_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type started_at_not: str
        """

        self._started_at_not = started_at_not

    @property
    def started_at_not_in(self):
        """Gets the started_at_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The started_at_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._started_at_not_in

    @started_at_not_in.setter
    def started_at_not_in(self, started_at_not_in):
        """Sets the started_at_not_in of this ReplicationTargetExecutionWhereInput.


        :param started_at_not_in: The started_at_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type started_at_not_in: list[str]
        """

        self._started_at_not_in = started_at_not_in

    @property
    def type(self):
        """Gets the type of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The type of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: BackupExecutionType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ReplicationTargetExecutionWhereInput.


        :param type: The type of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type type: BackupExecutionType
        """

        self._type = type

    @property
    def type_in(self):
        """Gets the type_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The type_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupExecutionType]
        """
        return self._type_in

    @type_in.setter
    def type_in(self, type_in):
        """Sets the type_in of this ReplicationTargetExecutionWhereInput.


        :param type_in: The type_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type type_in: list[BackupExecutionType]
        """

        self._type_in = type_in

    @property
    def type_not(self):
        """Gets the type_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The type_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: BackupExecutionType
        """
        return self._type_not

    @type_not.setter
    def type_not(self, type_not):
        """Sets the type_not of this ReplicationTargetExecutionWhereInput.


        :param type_not: The type_not of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type type_not: BackupExecutionType
        """

        self._type_not = type_not

    @property
    def type_not_in(self):
        """Gets the type_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501


        :return: The type_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupExecutionType]
        """
        return self._type_not_in

    @type_not_in.setter
    def type_not_in(self, type_not_in):
        """Sets the type_not_in of this ReplicationTargetExecutionWhereInput.


        :param type_not_in: The type_not_in of this ReplicationTargetExecutionWhereInput.  # noqa: E501
        :type type_not_in: list[BackupExecutionType]
        """

        self._type_not_in = type_not_in

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReplicationTargetExecutionWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ReplicationTargetExecutionWhereInput):
            return True

        return self.to_dict() != other.to_dict()
