# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ResourceChangeEvent(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'prev_revision': 'str',
        'created_at': 'str',
        'new_value': 'str',
        'old_value': 'str',
        'resource_id': 'str',
        'resource_type': 'str',
        'action': 'str',
        'revision': 'str'
    }

    attribute_map = {
        'prev_revision': 'prev_revision',
        'created_at': 'created_at',
        'new_value': 'new_value',
        'old_value': 'old_value',
        'resource_id': 'resource_id',
        'resource_type': 'resource_type',
        'action': 'action',
        'revision': 'revision'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ResourceChangeEvent - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._prev_revision = None
        self._created_at = None
        self._new_value = None
        self._old_value = None
        self._resource_id = None
        self._resource_type = None
        self._action = None
        self._revision = None
        self.discriminator = None

        if "prev_revision" in kwargs:
            self.prev_revision = kwargs["prev_revision"]
        if "created_at" in kwargs:
            self.created_at = kwargs["created_at"]
        if "new_value" in kwargs:
            self.new_value = kwargs["new_value"]
        if "old_value" in kwargs:
            self.old_value = kwargs["old_value"]
        if "resource_id" in kwargs:
            self.resource_id = kwargs["resource_id"]
        if "resource_type" in kwargs:
            self.resource_type = kwargs["resource_type"]
        if "action" in kwargs:
            self.action = kwargs["action"]
        if "revision" in kwargs:
            self.revision = kwargs["revision"]

    @property
    def prev_revision(self):
        """Gets the prev_revision of this ResourceChangeEvent.  # noqa: E501


        :return: The prev_revision of this ResourceChangeEvent.  # noqa: E501
        :rtype: str
        """
        return self._prev_revision

    @prev_revision.setter
    def prev_revision(self, prev_revision):
        """Sets the prev_revision of this ResourceChangeEvent.


        :param prev_revision: The prev_revision of this ResourceChangeEvent.  # noqa: E501
        :type prev_revision: str
        """

        self._prev_revision = prev_revision

    @property
    def created_at(self):
        """Gets the created_at of this ResourceChangeEvent.  # noqa: E501


        :return: The created_at of this ResourceChangeEvent.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ResourceChangeEvent.


        :param created_at: The created_at of this ResourceChangeEvent.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def new_value(self):
        """Gets the new_value of this ResourceChangeEvent.  # noqa: E501


        :return: The new_value of this ResourceChangeEvent.  # noqa: E501
        :rtype: str
        """
        return self._new_value

    @new_value.setter
    def new_value(self, new_value):
        """Sets the new_value of this ResourceChangeEvent.


        :param new_value: The new_value of this ResourceChangeEvent.  # noqa: E501
        :type new_value: str
        """

        self._new_value = new_value

    @property
    def old_value(self):
        """Gets the old_value of this ResourceChangeEvent.  # noqa: E501


        :return: The old_value of this ResourceChangeEvent.  # noqa: E501
        :rtype: str
        """
        return self._old_value

    @old_value.setter
    def old_value(self, old_value):
        """Sets the old_value of this ResourceChangeEvent.


        :param old_value: The old_value of this ResourceChangeEvent.  # noqa: E501
        :type old_value: str
        """

        self._old_value = old_value

    @property
    def resource_id(self):
        """Gets the resource_id of this ResourceChangeEvent.  # noqa: E501


        :return: The resource_id of this ResourceChangeEvent.  # noqa: E501
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """Sets the resource_id of this ResourceChangeEvent.


        :param resource_id: The resource_id of this ResourceChangeEvent.  # noqa: E501
        :type resource_id: str
        """

        self._resource_id = resource_id

    @property
    def resource_type(self):
        """Gets the resource_type of this ResourceChangeEvent.  # noqa: E501


        :return: The resource_type of this ResourceChangeEvent.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this ResourceChangeEvent.


        :param resource_type: The resource_type of this ResourceChangeEvent.  # noqa: E501
        :type resource_type: str
        """

        self._resource_type = resource_type

    @property
    def action(self):
        """Gets the action of this ResourceChangeEvent.  # noqa: E501


        :return: The action of this ResourceChangeEvent.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this ResourceChangeEvent.


        :param action: The action of this ResourceChangeEvent.  # noqa: E501
        :type action: str
        """

        self._action = action

    @property
    def revision(self):
        """Gets the revision of this ResourceChangeEvent.  # noqa: E501


        :return: The revision of this ResourceChangeEvent.  # noqa: E501
        :rtype: str
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this ResourceChangeEvent.


        :param revision: The revision of this ResourceChangeEvent.  # noqa: E501
        :type revision: str
        """
        if self.local_vars_configuration.client_side_validation and revision is None:  # noqa: E501
            raise ValueError("Invalid value for `revision`, must not be `None`")  # noqa: E501

        self._revision = revision

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ResourceChangeEvent):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ResourceChangeEvent):
            return True

        return self.to_dict() != other.to_dict()
