# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ResourceChangeResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'current_revision': 'str',
        'compact_revision': 'str',
        'data': 'list[ResourceChangeEvent]',
        'error': 'object',
        'ec': 'str'
    }

    attribute_map = {
        'current_revision': 'currentRevision',
        'compact_revision': 'compactRevision',
        'data': 'data',
        'error': 'error',
        'ec': 'ec'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ResourceChangeResponse - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._current_revision = None
        self._compact_revision = None
        self._data = None
        self._error = None
        self._ec = None
        self.discriminator = None

        if "current_revision" in kwargs:
            self.current_revision = kwargs["current_revision"]
        if "compact_revision" in kwargs:
            self.compact_revision = kwargs["compact_revision"]
        if "data" in kwargs:
            self.data = kwargs["data"]
        self.error = kwargs.get("error", None)
        if "ec" in kwargs:
            self.ec = kwargs["ec"]

    @property
    def current_revision(self):
        """Gets the current_revision of this ResourceChangeResponse.  # noqa: E501


        :return: The current_revision of this ResourceChangeResponse.  # noqa: E501
        :rtype: str
        """
        return self._current_revision

    @current_revision.setter
    def current_revision(self, current_revision):
        """Sets the current_revision of this ResourceChangeResponse.


        :param current_revision: The current_revision of this ResourceChangeResponse.  # noqa: E501
        :type current_revision: str
        """
        if self.local_vars_configuration.client_side_validation and current_revision is None:  # noqa: E501
            raise ValueError("Invalid value for `current_revision`, must not be `None`")  # noqa: E501

        self._current_revision = current_revision

    @property
    def compact_revision(self):
        """Gets the compact_revision of this ResourceChangeResponse.  # noqa: E501


        :return: The compact_revision of this ResourceChangeResponse.  # noqa: E501
        :rtype: str
        """
        return self._compact_revision

    @compact_revision.setter
    def compact_revision(self, compact_revision):
        """Sets the compact_revision of this ResourceChangeResponse.


        :param compact_revision: The compact_revision of this ResourceChangeResponse.  # noqa: E501
        :type compact_revision: str
        """
        if self.local_vars_configuration.client_side_validation and compact_revision is None:  # noqa: E501
            raise ValueError("Invalid value for `compact_revision`, must not be `None`")  # noqa: E501

        self._compact_revision = compact_revision

    @property
    def data(self):
        """Gets the data of this ResourceChangeResponse.  # noqa: E501


        :return: The data of this ResourceChangeResponse.  # noqa: E501
        :rtype: list[ResourceChangeEvent]
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this ResourceChangeResponse.


        :param data: The data of this ResourceChangeResponse.  # noqa: E501
        :type data: list[ResourceChangeEvent]
        """
        if self.local_vars_configuration.client_side_validation and data is None:  # noqa: E501
            raise ValueError("Invalid value for `data`, must not be `None`")  # noqa: E501

        self._data = data

    @property
    def error(self):
        """Gets the error of this ResourceChangeResponse.  # noqa: E501


        :return: The error of this ResourceChangeResponse.  # noqa: E501
        :rtype: object
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this ResourceChangeResponse.


        :param error: The error of this ResourceChangeResponse.  # noqa: E501
        :type error: object
        """

        self._error = error

    @property
    def ec(self):
        """Gets the ec of this ResourceChangeResponse.  # noqa: E501


        :return: The ec of this ResourceChangeResponse.  # noqa: E501
        :rtype: str
        """
        return self._ec

    @ec.setter
    def ec(self, ec):
        """Sets the ec of this ResourceChangeResponse.


        :param ec: The ec of this ResourceChangeResponse.  # noqa: E501
        :type ec: str
        """
        if self.local_vars_configuration.client_side_validation and ec is None:  # noqa: E501
            raise ValueError("Invalid value for `ec`, must not be `None`")  # noqa: E501

        self._ec = ec

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ResourceChangeResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ResourceChangeResponse):
            return True

        return self.to_dict() != other.to_dict()
