# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class SecurityGroup(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'description': 'str',
        'everoute_cluster': 'NestedEverouteCluster',
        'id': 'str',
        'isolation_policies': 'list[NestedIsolationPolicy]',
        'label_groups': 'list[NestedLabelGroup]',
        'name': 'str',
        'security_policies': 'list[NestedSecurityPolicy]',
        'vms': 'list[NestedVm]'
    }

    attribute_map = {
        'description': 'description',
        'everoute_cluster': 'everoute_cluster',
        'id': 'id',
        'isolation_policies': 'isolation_policies',
        'label_groups': 'label_groups',
        'name': 'name',
        'security_policies': 'security_policies',
        'vms': 'vms'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """SecurityGroup - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._description = None
        self._everoute_cluster = None
        self._id = None
        self._isolation_policies = None
        self._label_groups = None
        self._name = None
        self._security_policies = None
        self._vms = None
        self.discriminator = None

        self.description = kwargs.get("description", None)
        if "everoute_cluster" in kwargs:
            self.everoute_cluster = kwargs["everoute_cluster"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.isolation_policies = kwargs.get("isolation_policies", None)
        self.label_groups = kwargs.get("label_groups", None)
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.security_policies = kwargs.get("security_policies", None)
        self.vms = kwargs.get("vms", None)

    @property
    def description(self):
        """Gets the description of this SecurityGroup.  # noqa: E501


        :return: The description of this SecurityGroup.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this SecurityGroup.


        :param description: The description of this SecurityGroup.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def everoute_cluster(self):
        """Gets the everoute_cluster of this SecurityGroup.  # noqa: E501


        :return: The everoute_cluster of this SecurityGroup.  # noqa: E501
        :rtype: NestedEverouteCluster
        """
        return self._everoute_cluster

    @everoute_cluster.setter
    def everoute_cluster(self, everoute_cluster):
        """Sets the everoute_cluster of this SecurityGroup.


        :param everoute_cluster: The everoute_cluster of this SecurityGroup.  # noqa: E501
        :type everoute_cluster: NestedEverouteCluster
        """
        if self.local_vars_configuration.client_side_validation and everoute_cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `everoute_cluster`, must not be `None`")  # noqa: E501

        self._everoute_cluster = everoute_cluster

    @property
    def id(self):
        """Gets the id of this SecurityGroup.  # noqa: E501


        :return: The id of this SecurityGroup.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SecurityGroup.


        :param id: The id of this SecurityGroup.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def isolation_policies(self):
        """Gets the isolation_policies of this SecurityGroup.  # noqa: E501


        :return: The isolation_policies of this SecurityGroup.  # noqa: E501
        :rtype: list[NestedIsolationPolicy]
        """
        return self._isolation_policies

    @isolation_policies.setter
    def isolation_policies(self, isolation_policies):
        """Sets the isolation_policies of this SecurityGroup.


        :param isolation_policies: The isolation_policies of this SecurityGroup.  # noqa: E501
        :type isolation_policies: list[NestedIsolationPolicy]
        """

        self._isolation_policies = isolation_policies

    @property
    def label_groups(self):
        """Gets the label_groups of this SecurityGroup.  # noqa: E501


        :return: The label_groups of this SecurityGroup.  # noqa: E501
        :rtype: list[NestedLabelGroup]
        """
        return self._label_groups

    @label_groups.setter
    def label_groups(self, label_groups):
        """Sets the label_groups of this SecurityGroup.


        :param label_groups: The label_groups of this SecurityGroup.  # noqa: E501
        :type label_groups: list[NestedLabelGroup]
        """

        self._label_groups = label_groups

    @property
    def name(self):
        """Gets the name of this SecurityGroup.  # noqa: E501


        :return: The name of this SecurityGroup.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SecurityGroup.


        :param name: The name of this SecurityGroup.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def security_policies(self):
        """Gets the security_policies of this SecurityGroup.  # noqa: E501


        :return: The security_policies of this SecurityGroup.  # noqa: E501
        :rtype: list[NestedSecurityPolicy]
        """
        return self._security_policies

    @security_policies.setter
    def security_policies(self, security_policies):
        """Sets the security_policies of this SecurityGroup.


        :param security_policies: The security_policies of this SecurityGroup.  # noqa: E501
        :type security_policies: list[NestedSecurityPolicy]
        """

        self._security_policies = security_policies

    @property
    def vms(self):
        """Gets the vms of this SecurityGroup.  # noqa: E501


        :return: The vms of this SecurityGroup.  # noqa: E501
        :rtype: list[NestedVm]
        """
        return self._vms

    @vms.setter
    def vms(self, vms):
        """Sets the vms of this SecurityGroup.


        :param vms: The vms of this SecurityGroup.  # noqa: E501
        :type vms: list[NestedVm]
        """

        self._vms = vms

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SecurityGroup):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SecurityGroup):
            return True

        return self.to_dict() != other.to_dict()
