# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class SecurityPolicyIngressEgressInputTarget(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'security_groups': 'SecurityGroupWhereInput',
        'ips': 'list[IPSecurityPolicy]',
        'label_groups': 'list[LabelWhereInput]'
    }

    attribute_map = {
        'security_groups': 'security_groups',
        'ips': 'ips',
        'label_groups': 'label_groups'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """SecurityPolicyIngressEgressInputTarget - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._security_groups = None
        self._ips = None
        self._label_groups = None
        self.discriminator = None

        if "security_groups" in kwargs:
            self.security_groups = kwargs["security_groups"]
        if "ips" in kwargs:
            self.ips = kwargs["ips"]
        if "label_groups" in kwargs:
            self.label_groups = kwargs["label_groups"]

    @property
    def security_groups(self):
        """Gets the security_groups of this SecurityPolicyIngressEgressInputTarget.  # noqa: E501


        :return: The security_groups of this SecurityPolicyIngressEgressInputTarget.  # noqa: E501
        :rtype: SecurityGroupWhereInput
        """
        return self._security_groups

    @security_groups.setter
    def security_groups(self, security_groups):
        """Sets the security_groups of this SecurityPolicyIngressEgressInputTarget.


        :param security_groups: The security_groups of this SecurityPolicyIngressEgressInputTarget.  # noqa: E501
        :type security_groups: SecurityGroupWhereInput
        """

        self._security_groups = security_groups

    @property
    def ips(self):
        """Gets the ips of this SecurityPolicyIngressEgressInputTarget.  # noqa: E501


        :return: The ips of this SecurityPolicyIngressEgressInputTarget.  # noqa: E501
        :rtype: list[IPSecurityPolicy]
        """
        return self._ips

    @ips.setter
    def ips(self, ips):
        """Sets the ips of this SecurityPolicyIngressEgressInputTarget.


        :param ips: The ips of this SecurityPolicyIngressEgressInputTarget.  # noqa: E501
        :type ips: list[IPSecurityPolicy]
        """

        self._ips = ips

    @property
    def label_groups(self):
        """Gets the label_groups of this SecurityPolicyIngressEgressInputTarget.  # noqa: E501


        :return: The label_groups of this SecurityPolicyIngressEgressInputTarget.  # noqa: E501
        :rtype: list[LabelWhereInput]
        """
        return self._label_groups

    @label_groups.setter
    def label_groups(self, label_groups):
        """Sets the label_groups of this SecurityPolicyIngressEgressInputTarget.


        :param label_groups: The label_groups of this SecurityPolicyIngressEgressInputTarget.  # noqa: E501
        :type label_groups: list[LabelWhereInput]
        """

        self._label_groups = label_groups

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SecurityPolicyIngressEgressInputTarget):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SecurityPolicyIngressEgressInputTarget):
            return True

        return self.to_dict() != other.to_dict()
