# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class SecurityPolicyUpdateParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'is_blocklist': 'bool',
        'ingress': 'list[SecurityPolicyIngressEgressInput]',
        'egress': 'list[SecurityPolicyIngressEgressInput]',
        'apply_to': 'list[SecurityPolicyApplyToInput]',
        'policy_mode': 'PolicyMode'
    }

    attribute_map = {
        'is_blocklist': 'is_blocklist',
        'ingress': 'ingress',
        'egress': 'egress',
        'apply_to': 'apply_to',
        'policy_mode': 'policy_mode'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """SecurityPolicyUpdateParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._is_blocklist = None
        self._ingress = None
        self._egress = None
        self._apply_to = None
        self._policy_mode = None
        self.discriminator = None

        if "is_blocklist" in kwargs:
            self.is_blocklist = kwargs["is_blocklist"]
        if "ingress" in kwargs:
            self.ingress = kwargs["ingress"]
        if "egress" in kwargs:
            self.egress = kwargs["egress"]
        if "apply_to" in kwargs:
            self.apply_to = kwargs["apply_to"]
        if "policy_mode" in kwargs:
            self.policy_mode = kwargs["policy_mode"]

    @property
    def is_blocklist(self):
        """Gets the is_blocklist of this SecurityPolicyUpdateParams.  # noqa: E501


        :return: The is_blocklist of this SecurityPolicyUpdateParams.  # noqa: E501
        :rtype: bool
        """
        return self._is_blocklist

    @is_blocklist.setter
    def is_blocklist(self, is_blocklist):
        """Sets the is_blocklist of this SecurityPolicyUpdateParams.


        :param is_blocklist: The is_blocklist of this SecurityPolicyUpdateParams.  # noqa: E501
        :type is_blocklist: bool
        """

        self._is_blocklist = is_blocklist

    @property
    def ingress(self):
        """Gets the ingress of this SecurityPolicyUpdateParams.  # noqa: E501


        :return: The ingress of this SecurityPolicyUpdateParams.  # noqa: E501
        :rtype: list[SecurityPolicyIngressEgressInput]
        """
        return self._ingress

    @ingress.setter
    def ingress(self, ingress):
        """Sets the ingress of this SecurityPolicyUpdateParams.


        :param ingress: The ingress of this SecurityPolicyUpdateParams.  # noqa: E501
        :type ingress: list[SecurityPolicyIngressEgressInput]
        """

        self._ingress = ingress

    @property
    def egress(self):
        """Gets the egress of this SecurityPolicyUpdateParams.  # noqa: E501


        :return: The egress of this SecurityPolicyUpdateParams.  # noqa: E501
        :rtype: list[SecurityPolicyIngressEgressInput]
        """
        return self._egress

    @egress.setter
    def egress(self, egress):
        """Sets the egress of this SecurityPolicyUpdateParams.


        :param egress: The egress of this SecurityPolicyUpdateParams.  # noqa: E501
        :type egress: list[SecurityPolicyIngressEgressInput]
        """

        self._egress = egress

    @property
    def apply_to(self):
        """Gets the apply_to of this SecurityPolicyUpdateParams.  # noqa: E501


        :return: The apply_to of this SecurityPolicyUpdateParams.  # noqa: E501
        :rtype: list[SecurityPolicyApplyToInput]
        """
        return self._apply_to

    @apply_to.setter
    def apply_to(self, apply_to):
        """Sets the apply_to of this SecurityPolicyUpdateParams.


        :param apply_to: The apply_to of this SecurityPolicyUpdateParams.  # noqa: E501
        :type apply_to: list[SecurityPolicyApplyToInput]
        """

        self._apply_to = apply_to

    @property
    def policy_mode(self):
        """Gets the policy_mode of this SecurityPolicyUpdateParams.  # noqa: E501


        :return: The policy_mode of this SecurityPolicyUpdateParams.  # noqa: E501
        :rtype: PolicyMode
        """
        return self._policy_mode

    @policy_mode.setter
    def policy_mode(self, policy_mode):
        """Sets the policy_mode of this SecurityPolicyUpdateParams.


        :param policy_mode: The policy_mode of this SecurityPolicyUpdateParams.  # noqa: E501
        :type policy_mode: PolicyMode
        """

        self._policy_mode = policy_mode

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SecurityPolicyUpdateParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SecurityPolicyUpdateParams):
            return True

        return self.to_dict() != other.to_dict()
