# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class SmtpServer(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'description': 'str',
        'host': 'str',
        'id': 'str',
        'name': 'str',
        'port': 'int',
        'secure_mode': 'SmtpSecureMode',
        'username': 'str'
    }

    attribute_map = {
        'description': 'description',
        'host': 'host',
        'id': 'id',
        'name': 'name',
        'port': 'port',
        'secure_mode': 'secure_mode',
        'username': 'username'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """SmtpServer - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._description = None
        self._host = None
        self._id = None
        self._name = None
        self._port = None
        self._secure_mode = None
        self._username = None
        self.discriminator = None

        self.description = kwargs.get("description", None)
        if "host" in kwargs:
            self.host = kwargs["host"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "port" in kwargs:
            self.port = kwargs["port"]
        self.secure_mode = kwargs.get("secure_mode", None)
        self.username = kwargs.get("username", None)

    @property
    def description(self):
        """Gets the description of this SmtpServer.  # noqa: E501


        :return: The description of this SmtpServer.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this SmtpServer.


        :param description: The description of this SmtpServer.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def host(self):
        """Gets the host of this SmtpServer.  # noqa: E501


        :return: The host of this SmtpServer.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this SmtpServer.


        :param host: The host of this SmtpServer.  # noqa: E501
        :type host: str
        """
        if self.local_vars_configuration.client_side_validation and host is None:  # noqa: E501
            raise ValueError("Invalid value for `host`, must not be `None`")  # noqa: E501

        self._host = host

    @property
    def id(self):
        """Gets the id of this SmtpServer.  # noqa: E501


        :return: The id of this SmtpServer.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SmtpServer.


        :param id: The id of this SmtpServer.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this SmtpServer.  # noqa: E501


        :return: The name of this SmtpServer.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SmtpServer.


        :param name: The name of this SmtpServer.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def port(self):
        """Gets the port of this SmtpServer.  # noqa: E501


        :return: The port of this SmtpServer.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this SmtpServer.


        :param port: The port of this SmtpServer.  # noqa: E501
        :type port: int
        """
        if self.local_vars_configuration.client_side_validation and port is None:  # noqa: E501
            raise ValueError("Invalid value for `port`, must not be `None`")  # noqa: E501

        self._port = port

    @property
    def secure_mode(self):
        """Gets the secure_mode of this SmtpServer.  # noqa: E501


        :return: The secure_mode of this SmtpServer.  # noqa: E501
        :rtype: SmtpSecureMode
        """
        return self._secure_mode

    @secure_mode.setter
    def secure_mode(self, secure_mode):
        """Sets the secure_mode of this SmtpServer.


        :param secure_mode: The secure_mode of this SmtpServer.  # noqa: E501
        :type secure_mode: SmtpSecureMode
        """

        self._secure_mode = secure_mode

    @property
    def username(self):
        """Gets the username of this SmtpServer.  # noqa: E501


        :return: The username of this SmtpServer.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this SmtpServer.


        :param username: The username of this SmtpServer.  # noqa: E501
        :type username: str
        """

        self._username = username

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SmtpServer):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SmtpServer):
            return True

        return self.to_dict() != other.to_dict()
