# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class SnapshotGroup(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cluster': 'NestedCluster',
        'deleted': 'bool',
        'entity_async_status': 'EntityAsyncStatus',
        'estimated_recycling_time': 'str',
        'id': 'str',
        'internal': 'bool',
        'keep': 'bool',
        'local_created_at': 'str',
        'local_id': 'str',
        'logical_size_bytes': 'int',
        'name': 'str',
        'object_num': 'int',
        'snapshot_plan_task': 'NestedSnapshotPlanTask',
        'vm_info': 'list[NestedSnapshotGroupVmInfo]',
        'vm_snapshots': 'list[NestedVmSnapshot]'
    }

    attribute_map = {
        'cluster': 'cluster',
        'deleted': 'deleted',
        'entity_async_status': 'entityAsyncStatus',
        'estimated_recycling_time': 'estimated_recycling_time',
        'id': 'id',
        'internal': 'internal',
        'keep': 'keep',
        'local_created_at': 'local_created_at',
        'local_id': 'local_id',
        'logical_size_bytes': 'logical_size_bytes',
        'name': 'name',
        'object_num': 'object_num',
        'snapshot_plan_task': 'snapshotPlanTask',
        'vm_info': 'vm_info',
        'vm_snapshots': 'vm_snapshots'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """SnapshotGroup - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cluster = None
        self._deleted = None
        self._entity_async_status = None
        self._estimated_recycling_time = None
        self._id = None
        self._internal = None
        self._keep = None
        self._local_created_at = None
        self._local_id = None
        self._logical_size_bytes = None
        self._name = None
        self._object_num = None
        self._snapshot_plan_task = None
        self._vm_info = None
        self._vm_snapshots = None
        self.discriminator = None

        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]
        if "deleted" in kwargs:
            self.deleted = kwargs["deleted"]
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.estimated_recycling_time = kwargs.get("estimated_recycling_time", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.internal = kwargs.get("internal", None)
        if "keep" in kwargs:
            self.keep = kwargs["keep"]
        if "local_created_at" in kwargs:
            self.local_created_at = kwargs["local_created_at"]
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "logical_size_bytes" in kwargs:
            self.logical_size_bytes = kwargs["logical_size_bytes"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "object_num" in kwargs:
            self.object_num = kwargs["object_num"]
        if "snapshot_plan_task" in kwargs:
            self.snapshot_plan_task = kwargs["snapshot_plan_task"]
        if "vm_info" in kwargs:
            self.vm_info = kwargs["vm_info"]
        self.vm_snapshots = kwargs.get("vm_snapshots", None)

    @property
    def cluster(self):
        """Gets the cluster of this SnapshotGroup.  # noqa: E501


        :return: The cluster of this SnapshotGroup.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this SnapshotGroup.


        :param cluster: The cluster of this SnapshotGroup.  # noqa: E501
        :type cluster: NestedCluster
        """
        if self.local_vars_configuration.client_side_validation and cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster`, must not be `None`")  # noqa: E501

        self._cluster = cluster

    @property
    def deleted(self):
        """Gets the deleted of this SnapshotGroup.  # noqa: E501


        :return: The deleted of this SnapshotGroup.  # noqa: E501
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """Sets the deleted of this SnapshotGroup.


        :param deleted: The deleted of this SnapshotGroup.  # noqa: E501
        :type deleted: bool
        """
        if self.local_vars_configuration.client_side_validation and deleted is None:  # noqa: E501
            raise ValueError("Invalid value for `deleted`, must not be `None`")  # noqa: E501

        self._deleted = deleted

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this SnapshotGroup.  # noqa: E501


        :return: The entity_async_status of this SnapshotGroup.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this SnapshotGroup.


        :param entity_async_status: The entity_async_status of this SnapshotGroup.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def estimated_recycling_time(self):
        """Gets the estimated_recycling_time of this SnapshotGroup.  # noqa: E501


        :return: The estimated_recycling_time of this SnapshotGroup.  # noqa: E501
        :rtype: str
        """
        return self._estimated_recycling_time

    @estimated_recycling_time.setter
    def estimated_recycling_time(self, estimated_recycling_time):
        """Sets the estimated_recycling_time of this SnapshotGroup.


        :param estimated_recycling_time: The estimated_recycling_time of this SnapshotGroup.  # noqa: E501
        :type estimated_recycling_time: str
        """

        self._estimated_recycling_time = estimated_recycling_time

    @property
    def id(self):
        """Gets the id of this SnapshotGroup.  # noqa: E501


        :return: The id of this SnapshotGroup.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SnapshotGroup.


        :param id: The id of this SnapshotGroup.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def internal(self):
        """Gets the internal of this SnapshotGroup.  # noqa: E501


        :return: The internal of this SnapshotGroup.  # noqa: E501
        :rtype: bool
        """
        return self._internal

    @internal.setter
    def internal(self, internal):
        """Sets the internal of this SnapshotGroup.


        :param internal: The internal of this SnapshotGroup.  # noqa: E501
        :type internal: bool
        """

        self._internal = internal

    @property
    def keep(self):
        """Gets the keep of this SnapshotGroup.  # noqa: E501


        :return: The keep of this SnapshotGroup.  # noqa: E501
        :rtype: bool
        """
        return self._keep

    @keep.setter
    def keep(self, keep):
        """Sets the keep of this SnapshotGroup.


        :param keep: The keep of this SnapshotGroup.  # noqa: E501
        :type keep: bool
        """
        if self.local_vars_configuration.client_side_validation and keep is None:  # noqa: E501
            raise ValueError("Invalid value for `keep`, must not be `None`")  # noqa: E501

        self._keep = keep

    @property
    def local_created_at(self):
        """Gets the local_created_at of this SnapshotGroup.  # noqa: E501


        :return: The local_created_at of this SnapshotGroup.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this SnapshotGroup.


        :param local_created_at: The local_created_at of this SnapshotGroup.  # noqa: E501
        :type local_created_at: str
        """
        if self.local_vars_configuration.client_side_validation and local_created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `local_created_at`, must not be `None`")  # noqa: E501

        self._local_created_at = local_created_at

    @property
    def local_id(self):
        """Gets the local_id of this SnapshotGroup.  # noqa: E501


        :return: The local_id of this SnapshotGroup.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this SnapshotGroup.


        :param local_id: The local_id of this SnapshotGroup.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def logical_size_bytes(self):
        """Gets the logical_size_bytes of this SnapshotGroup.  # noqa: E501


        :return: The logical_size_bytes of this SnapshotGroup.  # noqa: E501
        :rtype: int
        """
        return self._logical_size_bytes

    @logical_size_bytes.setter
    def logical_size_bytes(self, logical_size_bytes):
        """Sets the logical_size_bytes of this SnapshotGroup.


        :param logical_size_bytes: The logical_size_bytes of this SnapshotGroup.  # noqa: E501
        :type logical_size_bytes: int
        """
        if self.local_vars_configuration.client_side_validation and logical_size_bytes is None:  # noqa: E501
            raise ValueError("Invalid value for `logical_size_bytes`, must not be `None`")  # noqa: E501

        self._logical_size_bytes = logical_size_bytes

    @property
    def name(self):
        """Gets the name of this SnapshotGroup.  # noqa: E501


        :return: The name of this SnapshotGroup.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SnapshotGroup.


        :param name: The name of this SnapshotGroup.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def object_num(self):
        """Gets the object_num of this SnapshotGroup.  # noqa: E501


        :return: The object_num of this SnapshotGroup.  # noqa: E501
        :rtype: int
        """
        return self._object_num

    @object_num.setter
    def object_num(self, object_num):
        """Sets the object_num of this SnapshotGroup.


        :param object_num: The object_num of this SnapshotGroup.  # noqa: E501
        :type object_num: int
        """
        if self.local_vars_configuration.client_side_validation and object_num is None:  # noqa: E501
            raise ValueError("Invalid value for `object_num`, must not be `None`")  # noqa: E501

        self._object_num = object_num

    @property
    def snapshot_plan_task(self):
        """Gets the snapshot_plan_task of this SnapshotGroup.  # noqa: E501


        :return: The snapshot_plan_task of this SnapshotGroup.  # noqa: E501
        :rtype: NestedSnapshotPlanTask
        """
        return self._snapshot_plan_task

    @snapshot_plan_task.setter
    def snapshot_plan_task(self, snapshot_plan_task):
        """Sets the snapshot_plan_task of this SnapshotGroup.


        :param snapshot_plan_task: The snapshot_plan_task of this SnapshotGroup.  # noqa: E501
        :type snapshot_plan_task: NestedSnapshotPlanTask
        """
        if self.local_vars_configuration.client_side_validation and snapshot_plan_task is None:  # noqa: E501
            raise ValueError("Invalid value for `snapshot_plan_task`, must not be `None`")  # noqa: E501

        self._snapshot_plan_task = snapshot_plan_task

    @property
    def vm_info(self):
        """Gets the vm_info of this SnapshotGroup.  # noqa: E501


        :return: The vm_info of this SnapshotGroup.  # noqa: E501
        :rtype: list[NestedSnapshotGroupVmInfo]
        """
        return self._vm_info

    @vm_info.setter
    def vm_info(self, vm_info):
        """Sets the vm_info of this SnapshotGroup.


        :param vm_info: The vm_info of this SnapshotGroup.  # noqa: E501
        :type vm_info: list[NestedSnapshotGroupVmInfo]
        """
        if self.local_vars_configuration.client_side_validation and vm_info is None:  # noqa: E501
            raise ValueError("Invalid value for `vm_info`, must not be `None`")  # noqa: E501

        self._vm_info = vm_info

    @property
    def vm_snapshots(self):
        """Gets the vm_snapshots of this SnapshotGroup.  # noqa: E501


        :return: The vm_snapshots of this SnapshotGroup.  # noqa: E501
        :rtype: list[NestedVmSnapshot]
        """
        return self._vm_snapshots

    @vm_snapshots.setter
    def vm_snapshots(self, vm_snapshots):
        """Sets the vm_snapshots of this SnapshotGroup.


        :param vm_snapshots: The vm_snapshots of this SnapshotGroup.  # noqa: E501
        :type vm_snapshots: list[NestedVmSnapshot]
        """

        self._vm_snapshots = vm_snapshots

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotGroup):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotGroup):
            return True

        return self.to_dict() != other.to_dict()
