# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class SnapshotPlan(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'auto_delete_num': 'int',
        'auto_execute_num': 'int',
        'cluster': 'NestedCluster',
        'description': 'str',
        'end_time': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'exec_h_m': 'object',
        'execute_intervals': 'list[int]',
        'execute_plan_type': 'SnapshotPlanExecuteType',
        'execution_tasks': 'list[NestedSnapshotPlanTask]',
        'healthy': 'bool',
        'id': 'str',
        'last_execute_end_time': 'str',
        'last_execute_status': 'SnapshotPlanExecuteStatus',
        'last_execute_time': 'str',
        'local_id': 'str',
        'logical_size_bytes': 'int',
        'manual_delete_num': 'int',
        'manual_execute_num': 'int',
        'mirror': 'bool',
        'name': 'str',
        'next_execute_time': 'str',
        'object_num': 'int',
        'physical_size_bytes': 'int',
        'remain_snapshot_num': 'int',
        'snapshot_group_num': 'int',
        'start_time': 'str',
        'status': 'SnapshotPlanStatus',
        'vms': 'list[NestedVm]'
    }

    attribute_map = {
        'auto_delete_num': 'auto_delete_num',
        'auto_execute_num': 'auto_execute_num',
        'cluster': 'cluster',
        'description': 'description',
        'end_time': 'end_time',
        'entity_async_status': 'entityAsyncStatus',
        'exec_h_m': 'exec_h_m',
        'execute_intervals': 'execute_intervals',
        'execute_plan_type': 'execute_plan_type',
        'execution_tasks': 'execution_tasks',
        'healthy': 'healthy',
        'id': 'id',
        'last_execute_end_time': 'last_execute_end_time',
        'last_execute_status': 'last_execute_status',
        'last_execute_time': 'last_execute_time',
        'local_id': 'local_id',
        'logical_size_bytes': 'logical_size_bytes',
        'manual_delete_num': 'manual_delete_num',
        'manual_execute_num': 'manual_execute_num',
        'mirror': 'mirror',
        'name': 'name',
        'next_execute_time': 'next_execute_time',
        'object_num': 'object_num',
        'physical_size_bytes': 'physical_size_bytes',
        'remain_snapshot_num': 'remain_snapshot_num',
        'snapshot_group_num': 'snapshot_group_num',
        'start_time': 'start_time',
        'status': 'status',
        'vms': 'vms'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """SnapshotPlan - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._auto_delete_num = None
        self._auto_execute_num = None
        self._cluster = None
        self._description = None
        self._end_time = None
        self._entity_async_status = None
        self._exec_h_m = None
        self._execute_intervals = None
        self._execute_plan_type = None
        self._execution_tasks = None
        self._healthy = None
        self._id = None
        self._last_execute_end_time = None
        self._last_execute_status = None
        self._last_execute_time = None
        self._local_id = None
        self._logical_size_bytes = None
        self._manual_delete_num = None
        self._manual_execute_num = None
        self._mirror = None
        self._name = None
        self._next_execute_time = None
        self._object_num = None
        self._physical_size_bytes = None
        self._remain_snapshot_num = None
        self._snapshot_group_num = None
        self._start_time = None
        self._status = None
        self._vms = None
        self.discriminator = None

        if "auto_delete_num" in kwargs:
            self.auto_delete_num = kwargs["auto_delete_num"]
        if "auto_execute_num" in kwargs:
            self.auto_execute_num = kwargs["auto_execute_num"]
        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]
        if "description" in kwargs:
            self.description = kwargs["description"]
        self.end_time = kwargs.get("end_time", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.exec_h_m = kwargs.get("exec_h_m", None)
        if "execute_intervals" in kwargs:
            self.execute_intervals = kwargs["execute_intervals"]
        if "execute_plan_type" in kwargs:
            self.execute_plan_type = kwargs["execute_plan_type"]
        self.execution_tasks = kwargs.get("execution_tasks", None)
        if "healthy" in kwargs:
            self.healthy = kwargs["healthy"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.last_execute_end_time = kwargs.get("last_execute_end_time", None)
        if "last_execute_status" in kwargs:
            self.last_execute_status = kwargs["last_execute_status"]
        self.last_execute_time = kwargs.get("last_execute_time", None)
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "logical_size_bytes" in kwargs:
            self.logical_size_bytes = kwargs["logical_size_bytes"]
        if "manual_delete_num" in kwargs:
            self.manual_delete_num = kwargs["manual_delete_num"]
        if "manual_execute_num" in kwargs:
            self.manual_execute_num = kwargs["manual_execute_num"]
        if "mirror" in kwargs:
            self.mirror = kwargs["mirror"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.next_execute_time = kwargs.get("next_execute_time", None)
        if "object_num" in kwargs:
            self.object_num = kwargs["object_num"]
        if "physical_size_bytes" in kwargs:
            self.physical_size_bytes = kwargs["physical_size_bytes"]
        if "remain_snapshot_num" in kwargs:
            self.remain_snapshot_num = kwargs["remain_snapshot_num"]
        if "snapshot_group_num" in kwargs:
            self.snapshot_group_num = kwargs["snapshot_group_num"]
        if "start_time" in kwargs:
            self.start_time = kwargs["start_time"]
        if "status" in kwargs:
            self.status = kwargs["status"]
        self.vms = kwargs.get("vms", None)

    @property
    def auto_delete_num(self):
        """Gets the auto_delete_num of this SnapshotPlan.  # noqa: E501


        :return: The auto_delete_num of this SnapshotPlan.  # noqa: E501
        :rtype: int
        """
        return self._auto_delete_num

    @auto_delete_num.setter
    def auto_delete_num(self, auto_delete_num):
        """Sets the auto_delete_num of this SnapshotPlan.


        :param auto_delete_num: The auto_delete_num of this SnapshotPlan.  # noqa: E501
        :type auto_delete_num: int
        """
        if self.local_vars_configuration.client_side_validation and auto_delete_num is None:  # noqa: E501
            raise ValueError("Invalid value for `auto_delete_num`, must not be `None`")  # noqa: E501

        self._auto_delete_num = auto_delete_num

    @property
    def auto_execute_num(self):
        """Gets the auto_execute_num of this SnapshotPlan.  # noqa: E501


        :return: The auto_execute_num of this SnapshotPlan.  # noqa: E501
        :rtype: int
        """
        return self._auto_execute_num

    @auto_execute_num.setter
    def auto_execute_num(self, auto_execute_num):
        """Sets the auto_execute_num of this SnapshotPlan.


        :param auto_execute_num: The auto_execute_num of this SnapshotPlan.  # noqa: E501
        :type auto_execute_num: int
        """
        if self.local_vars_configuration.client_side_validation and auto_execute_num is None:  # noqa: E501
            raise ValueError("Invalid value for `auto_execute_num`, must not be `None`")  # noqa: E501

        self._auto_execute_num = auto_execute_num

    @property
    def cluster(self):
        """Gets the cluster of this SnapshotPlan.  # noqa: E501


        :return: The cluster of this SnapshotPlan.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this SnapshotPlan.


        :param cluster: The cluster of this SnapshotPlan.  # noqa: E501
        :type cluster: NestedCluster
        """
        if self.local_vars_configuration.client_side_validation and cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster`, must not be `None`")  # noqa: E501

        self._cluster = cluster

    @property
    def description(self):
        """Gets the description of this SnapshotPlan.  # noqa: E501


        :return: The description of this SnapshotPlan.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this SnapshotPlan.


        :param description: The description of this SnapshotPlan.  # noqa: E501
        :type description: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def end_time(self):
        """Gets the end_time of this SnapshotPlan.  # noqa: E501


        :return: The end_time of this SnapshotPlan.  # noqa: E501
        :rtype: str
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this SnapshotPlan.


        :param end_time: The end_time of this SnapshotPlan.  # noqa: E501
        :type end_time: str
        """

        self._end_time = end_time

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this SnapshotPlan.  # noqa: E501


        :return: The entity_async_status of this SnapshotPlan.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this SnapshotPlan.


        :param entity_async_status: The entity_async_status of this SnapshotPlan.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def exec_h_m(self):
        """Gets the exec_h_m of this SnapshotPlan.  # noqa: E501


        :return: The exec_h_m of this SnapshotPlan.  # noqa: E501
        :rtype: object
        """
        return self._exec_h_m

    @exec_h_m.setter
    def exec_h_m(self, exec_h_m):
        """Sets the exec_h_m of this SnapshotPlan.


        :param exec_h_m: The exec_h_m of this SnapshotPlan.  # noqa: E501
        :type exec_h_m: object
        """

        self._exec_h_m = exec_h_m

    @property
    def execute_intervals(self):
        """Gets the execute_intervals of this SnapshotPlan.  # noqa: E501


        :return: The execute_intervals of this SnapshotPlan.  # noqa: E501
        :rtype: list[int]
        """
        return self._execute_intervals

    @execute_intervals.setter
    def execute_intervals(self, execute_intervals):
        """Sets the execute_intervals of this SnapshotPlan.


        :param execute_intervals: The execute_intervals of this SnapshotPlan.  # noqa: E501
        :type execute_intervals: list[int]
        """
        if self.local_vars_configuration.client_side_validation and execute_intervals is None:  # noqa: E501
            raise ValueError("Invalid value for `execute_intervals`, must not be `None`")  # noqa: E501

        self._execute_intervals = execute_intervals

    @property
    def execute_plan_type(self):
        """Gets the execute_plan_type of this SnapshotPlan.  # noqa: E501


        :return: The execute_plan_type of this SnapshotPlan.  # noqa: E501
        :rtype: SnapshotPlanExecuteType
        """
        return self._execute_plan_type

    @execute_plan_type.setter
    def execute_plan_type(self, execute_plan_type):
        """Sets the execute_plan_type of this SnapshotPlan.


        :param execute_plan_type: The execute_plan_type of this SnapshotPlan.  # noqa: E501
        :type execute_plan_type: SnapshotPlanExecuteType
        """
        if self.local_vars_configuration.client_side_validation and execute_plan_type is None:  # noqa: E501
            raise ValueError("Invalid value for `execute_plan_type`, must not be `None`")  # noqa: E501

        self._execute_plan_type = execute_plan_type

    @property
    def execution_tasks(self):
        """Gets the execution_tasks of this SnapshotPlan.  # noqa: E501


        :return: The execution_tasks of this SnapshotPlan.  # noqa: E501
        :rtype: list[NestedSnapshotPlanTask]
        """
        return self._execution_tasks

    @execution_tasks.setter
    def execution_tasks(self, execution_tasks):
        """Sets the execution_tasks of this SnapshotPlan.


        :param execution_tasks: The execution_tasks of this SnapshotPlan.  # noqa: E501
        :type execution_tasks: list[NestedSnapshotPlanTask]
        """

        self._execution_tasks = execution_tasks

    @property
    def healthy(self):
        """Gets the healthy of this SnapshotPlan.  # noqa: E501


        :return: The healthy of this SnapshotPlan.  # noqa: E501
        :rtype: bool
        """
        return self._healthy

    @healthy.setter
    def healthy(self, healthy):
        """Sets the healthy of this SnapshotPlan.


        :param healthy: The healthy of this SnapshotPlan.  # noqa: E501
        :type healthy: bool
        """
        if self.local_vars_configuration.client_side_validation and healthy is None:  # noqa: E501
            raise ValueError("Invalid value for `healthy`, must not be `None`")  # noqa: E501

        self._healthy = healthy

    @property
    def id(self):
        """Gets the id of this SnapshotPlan.  # noqa: E501


        :return: The id of this SnapshotPlan.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SnapshotPlan.


        :param id: The id of this SnapshotPlan.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def last_execute_end_time(self):
        """Gets the last_execute_end_time of this SnapshotPlan.  # noqa: E501


        :return: The last_execute_end_time of this SnapshotPlan.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_end_time

    @last_execute_end_time.setter
    def last_execute_end_time(self, last_execute_end_time):
        """Sets the last_execute_end_time of this SnapshotPlan.


        :param last_execute_end_time: The last_execute_end_time of this SnapshotPlan.  # noqa: E501
        :type last_execute_end_time: str
        """

        self._last_execute_end_time = last_execute_end_time

    @property
    def last_execute_status(self):
        """Gets the last_execute_status of this SnapshotPlan.  # noqa: E501


        :return: The last_execute_status of this SnapshotPlan.  # noqa: E501
        :rtype: SnapshotPlanExecuteStatus
        """
        return self._last_execute_status

    @last_execute_status.setter
    def last_execute_status(self, last_execute_status):
        """Sets the last_execute_status of this SnapshotPlan.


        :param last_execute_status: The last_execute_status of this SnapshotPlan.  # noqa: E501
        :type last_execute_status: SnapshotPlanExecuteStatus
        """
        if self.local_vars_configuration.client_side_validation and last_execute_status is None:  # noqa: E501
            raise ValueError("Invalid value for `last_execute_status`, must not be `None`")  # noqa: E501

        self._last_execute_status = last_execute_status

    @property
    def last_execute_time(self):
        """Gets the last_execute_time of this SnapshotPlan.  # noqa: E501


        :return: The last_execute_time of this SnapshotPlan.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_time

    @last_execute_time.setter
    def last_execute_time(self, last_execute_time):
        """Sets the last_execute_time of this SnapshotPlan.


        :param last_execute_time: The last_execute_time of this SnapshotPlan.  # noqa: E501
        :type last_execute_time: str
        """

        self._last_execute_time = last_execute_time

    @property
    def local_id(self):
        """Gets the local_id of this SnapshotPlan.  # noqa: E501


        :return: The local_id of this SnapshotPlan.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this SnapshotPlan.


        :param local_id: The local_id of this SnapshotPlan.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def logical_size_bytes(self):
        """Gets the logical_size_bytes of this SnapshotPlan.  # noqa: E501


        :return: The logical_size_bytes of this SnapshotPlan.  # noqa: E501
        :rtype: int
        """
        return self._logical_size_bytes

    @logical_size_bytes.setter
    def logical_size_bytes(self, logical_size_bytes):
        """Sets the logical_size_bytes of this SnapshotPlan.


        :param logical_size_bytes: The logical_size_bytes of this SnapshotPlan.  # noqa: E501
        :type logical_size_bytes: int
        """
        if self.local_vars_configuration.client_side_validation and logical_size_bytes is None:  # noqa: E501
            raise ValueError("Invalid value for `logical_size_bytes`, must not be `None`")  # noqa: E501

        self._logical_size_bytes = logical_size_bytes

    @property
    def manual_delete_num(self):
        """Gets the manual_delete_num of this SnapshotPlan.  # noqa: E501


        :return: The manual_delete_num of this SnapshotPlan.  # noqa: E501
        :rtype: int
        """
        return self._manual_delete_num

    @manual_delete_num.setter
    def manual_delete_num(self, manual_delete_num):
        """Sets the manual_delete_num of this SnapshotPlan.


        :param manual_delete_num: The manual_delete_num of this SnapshotPlan.  # noqa: E501
        :type manual_delete_num: int
        """
        if self.local_vars_configuration.client_side_validation and manual_delete_num is None:  # noqa: E501
            raise ValueError("Invalid value for `manual_delete_num`, must not be `None`")  # noqa: E501

        self._manual_delete_num = manual_delete_num

    @property
    def manual_execute_num(self):
        """Gets the manual_execute_num of this SnapshotPlan.  # noqa: E501


        :return: The manual_execute_num of this SnapshotPlan.  # noqa: E501
        :rtype: int
        """
        return self._manual_execute_num

    @manual_execute_num.setter
    def manual_execute_num(self, manual_execute_num):
        """Sets the manual_execute_num of this SnapshotPlan.


        :param manual_execute_num: The manual_execute_num of this SnapshotPlan.  # noqa: E501
        :type manual_execute_num: int
        """
        if self.local_vars_configuration.client_side_validation and manual_execute_num is None:  # noqa: E501
            raise ValueError("Invalid value for `manual_execute_num`, must not be `None`")  # noqa: E501

        self._manual_execute_num = manual_execute_num

    @property
    def mirror(self):
        """Gets the mirror of this SnapshotPlan.  # noqa: E501


        :return: The mirror of this SnapshotPlan.  # noqa: E501
        :rtype: bool
        """
        return self._mirror

    @mirror.setter
    def mirror(self, mirror):
        """Sets the mirror of this SnapshotPlan.


        :param mirror: The mirror of this SnapshotPlan.  # noqa: E501
        :type mirror: bool
        """
        if self.local_vars_configuration.client_side_validation and mirror is None:  # noqa: E501
            raise ValueError("Invalid value for `mirror`, must not be `None`")  # noqa: E501

        self._mirror = mirror

    @property
    def name(self):
        """Gets the name of this SnapshotPlan.  # noqa: E501


        :return: The name of this SnapshotPlan.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SnapshotPlan.


        :param name: The name of this SnapshotPlan.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def next_execute_time(self):
        """Gets the next_execute_time of this SnapshotPlan.  # noqa: E501


        :return: The next_execute_time of this SnapshotPlan.  # noqa: E501
        :rtype: str
        """
        return self._next_execute_time

    @next_execute_time.setter
    def next_execute_time(self, next_execute_time):
        """Sets the next_execute_time of this SnapshotPlan.


        :param next_execute_time: The next_execute_time of this SnapshotPlan.  # noqa: E501
        :type next_execute_time: str
        """

        self._next_execute_time = next_execute_time

    @property
    def object_num(self):
        """Gets the object_num of this SnapshotPlan.  # noqa: E501


        :return: The object_num of this SnapshotPlan.  # noqa: E501
        :rtype: int
        """
        return self._object_num

    @object_num.setter
    def object_num(self, object_num):
        """Sets the object_num of this SnapshotPlan.


        :param object_num: The object_num of this SnapshotPlan.  # noqa: E501
        :type object_num: int
        """
        if self.local_vars_configuration.client_side_validation and object_num is None:  # noqa: E501
            raise ValueError("Invalid value for `object_num`, must not be `None`")  # noqa: E501

        self._object_num = object_num

    @property
    def physical_size_bytes(self):
        """Gets the physical_size_bytes of this SnapshotPlan.  # noqa: E501


        :return: The physical_size_bytes of this SnapshotPlan.  # noqa: E501
        :rtype: int
        """
        return self._physical_size_bytes

    @physical_size_bytes.setter
    def physical_size_bytes(self, physical_size_bytes):
        """Sets the physical_size_bytes of this SnapshotPlan.


        :param physical_size_bytes: The physical_size_bytes of this SnapshotPlan.  # noqa: E501
        :type physical_size_bytes: int
        """
        if self.local_vars_configuration.client_side_validation and physical_size_bytes is None:  # noqa: E501
            raise ValueError("Invalid value for `physical_size_bytes`, must not be `None`")  # noqa: E501

        self._physical_size_bytes = physical_size_bytes

    @property
    def remain_snapshot_num(self):
        """Gets the remain_snapshot_num of this SnapshotPlan.  # noqa: E501


        :return: The remain_snapshot_num of this SnapshotPlan.  # noqa: E501
        :rtype: int
        """
        return self._remain_snapshot_num

    @remain_snapshot_num.setter
    def remain_snapshot_num(self, remain_snapshot_num):
        """Sets the remain_snapshot_num of this SnapshotPlan.


        :param remain_snapshot_num: The remain_snapshot_num of this SnapshotPlan.  # noqa: E501
        :type remain_snapshot_num: int
        """
        if self.local_vars_configuration.client_side_validation and remain_snapshot_num is None:  # noqa: E501
            raise ValueError("Invalid value for `remain_snapshot_num`, must not be `None`")  # noqa: E501

        self._remain_snapshot_num = remain_snapshot_num

    @property
    def snapshot_group_num(self):
        """Gets the snapshot_group_num of this SnapshotPlan.  # noqa: E501


        :return: The snapshot_group_num of this SnapshotPlan.  # noqa: E501
        :rtype: int
        """
        return self._snapshot_group_num

    @snapshot_group_num.setter
    def snapshot_group_num(self, snapshot_group_num):
        """Sets the snapshot_group_num of this SnapshotPlan.


        :param snapshot_group_num: The snapshot_group_num of this SnapshotPlan.  # noqa: E501
        :type snapshot_group_num: int
        """
        if self.local_vars_configuration.client_side_validation and snapshot_group_num is None:  # noqa: E501
            raise ValueError("Invalid value for `snapshot_group_num`, must not be `None`")  # noqa: E501

        self._snapshot_group_num = snapshot_group_num

    @property
    def start_time(self):
        """Gets the start_time of this SnapshotPlan.  # noqa: E501


        :return: The start_time of this SnapshotPlan.  # noqa: E501
        :rtype: str
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this SnapshotPlan.


        :param start_time: The start_time of this SnapshotPlan.  # noqa: E501
        :type start_time: str
        """
        if self.local_vars_configuration.client_side_validation and start_time is None:  # noqa: E501
            raise ValueError("Invalid value for `start_time`, must not be `None`")  # noqa: E501

        self._start_time = start_time

    @property
    def status(self):
        """Gets the status of this SnapshotPlan.  # noqa: E501


        :return: The status of this SnapshotPlan.  # noqa: E501
        :rtype: SnapshotPlanStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this SnapshotPlan.


        :param status: The status of this SnapshotPlan.  # noqa: E501
        :type status: SnapshotPlanStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def vms(self):
        """Gets the vms of this SnapshotPlan.  # noqa: E501


        :return: The vms of this SnapshotPlan.  # noqa: E501
        :rtype: list[NestedVm]
        """
        return self._vms

    @vms.setter
    def vms(self, vms):
        """Sets the vms of this SnapshotPlan.


        :param vms: The vms of this SnapshotPlan.  # noqa: E501
        :type vms: list[NestedVm]
        """

        self._vms = vms

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotPlan):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotPlan):
            return True

        return self.to_dict() != other.to_dict()
