# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class SnapshotPlanTaskWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[SnapshotPlanTaskWhereInput]',
        '_not': 'list[SnapshotPlanTaskWhereInput]',
        '_or': 'list[SnapshotPlanTaskWhereInput]',
        'cluster': 'ClusterWhereInput',
        'end_time': 'str',
        'end_time_gt': 'str',
        'end_time_gte': 'str',
        'end_time_in': 'list[str]',
        'end_time_lt': 'str',
        'end_time_lte': 'str',
        'end_time_not': 'str',
        'end_time_not_in': 'list[str]',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'internal': 'bool',
        'internal_not': 'bool',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'snapshot_group': 'SnapshotGroupWhereInput',
        'snapshot_plan': 'SnapshotPlanWhereInput',
        'start_time': 'str',
        'start_time_gt': 'str',
        'start_time_gte': 'str',
        'start_time_in': 'list[str]',
        'start_time_lt': 'str',
        'start_time_lte': 'str',
        'start_time_not': 'str',
        'start_time_not_in': 'list[str]',
        'status': 'SnapshotPlanExecuteStatus',
        'status_in': 'list[SnapshotPlanExecuteStatus]',
        'status_not': 'SnapshotPlanExecuteStatus',
        'status_not_in': 'list[SnapshotPlanExecuteStatus]',
        'type': 'SnapshotPlanTaskType',
        'type_in': 'list[SnapshotPlanTaskType]',
        'type_not': 'SnapshotPlanTaskType',
        'type_not_in': 'list[SnapshotPlanTaskType]'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'cluster': 'cluster',
        'end_time': 'end_time',
        'end_time_gt': 'end_time_gt',
        'end_time_gte': 'end_time_gte',
        'end_time_in': 'end_time_in',
        'end_time_lt': 'end_time_lt',
        'end_time_lte': 'end_time_lte',
        'end_time_not': 'end_time_not',
        'end_time_not_in': 'end_time_not_in',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'internal': 'internal',
        'internal_not': 'internal_not',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'snapshot_group': 'snapshotGroup',
        'snapshot_plan': 'snapshotPlan',
        'start_time': 'start_time',
        'start_time_gt': 'start_time_gt',
        'start_time_gte': 'start_time_gte',
        'start_time_in': 'start_time_in',
        'start_time_lt': 'start_time_lt',
        'start_time_lte': 'start_time_lte',
        'start_time_not': 'start_time_not',
        'start_time_not_in': 'start_time_not_in',
        'status': 'status',
        'status_in': 'status_in',
        'status_not': 'status_not',
        'status_not_in': 'status_not_in',
        'type': 'type',
        'type_in': 'type_in',
        'type_not': 'type_not',
        'type_not_in': 'type_not_in'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """SnapshotPlanTaskWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._cluster = None
        self._end_time = None
        self._end_time_gt = None
        self._end_time_gte = None
        self._end_time_in = None
        self._end_time_lt = None
        self._end_time_lte = None
        self._end_time_not = None
        self._end_time_not_in = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._internal = None
        self._internal_not = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._snapshot_group = None
        self._snapshot_plan = None
        self._start_time = None
        self._start_time_gt = None
        self._start_time_gte = None
        self._start_time_in = None
        self._start_time_lt = None
        self._start_time_lte = None
        self._start_time_not = None
        self._start_time_not_in = None
        self._status = None
        self._status_in = None
        self._status_not = None
        self._status_not_in = None
        self._type = None
        self._type_in = None
        self._type_not = None
        self._type_not_in = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.cluster = kwargs.get("cluster", None)
        self.end_time = kwargs.get("end_time", None)
        self.end_time_gt = kwargs.get("end_time_gt", None)
        self.end_time_gte = kwargs.get("end_time_gte", None)
        self.end_time_in = kwargs.get("end_time_in", None)
        self.end_time_lt = kwargs.get("end_time_lt", None)
        self.end_time_lte = kwargs.get("end_time_lte", None)
        self.end_time_not = kwargs.get("end_time_not", None)
        self.end_time_not_in = kwargs.get("end_time_not_in", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.internal = kwargs.get("internal", None)
        self.internal_not = kwargs.get("internal_not", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.snapshot_group = kwargs.get("snapshot_group", None)
        self.snapshot_plan = kwargs.get("snapshot_plan", None)
        self.start_time = kwargs.get("start_time", None)
        self.start_time_gt = kwargs.get("start_time_gt", None)
        self.start_time_gte = kwargs.get("start_time_gte", None)
        self.start_time_in = kwargs.get("start_time_in", None)
        self.start_time_lt = kwargs.get("start_time_lt", None)
        self.start_time_lte = kwargs.get("start_time_lte", None)
        self.start_time_not = kwargs.get("start_time_not", None)
        self.start_time_not_in = kwargs.get("start_time_not_in", None)
        self.status = kwargs.get("status", None)
        self.status_in = kwargs.get("status_in", None)
        self.status_not = kwargs.get("status_not", None)
        self.status_not_in = kwargs.get("status_not_in", None)
        self.type = kwargs.get("type", None)
        self.type_in = kwargs.get("type_in", None)
        self.type_not = kwargs.get("type_not", None)
        self.type_not_in = kwargs.get("type_not_in", None)

    @property
    def _and(self):
        """Gets the _and of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The _and of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[SnapshotPlanTaskWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this SnapshotPlanTaskWhereInput.


        :param _and: The _and of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type _and: list[SnapshotPlanTaskWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The _not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[SnapshotPlanTaskWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this SnapshotPlanTaskWhereInput.


        :param _not: The _not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type _not: list[SnapshotPlanTaskWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The _or of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[SnapshotPlanTaskWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this SnapshotPlanTaskWhereInput.


        :param _or: The _or of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type _or: list[SnapshotPlanTaskWhereInput]
        """

        self.__or = _or

    @property
    def cluster(self):
        """Gets the cluster of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The cluster of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this SnapshotPlanTaskWhereInput.


        :param cluster: The cluster of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type cluster: ClusterWhereInput
        """

        self._cluster = cluster

    @property
    def end_time(self):
        """Gets the end_time of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The end_time of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this SnapshotPlanTaskWhereInput.


        :param end_time: The end_time of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type end_time: str
        """

        self._end_time = end_time

    @property
    def end_time_gt(self):
        """Gets the end_time_gt of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The end_time_gt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._end_time_gt

    @end_time_gt.setter
    def end_time_gt(self, end_time_gt):
        """Sets the end_time_gt of this SnapshotPlanTaskWhereInput.


        :param end_time_gt: The end_time_gt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type end_time_gt: str
        """

        self._end_time_gt = end_time_gt

    @property
    def end_time_gte(self):
        """Gets the end_time_gte of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The end_time_gte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._end_time_gte

    @end_time_gte.setter
    def end_time_gte(self, end_time_gte):
        """Sets the end_time_gte of this SnapshotPlanTaskWhereInput.


        :param end_time_gte: The end_time_gte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type end_time_gte: str
        """

        self._end_time_gte = end_time_gte

    @property
    def end_time_in(self):
        """Gets the end_time_in of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The end_time_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._end_time_in

    @end_time_in.setter
    def end_time_in(self, end_time_in):
        """Sets the end_time_in of this SnapshotPlanTaskWhereInput.


        :param end_time_in: The end_time_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type end_time_in: list[str]
        """

        self._end_time_in = end_time_in

    @property
    def end_time_lt(self):
        """Gets the end_time_lt of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The end_time_lt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._end_time_lt

    @end_time_lt.setter
    def end_time_lt(self, end_time_lt):
        """Sets the end_time_lt of this SnapshotPlanTaskWhereInput.


        :param end_time_lt: The end_time_lt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type end_time_lt: str
        """

        self._end_time_lt = end_time_lt

    @property
    def end_time_lte(self):
        """Gets the end_time_lte of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The end_time_lte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._end_time_lte

    @end_time_lte.setter
    def end_time_lte(self, end_time_lte):
        """Sets the end_time_lte of this SnapshotPlanTaskWhereInput.


        :param end_time_lte: The end_time_lte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type end_time_lte: str
        """

        self._end_time_lte = end_time_lte

    @property
    def end_time_not(self):
        """Gets the end_time_not of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The end_time_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._end_time_not

    @end_time_not.setter
    def end_time_not(self, end_time_not):
        """Sets the end_time_not of this SnapshotPlanTaskWhereInput.


        :param end_time_not: The end_time_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type end_time_not: str
        """

        self._end_time_not = end_time_not

    @property
    def end_time_not_in(self):
        """Gets the end_time_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The end_time_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._end_time_not_in

    @end_time_not_in.setter
    def end_time_not_in(self, end_time_not_in):
        """Sets the end_time_not_in of this SnapshotPlanTaskWhereInput.


        :param end_time_not_in: The end_time_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type end_time_not_in: list[str]
        """

        self._end_time_not_in = end_time_not_in

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The entity_async_status of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this SnapshotPlanTaskWhereInput.


        :param entity_async_status: The entity_async_status of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this SnapshotPlanTaskWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this SnapshotPlanTaskWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this SnapshotPlanTaskWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def id(self):
        """Gets the id of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The id of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SnapshotPlanTaskWhereInput.


        :param id: The id of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The id_contains of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this SnapshotPlanTaskWhereInput.


        :param id_contains: The id_contains of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The id_ends_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this SnapshotPlanTaskWhereInput.


        :param id_ends_with: The id_ends_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The id_gt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this SnapshotPlanTaskWhereInput.


        :param id_gt: The id_gt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The id_gte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this SnapshotPlanTaskWhereInput.


        :param id_gte: The id_gte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The id_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this SnapshotPlanTaskWhereInput.


        :param id_in: The id_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The id_lt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this SnapshotPlanTaskWhereInput.


        :param id_lt: The id_lt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The id_lte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this SnapshotPlanTaskWhereInput.


        :param id_lte: The id_lte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The id_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this SnapshotPlanTaskWhereInput.


        :param id_not: The id_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The id_not_contains of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this SnapshotPlanTaskWhereInput.


        :param id_not_contains: The id_not_contains of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this SnapshotPlanTaskWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The id_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this SnapshotPlanTaskWhereInput.


        :param id_not_in: The id_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this SnapshotPlanTaskWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The id_starts_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this SnapshotPlanTaskWhereInput.


        :param id_starts_with: The id_starts_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def internal(self):
        """Gets the internal of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The internal of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._internal

    @internal.setter
    def internal(self, internal):
        """Sets the internal of this SnapshotPlanTaskWhereInput.


        :param internal: The internal of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type internal: bool
        """

        self._internal = internal

    @property
    def internal_not(self):
        """Gets the internal_not of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The internal_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._internal_not

    @internal_not.setter
    def internal_not(self, internal_not):
        """Sets the internal_not of this SnapshotPlanTaskWhereInput.


        :param internal_not: The internal_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type internal_not: bool
        """

        self._internal_not = internal_not

    @property
    def local_id(self):
        """Gets the local_id of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The local_id of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this SnapshotPlanTaskWhereInput.


        :param local_id: The local_id of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The local_id_contains of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this SnapshotPlanTaskWhereInput.


        :param local_id_contains: The local_id_contains of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this SnapshotPlanTaskWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The local_id_gt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this SnapshotPlanTaskWhereInput.


        :param local_id_gt: The local_id_gt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The local_id_gte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this SnapshotPlanTaskWhereInput.


        :param local_id_gte: The local_id_gte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The local_id_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this SnapshotPlanTaskWhereInput.


        :param local_id_in: The local_id_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The local_id_lt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this SnapshotPlanTaskWhereInput.


        :param local_id_lt: The local_id_lt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The local_id_lte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this SnapshotPlanTaskWhereInput.


        :param local_id_lte: The local_id_lte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The local_id_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this SnapshotPlanTaskWhereInput.


        :param local_id_not: The local_id_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this SnapshotPlanTaskWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this SnapshotPlanTaskWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The local_id_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this SnapshotPlanTaskWhereInput.


        :param local_id_not_in: The local_id_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this SnapshotPlanTaskWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this SnapshotPlanTaskWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def snapshot_group(self):
        """Gets the snapshot_group of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The snapshot_group of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: SnapshotGroupWhereInput
        """
        return self._snapshot_group

    @snapshot_group.setter
    def snapshot_group(self, snapshot_group):
        """Sets the snapshot_group of this SnapshotPlanTaskWhereInput.


        :param snapshot_group: The snapshot_group of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type snapshot_group: SnapshotGroupWhereInput
        """

        self._snapshot_group = snapshot_group

    @property
    def snapshot_plan(self):
        """Gets the snapshot_plan of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The snapshot_plan of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: SnapshotPlanWhereInput
        """
        return self._snapshot_plan

    @snapshot_plan.setter
    def snapshot_plan(self, snapshot_plan):
        """Sets the snapshot_plan of this SnapshotPlanTaskWhereInput.


        :param snapshot_plan: The snapshot_plan of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type snapshot_plan: SnapshotPlanWhereInput
        """

        self._snapshot_plan = snapshot_plan

    @property
    def start_time(self):
        """Gets the start_time of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The start_time of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this SnapshotPlanTaskWhereInput.


        :param start_time: The start_time of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type start_time: str
        """

        self._start_time = start_time

    @property
    def start_time_gt(self):
        """Gets the start_time_gt of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The start_time_gt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._start_time_gt

    @start_time_gt.setter
    def start_time_gt(self, start_time_gt):
        """Sets the start_time_gt of this SnapshotPlanTaskWhereInput.


        :param start_time_gt: The start_time_gt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type start_time_gt: str
        """

        self._start_time_gt = start_time_gt

    @property
    def start_time_gte(self):
        """Gets the start_time_gte of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The start_time_gte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._start_time_gte

    @start_time_gte.setter
    def start_time_gte(self, start_time_gte):
        """Sets the start_time_gte of this SnapshotPlanTaskWhereInput.


        :param start_time_gte: The start_time_gte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type start_time_gte: str
        """

        self._start_time_gte = start_time_gte

    @property
    def start_time_in(self):
        """Gets the start_time_in of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The start_time_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._start_time_in

    @start_time_in.setter
    def start_time_in(self, start_time_in):
        """Sets the start_time_in of this SnapshotPlanTaskWhereInput.


        :param start_time_in: The start_time_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type start_time_in: list[str]
        """

        self._start_time_in = start_time_in

    @property
    def start_time_lt(self):
        """Gets the start_time_lt of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The start_time_lt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._start_time_lt

    @start_time_lt.setter
    def start_time_lt(self, start_time_lt):
        """Sets the start_time_lt of this SnapshotPlanTaskWhereInput.


        :param start_time_lt: The start_time_lt of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type start_time_lt: str
        """

        self._start_time_lt = start_time_lt

    @property
    def start_time_lte(self):
        """Gets the start_time_lte of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The start_time_lte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._start_time_lte

    @start_time_lte.setter
    def start_time_lte(self, start_time_lte):
        """Sets the start_time_lte of this SnapshotPlanTaskWhereInput.


        :param start_time_lte: The start_time_lte of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type start_time_lte: str
        """

        self._start_time_lte = start_time_lte

    @property
    def start_time_not(self):
        """Gets the start_time_not of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The start_time_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._start_time_not

    @start_time_not.setter
    def start_time_not(self, start_time_not):
        """Sets the start_time_not of this SnapshotPlanTaskWhereInput.


        :param start_time_not: The start_time_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type start_time_not: str
        """

        self._start_time_not = start_time_not

    @property
    def start_time_not_in(self):
        """Gets the start_time_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The start_time_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._start_time_not_in

    @start_time_not_in.setter
    def start_time_not_in(self, start_time_not_in):
        """Sets the start_time_not_in of this SnapshotPlanTaskWhereInput.


        :param start_time_not_in: The start_time_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type start_time_not_in: list[str]
        """

        self._start_time_not_in = start_time_not_in

    @property
    def status(self):
        """Gets the status of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The status of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: SnapshotPlanExecuteStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this SnapshotPlanTaskWhereInput.


        :param status: The status of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type status: SnapshotPlanExecuteStatus
        """

        self._status = status

    @property
    def status_in(self):
        """Gets the status_in of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The status_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[SnapshotPlanExecuteStatus]
        """
        return self._status_in

    @status_in.setter
    def status_in(self, status_in):
        """Sets the status_in of this SnapshotPlanTaskWhereInput.


        :param status_in: The status_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type status_in: list[SnapshotPlanExecuteStatus]
        """

        self._status_in = status_in

    @property
    def status_not(self):
        """Gets the status_not of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The status_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: SnapshotPlanExecuteStatus
        """
        return self._status_not

    @status_not.setter
    def status_not(self, status_not):
        """Sets the status_not of this SnapshotPlanTaskWhereInput.


        :param status_not: The status_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type status_not: SnapshotPlanExecuteStatus
        """

        self._status_not = status_not

    @property
    def status_not_in(self):
        """Gets the status_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The status_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[SnapshotPlanExecuteStatus]
        """
        return self._status_not_in

    @status_not_in.setter
    def status_not_in(self, status_not_in):
        """Sets the status_not_in of this SnapshotPlanTaskWhereInput.


        :param status_not_in: The status_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type status_not_in: list[SnapshotPlanExecuteStatus]
        """

        self._status_not_in = status_not_in

    @property
    def type(self):
        """Gets the type of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The type of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: SnapshotPlanTaskType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this SnapshotPlanTaskWhereInput.


        :param type: The type of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type type: SnapshotPlanTaskType
        """

        self._type = type

    @property
    def type_in(self):
        """Gets the type_in of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The type_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[SnapshotPlanTaskType]
        """
        return self._type_in

    @type_in.setter
    def type_in(self, type_in):
        """Sets the type_in of this SnapshotPlanTaskWhereInput.


        :param type_in: The type_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type type_in: list[SnapshotPlanTaskType]
        """

        self._type_in = type_in

    @property
    def type_not(self):
        """Gets the type_not of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The type_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: SnapshotPlanTaskType
        """
        return self._type_not

    @type_not.setter
    def type_not(self, type_not):
        """Sets the type_not of this SnapshotPlanTaskWhereInput.


        :param type_not: The type_not of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type type_not: SnapshotPlanTaskType
        """

        self._type_not = type_not

    @property
    def type_not_in(self):
        """Gets the type_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501


        :return: The type_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :rtype: list[SnapshotPlanTaskType]
        """
        return self._type_not_in

    @type_not_in.setter
    def type_not_in(self, type_not_in):
        """Sets the type_not_in of this SnapshotPlanTaskWhereInput.


        :param type_not_in: The type_not_in of this SnapshotPlanTaskWhereInput.  # noqa: E501
        :type type_not_in: list[SnapshotPlanTaskType]
        """

        self._type_not_in = type_not_in

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotPlanTaskWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotPlanTaskWhereInput):
            return True

        return self.to_dict() != other.to_dict()
