# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class TableReporterParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'filter': 'TableReporterParamsFilter',
        'columns': 'list[ColumnConfig]',
        'name': 'str'
    }

    attribute_map = {
        'filter': 'filter',
        'columns': 'columns',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """TableReporterParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._filter = None
        self._columns = None
        self._name = None
        self.discriminator = None

        if "filter" in kwargs:
            self.filter = kwargs["filter"]
        if "columns" in kwargs:
            self.columns = kwargs["columns"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def filter(self):
        """Gets the filter of this TableReporterParams.  # noqa: E501


        :return: The filter of this TableReporterParams.  # noqa: E501
        :rtype: TableReporterParamsFilter
        """
        return self._filter

    @filter.setter
    def filter(self, filter):
        """Sets the filter of this TableReporterParams.


        :param filter: The filter of this TableReporterParams.  # noqa: E501
        :type filter: TableReporterParamsFilter
        """
        if self.local_vars_configuration.client_side_validation and filter is None:  # noqa: E501
            raise ValueError("Invalid value for `filter`, must not be `None`")  # noqa: E501

        self._filter = filter

    @property
    def columns(self):
        """Gets the columns of this TableReporterParams.  # noqa: E501


        :return: The columns of this TableReporterParams.  # noqa: E501
        :rtype: list[ColumnConfig]
        """
        return self._columns

    @columns.setter
    def columns(self, columns):
        """Sets the columns of this TableReporterParams.


        :param columns: The columns of this TableReporterParams.  # noqa: E501
        :type columns: list[ColumnConfig]
        """
        if self.local_vars_configuration.client_side_validation and columns is None:  # noqa: E501
            raise ValueError("Invalid value for `columns`, must not be `None`")  # noqa: E501

        self._columns = columns

    @property
    def name(self):
        """Gets the name of this TableReporterParams.  # noqa: E501


        :return: The name of this TableReporterParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TableReporterParams.


        :param name: The name of this TableReporterParams.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TableReporterParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TableReporterParams):
            return True

        return self.to_dict() != other.to_dict()
