# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class Task(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'args': 'object',
        'cluster': 'NestedCluster',
        'description': 'str',
        'error_code': 'str',
        'error_message': 'str',
        'finished_at': 'str',
        'id': 'str',
        'internal': 'bool',
        'key': 'str',
        'local_created_at': 'str',
        'progress': 'float',
        'resource_id': 'str',
        'resource_mutation': 'str',
        'resource_rollback_error': 'str',
        'resource_rollback_retry_count': 'int',
        'resource_rollbacked': 'bool',
        'resource_type': 'str',
        'snapshot': 'str',
        'started_at': 'str',
        'status': 'TaskStatus',
        'steps': 'list[NestedStep]',
        'type': 'TaskType',
        'user': 'NestedUser'
    }

    attribute_map = {
        'args': 'args',
        'cluster': 'cluster',
        'description': 'description',
        'error_code': 'error_code',
        'error_message': 'error_message',
        'finished_at': 'finished_at',
        'id': 'id',
        'internal': 'internal',
        'key': 'key',
        'local_created_at': 'local_created_at',
        'progress': 'progress',
        'resource_id': 'resource_id',
        'resource_mutation': 'resource_mutation',
        'resource_rollback_error': 'resource_rollback_error',
        'resource_rollback_retry_count': 'resource_rollback_retry_count',
        'resource_rollbacked': 'resource_rollbacked',
        'resource_type': 'resource_type',
        'snapshot': 'snapshot',
        'started_at': 'started_at',
        'status': 'status',
        'steps': 'steps',
        'type': 'type',
        'user': 'user'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """Task - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._args = None
        self._cluster = None
        self._description = None
        self._error_code = None
        self._error_message = None
        self._finished_at = None
        self._id = None
        self._internal = None
        self._key = None
        self._local_created_at = None
        self._progress = None
        self._resource_id = None
        self._resource_mutation = None
        self._resource_rollback_error = None
        self._resource_rollback_retry_count = None
        self._resource_rollbacked = None
        self._resource_type = None
        self._snapshot = None
        self._started_at = None
        self._status = None
        self._steps = None
        self._type = None
        self._user = None
        self.discriminator = None

        if "args" in kwargs:
            self.args = kwargs["args"]
        self.cluster = kwargs.get("cluster", None)
        if "description" in kwargs:
            self.description = kwargs["description"]
        self.error_code = kwargs.get("error_code", None)
        self.error_message = kwargs.get("error_message", None)
        self.finished_at = kwargs.get("finished_at", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "internal" in kwargs:
            self.internal = kwargs["internal"]
        self.key = kwargs.get("key", None)
        if "local_created_at" in kwargs:
            self.local_created_at = kwargs["local_created_at"]
        if "progress" in kwargs:
            self.progress = kwargs["progress"]
        self.resource_id = kwargs.get("resource_id", None)
        self.resource_mutation = kwargs.get("resource_mutation", None)
        self.resource_rollback_error = kwargs.get("resource_rollback_error", None)
        self.resource_rollback_retry_count = kwargs.get("resource_rollback_retry_count", None)
        self.resource_rollbacked = kwargs.get("resource_rollbacked", None)
        self.resource_type = kwargs.get("resource_type", None)
        if "snapshot" in kwargs:
            self.snapshot = kwargs["snapshot"]
        self.started_at = kwargs.get("started_at", None)
        if "status" in kwargs:
            self.status = kwargs["status"]
        if "steps" in kwargs:
            self.steps = kwargs["steps"]
        self.type = kwargs.get("type", None)
        self.user = kwargs.get("user", None)

    @property
    def args(self):
        """Gets the args of this Task.  # noqa: E501


        :return: The args of this Task.  # noqa: E501
        :rtype: object
        """
        return self._args

    @args.setter
    def args(self, args):
        """Sets the args of this Task.


        :param args: The args of this Task.  # noqa: E501
        :type args: object
        """
        if self.local_vars_configuration.client_side_validation and args is None:  # noqa: E501
            raise ValueError("Invalid value for `args`, must not be `None`")  # noqa: E501

        self._args = args

    @property
    def cluster(self):
        """Gets the cluster of this Task.  # noqa: E501


        :return: The cluster of this Task.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this Task.


        :param cluster: The cluster of this Task.  # noqa: E501
        :type cluster: NestedCluster
        """

        self._cluster = cluster

    @property
    def description(self):
        """Gets the description of this Task.  # noqa: E501


        :return: The description of this Task.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Task.


        :param description: The description of this Task.  # noqa: E501
        :type description: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def error_code(self):
        """Gets the error_code of this Task.  # noqa: E501


        :return: The error_code of this Task.  # noqa: E501
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """Sets the error_code of this Task.


        :param error_code: The error_code of this Task.  # noqa: E501
        :type error_code: str
        """

        self._error_code = error_code

    @property
    def error_message(self):
        """Gets the error_message of this Task.  # noqa: E501


        :return: The error_message of this Task.  # noqa: E501
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """Sets the error_message of this Task.


        :param error_message: The error_message of this Task.  # noqa: E501
        :type error_message: str
        """

        self._error_message = error_message

    @property
    def finished_at(self):
        """Gets the finished_at of this Task.  # noqa: E501


        :return: The finished_at of this Task.  # noqa: E501
        :rtype: str
        """
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """Sets the finished_at of this Task.


        :param finished_at: The finished_at of this Task.  # noqa: E501
        :type finished_at: str
        """

        self._finished_at = finished_at

    @property
    def id(self):
        """Gets the id of this Task.  # noqa: E501


        :return: The id of this Task.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Task.


        :param id: The id of this Task.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def internal(self):
        """Gets the internal of this Task.  # noqa: E501


        :return: The internal of this Task.  # noqa: E501
        :rtype: bool
        """
        return self._internal

    @internal.setter
    def internal(self, internal):
        """Sets the internal of this Task.


        :param internal: The internal of this Task.  # noqa: E501
        :type internal: bool
        """
        if self.local_vars_configuration.client_side_validation and internal is None:  # noqa: E501
            raise ValueError("Invalid value for `internal`, must not be `None`")  # noqa: E501

        self._internal = internal

    @property
    def key(self):
        """Gets the key of this Task.  # noqa: E501


        :return: The key of this Task.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this Task.


        :param key: The key of this Task.  # noqa: E501
        :type key: str
        """

        self._key = key

    @property
    def local_created_at(self):
        """Gets the local_created_at of this Task.  # noqa: E501


        :return: The local_created_at of this Task.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this Task.


        :param local_created_at: The local_created_at of this Task.  # noqa: E501
        :type local_created_at: str
        """
        if self.local_vars_configuration.client_side_validation and local_created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `local_created_at`, must not be `None`")  # noqa: E501

        self._local_created_at = local_created_at

    @property
    def progress(self):
        """Gets the progress of this Task.  # noqa: E501


        :return: The progress of this Task.  # noqa: E501
        :rtype: float
        """
        return self._progress

    @progress.setter
    def progress(self, progress):
        """Sets the progress of this Task.


        :param progress: The progress of this Task.  # noqa: E501
        :type progress: float
        """
        if self.local_vars_configuration.client_side_validation and progress is None:  # noqa: E501
            raise ValueError("Invalid value for `progress`, must not be `None`")  # noqa: E501

        self._progress = progress

    @property
    def resource_id(self):
        """Gets the resource_id of this Task.  # noqa: E501


        :return: The resource_id of this Task.  # noqa: E501
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """Sets the resource_id of this Task.


        :param resource_id: The resource_id of this Task.  # noqa: E501
        :type resource_id: str
        """

        self._resource_id = resource_id

    @property
    def resource_mutation(self):
        """Gets the resource_mutation of this Task.  # noqa: E501


        :return: The resource_mutation of this Task.  # noqa: E501
        :rtype: str
        """
        return self._resource_mutation

    @resource_mutation.setter
    def resource_mutation(self, resource_mutation):
        """Sets the resource_mutation of this Task.


        :param resource_mutation: The resource_mutation of this Task.  # noqa: E501
        :type resource_mutation: str
        """

        self._resource_mutation = resource_mutation

    @property
    def resource_rollback_error(self):
        """Gets the resource_rollback_error of this Task.  # noqa: E501


        :return: The resource_rollback_error of this Task.  # noqa: E501
        :rtype: str
        """
        return self._resource_rollback_error

    @resource_rollback_error.setter
    def resource_rollback_error(self, resource_rollback_error):
        """Sets the resource_rollback_error of this Task.


        :param resource_rollback_error: The resource_rollback_error of this Task.  # noqa: E501
        :type resource_rollback_error: str
        """

        self._resource_rollback_error = resource_rollback_error

    @property
    def resource_rollback_retry_count(self):
        """Gets the resource_rollback_retry_count of this Task.  # noqa: E501


        :return: The resource_rollback_retry_count of this Task.  # noqa: E501
        :rtype: int
        """
        return self._resource_rollback_retry_count

    @resource_rollback_retry_count.setter
    def resource_rollback_retry_count(self, resource_rollback_retry_count):
        """Sets the resource_rollback_retry_count of this Task.


        :param resource_rollback_retry_count: The resource_rollback_retry_count of this Task.  # noqa: E501
        :type resource_rollback_retry_count: int
        """

        self._resource_rollback_retry_count = resource_rollback_retry_count

    @property
    def resource_rollbacked(self):
        """Gets the resource_rollbacked of this Task.  # noqa: E501


        :return: The resource_rollbacked of this Task.  # noqa: E501
        :rtype: bool
        """
        return self._resource_rollbacked

    @resource_rollbacked.setter
    def resource_rollbacked(self, resource_rollbacked):
        """Sets the resource_rollbacked of this Task.


        :param resource_rollbacked: The resource_rollbacked of this Task.  # noqa: E501
        :type resource_rollbacked: bool
        """

        self._resource_rollbacked = resource_rollbacked

    @property
    def resource_type(self):
        """Gets the resource_type of this Task.  # noqa: E501


        :return: The resource_type of this Task.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this Task.


        :param resource_type: The resource_type of this Task.  # noqa: E501
        :type resource_type: str
        """

        self._resource_type = resource_type

    @property
    def snapshot(self):
        """Gets the snapshot of this Task.  # noqa: E501


        :return: The snapshot of this Task.  # noqa: E501
        :rtype: str
        """
        return self._snapshot

    @snapshot.setter
    def snapshot(self, snapshot):
        """Sets the snapshot of this Task.


        :param snapshot: The snapshot of this Task.  # noqa: E501
        :type snapshot: str
        """
        if self.local_vars_configuration.client_side_validation and snapshot is None:  # noqa: E501
            raise ValueError("Invalid value for `snapshot`, must not be `None`")  # noqa: E501

        self._snapshot = snapshot

    @property
    def started_at(self):
        """Gets the started_at of this Task.  # noqa: E501


        :return: The started_at of this Task.  # noqa: E501
        :rtype: str
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """Sets the started_at of this Task.


        :param started_at: The started_at of this Task.  # noqa: E501
        :type started_at: str
        """

        self._started_at = started_at

    @property
    def status(self):
        """Gets the status of this Task.  # noqa: E501


        :return: The status of this Task.  # noqa: E501
        :rtype: TaskStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Task.


        :param status: The status of this Task.  # noqa: E501
        :type status: TaskStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def steps(self):
        """Gets the steps of this Task.  # noqa: E501


        :return: The steps of this Task.  # noqa: E501
        :rtype: list[NestedStep]
        """
        return self._steps

    @steps.setter
    def steps(self, steps):
        """Sets the steps of this Task.


        :param steps: The steps of this Task.  # noqa: E501
        :type steps: list[NestedStep]
        """
        if self.local_vars_configuration.client_side_validation and steps is None:  # noqa: E501
            raise ValueError("Invalid value for `steps`, must not be `None`")  # noqa: E501

        self._steps = steps

    @property
    def type(self):
        """Gets the type of this Task.  # noqa: E501


        :return: The type of this Task.  # noqa: E501
        :rtype: TaskType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Task.


        :param type: The type of this Task.  # noqa: E501
        :type type: TaskType
        """

        self._type = type

    @property
    def user(self):
        """Gets the user of this Task.  # noqa: E501


        :return: The user of this Task.  # noqa: E501
        :rtype: NestedUser
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this Task.


        :param user: The user of this Task.  # noqa: E501
        :type user: NestedUser
        """

        self._user = user

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Task):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Task):
            return True

        return self.to_dict() != other.to_dict()
