# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class TaskCreationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'api_key_name': 'str',
        'snapshot': 'str',
        'status': 'TaskStatus',
        'id': 'str',
        'finished_at': 'str',
        'started_at': 'str',
        'steps': 'list[TaskStepCreationParams]',
        'args': 'object',
        'key': 'str',
        'internal': 'bool',
        'type': 'TaskType',
        'resource_id': 'str',
        'cluster_id': 'str',
        'user_id': 'str',
        'description': 'TaskDescription',
        'resource_mutation': 'str',
        'resource_type': 'str'
    }

    attribute_map = {
        'api_key_name': 'api_key_name',
        'snapshot': 'snapshot',
        'status': 'status',
        'id': 'id',
        'finished_at': 'finished_at',
        'started_at': 'started_at',
        'steps': 'steps',
        'args': 'args',
        'key': 'key',
        'internal': 'internal',
        'type': 'type',
        'resource_id': 'resource_id',
        'cluster_id': 'cluster_id',
        'user_id': 'user_id',
        'description': 'description',
        'resource_mutation': 'resource_mutation',
        'resource_type': 'resource_type'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """TaskCreationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._api_key_name = None
        self._snapshot = None
        self._status = None
        self._id = None
        self._finished_at = None
        self._started_at = None
        self._steps = None
        self._args = None
        self._key = None
        self._internal = None
        self._type = None
        self._resource_id = None
        self._cluster_id = None
        self._user_id = None
        self._description = None
        self._resource_mutation = None
        self._resource_type = None
        self.discriminator = None

        if "api_key_name" in kwargs:
            self.api_key_name = kwargs["api_key_name"]
        if "snapshot" in kwargs:
            self.snapshot = kwargs["snapshot"]
        if "status" in kwargs:
            self.status = kwargs["status"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "finished_at" in kwargs:
            self.finished_at = kwargs["finished_at"]
        if "started_at" in kwargs:
            self.started_at = kwargs["started_at"]
        if "steps" in kwargs:
            self.steps = kwargs["steps"]
        if "args" in kwargs:
            self.args = kwargs["args"]
        if "key" in kwargs:
            self.key = kwargs["key"]
        if "internal" in kwargs:
            self.internal = kwargs["internal"]
        if "type" in kwargs:
            self.type = kwargs["type"]
        if "resource_id" in kwargs:
            self.resource_id = kwargs["resource_id"]
        if "cluster_id" in kwargs:
            self.cluster_id = kwargs["cluster_id"]
        if "user_id" in kwargs:
            self.user_id = kwargs["user_id"]
        if "description" in kwargs:
            self.description = kwargs["description"]
        if "resource_mutation" in kwargs:
            self.resource_mutation = kwargs["resource_mutation"]
        if "resource_type" in kwargs:
            self.resource_type = kwargs["resource_type"]

    @property
    def api_key_name(self):
        """Gets the api_key_name of this TaskCreationParams.  # noqa: E501


        :return: The api_key_name of this TaskCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._api_key_name

    @api_key_name.setter
    def api_key_name(self, api_key_name):
        """Sets the api_key_name of this TaskCreationParams.


        :param api_key_name: The api_key_name of this TaskCreationParams.  # noqa: E501
        :type api_key_name: str
        """

        self._api_key_name = api_key_name

    @property
    def snapshot(self):
        """Gets the snapshot of this TaskCreationParams.  # noqa: E501


        :return: The snapshot of this TaskCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._snapshot

    @snapshot.setter
    def snapshot(self, snapshot):
        """Sets the snapshot of this TaskCreationParams.


        :param snapshot: The snapshot of this TaskCreationParams.  # noqa: E501
        :type snapshot: str
        """

        self._snapshot = snapshot

    @property
    def status(self):
        """Gets the status of this TaskCreationParams.  # noqa: E501


        :return: The status of this TaskCreationParams.  # noqa: E501
        :rtype: TaskStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this TaskCreationParams.


        :param status: The status of this TaskCreationParams.  # noqa: E501
        :type status: TaskStatus
        """

        self._status = status

    @property
    def id(self):
        """Gets the id of this TaskCreationParams.  # noqa: E501


        :return: The id of this TaskCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TaskCreationParams.


        :param id: The id of this TaskCreationParams.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def finished_at(self):
        """Gets the finished_at of this TaskCreationParams.  # noqa: E501


        :return: The finished_at of this TaskCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """Sets the finished_at of this TaskCreationParams.


        :param finished_at: The finished_at of this TaskCreationParams.  # noqa: E501
        :type finished_at: str
        """

        self._finished_at = finished_at

    @property
    def started_at(self):
        """Gets the started_at of this TaskCreationParams.  # noqa: E501


        :return: The started_at of this TaskCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """Sets the started_at of this TaskCreationParams.


        :param started_at: The started_at of this TaskCreationParams.  # noqa: E501
        :type started_at: str
        """

        self._started_at = started_at

    @property
    def steps(self):
        """Gets the steps of this TaskCreationParams.  # noqa: E501


        :return: The steps of this TaskCreationParams.  # noqa: E501
        :rtype: list[TaskStepCreationParams]
        """
        return self._steps

    @steps.setter
    def steps(self, steps):
        """Sets the steps of this TaskCreationParams.


        :param steps: The steps of this TaskCreationParams.  # noqa: E501
        :type steps: list[TaskStepCreationParams]
        """

        self._steps = steps

    @property
    def args(self):
        """Gets the args of this TaskCreationParams.  # noqa: E501


        :return: The args of this TaskCreationParams.  # noqa: E501
        :rtype: object
        """
        return self._args

    @args.setter
    def args(self, args):
        """Sets the args of this TaskCreationParams.


        :param args: The args of this TaskCreationParams.  # noqa: E501
        :type args: object
        """

        self._args = args

    @property
    def key(self):
        """Gets the key of this TaskCreationParams.  # noqa: E501


        :return: The key of this TaskCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this TaskCreationParams.


        :param key: The key of this TaskCreationParams.  # noqa: E501
        :type key: str
        """

        self._key = key

    @property
    def internal(self):
        """Gets the internal of this TaskCreationParams.  # noqa: E501


        :return: The internal of this TaskCreationParams.  # noqa: E501
        :rtype: bool
        """
        return self._internal

    @internal.setter
    def internal(self, internal):
        """Sets the internal of this TaskCreationParams.


        :param internal: The internal of this TaskCreationParams.  # noqa: E501
        :type internal: bool
        """

        self._internal = internal

    @property
    def type(self):
        """Gets the type of this TaskCreationParams.  # noqa: E501


        :return: The type of this TaskCreationParams.  # noqa: E501
        :rtype: TaskType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this TaskCreationParams.


        :param type: The type of this TaskCreationParams.  # noqa: E501
        :type type: TaskType
        """

        self._type = type

    @property
    def resource_id(self):
        """Gets the resource_id of this TaskCreationParams.  # noqa: E501


        :return: The resource_id of this TaskCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """Sets the resource_id of this TaskCreationParams.


        :param resource_id: The resource_id of this TaskCreationParams.  # noqa: E501
        :type resource_id: str
        """

        self._resource_id = resource_id

    @property
    def cluster_id(self):
        """Gets the cluster_id of this TaskCreationParams.  # noqa: E501


        :return: The cluster_id of this TaskCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """Sets the cluster_id of this TaskCreationParams.


        :param cluster_id: The cluster_id of this TaskCreationParams.  # noqa: E501
        :type cluster_id: str
        """

        self._cluster_id = cluster_id

    @property
    def user_id(self):
        """Gets the user_id of this TaskCreationParams.  # noqa: E501


        :return: The user_id of this TaskCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this TaskCreationParams.


        :param user_id: The user_id of this TaskCreationParams.  # noqa: E501
        :type user_id: str
        """
        if self.local_vars_configuration.client_side_validation and user_id is None:  # noqa: E501
            raise ValueError("Invalid value for `user_id`, must not be `None`")  # noqa: E501

        self._user_id = user_id

    @property
    def description(self):
        """Gets the description of this TaskCreationParams.  # noqa: E501


        :return: The description of this TaskCreationParams.  # noqa: E501
        :rtype: TaskDescription
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this TaskCreationParams.


        :param description: The description of this TaskCreationParams.  # noqa: E501
        :type description: TaskDescription
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def resource_mutation(self):
        """Gets the resource_mutation of this TaskCreationParams.  # noqa: E501


        :return: The resource_mutation of this TaskCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._resource_mutation

    @resource_mutation.setter
    def resource_mutation(self, resource_mutation):
        """Sets the resource_mutation of this TaskCreationParams.


        :param resource_mutation: The resource_mutation of this TaskCreationParams.  # noqa: E501
        :type resource_mutation: str
        """
        if self.local_vars_configuration.client_side_validation and resource_mutation is None:  # noqa: E501
            raise ValueError("Invalid value for `resource_mutation`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                resource_mutation is not None and len(resource_mutation) < 1):
            raise ValueError("Invalid value for `resource_mutation`, length must be greater than or equal to `1`")  # noqa: E501

        self._resource_mutation = resource_mutation

    @property
    def resource_type(self):
        """Gets the resource_type of this TaskCreationParams.  # noqa: E501


        :return: The resource_type of this TaskCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this TaskCreationParams.


        :param resource_type: The resource_type of this TaskCreationParams.  # noqa: E501
        :type resource_type: str
        """
        if self.local_vars_configuration.client_side_validation and resource_type is None:  # noqa: E501
            raise ValueError("Invalid value for `resource_type`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                resource_type is not None and len(resource_type) < 1):
            raise ValueError("Invalid value for `resource_type`, length must be greater than or equal to `1`")  # noqa: E501

        self._resource_type = resource_type

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskCreationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TaskCreationParams):
            return True

        return self.to_dict() != other.to_dict()
