# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class TaskDescription(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'en_us': 'str',
        'zh_cn': 'str'
    }

    attribute_map = {
        'en_us': 'en-US',
        'zh_cn': 'zh-CN'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """TaskDescription - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._en_us = None
        self._zh_cn = None
        self.discriminator = None

        if "en_us" in kwargs:
            self.en_us = kwargs["en_us"]
        if "zh_cn" in kwargs:
            self.zh_cn = kwargs["zh_cn"]

    @property
    def en_us(self):
        """Gets the en_us of this TaskDescription.  # noqa: E501


        :return: The en_us of this TaskDescription.  # noqa: E501
        :rtype: str
        """
        return self._en_us

    @en_us.setter
    def en_us(self, en_us):
        """Sets the en_us of this TaskDescription.


        :param en_us: The en_us of this TaskDescription.  # noqa: E501
        :type en_us: str
        """
        if self.local_vars_configuration.client_side_validation and en_us is None:  # noqa: E501
            raise ValueError("Invalid value for `en_us`, must not be `None`")  # noqa: E501

        self._en_us = en_us

    @property
    def zh_cn(self):
        """Gets the zh_cn of this TaskDescription.  # noqa: E501


        :return: The zh_cn of this TaskDescription.  # noqa: E501
        :rtype: str
        """
        return self._zh_cn

    @zh_cn.setter
    def zh_cn(self, zh_cn):
        """Sets the zh_cn of this TaskDescription.


        :param zh_cn: The zh_cn of this TaskDescription.  # noqa: E501
        :type zh_cn: str
        """
        if self.local_vars_configuration.client_side_validation and zh_cn is None:  # noqa: E501
            raise ValueError("Invalid value for `zh_cn`, must not be `None`")  # noqa: E501

        self._zh_cn = zh_cn

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskDescription):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TaskDescription):
            return True

        return self.to_dict() != other.to_dict()
