# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class TaskStepCreationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'description': 'str',
        'finished': 'bool',
        'key': 'str'
    }

    attribute_map = {
        'description': 'description',
        'finished': 'finished',
        'key': 'key'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """TaskStepCreationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._description = None
        self._finished = None
        self._key = None
        self.discriminator = None

        if "description" in kwargs:
            self.description = kwargs["description"]
        if "finished" in kwargs:
            self.finished = kwargs["finished"]
        if "key" in kwargs:
            self.key = kwargs["key"]

    @property
    def description(self):
        """Gets the description of this TaskStepCreationParams.  # noqa: E501


        :return: The description of this TaskStepCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this TaskStepCreationParams.


        :param description: The description of this TaskStepCreationParams.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def finished(self):
        """Gets the finished of this TaskStepCreationParams.  # noqa: E501


        :return: The finished of this TaskStepCreationParams.  # noqa: E501
        :rtype: bool
        """
        return self._finished

    @finished.setter
    def finished(self, finished):
        """Sets the finished of this TaskStepCreationParams.


        :param finished: The finished of this TaskStepCreationParams.  # noqa: E501
        :type finished: bool
        """
        if self.local_vars_configuration.client_side_validation and finished is None:  # noqa: E501
            raise ValueError("Invalid value for `finished`, must not be `None`")  # noqa: E501

        self._finished = finished

    @property
    def key(self):
        """Gets the key of this TaskStepCreationParams.  # noqa: E501


        :return: The key of this TaskStepCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this TaskStepCreationParams.


        :param key: The key of this TaskStepCreationParams.  # noqa: E501
        :type key: str
        """
        if self.local_vars_configuration.client_side_validation and key is None:  # noqa: E501
            raise ValueError("Invalid value for `key`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) < 1):
            raise ValueError("Invalid value for `key`, length must be greater than or equal to `1`")  # noqa: E501

        self._key = key

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskStepCreationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TaskStepCreationParams):
            return True

        return self.to_dict() != other.to_dict()
