# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class UpdatePassrodSecurityParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'password_expire_days': 'int',
        'password_complexity': 'PasswordComplexity',
        'login_miss_time_threshold': 'int',
        'login_miss_num_threshold': 'int'
    }

    attribute_map = {
        'password_expire_days': 'password_expire_days',
        'password_complexity': 'password_complexity',
        'login_miss_time_threshold': 'login_miss_time_threshold',
        'login_miss_num_threshold': 'login_miss_num_threshold'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """UpdatePassrodSecurityParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._password_expire_days = None
        self._password_complexity = None
        self._login_miss_time_threshold = None
        self._login_miss_num_threshold = None
        self.discriminator = None

        if "password_expire_days" in kwargs:
            self.password_expire_days = kwargs["password_expire_days"]
        if "password_complexity" in kwargs:
            self.password_complexity = kwargs["password_complexity"]
        if "login_miss_time_threshold" in kwargs:
            self.login_miss_time_threshold = kwargs["login_miss_time_threshold"]
        if "login_miss_num_threshold" in kwargs:
            self.login_miss_num_threshold = kwargs["login_miss_num_threshold"]

    @property
    def password_expire_days(self):
        """Gets the password_expire_days of this UpdatePassrodSecurityParams.  # noqa: E501


        :return: The password_expire_days of this UpdatePassrodSecurityParams.  # noqa: E501
        :rtype: int
        """
        return self._password_expire_days

    @password_expire_days.setter
    def password_expire_days(self, password_expire_days):
        """Sets the password_expire_days of this UpdatePassrodSecurityParams.


        :param password_expire_days: The password_expire_days of this UpdatePassrodSecurityParams.  # noqa: E501
        :type password_expire_days: int
        """

        self._password_expire_days = password_expire_days

    @property
    def password_complexity(self):
        """Gets the password_complexity of this UpdatePassrodSecurityParams.  # noqa: E501


        :return: The password_complexity of this UpdatePassrodSecurityParams.  # noqa: E501
        :rtype: PasswordComplexity
        """
        return self._password_complexity

    @password_complexity.setter
    def password_complexity(self, password_complexity):
        """Sets the password_complexity of this UpdatePassrodSecurityParams.


        :param password_complexity: The password_complexity of this UpdatePassrodSecurityParams.  # noqa: E501
        :type password_complexity: PasswordComplexity
        """

        self._password_complexity = password_complexity

    @property
    def login_miss_time_threshold(self):
        """Gets the login_miss_time_threshold of this UpdatePassrodSecurityParams.  # noqa: E501


        :return: The login_miss_time_threshold of this UpdatePassrodSecurityParams.  # noqa: E501
        :rtype: int
        """
        return self._login_miss_time_threshold

    @login_miss_time_threshold.setter
    def login_miss_time_threshold(self, login_miss_time_threshold):
        """Sets the login_miss_time_threshold of this UpdatePassrodSecurityParams.


        :param login_miss_time_threshold: The login_miss_time_threshold of this UpdatePassrodSecurityParams.  # noqa: E501
        :type login_miss_time_threshold: int
        """

        self._login_miss_time_threshold = login_miss_time_threshold

    @property
    def login_miss_num_threshold(self):
        """Gets the login_miss_num_threshold of this UpdatePassrodSecurityParams.  # noqa: E501


        :return: The login_miss_num_threshold of this UpdatePassrodSecurityParams.  # noqa: E501
        :rtype: int
        """
        return self._login_miss_num_threshold

    @login_miss_num_threshold.setter
    def login_miss_num_threshold(self, login_miss_num_threshold):
        """Sets the login_miss_num_threshold of this UpdatePassrodSecurityParams.


        :param login_miss_num_threshold: The login_miss_num_threshold of this UpdatePassrodSecurityParams.  # noqa: E501
        :type login_miss_num_threshold: int
        """

        self._login_miss_num_threshold = login_miss_num_threshold

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdatePassrodSecurityParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UpdatePassrodSecurityParams):
            return True

        return self.to_dict() != other.to_dict()
