# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class UpdateVsphereEsxiAccountParamsData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'port': 'int',
        'password': 'str',
        'username': 'str',
        'ip': 'str',
        'esxi_account_id': 'str'
    }

    attribute_map = {
        'port': 'port',
        'password': 'password',
        'username': 'username',
        'ip': 'ip',
        'esxi_account_id': 'esxi_account_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """UpdateVsphereEsxiAccountParamsData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._port = None
        self._password = None
        self._username = None
        self._ip = None
        self._esxi_account_id = None
        self.discriminator = None

        if "port" in kwargs:
            self.port = kwargs["port"]
        if "password" in kwargs:
            self.password = kwargs["password"]
        if "username" in kwargs:
            self.username = kwargs["username"]
        if "ip" in kwargs:
            self.ip = kwargs["ip"]
        if "esxi_account_id" in kwargs:
            self.esxi_account_id = kwargs["esxi_account_id"]

    @property
    def port(self):
        """Gets the port of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501


        :return: The port of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this UpdateVsphereEsxiAccountParamsData.


        :param port: The port of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501
        :type port: int
        """

        self._port = port

    @property
    def password(self):
        """Gets the password of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501


        :return: The password of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this UpdateVsphereEsxiAccountParamsData.


        :param password: The password of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501
        :type password: str
        """

        self._password = password

    @property
    def username(self):
        """Gets the username of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501


        :return: The username of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this UpdateVsphereEsxiAccountParamsData.


        :param username: The username of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501
        :type username: str
        """
        if self.local_vars_configuration.client_side_validation and username is None:  # noqa: E501
            raise ValueError("Invalid value for `username`, must not be `None`")  # noqa: E501

        self._username = username

    @property
    def ip(self):
        """Gets the ip of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501


        :return: The ip of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501
        :rtype: str
        """
        return self._ip

    @ip.setter
    def ip(self, ip):
        """Sets the ip of this UpdateVsphereEsxiAccountParamsData.


        :param ip: The ip of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501
        :type ip: str
        """
        if self.local_vars_configuration.client_side_validation and ip is None:  # noqa: E501
            raise ValueError("Invalid value for `ip`, must not be `None`")  # noqa: E501

        self._ip = ip

    @property
    def esxi_account_id(self):
        """Gets the esxi_account_id of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501


        :return: The esxi_account_id of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501
        :rtype: str
        """
        return self._esxi_account_id

    @esxi_account_id.setter
    def esxi_account_id(self, esxi_account_id):
        """Sets the esxi_account_id of this UpdateVsphereEsxiAccountParamsData.


        :param esxi_account_id: The esxi_account_id of this UpdateVsphereEsxiAccountParamsData.  # noqa: E501
        :type esxi_account_id: str
        """
        if self.local_vars_configuration.client_side_validation and esxi_account_id is None:  # noqa: E501
            raise ValueError("Invalid value for `esxi_account_id`, must not be `None`")  # noqa: E501

        self._esxi_account_id = esxi_account_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdateVsphereEsxiAccountParamsData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UpdateVsphereEsxiAccountParamsData):
            return True

        return self.to_dict() != other.to_dict()
