# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class UploadTask(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'args': 'object',
        'chunk_size': 'int',
        'current_chunk': 'int',
        'finished_at': 'str',
        'id': 'str',
        'resource_type': 'UploadResourceType',
        'size': 'int',
        'started_at': 'str',
        'status': 'UploadTaskStatus',
        'updated_at': 'str'
    }

    attribute_map = {
        'args': 'args',
        'chunk_size': 'chunk_size',
        'current_chunk': 'current_chunk',
        'finished_at': 'finished_at',
        'id': 'id',
        'resource_type': 'resource_type',
        'size': 'size',
        'started_at': 'started_at',
        'status': 'status',
        'updated_at': 'updatedAt'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """UploadTask - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._args = None
        self._chunk_size = None
        self._current_chunk = None
        self._finished_at = None
        self._id = None
        self._resource_type = None
        self._size = None
        self._started_at = None
        self._status = None
        self._updated_at = None
        self.discriminator = None

        if "args" in kwargs:
            self.args = kwargs["args"]
        if "chunk_size" in kwargs:
            self.chunk_size = kwargs["chunk_size"]
        if "current_chunk" in kwargs:
            self.current_chunk = kwargs["current_chunk"]
        self.finished_at = kwargs.get("finished_at", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "resource_type" in kwargs:
            self.resource_type = kwargs["resource_type"]
        if "size" in kwargs:
            self.size = kwargs["size"]
        self.started_at = kwargs.get("started_at", None)
        if "status" in kwargs:
            self.status = kwargs["status"]
        if "updated_at" in kwargs:
            self.updated_at = kwargs["updated_at"]

    @property
    def args(self):
        """Gets the args of this UploadTask.  # noqa: E501


        :return: The args of this UploadTask.  # noqa: E501
        :rtype: object
        """
        return self._args

    @args.setter
    def args(self, args):
        """Sets the args of this UploadTask.


        :param args: The args of this UploadTask.  # noqa: E501
        :type args: object
        """
        if self.local_vars_configuration.client_side_validation and args is None:  # noqa: E501
            raise ValueError("Invalid value for `args`, must not be `None`")  # noqa: E501

        self._args = args

    @property
    def chunk_size(self):
        """Gets the chunk_size of this UploadTask.  # noqa: E501


        :return: The chunk_size of this UploadTask.  # noqa: E501
        :rtype: int
        """
        return self._chunk_size

    @chunk_size.setter
    def chunk_size(self, chunk_size):
        """Sets the chunk_size of this UploadTask.


        :param chunk_size: The chunk_size of this UploadTask.  # noqa: E501
        :type chunk_size: int
        """
        if self.local_vars_configuration.client_side_validation and chunk_size is None:  # noqa: E501
            raise ValueError("Invalid value for `chunk_size`, must not be `None`")  # noqa: E501

        self._chunk_size = chunk_size

    @property
    def current_chunk(self):
        """Gets the current_chunk of this UploadTask.  # noqa: E501


        :return: The current_chunk of this UploadTask.  # noqa: E501
        :rtype: int
        """
        return self._current_chunk

    @current_chunk.setter
    def current_chunk(self, current_chunk):
        """Sets the current_chunk of this UploadTask.


        :param current_chunk: The current_chunk of this UploadTask.  # noqa: E501
        :type current_chunk: int
        """
        if self.local_vars_configuration.client_side_validation and current_chunk is None:  # noqa: E501
            raise ValueError("Invalid value for `current_chunk`, must not be `None`")  # noqa: E501

        self._current_chunk = current_chunk

    @property
    def finished_at(self):
        """Gets the finished_at of this UploadTask.  # noqa: E501


        :return: The finished_at of this UploadTask.  # noqa: E501
        :rtype: str
        """
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """Sets the finished_at of this UploadTask.


        :param finished_at: The finished_at of this UploadTask.  # noqa: E501
        :type finished_at: str
        """

        self._finished_at = finished_at

    @property
    def id(self):
        """Gets the id of this UploadTask.  # noqa: E501


        :return: The id of this UploadTask.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this UploadTask.


        :param id: The id of this UploadTask.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def resource_type(self):
        """Gets the resource_type of this UploadTask.  # noqa: E501


        :return: The resource_type of this UploadTask.  # noqa: E501
        :rtype: UploadResourceType
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this UploadTask.


        :param resource_type: The resource_type of this UploadTask.  # noqa: E501
        :type resource_type: UploadResourceType
        """
        if self.local_vars_configuration.client_side_validation and resource_type is None:  # noqa: E501
            raise ValueError("Invalid value for `resource_type`, must not be `None`")  # noqa: E501

        self._resource_type = resource_type

    @property
    def size(self):
        """Gets the size of this UploadTask.  # noqa: E501


        :return: The size of this UploadTask.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this UploadTask.


        :param size: The size of this UploadTask.  # noqa: E501
        :type size: int
        """
        if self.local_vars_configuration.client_side_validation and size is None:  # noqa: E501
            raise ValueError("Invalid value for `size`, must not be `None`")  # noqa: E501

        self._size = size

    @property
    def started_at(self):
        """Gets the started_at of this UploadTask.  # noqa: E501


        :return: The started_at of this UploadTask.  # noqa: E501
        :rtype: str
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """Sets the started_at of this UploadTask.


        :param started_at: The started_at of this UploadTask.  # noqa: E501
        :type started_at: str
        """

        self._started_at = started_at

    @property
    def status(self):
        """Gets the status of this UploadTask.  # noqa: E501


        :return: The status of this UploadTask.  # noqa: E501
        :rtype: UploadTaskStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this UploadTask.


        :param status: The status of this UploadTask.  # noqa: E501
        :type status: UploadTaskStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def updated_at(self):
        """Gets the updated_at of this UploadTask.  # noqa: E501


        :return: The updated_at of this UploadTask.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this UploadTask.


        :param updated_at: The updated_at of this UploadTask.  # noqa: E501
        :type updated_at: str
        """
        if self.local_vars_configuration.client_side_validation and updated_at is None:  # noqa: E501
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501

        self._updated_at = updated_at

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UploadTask):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UploadTask):
            return True

        return self.to_dict() != other.to_dict()
