# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class UploadTaskWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[UploadTaskWhereInput]',
        '_not': 'list[UploadTaskWhereInput]',
        '_or': 'list[UploadTaskWhereInput]',
        'chunk_size': 'int',
        'chunk_size_gt': 'int',
        'chunk_size_gte': 'int',
        'chunk_size_in': 'list[int]',
        'chunk_size_lt': 'int',
        'chunk_size_lte': 'int',
        'chunk_size_not': 'int',
        'chunk_size_not_in': 'list[int]',
        'current_chunk': 'int',
        'current_chunk_gt': 'int',
        'current_chunk_gte': 'int',
        'current_chunk_in': 'list[int]',
        'current_chunk_lt': 'int',
        'current_chunk_lte': 'int',
        'current_chunk_not': 'int',
        'current_chunk_not_in': 'list[int]',
        'finished_at': 'str',
        'finished_at_gt': 'str',
        'finished_at_gte': 'str',
        'finished_at_in': 'list[str]',
        'finished_at_lt': 'str',
        'finished_at_lte': 'str',
        'finished_at_not': 'str',
        'finished_at_not_in': 'list[str]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'resource_type': 'UploadResourceType',
        'resource_type_in': 'list[UploadResourceType]',
        'resource_type_not': 'UploadResourceType',
        'resource_type_not_in': 'list[UploadResourceType]',
        'size': 'int',
        'size_gt': 'int',
        'size_gte': 'int',
        'size_in': 'list[int]',
        'size_lt': 'int',
        'size_lte': 'int',
        'size_not': 'int',
        'size_not_in': 'list[int]',
        'started_at': 'str',
        'started_at_gt': 'str',
        'started_at_gte': 'str',
        'started_at_in': 'list[str]',
        'started_at_lt': 'str',
        'started_at_lte': 'str',
        'started_at_not': 'str',
        'started_at_not_in': 'list[str]',
        'status': 'UploadTaskStatus',
        'status_in': 'list[UploadTaskStatus]',
        'status_not': 'UploadTaskStatus',
        'status_not_in': 'list[UploadTaskStatus]',
        'updated_at': 'str',
        'updated_at_gt': 'str',
        'updated_at_gte': 'str',
        'updated_at_in': 'list[str]',
        'updated_at_lt': 'str',
        'updated_at_lte': 'str',
        'updated_at_not': 'str',
        'updated_at_not_in': 'list[str]'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'chunk_size': 'chunk_size',
        'chunk_size_gt': 'chunk_size_gt',
        'chunk_size_gte': 'chunk_size_gte',
        'chunk_size_in': 'chunk_size_in',
        'chunk_size_lt': 'chunk_size_lt',
        'chunk_size_lte': 'chunk_size_lte',
        'chunk_size_not': 'chunk_size_not',
        'chunk_size_not_in': 'chunk_size_not_in',
        'current_chunk': 'current_chunk',
        'current_chunk_gt': 'current_chunk_gt',
        'current_chunk_gte': 'current_chunk_gte',
        'current_chunk_in': 'current_chunk_in',
        'current_chunk_lt': 'current_chunk_lt',
        'current_chunk_lte': 'current_chunk_lte',
        'current_chunk_not': 'current_chunk_not',
        'current_chunk_not_in': 'current_chunk_not_in',
        'finished_at': 'finished_at',
        'finished_at_gt': 'finished_at_gt',
        'finished_at_gte': 'finished_at_gte',
        'finished_at_in': 'finished_at_in',
        'finished_at_lt': 'finished_at_lt',
        'finished_at_lte': 'finished_at_lte',
        'finished_at_not': 'finished_at_not',
        'finished_at_not_in': 'finished_at_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'resource_type': 'resource_type',
        'resource_type_in': 'resource_type_in',
        'resource_type_not': 'resource_type_not',
        'resource_type_not_in': 'resource_type_not_in',
        'size': 'size',
        'size_gt': 'size_gt',
        'size_gte': 'size_gte',
        'size_in': 'size_in',
        'size_lt': 'size_lt',
        'size_lte': 'size_lte',
        'size_not': 'size_not',
        'size_not_in': 'size_not_in',
        'started_at': 'started_at',
        'started_at_gt': 'started_at_gt',
        'started_at_gte': 'started_at_gte',
        'started_at_in': 'started_at_in',
        'started_at_lt': 'started_at_lt',
        'started_at_lte': 'started_at_lte',
        'started_at_not': 'started_at_not',
        'started_at_not_in': 'started_at_not_in',
        'status': 'status',
        'status_in': 'status_in',
        'status_not': 'status_not',
        'status_not_in': 'status_not_in',
        'updated_at': 'updatedAt',
        'updated_at_gt': 'updatedAt_gt',
        'updated_at_gte': 'updatedAt_gte',
        'updated_at_in': 'updatedAt_in',
        'updated_at_lt': 'updatedAt_lt',
        'updated_at_lte': 'updatedAt_lte',
        'updated_at_not': 'updatedAt_not',
        'updated_at_not_in': 'updatedAt_not_in'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """UploadTaskWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._chunk_size = None
        self._chunk_size_gt = None
        self._chunk_size_gte = None
        self._chunk_size_in = None
        self._chunk_size_lt = None
        self._chunk_size_lte = None
        self._chunk_size_not = None
        self._chunk_size_not_in = None
        self._current_chunk = None
        self._current_chunk_gt = None
        self._current_chunk_gte = None
        self._current_chunk_in = None
        self._current_chunk_lt = None
        self._current_chunk_lte = None
        self._current_chunk_not = None
        self._current_chunk_not_in = None
        self._finished_at = None
        self._finished_at_gt = None
        self._finished_at_gte = None
        self._finished_at_in = None
        self._finished_at_lt = None
        self._finished_at_lte = None
        self._finished_at_not = None
        self._finished_at_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._resource_type = None
        self._resource_type_in = None
        self._resource_type_not = None
        self._resource_type_not_in = None
        self._size = None
        self._size_gt = None
        self._size_gte = None
        self._size_in = None
        self._size_lt = None
        self._size_lte = None
        self._size_not = None
        self._size_not_in = None
        self._started_at = None
        self._started_at_gt = None
        self._started_at_gte = None
        self._started_at_in = None
        self._started_at_lt = None
        self._started_at_lte = None
        self._started_at_not = None
        self._started_at_not_in = None
        self._status = None
        self._status_in = None
        self._status_not = None
        self._status_not_in = None
        self._updated_at = None
        self._updated_at_gt = None
        self._updated_at_gte = None
        self._updated_at_in = None
        self._updated_at_lt = None
        self._updated_at_lte = None
        self._updated_at_not = None
        self._updated_at_not_in = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.chunk_size = kwargs.get("chunk_size", None)
        self.chunk_size_gt = kwargs.get("chunk_size_gt", None)
        self.chunk_size_gte = kwargs.get("chunk_size_gte", None)
        self.chunk_size_in = kwargs.get("chunk_size_in", None)
        self.chunk_size_lt = kwargs.get("chunk_size_lt", None)
        self.chunk_size_lte = kwargs.get("chunk_size_lte", None)
        self.chunk_size_not = kwargs.get("chunk_size_not", None)
        self.chunk_size_not_in = kwargs.get("chunk_size_not_in", None)
        self.current_chunk = kwargs.get("current_chunk", None)
        self.current_chunk_gt = kwargs.get("current_chunk_gt", None)
        self.current_chunk_gte = kwargs.get("current_chunk_gte", None)
        self.current_chunk_in = kwargs.get("current_chunk_in", None)
        self.current_chunk_lt = kwargs.get("current_chunk_lt", None)
        self.current_chunk_lte = kwargs.get("current_chunk_lte", None)
        self.current_chunk_not = kwargs.get("current_chunk_not", None)
        self.current_chunk_not_in = kwargs.get("current_chunk_not_in", None)
        self.finished_at = kwargs.get("finished_at", None)
        self.finished_at_gt = kwargs.get("finished_at_gt", None)
        self.finished_at_gte = kwargs.get("finished_at_gte", None)
        self.finished_at_in = kwargs.get("finished_at_in", None)
        self.finished_at_lt = kwargs.get("finished_at_lt", None)
        self.finished_at_lte = kwargs.get("finished_at_lte", None)
        self.finished_at_not = kwargs.get("finished_at_not", None)
        self.finished_at_not_in = kwargs.get("finished_at_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.resource_type = kwargs.get("resource_type", None)
        self.resource_type_in = kwargs.get("resource_type_in", None)
        self.resource_type_not = kwargs.get("resource_type_not", None)
        self.resource_type_not_in = kwargs.get("resource_type_not_in", None)
        self.size = kwargs.get("size", None)
        self.size_gt = kwargs.get("size_gt", None)
        self.size_gte = kwargs.get("size_gte", None)
        self.size_in = kwargs.get("size_in", None)
        self.size_lt = kwargs.get("size_lt", None)
        self.size_lte = kwargs.get("size_lte", None)
        self.size_not = kwargs.get("size_not", None)
        self.size_not_in = kwargs.get("size_not_in", None)
        self.started_at = kwargs.get("started_at", None)
        self.started_at_gt = kwargs.get("started_at_gt", None)
        self.started_at_gte = kwargs.get("started_at_gte", None)
        self.started_at_in = kwargs.get("started_at_in", None)
        self.started_at_lt = kwargs.get("started_at_lt", None)
        self.started_at_lte = kwargs.get("started_at_lte", None)
        self.started_at_not = kwargs.get("started_at_not", None)
        self.started_at_not_in = kwargs.get("started_at_not_in", None)
        self.status = kwargs.get("status", None)
        self.status_in = kwargs.get("status_in", None)
        self.status_not = kwargs.get("status_not", None)
        self.status_not_in = kwargs.get("status_not_in", None)
        self.updated_at = kwargs.get("updated_at", None)
        self.updated_at_gt = kwargs.get("updated_at_gt", None)
        self.updated_at_gte = kwargs.get("updated_at_gte", None)
        self.updated_at_in = kwargs.get("updated_at_in", None)
        self.updated_at_lt = kwargs.get("updated_at_lt", None)
        self.updated_at_lte = kwargs.get("updated_at_lte", None)
        self.updated_at_not = kwargs.get("updated_at_not", None)
        self.updated_at_not_in = kwargs.get("updated_at_not_in", None)

    @property
    def _and(self):
        """Gets the _and of this UploadTaskWhereInput.  # noqa: E501


        :return: The _and of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[UploadTaskWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this UploadTaskWhereInput.


        :param _and: The _and of this UploadTaskWhereInput.  # noqa: E501
        :type _and: list[UploadTaskWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this UploadTaskWhereInput.  # noqa: E501


        :return: The _not of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[UploadTaskWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this UploadTaskWhereInput.


        :param _not: The _not of this UploadTaskWhereInput.  # noqa: E501
        :type _not: list[UploadTaskWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this UploadTaskWhereInput.  # noqa: E501


        :return: The _or of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[UploadTaskWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this UploadTaskWhereInput.


        :param _or: The _or of this UploadTaskWhereInput.  # noqa: E501
        :type _or: list[UploadTaskWhereInput]
        """

        self.__or = _or

    @property
    def chunk_size(self):
        """Gets the chunk_size of this UploadTaskWhereInput.  # noqa: E501


        :return: The chunk_size of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_size

    @chunk_size.setter
    def chunk_size(self, chunk_size):
        """Sets the chunk_size of this UploadTaskWhereInput.


        :param chunk_size: The chunk_size of this UploadTaskWhereInput.  # noqa: E501
        :type chunk_size: int
        """

        self._chunk_size = chunk_size

    @property
    def chunk_size_gt(self):
        """Gets the chunk_size_gt of this UploadTaskWhereInput.  # noqa: E501


        :return: The chunk_size_gt of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_size_gt

    @chunk_size_gt.setter
    def chunk_size_gt(self, chunk_size_gt):
        """Sets the chunk_size_gt of this UploadTaskWhereInput.


        :param chunk_size_gt: The chunk_size_gt of this UploadTaskWhereInput.  # noqa: E501
        :type chunk_size_gt: int
        """

        self._chunk_size_gt = chunk_size_gt

    @property
    def chunk_size_gte(self):
        """Gets the chunk_size_gte of this UploadTaskWhereInput.  # noqa: E501


        :return: The chunk_size_gte of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_size_gte

    @chunk_size_gte.setter
    def chunk_size_gte(self, chunk_size_gte):
        """Sets the chunk_size_gte of this UploadTaskWhereInput.


        :param chunk_size_gte: The chunk_size_gte of this UploadTaskWhereInput.  # noqa: E501
        :type chunk_size_gte: int
        """

        self._chunk_size_gte = chunk_size_gte

    @property
    def chunk_size_in(self):
        """Gets the chunk_size_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The chunk_size_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._chunk_size_in

    @chunk_size_in.setter
    def chunk_size_in(self, chunk_size_in):
        """Sets the chunk_size_in of this UploadTaskWhereInput.


        :param chunk_size_in: The chunk_size_in of this UploadTaskWhereInput.  # noqa: E501
        :type chunk_size_in: list[int]
        """

        self._chunk_size_in = chunk_size_in

    @property
    def chunk_size_lt(self):
        """Gets the chunk_size_lt of this UploadTaskWhereInput.  # noqa: E501


        :return: The chunk_size_lt of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_size_lt

    @chunk_size_lt.setter
    def chunk_size_lt(self, chunk_size_lt):
        """Sets the chunk_size_lt of this UploadTaskWhereInput.


        :param chunk_size_lt: The chunk_size_lt of this UploadTaskWhereInput.  # noqa: E501
        :type chunk_size_lt: int
        """

        self._chunk_size_lt = chunk_size_lt

    @property
    def chunk_size_lte(self):
        """Gets the chunk_size_lte of this UploadTaskWhereInput.  # noqa: E501


        :return: The chunk_size_lte of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_size_lte

    @chunk_size_lte.setter
    def chunk_size_lte(self, chunk_size_lte):
        """Sets the chunk_size_lte of this UploadTaskWhereInput.


        :param chunk_size_lte: The chunk_size_lte of this UploadTaskWhereInput.  # noqa: E501
        :type chunk_size_lte: int
        """

        self._chunk_size_lte = chunk_size_lte

    @property
    def chunk_size_not(self):
        """Gets the chunk_size_not of this UploadTaskWhereInput.  # noqa: E501


        :return: The chunk_size_not of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._chunk_size_not

    @chunk_size_not.setter
    def chunk_size_not(self, chunk_size_not):
        """Sets the chunk_size_not of this UploadTaskWhereInput.


        :param chunk_size_not: The chunk_size_not of this UploadTaskWhereInput.  # noqa: E501
        :type chunk_size_not: int
        """

        self._chunk_size_not = chunk_size_not

    @property
    def chunk_size_not_in(self):
        """Gets the chunk_size_not_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The chunk_size_not_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._chunk_size_not_in

    @chunk_size_not_in.setter
    def chunk_size_not_in(self, chunk_size_not_in):
        """Sets the chunk_size_not_in of this UploadTaskWhereInput.


        :param chunk_size_not_in: The chunk_size_not_in of this UploadTaskWhereInput.  # noqa: E501
        :type chunk_size_not_in: list[int]
        """

        self._chunk_size_not_in = chunk_size_not_in

    @property
    def current_chunk(self):
        """Gets the current_chunk of this UploadTaskWhereInput.  # noqa: E501


        :return: The current_chunk of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._current_chunk

    @current_chunk.setter
    def current_chunk(self, current_chunk):
        """Sets the current_chunk of this UploadTaskWhereInput.


        :param current_chunk: The current_chunk of this UploadTaskWhereInput.  # noqa: E501
        :type current_chunk: int
        """

        self._current_chunk = current_chunk

    @property
    def current_chunk_gt(self):
        """Gets the current_chunk_gt of this UploadTaskWhereInput.  # noqa: E501


        :return: The current_chunk_gt of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._current_chunk_gt

    @current_chunk_gt.setter
    def current_chunk_gt(self, current_chunk_gt):
        """Sets the current_chunk_gt of this UploadTaskWhereInput.


        :param current_chunk_gt: The current_chunk_gt of this UploadTaskWhereInput.  # noqa: E501
        :type current_chunk_gt: int
        """

        self._current_chunk_gt = current_chunk_gt

    @property
    def current_chunk_gte(self):
        """Gets the current_chunk_gte of this UploadTaskWhereInput.  # noqa: E501


        :return: The current_chunk_gte of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._current_chunk_gte

    @current_chunk_gte.setter
    def current_chunk_gte(self, current_chunk_gte):
        """Sets the current_chunk_gte of this UploadTaskWhereInput.


        :param current_chunk_gte: The current_chunk_gte of this UploadTaskWhereInput.  # noqa: E501
        :type current_chunk_gte: int
        """

        self._current_chunk_gte = current_chunk_gte

    @property
    def current_chunk_in(self):
        """Gets the current_chunk_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The current_chunk_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._current_chunk_in

    @current_chunk_in.setter
    def current_chunk_in(self, current_chunk_in):
        """Sets the current_chunk_in of this UploadTaskWhereInput.


        :param current_chunk_in: The current_chunk_in of this UploadTaskWhereInput.  # noqa: E501
        :type current_chunk_in: list[int]
        """

        self._current_chunk_in = current_chunk_in

    @property
    def current_chunk_lt(self):
        """Gets the current_chunk_lt of this UploadTaskWhereInput.  # noqa: E501


        :return: The current_chunk_lt of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._current_chunk_lt

    @current_chunk_lt.setter
    def current_chunk_lt(self, current_chunk_lt):
        """Sets the current_chunk_lt of this UploadTaskWhereInput.


        :param current_chunk_lt: The current_chunk_lt of this UploadTaskWhereInput.  # noqa: E501
        :type current_chunk_lt: int
        """

        self._current_chunk_lt = current_chunk_lt

    @property
    def current_chunk_lte(self):
        """Gets the current_chunk_lte of this UploadTaskWhereInput.  # noqa: E501


        :return: The current_chunk_lte of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._current_chunk_lte

    @current_chunk_lte.setter
    def current_chunk_lte(self, current_chunk_lte):
        """Sets the current_chunk_lte of this UploadTaskWhereInput.


        :param current_chunk_lte: The current_chunk_lte of this UploadTaskWhereInput.  # noqa: E501
        :type current_chunk_lte: int
        """

        self._current_chunk_lte = current_chunk_lte

    @property
    def current_chunk_not(self):
        """Gets the current_chunk_not of this UploadTaskWhereInput.  # noqa: E501


        :return: The current_chunk_not of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._current_chunk_not

    @current_chunk_not.setter
    def current_chunk_not(self, current_chunk_not):
        """Sets the current_chunk_not of this UploadTaskWhereInput.


        :param current_chunk_not: The current_chunk_not of this UploadTaskWhereInput.  # noqa: E501
        :type current_chunk_not: int
        """

        self._current_chunk_not = current_chunk_not

    @property
    def current_chunk_not_in(self):
        """Gets the current_chunk_not_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The current_chunk_not_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._current_chunk_not_in

    @current_chunk_not_in.setter
    def current_chunk_not_in(self, current_chunk_not_in):
        """Sets the current_chunk_not_in of this UploadTaskWhereInput.


        :param current_chunk_not_in: The current_chunk_not_in of this UploadTaskWhereInput.  # noqa: E501
        :type current_chunk_not_in: list[int]
        """

        self._current_chunk_not_in = current_chunk_not_in

    @property
    def finished_at(self):
        """Gets the finished_at of this UploadTaskWhereInput.  # noqa: E501


        :return: The finished_at of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """Sets the finished_at of this UploadTaskWhereInput.


        :param finished_at: The finished_at of this UploadTaskWhereInput.  # noqa: E501
        :type finished_at: str
        """

        self._finished_at = finished_at

    @property
    def finished_at_gt(self):
        """Gets the finished_at_gt of this UploadTaskWhereInput.  # noqa: E501


        :return: The finished_at_gt of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_gt

    @finished_at_gt.setter
    def finished_at_gt(self, finished_at_gt):
        """Sets the finished_at_gt of this UploadTaskWhereInput.


        :param finished_at_gt: The finished_at_gt of this UploadTaskWhereInput.  # noqa: E501
        :type finished_at_gt: str
        """

        self._finished_at_gt = finished_at_gt

    @property
    def finished_at_gte(self):
        """Gets the finished_at_gte of this UploadTaskWhereInput.  # noqa: E501


        :return: The finished_at_gte of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_gte

    @finished_at_gte.setter
    def finished_at_gte(self, finished_at_gte):
        """Sets the finished_at_gte of this UploadTaskWhereInput.


        :param finished_at_gte: The finished_at_gte of this UploadTaskWhereInput.  # noqa: E501
        :type finished_at_gte: str
        """

        self._finished_at_gte = finished_at_gte

    @property
    def finished_at_in(self):
        """Gets the finished_at_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The finished_at_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._finished_at_in

    @finished_at_in.setter
    def finished_at_in(self, finished_at_in):
        """Sets the finished_at_in of this UploadTaskWhereInput.


        :param finished_at_in: The finished_at_in of this UploadTaskWhereInput.  # noqa: E501
        :type finished_at_in: list[str]
        """

        self._finished_at_in = finished_at_in

    @property
    def finished_at_lt(self):
        """Gets the finished_at_lt of this UploadTaskWhereInput.  # noqa: E501


        :return: The finished_at_lt of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_lt

    @finished_at_lt.setter
    def finished_at_lt(self, finished_at_lt):
        """Sets the finished_at_lt of this UploadTaskWhereInput.


        :param finished_at_lt: The finished_at_lt of this UploadTaskWhereInput.  # noqa: E501
        :type finished_at_lt: str
        """

        self._finished_at_lt = finished_at_lt

    @property
    def finished_at_lte(self):
        """Gets the finished_at_lte of this UploadTaskWhereInput.  # noqa: E501


        :return: The finished_at_lte of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_lte

    @finished_at_lte.setter
    def finished_at_lte(self, finished_at_lte):
        """Sets the finished_at_lte of this UploadTaskWhereInput.


        :param finished_at_lte: The finished_at_lte of this UploadTaskWhereInput.  # noqa: E501
        :type finished_at_lte: str
        """

        self._finished_at_lte = finished_at_lte

    @property
    def finished_at_not(self):
        """Gets the finished_at_not of this UploadTaskWhereInput.  # noqa: E501


        :return: The finished_at_not of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._finished_at_not

    @finished_at_not.setter
    def finished_at_not(self, finished_at_not):
        """Sets the finished_at_not of this UploadTaskWhereInput.


        :param finished_at_not: The finished_at_not of this UploadTaskWhereInput.  # noqa: E501
        :type finished_at_not: str
        """

        self._finished_at_not = finished_at_not

    @property
    def finished_at_not_in(self):
        """Gets the finished_at_not_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The finished_at_not_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._finished_at_not_in

    @finished_at_not_in.setter
    def finished_at_not_in(self, finished_at_not_in):
        """Sets the finished_at_not_in of this UploadTaskWhereInput.


        :param finished_at_not_in: The finished_at_not_in of this UploadTaskWhereInput.  # noqa: E501
        :type finished_at_not_in: list[str]
        """

        self._finished_at_not_in = finished_at_not_in

    @property
    def id(self):
        """Gets the id of this UploadTaskWhereInput.  # noqa: E501


        :return: The id of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this UploadTaskWhereInput.


        :param id: The id of this UploadTaskWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this UploadTaskWhereInput.  # noqa: E501


        :return: The id_contains of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this UploadTaskWhereInput.


        :param id_contains: The id_contains of this UploadTaskWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this UploadTaskWhereInput.  # noqa: E501


        :return: The id_ends_with of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this UploadTaskWhereInput.


        :param id_ends_with: The id_ends_with of this UploadTaskWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this UploadTaskWhereInput.  # noqa: E501


        :return: The id_gt of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this UploadTaskWhereInput.


        :param id_gt: The id_gt of this UploadTaskWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this UploadTaskWhereInput.  # noqa: E501


        :return: The id_gte of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this UploadTaskWhereInput.


        :param id_gte: The id_gte of this UploadTaskWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The id_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this UploadTaskWhereInput.


        :param id_in: The id_in of this UploadTaskWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this UploadTaskWhereInput.  # noqa: E501


        :return: The id_lt of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this UploadTaskWhereInput.


        :param id_lt: The id_lt of this UploadTaskWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this UploadTaskWhereInput.  # noqa: E501


        :return: The id_lte of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this UploadTaskWhereInput.


        :param id_lte: The id_lte of this UploadTaskWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this UploadTaskWhereInput.  # noqa: E501


        :return: The id_not of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this UploadTaskWhereInput.


        :param id_not: The id_not of this UploadTaskWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this UploadTaskWhereInput.  # noqa: E501


        :return: The id_not_contains of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this UploadTaskWhereInput.


        :param id_not_contains: The id_not_contains of this UploadTaskWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this UploadTaskWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this UploadTaskWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this UploadTaskWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The id_not_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this UploadTaskWhereInput.


        :param id_not_in: The id_not_in of this UploadTaskWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this UploadTaskWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this UploadTaskWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this UploadTaskWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this UploadTaskWhereInput.  # noqa: E501


        :return: The id_starts_with of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this UploadTaskWhereInput.


        :param id_starts_with: The id_starts_with of this UploadTaskWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def resource_type(self):
        """Gets the resource_type of this UploadTaskWhereInput.  # noqa: E501


        :return: The resource_type of this UploadTaskWhereInput.  # noqa: E501
        :rtype: UploadResourceType
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this UploadTaskWhereInput.


        :param resource_type: The resource_type of this UploadTaskWhereInput.  # noqa: E501
        :type resource_type: UploadResourceType
        """

        self._resource_type = resource_type

    @property
    def resource_type_in(self):
        """Gets the resource_type_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The resource_type_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[UploadResourceType]
        """
        return self._resource_type_in

    @resource_type_in.setter
    def resource_type_in(self, resource_type_in):
        """Sets the resource_type_in of this UploadTaskWhereInput.


        :param resource_type_in: The resource_type_in of this UploadTaskWhereInput.  # noqa: E501
        :type resource_type_in: list[UploadResourceType]
        """

        self._resource_type_in = resource_type_in

    @property
    def resource_type_not(self):
        """Gets the resource_type_not of this UploadTaskWhereInput.  # noqa: E501


        :return: The resource_type_not of this UploadTaskWhereInput.  # noqa: E501
        :rtype: UploadResourceType
        """
        return self._resource_type_not

    @resource_type_not.setter
    def resource_type_not(self, resource_type_not):
        """Sets the resource_type_not of this UploadTaskWhereInput.


        :param resource_type_not: The resource_type_not of this UploadTaskWhereInput.  # noqa: E501
        :type resource_type_not: UploadResourceType
        """

        self._resource_type_not = resource_type_not

    @property
    def resource_type_not_in(self):
        """Gets the resource_type_not_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The resource_type_not_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[UploadResourceType]
        """
        return self._resource_type_not_in

    @resource_type_not_in.setter
    def resource_type_not_in(self, resource_type_not_in):
        """Sets the resource_type_not_in of this UploadTaskWhereInput.


        :param resource_type_not_in: The resource_type_not_in of this UploadTaskWhereInput.  # noqa: E501
        :type resource_type_not_in: list[UploadResourceType]
        """

        self._resource_type_not_in = resource_type_not_in

    @property
    def size(self):
        """Gets the size of this UploadTaskWhereInput.  # noqa: E501


        :return: The size of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this UploadTaskWhereInput.


        :param size: The size of this UploadTaskWhereInput.  # noqa: E501
        :type size: int
        """

        self._size = size

    @property
    def size_gt(self):
        """Gets the size_gt of this UploadTaskWhereInput.  # noqa: E501


        :return: The size_gt of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_gt

    @size_gt.setter
    def size_gt(self, size_gt):
        """Sets the size_gt of this UploadTaskWhereInput.


        :param size_gt: The size_gt of this UploadTaskWhereInput.  # noqa: E501
        :type size_gt: int
        """

        self._size_gt = size_gt

    @property
    def size_gte(self):
        """Gets the size_gte of this UploadTaskWhereInput.  # noqa: E501


        :return: The size_gte of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_gte

    @size_gte.setter
    def size_gte(self, size_gte):
        """Sets the size_gte of this UploadTaskWhereInput.


        :param size_gte: The size_gte of this UploadTaskWhereInput.  # noqa: E501
        :type size_gte: int
        """

        self._size_gte = size_gte

    @property
    def size_in(self):
        """Gets the size_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The size_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._size_in

    @size_in.setter
    def size_in(self, size_in):
        """Sets the size_in of this UploadTaskWhereInput.


        :param size_in: The size_in of this UploadTaskWhereInput.  # noqa: E501
        :type size_in: list[int]
        """

        self._size_in = size_in

    @property
    def size_lt(self):
        """Gets the size_lt of this UploadTaskWhereInput.  # noqa: E501


        :return: The size_lt of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_lt

    @size_lt.setter
    def size_lt(self, size_lt):
        """Sets the size_lt of this UploadTaskWhereInput.


        :param size_lt: The size_lt of this UploadTaskWhereInput.  # noqa: E501
        :type size_lt: int
        """

        self._size_lt = size_lt

    @property
    def size_lte(self):
        """Gets the size_lte of this UploadTaskWhereInput.  # noqa: E501


        :return: The size_lte of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_lte

    @size_lte.setter
    def size_lte(self, size_lte):
        """Sets the size_lte of this UploadTaskWhereInput.


        :param size_lte: The size_lte of this UploadTaskWhereInput.  # noqa: E501
        :type size_lte: int
        """

        self._size_lte = size_lte

    @property
    def size_not(self):
        """Gets the size_not of this UploadTaskWhereInput.  # noqa: E501


        :return: The size_not of this UploadTaskWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_not

    @size_not.setter
    def size_not(self, size_not):
        """Sets the size_not of this UploadTaskWhereInput.


        :param size_not: The size_not of this UploadTaskWhereInput.  # noqa: E501
        :type size_not: int
        """

        self._size_not = size_not

    @property
    def size_not_in(self):
        """Gets the size_not_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The size_not_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._size_not_in

    @size_not_in.setter
    def size_not_in(self, size_not_in):
        """Sets the size_not_in of this UploadTaskWhereInput.


        :param size_not_in: The size_not_in of this UploadTaskWhereInput.  # noqa: E501
        :type size_not_in: list[int]
        """

        self._size_not_in = size_not_in

    @property
    def started_at(self):
        """Gets the started_at of this UploadTaskWhereInput.  # noqa: E501


        :return: The started_at of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """Sets the started_at of this UploadTaskWhereInput.


        :param started_at: The started_at of this UploadTaskWhereInput.  # noqa: E501
        :type started_at: str
        """

        self._started_at = started_at

    @property
    def started_at_gt(self):
        """Gets the started_at_gt of this UploadTaskWhereInput.  # noqa: E501


        :return: The started_at_gt of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._started_at_gt

    @started_at_gt.setter
    def started_at_gt(self, started_at_gt):
        """Sets the started_at_gt of this UploadTaskWhereInput.


        :param started_at_gt: The started_at_gt of this UploadTaskWhereInput.  # noqa: E501
        :type started_at_gt: str
        """

        self._started_at_gt = started_at_gt

    @property
    def started_at_gte(self):
        """Gets the started_at_gte of this UploadTaskWhereInput.  # noqa: E501


        :return: The started_at_gte of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._started_at_gte

    @started_at_gte.setter
    def started_at_gte(self, started_at_gte):
        """Sets the started_at_gte of this UploadTaskWhereInput.


        :param started_at_gte: The started_at_gte of this UploadTaskWhereInput.  # noqa: E501
        :type started_at_gte: str
        """

        self._started_at_gte = started_at_gte

    @property
    def started_at_in(self):
        """Gets the started_at_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The started_at_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._started_at_in

    @started_at_in.setter
    def started_at_in(self, started_at_in):
        """Sets the started_at_in of this UploadTaskWhereInput.


        :param started_at_in: The started_at_in of this UploadTaskWhereInput.  # noqa: E501
        :type started_at_in: list[str]
        """

        self._started_at_in = started_at_in

    @property
    def started_at_lt(self):
        """Gets the started_at_lt of this UploadTaskWhereInput.  # noqa: E501


        :return: The started_at_lt of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._started_at_lt

    @started_at_lt.setter
    def started_at_lt(self, started_at_lt):
        """Sets the started_at_lt of this UploadTaskWhereInput.


        :param started_at_lt: The started_at_lt of this UploadTaskWhereInput.  # noqa: E501
        :type started_at_lt: str
        """

        self._started_at_lt = started_at_lt

    @property
    def started_at_lte(self):
        """Gets the started_at_lte of this UploadTaskWhereInput.  # noqa: E501


        :return: The started_at_lte of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._started_at_lte

    @started_at_lte.setter
    def started_at_lte(self, started_at_lte):
        """Sets the started_at_lte of this UploadTaskWhereInput.


        :param started_at_lte: The started_at_lte of this UploadTaskWhereInput.  # noqa: E501
        :type started_at_lte: str
        """

        self._started_at_lte = started_at_lte

    @property
    def started_at_not(self):
        """Gets the started_at_not of this UploadTaskWhereInput.  # noqa: E501


        :return: The started_at_not of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._started_at_not

    @started_at_not.setter
    def started_at_not(self, started_at_not):
        """Sets the started_at_not of this UploadTaskWhereInput.


        :param started_at_not: The started_at_not of this UploadTaskWhereInput.  # noqa: E501
        :type started_at_not: str
        """

        self._started_at_not = started_at_not

    @property
    def started_at_not_in(self):
        """Gets the started_at_not_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The started_at_not_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._started_at_not_in

    @started_at_not_in.setter
    def started_at_not_in(self, started_at_not_in):
        """Sets the started_at_not_in of this UploadTaskWhereInput.


        :param started_at_not_in: The started_at_not_in of this UploadTaskWhereInput.  # noqa: E501
        :type started_at_not_in: list[str]
        """

        self._started_at_not_in = started_at_not_in

    @property
    def status(self):
        """Gets the status of this UploadTaskWhereInput.  # noqa: E501


        :return: The status of this UploadTaskWhereInput.  # noqa: E501
        :rtype: UploadTaskStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this UploadTaskWhereInput.


        :param status: The status of this UploadTaskWhereInput.  # noqa: E501
        :type status: UploadTaskStatus
        """

        self._status = status

    @property
    def status_in(self):
        """Gets the status_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The status_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[UploadTaskStatus]
        """
        return self._status_in

    @status_in.setter
    def status_in(self, status_in):
        """Sets the status_in of this UploadTaskWhereInput.


        :param status_in: The status_in of this UploadTaskWhereInput.  # noqa: E501
        :type status_in: list[UploadTaskStatus]
        """

        self._status_in = status_in

    @property
    def status_not(self):
        """Gets the status_not of this UploadTaskWhereInput.  # noqa: E501


        :return: The status_not of this UploadTaskWhereInput.  # noqa: E501
        :rtype: UploadTaskStatus
        """
        return self._status_not

    @status_not.setter
    def status_not(self, status_not):
        """Sets the status_not of this UploadTaskWhereInput.


        :param status_not: The status_not of this UploadTaskWhereInput.  # noqa: E501
        :type status_not: UploadTaskStatus
        """

        self._status_not = status_not

    @property
    def status_not_in(self):
        """Gets the status_not_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The status_not_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[UploadTaskStatus]
        """
        return self._status_not_in

    @status_not_in.setter
    def status_not_in(self, status_not_in):
        """Sets the status_not_in of this UploadTaskWhereInput.


        :param status_not_in: The status_not_in of this UploadTaskWhereInput.  # noqa: E501
        :type status_not_in: list[UploadTaskStatus]
        """

        self._status_not_in = status_not_in

    @property
    def updated_at(self):
        """Gets the updated_at of this UploadTaskWhereInput.  # noqa: E501


        :return: The updated_at of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this UploadTaskWhereInput.


        :param updated_at: The updated_at of this UploadTaskWhereInput.  # noqa: E501
        :type updated_at: str
        """

        self._updated_at = updated_at

    @property
    def updated_at_gt(self):
        """Gets the updated_at_gt of this UploadTaskWhereInput.  # noqa: E501


        :return: The updated_at_gt of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_gt

    @updated_at_gt.setter
    def updated_at_gt(self, updated_at_gt):
        """Sets the updated_at_gt of this UploadTaskWhereInput.


        :param updated_at_gt: The updated_at_gt of this UploadTaskWhereInput.  # noqa: E501
        :type updated_at_gt: str
        """

        self._updated_at_gt = updated_at_gt

    @property
    def updated_at_gte(self):
        """Gets the updated_at_gte of this UploadTaskWhereInput.  # noqa: E501


        :return: The updated_at_gte of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_gte

    @updated_at_gte.setter
    def updated_at_gte(self, updated_at_gte):
        """Sets the updated_at_gte of this UploadTaskWhereInput.


        :param updated_at_gte: The updated_at_gte of this UploadTaskWhereInput.  # noqa: E501
        :type updated_at_gte: str
        """

        self._updated_at_gte = updated_at_gte

    @property
    def updated_at_in(self):
        """Gets the updated_at_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The updated_at_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._updated_at_in

    @updated_at_in.setter
    def updated_at_in(self, updated_at_in):
        """Sets the updated_at_in of this UploadTaskWhereInput.


        :param updated_at_in: The updated_at_in of this UploadTaskWhereInput.  # noqa: E501
        :type updated_at_in: list[str]
        """

        self._updated_at_in = updated_at_in

    @property
    def updated_at_lt(self):
        """Gets the updated_at_lt of this UploadTaskWhereInput.  # noqa: E501


        :return: The updated_at_lt of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_lt

    @updated_at_lt.setter
    def updated_at_lt(self, updated_at_lt):
        """Sets the updated_at_lt of this UploadTaskWhereInput.


        :param updated_at_lt: The updated_at_lt of this UploadTaskWhereInput.  # noqa: E501
        :type updated_at_lt: str
        """

        self._updated_at_lt = updated_at_lt

    @property
    def updated_at_lte(self):
        """Gets the updated_at_lte of this UploadTaskWhereInput.  # noqa: E501


        :return: The updated_at_lte of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_lte

    @updated_at_lte.setter
    def updated_at_lte(self, updated_at_lte):
        """Sets the updated_at_lte of this UploadTaskWhereInput.


        :param updated_at_lte: The updated_at_lte of this UploadTaskWhereInput.  # noqa: E501
        :type updated_at_lte: str
        """

        self._updated_at_lte = updated_at_lte

    @property
    def updated_at_not(self):
        """Gets the updated_at_not of this UploadTaskWhereInput.  # noqa: E501


        :return: The updated_at_not of this UploadTaskWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._updated_at_not

    @updated_at_not.setter
    def updated_at_not(self, updated_at_not):
        """Sets the updated_at_not of this UploadTaskWhereInput.


        :param updated_at_not: The updated_at_not of this UploadTaskWhereInput.  # noqa: E501
        :type updated_at_not: str
        """

        self._updated_at_not = updated_at_not

    @property
    def updated_at_not_in(self):
        """Gets the updated_at_not_in of this UploadTaskWhereInput.  # noqa: E501


        :return: The updated_at_not_in of this UploadTaskWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._updated_at_not_in

    @updated_at_not_in.setter
    def updated_at_not_in(self, updated_at_not_in):
        """Sets the updated_at_not_in of this UploadTaskWhereInput.


        :param updated_at_not_in: The updated_at_not_in of this UploadTaskWhereInput.  # noqa: E501
        :type updated_at_not_in: list[str]
        """

        self._updated_at_not_in = updated_at_not_in

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UploadTaskWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UploadTaskWhereInput):
            return True

        return self.to_dict() != other.to_dict()
