# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class UsbDeviceMountParamsData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'vms': 'VmWhereInput',
        'vm_id': 'str'
    }

    attribute_map = {
        'vms': 'vms',
        'vm_id': 'vm_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """UsbDeviceMountParamsData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._vms = None
        self._vm_id = None
        self.discriminator = None

        if "vms" in kwargs:
            self.vms = kwargs["vms"]
        if "vm_id" in kwargs:
            self.vm_id = kwargs["vm_id"]

    @property
    def vms(self):
        """Gets the vms of this UsbDeviceMountParamsData.  # noqa: E501


        :return: The vms of this UsbDeviceMountParamsData.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vms

    @vms.setter
    def vms(self, vms):
        """Sets the vms of this UsbDeviceMountParamsData.


        :param vms: The vms of this UsbDeviceMountParamsData.  # noqa: E501
        :type vms: VmWhereInput
        """

        self._vms = vms

    @property
    def vm_id(self):
        """Gets the vm_id of this UsbDeviceMountParamsData.  # noqa: E501


        :return: The vm_id of this UsbDeviceMountParamsData.  # noqa: E501
        :rtype: str
        """
        return self._vm_id

    @vm_id.setter
    def vm_id(self, vm_id):
        """Sets the vm_id of this UsbDeviceMountParamsData.


        :param vm_id: The vm_id of this UsbDeviceMountParamsData.  # noqa: E501
        :type vm_id: str
        """

        self._vm_id = vm_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UsbDeviceMountParamsData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UsbDeviceMountParamsData):
            return True

        return self.to_dict() != other.to_dict()
