# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class UserAuditLogCreationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'api_key_name': 'str',
        'id': 'str',
        'started_at': 'str',
        'finished_at': 'str',
        'cluster_id': 'str',
        'resource_id': 'str',
        'ip_address': 'str',
        'status': 'UserAuditLogStatus',
        'user_id': 'str',
        'key': 'str',
        'message': 'UserAuditLogMessage',
        'resource_type': 'str',
        'action': 'str'
    }

    attribute_map = {
        'api_key_name': 'api_key_name',
        'id': 'id',
        'started_at': 'started_at',
        'finished_at': 'finished_at',
        'cluster_id': 'cluster_id',
        'resource_id': 'resource_id',
        'ip_address': 'ip_address',
        'status': 'status',
        'user_id': 'user_id',
        'key': 'key',
        'message': 'message',
        'resource_type': 'resource_type',
        'action': 'action'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """UserAuditLogCreationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._api_key_name = None
        self._id = None
        self._started_at = None
        self._finished_at = None
        self._cluster_id = None
        self._resource_id = None
        self._ip_address = None
        self._status = None
        self._user_id = None
        self._key = None
        self._message = None
        self._resource_type = None
        self._action = None
        self.discriminator = None

        if "api_key_name" in kwargs:
            self.api_key_name = kwargs["api_key_name"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "started_at" in kwargs:
            self.started_at = kwargs["started_at"]
        if "finished_at" in kwargs:
            self.finished_at = kwargs["finished_at"]
        if "cluster_id" in kwargs:
            self.cluster_id = kwargs["cluster_id"]
        if "resource_id" in kwargs:
            self.resource_id = kwargs["resource_id"]
        if "ip_address" in kwargs:
            self.ip_address = kwargs["ip_address"]
        if "status" in kwargs:
            self.status = kwargs["status"]
        if "user_id" in kwargs:
            self.user_id = kwargs["user_id"]
        if "key" in kwargs:
            self.key = kwargs["key"]
        if "message" in kwargs:
            self.message = kwargs["message"]
        if "resource_type" in kwargs:
            self.resource_type = kwargs["resource_type"]
        if "action" in kwargs:
            self.action = kwargs["action"]

    @property
    def api_key_name(self):
        """Gets the api_key_name of this UserAuditLogCreationParams.  # noqa: E501


        :return: The api_key_name of this UserAuditLogCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._api_key_name

    @api_key_name.setter
    def api_key_name(self, api_key_name):
        """Sets the api_key_name of this UserAuditLogCreationParams.


        :param api_key_name: The api_key_name of this UserAuditLogCreationParams.  # noqa: E501
        :type api_key_name: str
        """

        self._api_key_name = api_key_name

    @property
    def id(self):
        """Gets the id of this UserAuditLogCreationParams.  # noqa: E501


        :return: The id of this UserAuditLogCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this UserAuditLogCreationParams.


        :param id: The id of this UserAuditLogCreationParams.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def started_at(self):
        """Gets the started_at of this UserAuditLogCreationParams.  # noqa: E501


        :return: The started_at of this UserAuditLogCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """Sets the started_at of this UserAuditLogCreationParams.


        :param started_at: The started_at of this UserAuditLogCreationParams.  # noqa: E501
        :type started_at: str
        """

        self._started_at = started_at

    @property
    def finished_at(self):
        """Gets the finished_at of this UserAuditLogCreationParams.  # noqa: E501


        :return: The finished_at of this UserAuditLogCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """Sets the finished_at of this UserAuditLogCreationParams.


        :param finished_at: The finished_at of this UserAuditLogCreationParams.  # noqa: E501
        :type finished_at: str
        """

        self._finished_at = finished_at

    @property
    def cluster_id(self):
        """Gets the cluster_id of this UserAuditLogCreationParams.  # noqa: E501


        :return: The cluster_id of this UserAuditLogCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """Sets the cluster_id of this UserAuditLogCreationParams.


        :param cluster_id: The cluster_id of this UserAuditLogCreationParams.  # noqa: E501
        :type cluster_id: str
        """

        self._cluster_id = cluster_id

    @property
    def resource_id(self):
        """Gets the resource_id of this UserAuditLogCreationParams.  # noqa: E501


        :return: The resource_id of this UserAuditLogCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """Sets the resource_id of this UserAuditLogCreationParams.


        :param resource_id: The resource_id of this UserAuditLogCreationParams.  # noqa: E501
        :type resource_id: str
        """

        self._resource_id = resource_id

    @property
    def ip_address(self):
        """Gets the ip_address of this UserAuditLogCreationParams.  # noqa: E501


        :return: The ip_address of this UserAuditLogCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """Sets the ip_address of this UserAuditLogCreationParams.


        :param ip_address: The ip_address of this UserAuditLogCreationParams.  # noqa: E501
        :type ip_address: str
        """

        self._ip_address = ip_address

    @property
    def status(self):
        """Gets the status of this UserAuditLogCreationParams.  # noqa: E501


        :return: The status of this UserAuditLogCreationParams.  # noqa: E501
        :rtype: UserAuditLogStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this UserAuditLogCreationParams.


        :param status: The status of this UserAuditLogCreationParams.  # noqa: E501
        :type status: UserAuditLogStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def user_id(self):
        """Gets the user_id of this UserAuditLogCreationParams.  # noqa: E501


        :return: The user_id of this UserAuditLogCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this UserAuditLogCreationParams.


        :param user_id: The user_id of this UserAuditLogCreationParams.  # noqa: E501
        :type user_id: str
        """
        if self.local_vars_configuration.client_side_validation and user_id is None:  # noqa: E501
            raise ValueError("Invalid value for `user_id`, must not be `None`")  # noqa: E501

        self._user_id = user_id

    @property
    def key(self):
        """Gets the key of this UserAuditLogCreationParams.  # noqa: E501


        :return: The key of this UserAuditLogCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this UserAuditLogCreationParams.


        :param key: The key of this UserAuditLogCreationParams.  # noqa: E501
        :type key: str
        """

        self._key = key

    @property
    def message(self):
        """Gets the message of this UserAuditLogCreationParams.  # noqa: E501


        :return: The message of this UserAuditLogCreationParams.  # noqa: E501
        :rtype: UserAuditLogMessage
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this UserAuditLogCreationParams.


        :param message: The message of this UserAuditLogCreationParams.  # noqa: E501
        :type message: UserAuditLogMessage
        """
        if self.local_vars_configuration.client_side_validation and message is None:  # noqa: E501
            raise ValueError("Invalid value for `message`, must not be `None`")  # noqa: E501

        self._message = message

    @property
    def resource_type(self):
        """Gets the resource_type of this UserAuditLogCreationParams.  # noqa: E501


        :return: The resource_type of this UserAuditLogCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this UserAuditLogCreationParams.


        :param resource_type: The resource_type of this UserAuditLogCreationParams.  # noqa: E501
        :type resource_type: str
        """
        if self.local_vars_configuration.client_side_validation and resource_type is None:  # noqa: E501
            raise ValueError("Invalid value for `resource_type`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                resource_type is not None and len(resource_type) < 1):
            raise ValueError("Invalid value for `resource_type`, length must be greater than or equal to `1`")  # noqa: E501

        self._resource_type = resource_type

    @property
    def action(self):
        """Gets the action of this UserAuditLogCreationParams.  # noqa: E501


        :return: The action of this UserAuditLogCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this UserAuditLogCreationParams.


        :param action: The action of this UserAuditLogCreationParams.  # noqa: E501
        :type action: str
        """
        if self.local_vars_configuration.client_side_validation and action is None:  # noqa: E501
            raise ValueError("Invalid value for `action`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                action is not None and len(action) < 1):
            raise ValueError("Invalid value for `action`, length must be greater than or equal to `1`")  # noqa: E501

        self._action = action

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserAuditLogCreationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UserAuditLogCreationParams):
            return True

        return self.to_dict() != other.to_dict()
