# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ViewUpdationParamsData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'time_unit': 'TimeUnit',
        'time_span': 'int',
        'name': 'str'
    }

    attribute_map = {
        'time_unit': 'time_unit',
        'time_span': 'time_span',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ViewUpdationParamsData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._time_unit = None
        self._time_span = None
        self._name = None
        self.discriminator = None

        if "time_unit" in kwargs:
            self.time_unit = kwargs["time_unit"]
        if "time_span" in kwargs:
            self.time_span = kwargs["time_span"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def time_unit(self):
        """Gets the time_unit of this ViewUpdationParamsData.  # noqa: E501


        :return: The time_unit of this ViewUpdationParamsData.  # noqa: E501
        :rtype: TimeUnit
        """
        return self._time_unit

    @time_unit.setter
    def time_unit(self, time_unit):
        """Sets the time_unit of this ViewUpdationParamsData.


        :param time_unit: The time_unit of this ViewUpdationParamsData.  # noqa: E501
        :type time_unit: TimeUnit
        """

        self._time_unit = time_unit

    @property
    def time_span(self):
        """Gets the time_span of this ViewUpdationParamsData.  # noqa: E501


        :return: The time_span of this ViewUpdationParamsData.  # noqa: E501
        :rtype: int
        """
        return self._time_span

    @time_span.setter
    def time_span(self, time_span):
        """Sets the time_span of this ViewUpdationParamsData.


        :param time_span: The time_span of this ViewUpdationParamsData.  # noqa: E501
        :type time_span: int
        """

        self._time_span = time_span

    @property
    def name(self):
        """Gets the name of this ViewUpdationParamsData.  # noqa: E501


        :return: The name of this ViewUpdationParamsData.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ViewUpdationParamsData.


        :param name: The name of this ViewUpdationParamsData.  # noqa: E501
        :type name: str
        """

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ViewUpdationParamsData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ViewUpdationParamsData):
            return True

        return self.to_dict() != other.to_dict()
