# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudClusterBinding(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cluster': 'NestedCluster',
        'entity_async_status': 'EntityAsyncStatus',
        'id': 'str',
        'mtu': 'int',
        'vds': 'NestedVds',
        'vlan_id': 'int',
        'vpc_service': 'NestedVirtualPrivateCloudService'
    }

    attribute_map = {
        'cluster': 'cluster',
        'entity_async_status': 'entityAsyncStatus',
        'id': 'id',
        'mtu': 'mtu',
        'vds': 'vds',
        'vlan_id': 'vlan_id',
        'vpc_service': 'vpc_service'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudClusterBinding - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cluster = None
        self._entity_async_status = None
        self._id = None
        self._mtu = None
        self._vds = None
        self._vlan_id = None
        self._vpc_service = None
        self.discriminator = None

        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.mtu = kwargs.get("mtu", None)
        if "vds" in kwargs:
            self.vds = kwargs["vds"]
        if "vlan_id" in kwargs:
            self.vlan_id = kwargs["vlan_id"]
        if "vpc_service" in kwargs:
            self.vpc_service = kwargs["vpc_service"]

    @property
    def cluster(self):
        """Gets the cluster of this VirtualPrivateCloudClusterBinding.  # noqa: E501


        :return: The cluster of this VirtualPrivateCloudClusterBinding.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this VirtualPrivateCloudClusterBinding.


        :param cluster: The cluster of this VirtualPrivateCloudClusterBinding.  # noqa: E501
        :type cluster: NestedCluster
        """
        if self.local_vars_configuration.client_side_validation and cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster`, must not be `None`")  # noqa: E501

        self._cluster = cluster

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VirtualPrivateCloudClusterBinding.  # noqa: E501


        :return: The entity_async_status of this VirtualPrivateCloudClusterBinding.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VirtualPrivateCloudClusterBinding.


        :param entity_async_status: The entity_async_status of this VirtualPrivateCloudClusterBinding.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def id(self):
        """Gets the id of this VirtualPrivateCloudClusterBinding.  # noqa: E501


        :return: The id of this VirtualPrivateCloudClusterBinding.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VirtualPrivateCloudClusterBinding.


        :param id: The id of this VirtualPrivateCloudClusterBinding.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def mtu(self):
        """Gets the mtu of this VirtualPrivateCloudClusterBinding.  # noqa: E501


        :return: The mtu of this VirtualPrivateCloudClusterBinding.  # noqa: E501
        :rtype: int
        """
        return self._mtu

    @mtu.setter
    def mtu(self, mtu):
        """Sets the mtu of this VirtualPrivateCloudClusterBinding.


        :param mtu: The mtu of this VirtualPrivateCloudClusterBinding.  # noqa: E501
        :type mtu: int
        """

        self._mtu = mtu

    @property
    def vds(self):
        """Gets the vds of this VirtualPrivateCloudClusterBinding.  # noqa: E501


        :return: The vds of this VirtualPrivateCloudClusterBinding.  # noqa: E501
        :rtype: NestedVds
        """
        return self._vds

    @vds.setter
    def vds(self, vds):
        """Sets the vds of this VirtualPrivateCloudClusterBinding.


        :param vds: The vds of this VirtualPrivateCloudClusterBinding.  # noqa: E501
        :type vds: NestedVds
        """
        if self.local_vars_configuration.client_side_validation and vds is None:  # noqa: E501
            raise ValueError("Invalid value for `vds`, must not be `None`")  # noqa: E501

        self._vds = vds

    @property
    def vlan_id(self):
        """Gets the vlan_id of this VirtualPrivateCloudClusterBinding.  # noqa: E501


        :return: The vlan_id of this VirtualPrivateCloudClusterBinding.  # noqa: E501
        :rtype: int
        """
        return self._vlan_id

    @vlan_id.setter
    def vlan_id(self, vlan_id):
        """Sets the vlan_id of this VirtualPrivateCloudClusterBinding.


        :param vlan_id: The vlan_id of this VirtualPrivateCloudClusterBinding.  # noqa: E501
        :type vlan_id: int
        """
        if self.local_vars_configuration.client_side_validation and vlan_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vlan_id`, must not be `None`")  # noqa: E501

        self._vlan_id = vlan_id

    @property
    def vpc_service(self):
        """Gets the vpc_service of this VirtualPrivateCloudClusterBinding.  # noqa: E501


        :return: The vpc_service of this VirtualPrivateCloudClusterBinding.  # noqa: E501
        :rtype: NestedVirtualPrivateCloudService
        """
        return self._vpc_service

    @vpc_service.setter
    def vpc_service(self, vpc_service):
        """Sets the vpc_service of this VirtualPrivateCloudClusterBinding.


        :param vpc_service: The vpc_service of this VirtualPrivateCloudClusterBinding.  # noqa: E501
        :type vpc_service: NestedVirtualPrivateCloudService
        """
        if self.local_vars_configuration.client_side_validation and vpc_service is None:  # noqa: E501
            raise ValueError("Invalid value for `vpc_service`, must not be `None`")  # noqa: E501

        self._vpc_service = vpc_service

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudClusterBinding):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudClusterBinding):
            return True

        return self.to_dict() != other.to_dict()
