# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudClusterBindingWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[VirtualPrivateCloudClusterBindingWhereInput]',
        '_not': 'list[VirtualPrivateCloudClusterBindingWhereInput]',
        '_or': 'list[VirtualPrivateCloudClusterBindingWhereInput]',
        'cluster': 'ClusterWhereInput',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'mtu': 'int',
        'mtu_gt': 'int',
        'mtu_gte': 'int',
        'mtu_in': 'list[int]',
        'mtu_lt': 'int',
        'mtu_lte': 'int',
        'mtu_not': 'int',
        'mtu_not_in': 'list[int]',
        'vds': 'VdsWhereInput',
        'vlan_id': 'int',
        'vlan_id_gt': 'int',
        'vlan_id_gte': 'int',
        'vlan_id_in': 'list[int]',
        'vlan_id_lt': 'int',
        'vlan_id_lte': 'int',
        'vlan_id_not': 'int',
        'vlan_id_not_in': 'list[int]',
        'vpc_service': 'VirtualPrivateCloudServiceWhereInput'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'cluster': 'cluster',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'mtu': 'mtu',
        'mtu_gt': 'mtu_gt',
        'mtu_gte': 'mtu_gte',
        'mtu_in': 'mtu_in',
        'mtu_lt': 'mtu_lt',
        'mtu_lte': 'mtu_lte',
        'mtu_not': 'mtu_not',
        'mtu_not_in': 'mtu_not_in',
        'vds': 'vds',
        'vlan_id': 'vlan_id',
        'vlan_id_gt': 'vlan_id_gt',
        'vlan_id_gte': 'vlan_id_gte',
        'vlan_id_in': 'vlan_id_in',
        'vlan_id_lt': 'vlan_id_lt',
        'vlan_id_lte': 'vlan_id_lte',
        'vlan_id_not': 'vlan_id_not',
        'vlan_id_not_in': 'vlan_id_not_in',
        'vpc_service': 'vpc_service'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudClusterBindingWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._cluster = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._mtu = None
        self._mtu_gt = None
        self._mtu_gte = None
        self._mtu_in = None
        self._mtu_lt = None
        self._mtu_lte = None
        self._mtu_not = None
        self._mtu_not_in = None
        self._vds = None
        self._vlan_id = None
        self._vlan_id_gt = None
        self._vlan_id_gte = None
        self._vlan_id_in = None
        self._vlan_id_lt = None
        self._vlan_id_lte = None
        self._vlan_id_not = None
        self._vlan_id_not_in = None
        self._vpc_service = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.cluster = kwargs.get("cluster", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.mtu = kwargs.get("mtu", None)
        self.mtu_gt = kwargs.get("mtu_gt", None)
        self.mtu_gte = kwargs.get("mtu_gte", None)
        self.mtu_in = kwargs.get("mtu_in", None)
        self.mtu_lt = kwargs.get("mtu_lt", None)
        self.mtu_lte = kwargs.get("mtu_lte", None)
        self.mtu_not = kwargs.get("mtu_not", None)
        self.mtu_not_in = kwargs.get("mtu_not_in", None)
        self.vds = kwargs.get("vds", None)
        self.vlan_id = kwargs.get("vlan_id", None)
        self.vlan_id_gt = kwargs.get("vlan_id_gt", None)
        self.vlan_id_gte = kwargs.get("vlan_id_gte", None)
        self.vlan_id_in = kwargs.get("vlan_id_in", None)
        self.vlan_id_lt = kwargs.get("vlan_id_lt", None)
        self.vlan_id_lte = kwargs.get("vlan_id_lte", None)
        self.vlan_id_not = kwargs.get("vlan_id_not", None)
        self.vlan_id_not_in = kwargs.get("vlan_id_not_in", None)
        self.vpc_service = kwargs.get("vpc_service", None)

    @property
    def _and(self):
        """Gets the _and of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The _and of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudClusterBindingWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this VirtualPrivateCloudClusterBindingWhereInput.


        :param _and: The _and of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type _and: list[VirtualPrivateCloudClusterBindingWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The _not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudClusterBindingWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this VirtualPrivateCloudClusterBindingWhereInput.


        :param _not: The _not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type _not: list[VirtualPrivateCloudClusterBindingWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The _or of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudClusterBindingWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this VirtualPrivateCloudClusterBindingWhereInput.


        :param _or: The _or of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type _or: list[VirtualPrivateCloudClusterBindingWhereInput]
        """

        self.__or = _or

    @property
    def cluster(self):
        """Gets the cluster of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The cluster of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this VirtualPrivateCloudClusterBindingWhereInput.


        :param cluster: The cluster of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type cluster: ClusterWhereInput
        """

        self._cluster = cluster

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The entity_async_status of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VirtualPrivateCloudClusterBindingWhereInput.


        :param entity_async_status: The entity_async_status of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this VirtualPrivateCloudClusterBindingWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this VirtualPrivateCloudClusterBindingWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this VirtualPrivateCloudClusterBindingWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def id(self):
        """Gets the id of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The id of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VirtualPrivateCloudClusterBindingWhereInput.


        :param id: The id of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The id_contains of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this VirtualPrivateCloudClusterBindingWhereInput.


        :param id_contains: The id_contains of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The id_ends_with of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this VirtualPrivateCloudClusterBindingWhereInput.


        :param id_ends_with: The id_ends_with of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The id_gt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this VirtualPrivateCloudClusterBindingWhereInput.


        :param id_gt: The id_gt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The id_gte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this VirtualPrivateCloudClusterBindingWhereInput.


        :param id_gte: The id_gte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The id_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this VirtualPrivateCloudClusterBindingWhereInput.


        :param id_in: The id_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The id_lt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this VirtualPrivateCloudClusterBindingWhereInput.


        :param id_lt: The id_lt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The id_lte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this VirtualPrivateCloudClusterBindingWhereInput.


        :param id_lte: The id_lte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The id_not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this VirtualPrivateCloudClusterBindingWhereInput.


        :param id_not: The id_not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The id_not_contains of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this VirtualPrivateCloudClusterBindingWhereInput.


        :param id_not_contains: The id_not_contains of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this VirtualPrivateCloudClusterBindingWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The id_not_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this VirtualPrivateCloudClusterBindingWhereInput.


        :param id_not_in: The id_not_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this VirtualPrivateCloudClusterBindingWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The id_starts_with of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this VirtualPrivateCloudClusterBindingWhereInput.


        :param id_starts_with: The id_starts_with of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def mtu(self):
        """Gets the mtu of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The mtu of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._mtu

    @mtu.setter
    def mtu(self, mtu):
        """Sets the mtu of this VirtualPrivateCloudClusterBindingWhereInput.


        :param mtu: The mtu of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type mtu: int
        """

        self._mtu = mtu

    @property
    def mtu_gt(self):
        """Gets the mtu_gt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The mtu_gt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._mtu_gt

    @mtu_gt.setter
    def mtu_gt(self, mtu_gt):
        """Sets the mtu_gt of this VirtualPrivateCloudClusterBindingWhereInput.


        :param mtu_gt: The mtu_gt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type mtu_gt: int
        """

        self._mtu_gt = mtu_gt

    @property
    def mtu_gte(self):
        """Gets the mtu_gte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The mtu_gte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._mtu_gte

    @mtu_gte.setter
    def mtu_gte(self, mtu_gte):
        """Sets the mtu_gte of this VirtualPrivateCloudClusterBindingWhereInput.


        :param mtu_gte: The mtu_gte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type mtu_gte: int
        """

        self._mtu_gte = mtu_gte

    @property
    def mtu_in(self):
        """Gets the mtu_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The mtu_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._mtu_in

    @mtu_in.setter
    def mtu_in(self, mtu_in):
        """Sets the mtu_in of this VirtualPrivateCloudClusterBindingWhereInput.


        :param mtu_in: The mtu_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type mtu_in: list[int]
        """

        self._mtu_in = mtu_in

    @property
    def mtu_lt(self):
        """Gets the mtu_lt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The mtu_lt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._mtu_lt

    @mtu_lt.setter
    def mtu_lt(self, mtu_lt):
        """Sets the mtu_lt of this VirtualPrivateCloudClusterBindingWhereInput.


        :param mtu_lt: The mtu_lt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type mtu_lt: int
        """

        self._mtu_lt = mtu_lt

    @property
    def mtu_lte(self):
        """Gets the mtu_lte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The mtu_lte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._mtu_lte

    @mtu_lte.setter
    def mtu_lte(self, mtu_lte):
        """Sets the mtu_lte of this VirtualPrivateCloudClusterBindingWhereInput.


        :param mtu_lte: The mtu_lte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type mtu_lte: int
        """

        self._mtu_lte = mtu_lte

    @property
    def mtu_not(self):
        """Gets the mtu_not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The mtu_not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._mtu_not

    @mtu_not.setter
    def mtu_not(self, mtu_not):
        """Sets the mtu_not of this VirtualPrivateCloudClusterBindingWhereInput.


        :param mtu_not: The mtu_not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type mtu_not: int
        """

        self._mtu_not = mtu_not

    @property
    def mtu_not_in(self):
        """Gets the mtu_not_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The mtu_not_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._mtu_not_in

    @mtu_not_in.setter
    def mtu_not_in(self, mtu_not_in):
        """Sets the mtu_not_in of this VirtualPrivateCloudClusterBindingWhereInput.


        :param mtu_not_in: The mtu_not_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type mtu_not_in: list[int]
        """

        self._mtu_not_in = mtu_not_in

    @property
    def vds(self):
        """Gets the vds of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The vds of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: VdsWhereInput
        """
        return self._vds

    @vds.setter
    def vds(self, vds):
        """Sets the vds of this VirtualPrivateCloudClusterBindingWhereInput.


        :param vds: The vds of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type vds: VdsWhereInput
        """

        self._vds = vds

    @property
    def vlan_id(self):
        """Gets the vlan_id of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The vlan_id of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vlan_id

    @vlan_id.setter
    def vlan_id(self, vlan_id):
        """Sets the vlan_id of this VirtualPrivateCloudClusterBindingWhereInput.


        :param vlan_id: The vlan_id of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type vlan_id: int
        """

        self._vlan_id = vlan_id

    @property
    def vlan_id_gt(self):
        """Gets the vlan_id_gt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The vlan_id_gt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vlan_id_gt

    @vlan_id_gt.setter
    def vlan_id_gt(self, vlan_id_gt):
        """Sets the vlan_id_gt of this VirtualPrivateCloudClusterBindingWhereInput.


        :param vlan_id_gt: The vlan_id_gt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type vlan_id_gt: int
        """

        self._vlan_id_gt = vlan_id_gt

    @property
    def vlan_id_gte(self):
        """Gets the vlan_id_gte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The vlan_id_gte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vlan_id_gte

    @vlan_id_gte.setter
    def vlan_id_gte(self, vlan_id_gte):
        """Sets the vlan_id_gte of this VirtualPrivateCloudClusterBindingWhereInput.


        :param vlan_id_gte: The vlan_id_gte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type vlan_id_gte: int
        """

        self._vlan_id_gte = vlan_id_gte

    @property
    def vlan_id_in(self):
        """Gets the vlan_id_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The vlan_id_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._vlan_id_in

    @vlan_id_in.setter
    def vlan_id_in(self, vlan_id_in):
        """Sets the vlan_id_in of this VirtualPrivateCloudClusterBindingWhereInput.


        :param vlan_id_in: The vlan_id_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type vlan_id_in: list[int]
        """

        self._vlan_id_in = vlan_id_in

    @property
    def vlan_id_lt(self):
        """Gets the vlan_id_lt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The vlan_id_lt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vlan_id_lt

    @vlan_id_lt.setter
    def vlan_id_lt(self, vlan_id_lt):
        """Sets the vlan_id_lt of this VirtualPrivateCloudClusterBindingWhereInput.


        :param vlan_id_lt: The vlan_id_lt of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type vlan_id_lt: int
        """

        self._vlan_id_lt = vlan_id_lt

    @property
    def vlan_id_lte(self):
        """Gets the vlan_id_lte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The vlan_id_lte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vlan_id_lte

    @vlan_id_lte.setter
    def vlan_id_lte(self, vlan_id_lte):
        """Sets the vlan_id_lte of this VirtualPrivateCloudClusterBindingWhereInput.


        :param vlan_id_lte: The vlan_id_lte of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type vlan_id_lte: int
        """

        self._vlan_id_lte = vlan_id_lte

    @property
    def vlan_id_not(self):
        """Gets the vlan_id_not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The vlan_id_not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vlan_id_not

    @vlan_id_not.setter
    def vlan_id_not(self, vlan_id_not):
        """Sets the vlan_id_not of this VirtualPrivateCloudClusterBindingWhereInput.


        :param vlan_id_not: The vlan_id_not of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type vlan_id_not: int
        """

        self._vlan_id_not = vlan_id_not

    @property
    def vlan_id_not_in(self):
        """Gets the vlan_id_not_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The vlan_id_not_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._vlan_id_not_in

    @vlan_id_not_in.setter
    def vlan_id_not_in(self, vlan_id_not_in):
        """Sets the vlan_id_not_in of this VirtualPrivateCloudClusterBindingWhereInput.


        :param vlan_id_not_in: The vlan_id_not_in of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type vlan_id_not_in: list[int]
        """

        self._vlan_id_not_in = vlan_id_not_in

    @property
    def vpc_service(self):
        """Gets the vpc_service of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501


        :return: The vpc_service of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudServiceWhereInput
        """
        return self._vpc_service

    @vpc_service.setter
    def vpc_service(self, vpc_service):
        """Sets the vpc_service of this VirtualPrivateCloudClusterBindingWhereInput.


        :param vpc_service: The vpc_service of this VirtualPrivateCloudClusterBindingWhereInput.  # noqa: E501
        :type vpc_service: VirtualPrivateCloudServiceWhereInput
        """

        self._vpc_service = vpc_service

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudClusterBindingWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudClusterBindingWhereInput):
            return True

        return self.to_dict() != other.to_dict()
