# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudDnatRuleParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'target_port': 'int',
        'port': 'int',
        'target_ip': 'str'
    }

    attribute_map = {
        'target_port': 'target_port',
        'port': 'port',
        'target_ip': 'target_ip'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudDnatRuleParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._target_port = None
        self._port = None
        self._target_ip = None
        self.discriminator = None

        if "target_port" in kwargs:
            self.target_port = kwargs["target_port"]
        if "port" in kwargs:
            self.port = kwargs["port"]
        if "target_ip" in kwargs:
            self.target_ip = kwargs["target_ip"]

    @property
    def target_port(self):
        """Gets the target_port of this VirtualPrivateCloudDnatRuleParams.  # noqa: E501


        :return: The target_port of this VirtualPrivateCloudDnatRuleParams.  # noqa: E501
        :rtype: int
        """
        return self._target_port

    @target_port.setter
    def target_port(self, target_port):
        """Sets the target_port of this VirtualPrivateCloudDnatRuleParams.


        :param target_port: The target_port of this VirtualPrivateCloudDnatRuleParams.  # noqa: E501
        :type target_port: int
        """
        if self.local_vars_configuration.client_side_validation and target_port is None:  # noqa: E501
            raise ValueError("Invalid value for `target_port`, must not be `None`")  # noqa: E501

        self._target_port = target_port

    @property
    def port(self):
        """Gets the port of this VirtualPrivateCloudDnatRuleParams.  # noqa: E501


        :return: The port of this VirtualPrivateCloudDnatRuleParams.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this VirtualPrivateCloudDnatRuleParams.


        :param port: The port of this VirtualPrivateCloudDnatRuleParams.  # noqa: E501
        :type port: int
        """
        if self.local_vars_configuration.client_side_validation and port is None:  # noqa: E501
            raise ValueError("Invalid value for `port`, must not be `None`")  # noqa: E501

        self._port = port

    @property
    def target_ip(self):
        """Gets the target_ip of this VirtualPrivateCloudDnatRuleParams.  # noqa: E501


        :return: The target_ip of this VirtualPrivateCloudDnatRuleParams.  # noqa: E501
        :rtype: str
        """
        return self._target_ip

    @target_ip.setter
    def target_ip(self, target_ip):
        """Sets the target_ip of this VirtualPrivateCloudDnatRuleParams.


        :param target_ip: The target_ip of this VirtualPrivateCloudDnatRuleParams.  # noqa: E501
        :type target_ip: str
        """
        if self.local_vars_configuration.client_side_validation and target_ip is None:  # noqa: E501
            raise ValueError("Invalid value for `target_ip`, must not be `None`")  # noqa: E501

        self._target_ip = target_ip

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudDnatRuleParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudDnatRuleParams):
            return True

        return self.to_dict() != other.to_dict()
