# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudEdgeGateway(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'description': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'id': 'str',
        'name': 'str',
        'status': 'NestedVirtualPrivateCloudEdgeGatewayStatus',
        'vdses': 'list[NestedVds]'
    }

    attribute_map = {
        'description': 'description',
        'entity_async_status': 'entityAsyncStatus',
        'id': 'id',
        'name': 'name',
        'status': 'status',
        'vdses': 'vdses'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudEdgeGateway - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._description = None
        self._entity_async_status = None
        self._id = None
        self._name = None
        self._status = None
        self._vdses = None
        self.discriminator = None

        self.description = kwargs.get("description", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.status = kwargs.get("status", None)
        self.vdses = kwargs.get("vdses", None)

    @property
    def description(self):
        """Gets the description of this VirtualPrivateCloudEdgeGateway.  # noqa: E501


        :return: The description of this VirtualPrivateCloudEdgeGateway.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VirtualPrivateCloudEdgeGateway.


        :param description: The description of this VirtualPrivateCloudEdgeGateway.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VirtualPrivateCloudEdgeGateway.  # noqa: E501


        :return: The entity_async_status of this VirtualPrivateCloudEdgeGateway.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VirtualPrivateCloudEdgeGateway.


        :param entity_async_status: The entity_async_status of this VirtualPrivateCloudEdgeGateway.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def id(self):
        """Gets the id of this VirtualPrivateCloudEdgeGateway.  # noqa: E501


        :return: The id of this VirtualPrivateCloudEdgeGateway.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VirtualPrivateCloudEdgeGateway.


        :param id: The id of this VirtualPrivateCloudEdgeGateway.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this VirtualPrivateCloudEdgeGateway.  # noqa: E501


        :return: The name of this VirtualPrivateCloudEdgeGateway.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VirtualPrivateCloudEdgeGateway.


        :param name: The name of this VirtualPrivateCloudEdgeGateway.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def status(self):
        """Gets the status of this VirtualPrivateCloudEdgeGateway.  # noqa: E501


        :return: The status of this VirtualPrivateCloudEdgeGateway.  # noqa: E501
        :rtype: NestedVirtualPrivateCloudEdgeGatewayStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this VirtualPrivateCloudEdgeGateway.


        :param status: The status of this VirtualPrivateCloudEdgeGateway.  # noqa: E501
        :type status: NestedVirtualPrivateCloudEdgeGatewayStatus
        """

        self._status = status

    @property
    def vdses(self):
        """Gets the vdses of this VirtualPrivateCloudEdgeGateway.  # noqa: E501


        :return: The vdses of this VirtualPrivateCloudEdgeGateway.  # noqa: E501
        :rtype: list[NestedVds]
        """
        return self._vdses

    @vdses.setter
    def vdses(self, vdses):
        """Sets the vdses of this VirtualPrivateCloudEdgeGateway.


        :param vdses: The vdses of this VirtualPrivateCloudEdgeGateway.  # noqa: E501
        :type vdses: list[NestedVds]
        """

        self._vdses = vdses

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudEdgeGateway):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudEdgeGateway):
            return True

        return self.to_dict() != other.to_dict()
