# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudEdgeGatewayGroup(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'active_edge_gateway_ids': 'list[str]',
        'description': 'str',
        'edge_gateways': 'list[NestedVirtualPrivateCloudEdgeGateway]',
        'entity_async_status': 'EntityAsyncStatus',
        'id': 'str',
        'name': 'str',
        'primary_edge_gateway_id': 'str'
    }

    attribute_map = {
        'active_edge_gateway_ids': 'active_edge_gateway_ids',
        'description': 'description',
        'edge_gateways': 'edge_gateways',
        'entity_async_status': 'entityAsyncStatus',
        'id': 'id',
        'name': 'name',
        'primary_edge_gateway_id': 'primary_edge_gateway_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudEdgeGatewayGroup - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._active_edge_gateway_ids = None
        self._description = None
        self._edge_gateways = None
        self._entity_async_status = None
        self._id = None
        self._name = None
        self._primary_edge_gateway_id = None
        self.discriminator = None

        if "active_edge_gateway_ids" in kwargs:
            self.active_edge_gateway_ids = kwargs["active_edge_gateway_ids"]
        self.description = kwargs.get("description", None)
        self.edge_gateways = kwargs.get("edge_gateways", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.primary_edge_gateway_id = kwargs.get("primary_edge_gateway_id", None)

    @property
    def active_edge_gateway_ids(self):
        """Gets the active_edge_gateway_ids of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501


        :return: The active_edge_gateway_ids of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501
        :rtype: list[str]
        """
        return self._active_edge_gateway_ids

    @active_edge_gateway_ids.setter
    def active_edge_gateway_ids(self, active_edge_gateway_ids):
        """Sets the active_edge_gateway_ids of this VirtualPrivateCloudEdgeGatewayGroup.


        :param active_edge_gateway_ids: The active_edge_gateway_ids of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501
        :type active_edge_gateway_ids: list[str]
        """
        if self.local_vars_configuration.client_side_validation and active_edge_gateway_ids is None:  # noqa: E501
            raise ValueError("Invalid value for `active_edge_gateway_ids`, must not be `None`")  # noqa: E501

        self._active_edge_gateway_ids = active_edge_gateway_ids

    @property
    def description(self):
        """Gets the description of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501


        :return: The description of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VirtualPrivateCloudEdgeGatewayGroup.


        :param description: The description of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def edge_gateways(self):
        """Gets the edge_gateways of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501


        :return: The edge_gateways of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501
        :rtype: list[NestedVirtualPrivateCloudEdgeGateway]
        """
        return self._edge_gateways

    @edge_gateways.setter
    def edge_gateways(self, edge_gateways):
        """Sets the edge_gateways of this VirtualPrivateCloudEdgeGatewayGroup.


        :param edge_gateways: The edge_gateways of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501
        :type edge_gateways: list[NestedVirtualPrivateCloudEdgeGateway]
        """

        self._edge_gateways = edge_gateways

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501


        :return: The entity_async_status of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VirtualPrivateCloudEdgeGatewayGroup.


        :param entity_async_status: The entity_async_status of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def id(self):
        """Gets the id of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501


        :return: The id of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VirtualPrivateCloudEdgeGatewayGroup.


        :param id: The id of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501


        :return: The name of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VirtualPrivateCloudEdgeGatewayGroup.


        :param name: The name of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def primary_edge_gateway_id(self):
        """Gets the primary_edge_gateway_id of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501


        :return: The primary_edge_gateway_id of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501
        :rtype: str
        """
        return self._primary_edge_gateway_id

    @primary_edge_gateway_id.setter
    def primary_edge_gateway_id(self, primary_edge_gateway_id):
        """Sets the primary_edge_gateway_id of this VirtualPrivateCloudEdgeGatewayGroup.


        :param primary_edge_gateway_id: The primary_edge_gateway_id of this VirtualPrivateCloudEdgeGatewayGroup.  # noqa: E501
        :type primary_edge_gateway_id: str
        """

        self._primary_edge_gateway_id = primary_edge_gateway_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudEdgeGatewayGroup):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudEdgeGatewayGroup):
            return True

        return self.to_dict() != other.to_dict()
