# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudExternalSubnetGroup(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'description': 'str',
        'edge_gateway_group': 'NestedVirtualPrivateCloudEdgeGatewayGroup',
        'entity_async_status': 'EntityAsyncStatus',
        'exclusive': 'bool',
        'external_subnets_spec': 'list[NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec]',
        'floating_ips': 'list[NestedVirtualPrivateCloudFloatingIp]',
        'id': 'str',
        'local_id': 'str',
        'name': 'str',
        'nat_gateways': 'list[NestedVirtualPrivateCloudNatGateway]',
        'router_gateways': 'list[NestedVirtualPrivateCloudRouterGateway]',
        'shared_in_edge_gateway_group': 'bool',
        'vpc': 'NestedVirtualPrivateCloud'
    }

    attribute_map = {
        'description': 'description',
        'edge_gateway_group': 'edge_gateway_group',
        'entity_async_status': 'entityAsyncStatus',
        'exclusive': 'exclusive',
        'external_subnets_spec': 'external_subnets_spec',
        'floating_ips': 'floating_ips',
        'id': 'id',
        'local_id': 'local_id',
        'name': 'name',
        'nat_gateways': 'nat_gateways',
        'router_gateways': 'router_gateways',
        'shared_in_edge_gateway_group': 'shared_in_edge_gateway_group',
        'vpc': 'vpc'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudExternalSubnetGroup - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._description = None
        self._edge_gateway_group = None
        self._entity_async_status = None
        self._exclusive = None
        self._external_subnets_spec = None
        self._floating_ips = None
        self._id = None
        self._local_id = None
        self._name = None
        self._nat_gateways = None
        self._router_gateways = None
        self._shared_in_edge_gateway_group = None
        self._vpc = None
        self.discriminator = None

        self.description = kwargs.get("description", None)
        if "edge_gateway_group" in kwargs:
            self.edge_gateway_group = kwargs["edge_gateway_group"]
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "exclusive" in kwargs:
            self.exclusive = kwargs["exclusive"]
        if "external_subnets_spec" in kwargs:
            self.external_subnets_spec = kwargs["external_subnets_spec"]
        self.floating_ips = kwargs.get("floating_ips", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.nat_gateways = kwargs.get("nat_gateways", None)
        self.router_gateways = kwargs.get("router_gateways", None)
        if "shared_in_edge_gateway_group" in kwargs:
            self.shared_in_edge_gateway_group = kwargs["shared_in_edge_gateway_group"]
        self.vpc = kwargs.get("vpc", None)

    @property
    def description(self):
        """Gets the description of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The description of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VirtualPrivateCloudExternalSubnetGroup.


        :param description: The description of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def edge_gateway_group(self):
        """Gets the edge_gateway_group of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The edge_gateway_group of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: NestedVirtualPrivateCloudEdgeGatewayGroup
        """
        return self._edge_gateway_group

    @edge_gateway_group.setter
    def edge_gateway_group(self, edge_gateway_group):
        """Sets the edge_gateway_group of this VirtualPrivateCloudExternalSubnetGroup.


        :param edge_gateway_group: The edge_gateway_group of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type edge_gateway_group: NestedVirtualPrivateCloudEdgeGatewayGroup
        """
        if self.local_vars_configuration.client_side_validation and edge_gateway_group is None:  # noqa: E501
            raise ValueError("Invalid value for `edge_gateway_group`, must not be `None`")  # noqa: E501

        self._edge_gateway_group = edge_gateway_group

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The entity_async_status of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VirtualPrivateCloudExternalSubnetGroup.


        :param entity_async_status: The entity_async_status of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def exclusive(self):
        """Gets the exclusive of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The exclusive of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: bool
        """
        return self._exclusive

    @exclusive.setter
    def exclusive(self, exclusive):
        """Sets the exclusive of this VirtualPrivateCloudExternalSubnetGroup.


        :param exclusive: The exclusive of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type exclusive: bool
        """
        if self.local_vars_configuration.client_side_validation and exclusive is None:  # noqa: E501
            raise ValueError("Invalid value for `exclusive`, must not be `None`")  # noqa: E501

        self._exclusive = exclusive

    @property
    def external_subnets_spec(self):
        """Gets the external_subnets_spec of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The external_subnets_spec of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: list[NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec]
        """
        return self._external_subnets_spec

    @external_subnets_spec.setter
    def external_subnets_spec(self, external_subnets_spec):
        """Sets the external_subnets_spec of this VirtualPrivateCloudExternalSubnetGroup.


        :param external_subnets_spec: The external_subnets_spec of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type external_subnets_spec: list[NestedVirtualPrivateCloudExternalSubnetGroupExternalSubnetsSpec]
        """
        if self.local_vars_configuration.client_side_validation and external_subnets_spec is None:  # noqa: E501
            raise ValueError("Invalid value for `external_subnets_spec`, must not be `None`")  # noqa: E501

        self._external_subnets_spec = external_subnets_spec

    @property
    def floating_ips(self):
        """Gets the floating_ips of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The floating_ips of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: list[NestedVirtualPrivateCloudFloatingIp]
        """
        return self._floating_ips

    @floating_ips.setter
    def floating_ips(self, floating_ips):
        """Sets the floating_ips of this VirtualPrivateCloudExternalSubnetGroup.


        :param floating_ips: The floating_ips of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type floating_ips: list[NestedVirtualPrivateCloudFloatingIp]
        """

        self._floating_ips = floating_ips

    @property
    def id(self):
        """Gets the id of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The id of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VirtualPrivateCloudExternalSubnetGroup.


        :param id: The id of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def local_id(self):
        """Gets the local_id of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The local_id of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VirtualPrivateCloudExternalSubnetGroup.


        :param local_id: The local_id of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def name(self):
        """Gets the name of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The name of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VirtualPrivateCloudExternalSubnetGroup.


        :param name: The name of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def nat_gateways(self):
        """Gets the nat_gateways of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The nat_gateways of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: list[NestedVirtualPrivateCloudNatGateway]
        """
        return self._nat_gateways

    @nat_gateways.setter
    def nat_gateways(self, nat_gateways):
        """Sets the nat_gateways of this VirtualPrivateCloudExternalSubnetGroup.


        :param nat_gateways: The nat_gateways of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type nat_gateways: list[NestedVirtualPrivateCloudNatGateway]
        """

        self._nat_gateways = nat_gateways

    @property
    def router_gateways(self):
        """Gets the router_gateways of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The router_gateways of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: list[NestedVirtualPrivateCloudRouterGateway]
        """
        return self._router_gateways

    @router_gateways.setter
    def router_gateways(self, router_gateways):
        """Sets the router_gateways of this VirtualPrivateCloudExternalSubnetGroup.


        :param router_gateways: The router_gateways of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type router_gateways: list[NestedVirtualPrivateCloudRouterGateway]
        """

        self._router_gateways = router_gateways

    @property
    def shared_in_edge_gateway_group(self):
        """Gets the shared_in_edge_gateway_group of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The shared_in_edge_gateway_group of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: bool
        """
        return self._shared_in_edge_gateway_group

    @shared_in_edge_gateway_group.setter
    def shared_in_edge_gateway_group(self, shared_in_edge_gateway_group):
        """Sets the shared_in_edge_gateway_group of this VirtualPrivateCloudExternalSubnetGroup.


        :param shared_in_edge_gateway_group: The shared_in_edge_gateway_group of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type shared_in_edge_gateway_group: bool
        """
        if self.local_vars_configuration.client_side_validation and shared_in_edge_gateway_group is None:  # noqa: E501
            raise ValueError("Invalid value for `shared_in_edge_gateway_group`, must not be `None`")  # noqa: E501

        self._shared_in_edge_gateway_group = shared_in_edge_gateway_group

    @property
    def vpc(self):
        """Gets the vpc of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501


        :return: The vpc of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :rtype: NestedVirtualPrivateCloud
        """
        return self._vpc

    @vpc.setter
    def vpc(self, vpc):
        """Sets the vpc of this VirtualPrivateCloudExternalSubnetGroup.


        :param vpc: The vpc of this VirtualPrivateCloudExternalSubnetGroup.  # noqa: E501
        :type vpc: NestedVirtualPrivateCloud
        """

        self._vpc = vpc

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudExternalSubnetGroup):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudExternalSubnetGroup):
            return True

        return self.to_dict() != other.to_dict()
