# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudFloatingIpCreationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'external_ip': 'str',
        'external_subnet_id': 'str',
        'vpc_id': 'str'
    }

    attribute_map = {
        'external_ip': 'external_ip',
        'external_subnet_id': 'external_subnet_id',
        'vpc_id': 'vpc_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudFloatingIpCreationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._external_ip = None
        self._external_subnet_id = None
        self._vpc_id = None
        self.discriminator = None

        if "external_ip" in kwargs:
            self.external_ip = kwargs["external_ip"]
        if "external_subnet_id" in kwargs:
            self.external_subnet_id = kwargs["external_subnet_id"]
        if "vpc_id" in kwargs:
            self.vpc_id = kwargs["vpc_id"]

    @property
    def external_ip(self):
        """Gets the external_ip of this VirtualPrivateCloudFloatingIpCreationParams.  # noqa: E501


        :return: The external_ip of this VirtualPrivateCloudFloatingIpCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._external_ip

    @external_ip.setter
    def external_ip(self, external_ip):
        """Sets the external_ip of this VirtualPrivateCloudFloatingIpCreationParams.


        :param external_ip: The external_ip of this VirtualPrivateCloudFloatingIpCreationParams.  # noqa: E501
        :type external_ip: str
        """

        self._external_ip = external_ip

    @property
    def external_subnet_id(self):
        """Gets the external_subnet_id of this VirtualPrivateCloudFloatingIpCreationParams.  # noqa: E501


        :return: The external_subnet_id of this VirtualPrivateCloudFloatingIpCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._external_subnet_id

    @external_subnet_id.setter
    def external_subnet_id(self, external_subnet_id):
        """Sets the external_subnet_id of this VirtualPrivateCloudFloatingIpCreationParams.


        :param external_subnet_id: The external_subnet_id of this VirtualPrivateCloudFloatingIpCreationParams.  # noqa: E501
        :type external_subnet_id: str
        """
        if self.local_vars_configuration.client_side_validation and external_subnet_id is None:  # noqa: E501
            raise ValueError("Invalid value for `external_subnet_id`, must not be `None`")  # noqa: E501

        self._external_subnet_id = external_subnet_id

    @property
    def vpc_id(self):
        """Gets the vpc_id of this VirtualPrivateCloudFloatingIpCreationParams.  # noqa: E501


        :return: The vpc_id of this VirtualPrivateCloudFloatingIpCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._vpc_id

    @vpc_id.setter
    def vpc_id(self, vpc_id):
        """Sets the vpc_id of this VirtualPrivateCloudFloatingIpCreationParams.


        :param vpc_id: The vpc_id of this VirtualPrivateCloudFloatingIpCreationParams.  # noqa: E501
        :type vpc_id: str
        """
        if self.local_vars_configuration.client_side_validation and vpc_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vpc_id`, must not be `None`")  # noqa: E501

        self._vpc_id = vpc_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudFloatingIpCreationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudFloatingIpCreationParams):
            return True

        return self.to_dict() != other.to_dict()
