# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudFloatingIpWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[VirtualPrivateCloudFloatingIpWhereInput]',
        '_not': 'list[VirtualPrivateCloudFloatingIpWhereInput]',
        '_or': 'list[VirtualPrivateCloudFloatingIpWhereInput]',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'external_ip': 'str',
        'external_ip_contains': 'str',
        'external_ip_ends_with': 'str',
        'external_ip_gt': 'str',
        'external_ip_gte': 'str',
        'external_ip_in': 'list[str]',
        'external_ip_lt': 'str',
        'external_ip_lte': 'str',
        'external_ip_not': 'str',
        'external_ip_not_contains': 'str',
        'external_ip_not_ends_with': 'str',
        'external_ip_not_in': 'list[str]',
        'external_ip_not_starts_with': 'str',
        'external_ip_starts_with': 'str',
        'external_subnet': 'VirtualPrivateCloudExternalSubnetWhereInput',
        'external_subnet_group': 'VirtualPrivateCloudExternalSubnetGroupWhereInput',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'vpc': 'VirtualPrivateCloudWhereInput'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'external_ip': 'external_ip',
        'external_ip_contains': 'external_ip_contains',
        'external_ip_ends_with': 'external_ip_ends_with',
        'external_ip_gt': 'external_ip_gt',
        'external_ip_gte': 'external_ip_gte',
        'external_ip_in': 'external_ip_in',
        'external_ip_lt': 'external_ip_lt',
        'external_ip_lte': 'external_ip_lte',
        'external_ip_not': 'external_ip_not',
        'external_ip_not_contains': 'external_ip_not_contains',
        'external_ip_not_ends_with': 'external_ip_not_ends_with',
        'external_ip_not_in': 'external_ip_not_in',
        'external_ip_not_starts_with': 'external_ip_not_starts_with',
        'external_ip_starts_with': 'external_ip_starts_with',
        'external_subnet': 'external_subnet',
        'external_subnet_group': 'external_subnet_group',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'vpc': 'vpc'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudFloatingIpWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._external_ip = None
        self._external_ip_contains = None
        self._external_ip_ends_with = None
        self._external_ip_gt = None
        self._external_ip_gte = None
        self._external_ip_in = None
        self._external_ip_lt = None
        self._external_ip_lte = None
        self._external_ip_not = None
        self._external_ip_not_contains = None
        self._external_ip_not_ends_with = None
        self._external_ip_not_in = None
        self._external_ip_not_starts_with = None
        self._external_ip_starts_with = None
        self._external_subnet = None
        self._external_subnet_group = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._vpc = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.external_ip = kwargs.get("external_ip", None)
        self.external_ip_contains = kwargs.get("external_ip_contains", None)
        self.external_ip_ends_with = kwargs.get("external_ip_ends_with", None)
        self.external_ip_gt = kwargs.get("external_ip_gt", None)
        self.external_ip_gte = kwargs.get("external_ip_gte", None)
        self.external_ip_in = kwargs.get("external_ip_in", None)
        self.external_ip_lt = kwargs.get("external_ip_lt", None)
        self.external_ip_lte = kwargs.get("external_ip_lte", None)
        self.external_ip_not = kwargs.get("external_ip_not", None)
        self.external_ip_not_contains = kwargs.get("external_ip_not_contains", None)
        self.external_ip_not_ends_with = kwargs.get("external_ip_not_ends_with", None)
        self.external_ip_not_in = kwargs.get("external_ip_not_in", None)
        self.external_ip_not_starts_with = kwargs.get("external_ip_not_starts_with", None)
        self.external_ip_starts_with = kwargs.get("external_ip_starts_with", None)
        self.external_subnet = kwargs.get("external_subnet", None)
        self.external_subnet_group = kwargs.get("external_subnet_group", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.vpc = kwargs.get("vpc", None)

    @property
    def _and(self):
        """Gets the _and of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The _and of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudFloatingIpWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this VirtualPrivateCloudFloatingIpWhereInput.


        :param _and: The _and of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type _and: list[VirtualPrivateCloudFloatingIpWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The _not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudFloatingIpWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this VirtualPrivateCloudFloatingIpWhereInput.


        :param _not: The _not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type _not: list[VirtualPrivateCloudFloatingIpWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The _or of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudFloatingIpWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this VirtualPrivateCloudFloatingIpWhereInput.


        :param _or: The _or of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type _or: list[VirtualPrivateCloudFloatingIpWhereInput]
        """

        self.__or = _or

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The entity_async_status of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VirtualPrivateCloudFloatingIpWhereInput.


        :param entity_async_status: The entity_async_status of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this VirtualPrivateCloudFloatingIpWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this VirtualPrivateCloudFloatingIpWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this VirtualPrivateCloudFloatingIpWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def external_ip(self):
        """Gets the external_ip of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_ip of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._external_ip

    @external_ip.setter
    def external_ip(self, external_ip):
        """Sets the external_ip of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_ip: The external_ip of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_ip: str
        """

        self._external_ip = external_ip

    @property
    def external_ip_contains(self):
        """Gets the external_ip_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_ip_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._external_ip_contains

    @external_ip_contains.setter
    def external_ip_contains(self, external_ip_contains):
        """Sets the external_ip_contains of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_ip_contains: The external_ip_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_ip_contains: str
        """

        self._external_ip_contains = external_ip_contains

    @property
    def external_ip_ends_with(self):
        """Gets the external_ip_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_ip_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._external_ip_ends_with

    @external_ip_ends_with.setter
    def external_ip_ends_with(self, external_ip_ends_with):
        """Sets the external_ip_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_ip_ends_with: The external_ip_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_ip_ends_with: str
        """

        self._external_ip_ends_with = external_ip_ends_with

    @property
    def external_ip_gt(self):
        """Gets the external_ip_gt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_ip_gt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._external_ip_gt

    @external_ip_gt.setter
    def external_ip_gt(self, external_ip_gt):
        """Sets the external_ip_gt of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_ip_gt: The external_ip_gt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_ip_gt: str
        """

        self._external_ip_gt = external_ip_gt

    @property
    def external_ip_gte(self):
        """Gets the external_ip_gte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_ip_gte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._external_ip_gte

    @external_ip_gte.setter
    def external_ip_gte(self, external_ip_gte):
        """Sets the external_ip_gte of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_ip_gte: The external_ip_gte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_ip_gte: str
        """

        self._external_ip_gte = external_ip_gte

    @property
    def external_ip_in(self):
        """Gets the external_ip_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_ip_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._external_ip_in

    @external_ip_in.setter
    def external_ip_in(self, external_ip_in):
        """Sets the external_ip_in of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_ip_in: The external_ip_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_ip_in: list[str]
        """

        self._external_ip_in = external_ip_in

    @property
    def external_ip_lt(self):
        """Gets the external_ip_lt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_ip_lt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._external_ip_lt

    @external_ip_lt.setter
    def external_ip_lt(self, external_ip_lt):
        """Sets the external_ip_lt of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_ip_lt: The external_ip_lt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_ip_lt: str
        """

        self._external_ip_lt = external_ip_lt

    @property
    def external_ip_lte(self):
        """Gets the external_ip_lte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_ip_lte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._external_ip_lte

    @external_ip_lte.setter
    def external_ip_lte(self, external_ip_lte):
        """Sets the external_ip_lte of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_ip_lte: The external_ip_lte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_ip_lte: str
        """

        self._external_ip_lte = external_ip_lte

    @property
    def external_ip_not(self):
        """Gets the external_ip_not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_ip_not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._external_ip_not

    @external_ip_not.setter
    def external_ip_not(self, external_ip_not):
        """Sets the external_ip_not of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_ip_not: The external_ip_not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_ip_not: str
        """

        self._external_ip_not = external_ip_not

    @property
    def external_ip_not_contains(self):
        """Gets the external_ip_not_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_ip_not_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._external_ip_not_contains

    @external_ip_not_contains.setter
    def external_ip_not_contains(self, external_ip_not_contains):
        """Sets the external_ip_not_contains of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_ip_not_contains: The external_ip_not_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_ip_not_contains: str
        """

        self._external_ip_not_contains = external_ip_not_contains

    @property
    def external_ip_not_ends_with(self):
        """Gets the external_ip_not_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_ip_not_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._external_ip_not_ends_with

    @external_ip_not_ends_with.setter
    def external_ip_not_ends_with(self, external_ip_not_ends_with):
        """Sets the external_ip_not_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_ip_not_ends_with: The external_ip_not_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_ip_not_ends_with: str
        """

        self._external_ip_not_ends_with = external_ip_not_ends_with

    @property
    def external_ip_not_in(self):
        """Gets the external_ip_not_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_ip_not_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._external_ip_not_in

    @external_ip_not_in.setter
    def external_ip_not_in(self, external_ip_not_in):
        """Sets the external_ip_not_in of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_ip_not_in: The external_ip_not_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_ip_not_in: list[str]
        """

        self._external_ip_not_in = external_ip_not_in

    @property
    def external_ip_not_starts_with(self):
        """Gets the external_ip_not_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_ip_not_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._external_ip_not_starts_with

    @external_ip_not_starts_with.setter
    def external_ip_not_starts_with(self, external_ip_not_starts_with):
        """Sets the external_ip_not_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_ip_not_starts_with: The external_ip_not_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_ip_not_starts_with: str
        """

        self._external_ip_not_starts_with = external_ip_not_starts_with

    @property
    def external_ip_starts_with(self):
        """Gets the external_ip_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_ip_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._external_ip_starts_with

    @external_ip_starts_with.setter
    def external_ip_starts_with(self, external_ip_starts_with):
        """Sets the external_ip_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_ip_starts_with: The external_ip_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_ip_starts_with: str
        """

        self._external_ip_starts_with = external_ip_starts_with

    @property
    def external_subnet(self):
        """Gets the external_subnet of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_subnet of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudExternalSubnetWhereInput
        """
        return self._external_subnet

    @external_subnet.setter
    def external_subnet(self, external_subnet):
        """Sets the external_subnet of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_subnet: The external_subnet of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_subnet: VirtualPrivateCloudExternalSubnetWhereInput
        """

        self._external_subnet = external_subnet

    @property
    def external_subnet_group(self):
        """Gets the external_subnet_group of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The external_subnet_group of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudExternalSubnetGroupWhereInput
        """
        return self._external_subnet_group

    @external_subnet_group.setter
    def external_subnet_group(self, external_subnet_group):
        """Sets the external_subnet_group of this VirtualPrivateCloudFloatingIpWhereInput.


        :param external_subnet_group: The external_subnet_group of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type external_subnet_group: VirtualPrivateCloudExternalSubnetGroupWhereInput
        """

        self._external_subnet_group = external_subnet_group

    @property
    def id(self):
        """Gets the id of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The id of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VirtualPrivateCloudFloatingIpWhereInput.


        :param id: The id of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The id_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this VirtualPrivateCloudFloatingIpWhereInput.


        :param id_contains: The id_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The id_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.


        :param id_ends_with: The id_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The id_gt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this VirtualPrivateCloudFloatingIpWhereInput.


        :param id_gt: The id_gt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The id_gte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this VirtualPrivateCloudFloatingIpWhereInput.


        :param id_gte: The id_gte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The id_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this VirtualPrivateCloudFloatingIpWhereInput.


        :param id_in: The id_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The id_lt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this VirtualPrivateCloudFloatingIpWhereInput.


        :param id_lt: The id_lt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The id_lte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this VirtualPrivateCloudFloatingIpWhereInput.


        :param id_lte: The id_lte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The id_not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this VirtualPrivateCloudFloatingIpWhereInput.


        :param id_not: The id_not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The id_not_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this VirtualPrivateCloudFloatingIpWhereInput.


        :param id_not_contains: The id_not_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The id_not_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this VirtualPrivateCloudFloatingIpWhereInput.


        :param id_not_in: The id_not_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The id_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.


        :param id_starts_with: The id_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def local_id(self):
        """Gets the local_id of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The local_id of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VirtualPrivateCloudFloatingIpWhereInput.


        :param local_id: The local_id of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The local_id_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this VirtualPrivateCloudFloatingIpWhereInput.


        :param local_id_contains: The local_id_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The local_id_gt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this VirtualPrivateCloudFloatingIpWhereInput.


        :param local_id_gt: The local_id_gt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The local_id_gte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this VirtualPrivateCloudFloatingIpWhereInput.


        :param local_id_gte: The local_id_gte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The local_id_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this VirtualPrivateCloudFloatingIpWhereInput.


        :param local_id_in: The local_id_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The local_id_lt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this VirtualPrivateCloudFloatingIpWhereInput.


        :param local_id_lt: The local_id_lt of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The local_id_lte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this VirtualPrivateCloudFloatingIpWhereInput.


        :param local_id_lte: The local_id_lte of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The local_id_not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this VirtualPrivateCloudFloatingIpWhereInput.


        :param local_id_not: The local_id_not of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this VirtualPrivateCloudFloatingIpWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The local_id_not_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this VirtualPrivateCloudFloatingIpWhereInput.


        :param local_id_not_in: The local_id_not_in of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def vpc(self):
        """Gets the vpc of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501


        :return: The vpc of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudWhereInput
        """
        return self._vpc

    @vpc.setter
    def vpc(self, vpc):
        """Sets the vpc of this VirtualPrivateCloudFloatingIpWhereInput.


        :param vpc: The vpc of this VirtualPrivateCloudFloatingIpWhereInput.  # noqa: E501
        :type vpc: VirtualPrivateCloudWhereInput
        """

        self._vpc = vpc

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudFloatingIpWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudFloatingIpWhereInput):
            return True

        return self.to_dict() != other.to_dict()
