# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudNicWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[VirtualPrivateCloudNicWhereInput]',
        '_not': 'list[VirtualPrivateCloudNicWhereInput]',
        '_or': 'list[VirtualPrivateCloudNicWhereInput]',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'floating_ip': 'VirtualPrivateCloudFloatingIpWhereInput',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'snapshots_every': 'VirtualPrivateCloudNicSnapshotWhereInput',
        'snapshots_none': 'VirtualPrivateCloudNicSnapshotWhereInput',
        'snapshots_some': 'VirtualPrivateCloudNicSnapshotWhereInput',
        'vm_nic': 'VmNicWhereInput',
        'vpc': 'VirtualPrivateCloudWhereInput',
        'vpc_subnet': 'VirtualPrivateCloudSubnetWhereInput'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'floating_ip': 'floating_ip',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'snapshots_every': 'snapshots_every',
        'snapshots_none': 'snapshots_none',
        'snapshots_some': 'snapshots_some',
        'vm_nic': 'vm_nic',
        'vpc': 'vpc',
        'vpc_subnet': 'vpc_subnet'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudNicWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._floating_ip = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._snapshots_every = None
        self._snapshots_none = None
        self._snapshots_some = None
        self._vm_nic = None
        self._vpc = None
        self._vpc_subnet = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.floating_ip = kwargs.get("floating_ip", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.snapshots_every = kwargs.get("snapshots_every", None)
        self.snapshots_none = kwargs.get("snapshots_none", None)
        self.snapshots_some = kwargs.get("snapshots_some", None)
        self.vm_nic = kwargs.get("vm_nic", None)
        self.vpc = kwargs.get("vpc", None)
        self.vpc_subnet = kwargs.get("vpc_subnet", None)

    @property
    def _and(self):
        """Gets the _and of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The _and of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudNicWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this VirtualPrivateCloudNicWhereInput.


        :param _and: The _and of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type _and: list[VirtualPrivateCloudNicWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The _not of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudNicWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this VirtualPrivateCloudNicWhereInput.


        :param _not: The _not of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type _not: list[VirtualPrivateCloudNicWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The _or of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudNicWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this VirtualPrivateCloudNicWhereInput.


        :param _or: The _or of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type _or: list[VirtualPrivateCloudNicWhereInput]
        """

        self.__or = _or

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The entity_async_status of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VirtualPrivateCloudNicWhereInput.


        :param entity_async_status: The entity_async_status of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this VirtualPrivateCloudNicWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this VirtualPrivateCloudNicWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this VirtualPrivateCloudNicWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def floating_ip(self):
        """Gets the floating_ip of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The floating_ip of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudFloatingIpWhereInput
        """
        return self._floating_ip

    @floating_ip.setter
    def floating_ip(self, floating_ip):
        """Sets the floating_ip of this VirtualPrivateCloudNicWhereInput.


        :param floating_ip: The floating_ip of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type floating_ip: VirtualPrivateCloudFloatingIpWhereInput
        """

        self._floating_ip = floating_ip

    @property
    def id(self):
        """Gets the id of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The id of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VirtualPrivateCloudNicWhereInput.


        :param id: The id of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The id_contains of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this VirtualPrivateCloudNicWhereInput.


        :param id_contains: The id_contains of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The id_ends_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this VirtualPrivateCloudNicWhereInput.


        :param id_ends_with: The id_ends_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The id_gt of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this VirtualPrivateCloudNicWhereInput.


        :param id_gt: The id_gt of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The id_gte of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this VirtualPrivateCloudNicWhereInput.


        :param id_gte: The id_gte of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The id_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this VirtualPrivateCloudNicWhereInput.


        :param id_in: The id_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The id_lt of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this VirtualPrivateCloudNicWhereInput.


        :param id_lt: The id_lt of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The id_lte of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this VirtualPrivateCloudNicWhereInput.


        :param id_lte: The id_lte of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The id_not of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this VirtualPrivateCloudNicWhereInput.


        :param id_not: The id_not of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The id_not_contains of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this VirtualPrivateCloudNicWhereInput.


        :param id_not_contains: The id_not_contains of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this VirtualPrivateCloudNicWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The id_not_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this VirtualPrivateCloudNicWhereInput.


        :param id_not_in: The id_not_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this VirtualPrivateCloudNicWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The id_starts_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this VirtualPrivateCloudNicWhereInput.


        :param id_starts_with: The id_starts_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def local_id(self):
        """Gets the local_id of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The local_id of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VirtualPrivateCloudNicWhereInput.


        :param local_id: The local_id of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The local_id_contains of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this VirtualPrivateCloudNicWhereInput.


        :param local_id_contains: The local_id_contains of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this VirtualPrivateCloudNicWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The local_id_gt of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this VirtualPrivateCloudNicWhereInput.


        :param local_id_gt: The local_id_gt of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The local_id_gte of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this VirtualPrivateCloudNicWhereInput.


        :param local_id_gte: The local_id_gte of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The local_id_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this VirtualPrivateCloudNicWhereInput.


        :param local_id_in: The local_id_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The local_id_lt of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this VirtualPrivateCloudNicWhereInput.


        :param local_id_lt: The local_id_lt of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The local_id_lte of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this VirtualPrivateCloudNicWhereInput.


        :param local_id_lte: The local_id_lte of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The local_id_not of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this VirtualPrivateCloudNicWhereInput.


        :param local_id_not: The local_id_not of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this VirtualPrivateCloudNicWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this VirtualPrivateCloudNicWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The local_id_not_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this VirtualPrivateCloudNicWhereInput.


        :param local_id_not_in: The local_id_not_in of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this VirtualPrivateCloudNicWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this VirtualPrivateCloudNicWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def snapshots_every(self):
        """Gets the snapshots_every of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The snapshots_every of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudNicSnapshotWhereInput
        """
        return self._snapshots_every

    @snapshots_every.setter
    def snapshots_every(self, snapshots_every):
        """Sets the snapshots_every of this VirtualPrivateCloudNicWhereInput.


        :param snapshots_every: The snapshots_every of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type snapshots_every: VirtualPrivateCloudNicSnapshotWhereInput
        """

        self._snapshots_every = snapshots_every

    @property
    def snapshots_none(self):
        """Gets the snapshots_none of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The snapshots_none of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudNicSnapshotWhereInput
        """
        return self._snapshots_none

    @snapshots_none.setter
    def snapshots_none(self, snapshots_none):
        """Sets the snapshots_none of this VirtualPrivateCloudNicWhereInput.


        :param snapshots_none: The snapshots_none of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type snapshots_none: VirtualPrivateCloudNicSnapshotWhereInput
        """

        self._snapshots_none = snapshots_none

    @property
    def snapshots_some(self):
        """Gets the snapshots_some of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The snapshots_some of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudNicSnapshotWhereInput
        """
        return self._snapshots_some

    @snapshots_some.setter
    def snapshots_some(self, snapshots_some):
        """Sets the snapshots_some of this VirtualPrivateCloudNicWhereInput.


        :param snapshots_some: The snapshots_some of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type snapshots_some: VirtualPrivateCloudNicSnapshotWhereInput
        """

        self._snapshots_some = snapshots_some

    @property
    def vm_nic(self):
        """Gets the vm_nic of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The vm_nic of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: VmNicWhereInput
        """
        return self._vm_nic

    @vm_nic.setter
    def vm_nic(self, vm_nic):
        """Sets the vm_nic of this VirtualPrivateCloudNicWhereInput.


        :param vm_nic: The vm_nic of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type vm_nic: VmNicWhereInput
        """

        self._vm_nic = vm_nic

    @property
    def vpc(self):
        """Gets the vpc of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The vpc of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudWhereInput
        """
        return self._vpc

    @vpc.setter
    def vpc(self, vpc):
        """Sets the vpc of this VirtualPrivateCloudNicWhereInput.


        :param vpc: The vpc of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type vpc: VirtualPrivateCloudWhereInput
        """

        self._vpc = vpc

    @property
    def vpc_subnet(self):
        """Gets the vpc_subnet of this VirtualPrivateCloudNicWhereInput.  # noqa: E501


        :return: The vpc_subnet of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudSubnetWhereInput
        """
        return self._vpc_subnet

    @vpc_subnet.setter
    def vpc_subnet(self, vpc_subnet):
        """Sets the vpc_subnet of this VirtualPrivateCloudNicWhereInput.


        :param vpc_subnet: The vpc_subnet of this VirtualPrivateCloudNicWhereInput.  # noqa: E501
        :type vpc_subnet: VirtualPrivateCloudSubnetWhereInput
        """

        self._vpc_subnet = vpc_subnet

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudNicWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudNicWhereInput):
            return True

        return self.to_dict() != other.to_dict()
