# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudRouteTable(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'default_for_vpc': 'bool',
        'description': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'id': 'str',
        'local_id': 'str',
        'name': 'str',
        'routes': 'list[NestedVirtualPrivateCloudRoute]',
        'subnets': 'list[NestedVirtualPrivateCloudSubnet]',
        'vpc': 'NestedVirtualPrivateCloud'
    }

    attribute_map = {
        'default_for_vpc': 'default_for_vpc',
        'description': 'description',
        'entity_async_status': 'entityAsyncStatus',
        'id': 'id',
        'local_id': 'local_id',
        'name': 'name',
        'routes': 'routes',
        'subnets': 'subnets',
        'vpc': 'vpc'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudRouteTable - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._default_for_vpc = None
        self._description = None
        self._entity_async_status = None
        self._id = None
        self._local_id = None
        self._name = None
        self._routes = None
        self._subnets = None
        self._vpc = None
        self.discriminator = None

        self.default_for_vpc = kwargs.get("default_for_vpc", None)
        self.description = kwargs.get("description", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.routes = kwargs.get("routes", None)
        self.subnets = kwargs.get("subnets", None)
        if "vpc" in kwargs:
            self.vpc = kwargs["vpc"]

    @property
    def default_for_vpc(self):
        """Gets the default_for_vpc of this VirtualPrivateCloudRouteTable.  # noqa: E501


        :return: The default_for_vpc of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :rtype: bool
        """
        return self._default_for_vpc

    @default_for_vpc.setter
    def default_for_vpc(self, default_for_vpc):
        """Sets the default_for_vpc of this VirtualPrivateCloudRouteTable.


        :param default_for_vpc: The default_for_vpc of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :type default_for_vpc: bool
        """

        self._default_for_vpc = default_for_vpc

    @property
    def description(self):
        """Gets the description of this VirtualPrivateCloudRouteTable.  # noqa: E501


        :return: The description of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VirtualPrivateCloudRouteTable.


        :param description: The description of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VirtualPrivateCloudRouteTable.  # noqa: E501


        :return: The entity_async_status of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VirtualPrivateCloudRouteTable.


        :param entity_async_status: The entity_async_status of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def id(self):
        """Gets the id of this VirtualPrivateCloudRouteTable.  # noqa: E501


        :return: The id of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VirtualPrivateCloudRouteTable.


        :param id: The id of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def local_id(self):
        """Gets the local_id of this VirtualPrivateCloudRouteTable.  # noqa: E501


        :return: The local_id of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VirtualPrivateCloudRouteTable.


        :param local_id: The local_id of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def name(self):
        """Gets the name of this VirtualPrivateCloudRouteTable.  # noqa: E501


        :return: The name of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VirtualPrivateCloudRouteTable.


        :param name: The name of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def routes(self):
        """Gets the routes of this VirtualPrivateCloudRouteTable.  # noqa: E501


        :return: The routes of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :rtype: list[NestedVirtualPrivateCloudRoute]
        """
        return self._routes

    @routes.setter
    def routes(self, routes):
        """Sets the routes of this VirtualPrivateCloudRouteTable.


        :param routes: The routes of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :type routes: list[NestedVirtualPrivateCloudRoute]
        """

        self._routes = routes

    @property
    def subnets(self):
        """Gets the subnets of this VirtualPrivateCloudRouteTable.  # noqa: E501


        :return: The subnets of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :rtype: list[NestedVirtualPrivateCloudSubnet]
        """
        return self._subnets

    @subnets.setter
    def subnets(self, subnets):
        """Sets the subnets of this VirtualPrivateCloudRouteTable.


        :param subnets: The subnets of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :type subnets: list[NestedVirtualPrivateCloudSubnet]
        """

        self._subnets = subnets

    @property
    def vpc(self):
        """Gets the vpc of this VirtualPrivateCloudRouteTable.  # noqa: E501


        :return: The vpc of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :rtype: NestedVirtualPrivateCloud
        """
        return self._vpc

    @vpc.setter
    def vpc(self, vpc):
        """Sets the vpc of this VirtualPrivateCloudRouteTable.


        :param vpc: The vpc of this VirtualPrivateCloudRouteTable.  # noqa: E501
        :type vpc: NestedVirtualPrivateCloud
        """
        if self.local_vars_configuration.client_side_validation and vpc is None:  # noqa: E501
            raise ValueError("Invalid value for `vpc`, must not be `None`")  # noqa: E501

        self._vpc = vpc

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudRouteTable):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudRouteTable):
            return True

        return self.to_dict() != other.to_dict()
